/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.test.core.ClusteredEventBusTestBase;
import io.vertx.test.core.Http1xTest;
import io.vertx.test.core.TLSCert;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClusteredEventBusWithSSLTest
extends ClusteredEventBusTestBase {
    private final EventBusOptions options = new EventBusOptions();

    public ClusteredEventBusWithSSLTest(TLSCert cert, TLSCert trust, boolean requireClientAuth, boolean clientTrustAll, boolean useCrl, List<String> enabledCipherSuites) {
        this.options.setSsl(true);
        if (clientTrustAll) {
            this.options.setTrustAll(true);
        }
        if (useCrl) {
            this.options.addCrlPath("tls/root-ca/crl.pem");
        }
        ClusteredEventBusWithSSLTest.setOptions((TCPSSLOptions)this.options, trust.getClientTrustOptions());
        ClusteredEventBusWithSSLTest.setOptions((TCPSSLOptions)this.options, cert.getServerKeyCertOptions());
        if (enabledCipherSuites != null) {
            enabledCipherSuites.forEach(arg_0 -> ((EventBusOptions)this.options).addEnabledCipherSuite(arg_0));
        }
        if (requireClientAuth) {
            this.options.setClientAuth(ClientAuth.REQUIRED);
        }
    }

    @Parameterized.Parameters(name="{index}: event bus SSL ({0} {1} {2} {3} {4} {5}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({TLSCert.JKS, TLSCert.NONE, false, true, false, Collections.emptyList()}, {TLSCert.JKS, TLSCert.JKS, false, false, true, Collections.emptyList()}, {TLSCert.PKCS12, TLSCert.JKS, false, false, false, Collections.emptyList()}, {TLSCert.PEM, TLSCert.JKS, false, false, false, Collections.emptyList()}, {TLSCert.PKCS12_ROOT_CA, TLSCert.JKS_ROOT_CA, false, false, false, Collections.emptyList()}, {TLSCert.PEM_ROOT_CA, TLSCert.PKCS12_ROOT_CA, false, false, false, Collections.emptyList()}, {TLSCert.JKS, TLSCert.PEM_ROOT_CA, false, true, false, Arrays.asList(Http1xTest.ENABLED_CIPHER_SUITES)});
    }

    @Override
    protected void startNodes(int numNodes) {
        super.startNodes(numNodes, new VertxOptions().setEventBusOptions(this.options));
    }
}

