/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.file.FileSystemProps;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.impl.Utils;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSystemTest
extends VertxTestBase {
    private static final String DEFAULT_DIR_PERMS = "rwxr-xr-x";
    private static final String DEFAULT_FILE_PERMS = "rw-r--r--";
    private String pathSep;
    private String testDir;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        FileSystem fs = FileSystems.getDefault();
        this.pathSep = fs.getSeparator();
        File ftestDir = this.testFolder.newFolder();
        this.testDir = ftestDir.toString();
    }

    @Test
    public void testIllegalArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copy(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copy("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyRecursive(null, "ignored", true, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyRecursive("ignored", null, true, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyRecursiveBlocking(null, "ignored", true));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().copyRecursiveBlocking("ignored", null, true));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().move(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().move("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().moveBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().moveBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().truncate(null, 0L, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().truncateBlocking(null, 0L));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmod(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmod("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodRecursive(null, "ignored", "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodRecursive("ignored", null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodRecursiveBlocking(null, "ignored", "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chmodRecursiveBlocking("ignored", null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chown(null, "ignored", "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().chownBlocking(null, "ignored", "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().props(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().propsBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().lprops(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().lpropsBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().link(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().link("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().linkBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().linkBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().symlink(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().symlink("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().symlinkBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().symlinkBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().unlink(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().unlinkBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readSymlink(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readSymlinkBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().delete(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().deleteBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().deleteRecursive(null, true, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().deleteRecursiveBlocking(null, true));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdir(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdir(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirs(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirsBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirs(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().mkdirsBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readDir(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readDirBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readDir(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readDirBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readFile(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().readFileBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().writeFile(null, Buffer.buffer(), h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().writeFile("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().writeFileBlocking(null, Buffer.buffer()));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().writeFileBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().open(null, new OpenOptions(), h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().open("ignored", null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().openBlocking(null, new OpenOptions()));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().openBlocking("ignored", null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().createFile(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().createFileBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().createFile(null, "ignored", h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().createFileBlocking(null, "ignored"));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().exists(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().existsBlocking(null));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().fsProps(null, h -> {}));
        TestUtils.assertNullPointerException(() -> this.vertx.fileSystem().fsPropsBlocking(null));
        String fileName = "some-file.dat";
        AsyncFile asyncFile = this.vertx.fileSystem().openBlocking(this.testDir + this.pathSep + fileName, new OpenOptions());
        TestUtils.assertNullPointerException(() -> asyncFile.write(null));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.setWriteQueueMaxSize(1));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.setWriteQueueMaxSize(0));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.setWriteQueueMaxSize(-1));
        TestUtils.assertNullPointerException(() -> asyncFile.write(null, 0L, h -> {}));
        TestUtils.assertNullPointerException(() -> asyncFile.write(Buffer.buffer(), 0L, null));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.write(Buffer.buffer(), -1L, h -> {}));
        TestUtils.assertNullPointerException(() -> asyncFile.read(null, 0, 0L, 0, h -> {}));
        TestUtils.assertNullPointerException(() -> asyncFile.read(Buffer.buffer(), 0, 0L, 0, null));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.read(Buffer.buffer(), -1, 0L, 0, h -> {}));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.read(Buffer.buffer(), 0, -1L, 0, h -> {}));
        TestUtils.assertIllegalArgumentException(() -> asyncFile.read(Buffer.buffer(), 0, 0L, -1, h -> {}));
    }

    @Test
    public void testSimpleCopy() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.testCopy(source, target, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testSimpleCopyFileAlreadyExists() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.createFileWithJunk(target, 100L);
        this.testCopy(source, target, false, false, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testCopyIntoDir() throws Exception {
        String source = "foo.txt";
        String dir = "some-dir";
        String target = dir + this.pathSep + "bar.txt";
        this.mkDir(dir);
        this.createFileWithJunk(source, 100L);
        this.testCopy(source, target, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testCopyEmptyDir() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        this.mkDir(source);
        this.testCopy(source, target, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testCopyNonEmptyDir() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        String file1 = this.pathSep + "somefile.bar";
        this.mkDir(source);
        this.createFileWithJunk(source + file1, 100L);
        this.testCopy(source, target, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
            this.assertFalse(this.fileExists(target + file1));
        }));
        this.await();
    }

    @Test
    public void testFailCopyDirAlreadyExists() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        this.mkDir(source);
        this.mkDir(target);
        this.testCopy(source, target, false, false, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testRecursiveCopy() throws Exception {
        String dir = "some-dir";
        String file1 = this.pathSep + "file1.dat";
        String file2 = this.pathSep + "index.html";
        String dir2 = "next-dir";
        String file3 = this.pathSep + "blah.java";
        this.mkDir(dir);
        this.createFileWithJunk(dir + file1, 100L);
        this.createFileWithJunk(dir + file2, 100L);
        this.mkDir(dir + this.pathSep + dir2);
        this.createFileWithJunk(dir + this.pathSep + dir2 + file3, 100L);
        String target = "some-other-dir";
        this.testCopy(dir, target, true, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dir));
            this.assertTrue(this.fileExists(target));
            this.assertTrue(this.fileExists(target + file1));
            this.assertTrue(this.fileExists(target + file2));
            this.assertTrue(this.fileExists(target + this.pathSep + dir2 + file3));
        }));
        this.await();
    }

    private void testCopy(String source, String target, boolean recursive, boolean shouldPass, Handler<Void> afterOK) {
        if (recursive) {
            this.vertx.fileSystem().copyRecursive(this.testDir + this.pathSep + source, this.testDir + this.pathSep + target, true, this.createHandler(shouldPass, afterOK));
        } else {
            this.vertx.fileSystem().copy(this.testDir + this.pathSep + source, this.testDir + this.pathSep + target, this.createHandler(shouldPass, afterOK));
        }
    }

    @Test
    public void testSimpleMove() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.testMove(source, target, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testSimpleMoveFileAlreadyExists() throws Exception {
        String source = "foo.txt";
        String target = "bar.txt";
        this.createFileWithJunk(source, 100L);
        this.createFileWithJunk(target, 100L);
        this.testMove(source, target, false, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testMoveEmptyDir() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        this.mkDir(source);
        this.testMove(source, target, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testMoveEmptyDirTargetExists() throws Exception {
        String source = "some-dir";
        String target = "some-other-dir";
        this.mkDir(source);
        this.mkDir(target);
        this.testMove(source, target, false, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(source));
            this.assertTrue(this.fileExists(target));
        }));
        this.await();
    }

    @Test
    public void testMoveNonEmptyDir() throws Exception {
        String dir = "some-dir";
        String file1 = this.pathSep + "file1.dat";
        String file2 = this.pathSep + "index.html";
        String dir2 = "next-dir";
        String file3 = this.pathSep + "blah.java";
        this.mkDir(dir);
        this.createFileWithJunk(dir + file1, 100L);
        this.createFileWithJunk(dir + file2, 100L);
        this.mkDir(dir + this.pathSep + dir2);
        this.createFileWithJunk(dir + this.pathSep + dir2 + file3, 100L);
        String target = "some-other-dir";
        this.testMove(dir, target, true, (Handler<Void>)((Handler)v -> {
            this.assertFalse(this.fileExists(dir));
            this.assertTrue(this.fileExists(target));
            this.assertTrue(this.fileExists(target + file1));
            this.assertTrue(this.fileExists(target + file2));
            this.assertTrue(this.fileExists(target + this.pathSep + dir2 + file3));
        }));
        this.await();
    }

    private void testMove(String source, String target, boolean shouldPass, Handler<Void> afterOK) throws Exception {
        this.vertx.fileSystem().move(this.testDir + this.pathSep + source, this.testDir + this.pathSep + target, this.createHandler(shouldPass, afterOK));
    }

    @Test
    public void testTruncate() throws Exception {
        String file1 = "some-file.dat";
        long initialLen = 1000L;
        long truncatedLen = 534L;
        this.createFileWithJunk(file1, initialLen);
        this.assertEquals(initialLen, this.fileLength(file1));
        this.testTruncate(file1, truncatedLen, true, (Handler<Void>)((Handler)v -> this.assertEquals(truncatedLen, this.fileLength(file1))));
        this.await();
    }

    @Test
    public void testTruncateExtendsFile() throws Exception {
        String file1 = "some-file.dat";
        long initialLen = 500L;
        long truncatedLen = 1000L;
        this.createFileWithJunk(file1, initialLen);
        this.assertEquals(initialLen, this.fileLength(file1));
        this.testTruncate(file1, truncatedLen, true, (Handler<Void>)((Handler)v -> this.assertEquals(truncatedLen, this.fileLength(file1))));
        this.await();
    }

    @Test
    public void testTruncateFileDoesNotExist() throws Exception {
        String file1 = "some-file.dat";
        long truncatedLen = 534L;
        this.testTruncate(file1, truncatedLen, false, null);
        this.await();
    }

    private void testTruncate(String file, long truncatedLen, boolean shouldPass, Handler<Void> afterOK) throws Exception {
        this.vertx.fileSystem().truncate(this.testDir + this.pathSep + file, truncatedLen, this.createHandler(shouldPass, afterOK));
    }

    @Test
    public void testChmodNonRecursive1() throws Exception {
        this.testChmodNonRecursive("rw-------");
    }

    @Test
    public void testChmodNonRecursive2() throws Exception {
        this.testChmodNonRecursive("rwx------");
    }

    @Test
    public void testChmodNonRecursive3() throws Exception {
        this.testChmodNonRecursive("rw-rw-rw-");
    }

    @Test
    public void testChmodNonRecursive4() throws Exception {
        this.testChmodNonRecursive(DEFAULT_FILE_PERMS);
    }

    @Test
    public void testChmodNonRecursive5() throws Exception {
        this.testChmodNonRecursive("rw--w--w-");
    }

    @Test
    public void testChmodNonRecursive6() throws Exception {
        this.testChmodNonRecursive("rw-rw-rw-");
    }

    private void testChmodNonRecursive(String perms) throws Exception {
        String file1 = "some-file.dat";
        this.createFileWithJunk(file1, 100L);
        this.testChmod(file1, perms, null, true, (Handler<Void>)((Handler)v -> {
            this.azzertPerms(perms, file1);
            this.deleteFile(file1);
        }));
        this.await();
    }

    private void azzertPerms(String perms, String file1) {
        if (!Utils.isWindows()) {
            this.assertEquals(perms, this.getPerms(file1));
        }
    }

    @Test
    public void testChmodRecursive1() throws Exception {
        this.testChmodRecursive("rw-------", "rwx------");
    }

    @Test
    public void testChmodRecursive2() throws Exception {
        this.testChmodRecursive("rwx------", "rwx------");
    }

    @Test
    public void testChmodRecursive3() throws Exception {
        this.testChmodRecursive("rw-rw-rw-", "rwxrw-rw-");
    }

    @Test
    public void testChmodRecursive4() throws Exception {
        this.testChmodRecursive(DEFAULT_FILE_PERMS, "rwxr--r--");
    }

    @Test
    public void testChmodRecursive5() throws Exception {
        this.testChmodRecursive("rw--w--w-", "rwx-w--w-");
    }

    @Test
    public void testChmodRecursive6() throws Exception {
        this.testChmodRecursive("rw-rw-rw-", "rwxrw-rw-");
    }

    private void testChmodRecursive(String perms, String dirPerms) throws Exception {
        String dir = "some-dir";
        String file1 = this.pathSep + "file1.dat";
        String file2 = this.pathSep + "index.html";
        String dir2 = "next-dir";
        String file3 = this.pathSep + "blah.java";
        this.mkDir(dir);
        this.createFileWithJunk(dir + file1, 100L);
        this.createFileWithJunk(dir + file2, 100L);
        this.mkDir(dir + this.pathSep + dir2);
        this.createFileWithJunk(dir + this.pathSep + dir2 + file3, 100L);
        this.testChmod(dir, perms, dirPerms, true, (Handler<Void>)((Handler)v -> {
            this.azzertPerms(dirPerms, dir);
            this.azzertPerms(perms, dir + file1);
            this.azzertPerms(perms, dir + file2);
            this.azzertPerms(dirPerms, dir + this.pathSep + dir2);
            this.azzertPerms(perms, dir + this.pathSep + dir2 + file3);
            this.deleteDir(dir);
        }));
        this.await();
    }

    @Test
    public void testChownToRootFails() throws Exception {
        this.testChownFails("root");
    }

    @Test
    public void testChownToNotExistingUserFails() throws Exception {
        this.testChownFails("jfhfhjejweg");
    }

    private void testChownFails(String user) throws Exception {
        String file1 = "some-file.dat";
        this.createFileWithJunk(file1, 100L);
        this.vertx.fileSystem().chown(this.testDir + this.pathSep + file1, user, null, ar -> {
            this.deleteFile(file1);
            this.assertTrue(ar.failed());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testChownToOwnUser() throws Exception {
        String file1 = "some-file.dat";
        this.createFileWithJunk(file1, 100L);
        String fullPath = this.testDir + this.pathSep + file1;
        Path path = Paths.get(fullPath, new String[0]);
        UserPrincipal owner = Files.getOwner(path, new LinkOption[0]);
        String user = owner.getName();
        this.vertx.fileSystem().chown(fullPath, user, null, ar -> {
            this.deleteFile(file1);
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testChownToOwnGroup() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String file1 = "some-file.dat";
        this.createFileWithJunk(file1, 100L);
        String fullPath = this.testDir + this.pathSep + file1;
        Path path = Paths.get(fullPath, new String[0]);
        GroupPrincipal group = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).group();
        this.vertx.fileSystem().chown(fullPath, null, group.getName(), ar -> {
            this.deleteFile(file1);
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    private void testChmod(String file, String perms, String dirPerms, boolean shouldPass, Handler<Void> afterOK) throws Exception {
        if (Files.isDirectory(Paths.get(this.testDir + this.pathSep + file, new String[0]), new LinkOption[0])) {
            this.azzertPerms(DEFAULT_DIR_PERMS, file);
        } else {
            this.azzertPerms(DEFAULT_FILE_PERMS, file);
        }
        if (dirPerms != null) {
            this.vertx.fileSystem().chmodRecursive(this.testDir + this.pathSep + file, perms, dirPerms, this.createHandler(shouldPass, afterOK));
        } else {
            this.vertx.fileSystem().chmod(this.testDir + this.pathSep + file, perms, this.createHandler(shouldPass, afterOK));
        }
    }

    @Test
    public void testProps() throws Exception {
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        long start = 1000L * (System.currentTimeMillis() / 1000L - 1L);
        this.createFileWithJunk(fileName, fileSize);
        this.testProps(fileName, false, true, (Handler<FileProps>)((Handler)st -> {
            this.assertNotNull(st);
            this.assertEquals(fileSize, st.size());
            this.assertTrue(st.creationTime() >= start);
            this.assertTrue(st.lastAccessTime() >= start);
            this.assertTrue(st.lastModifiedTime() >= start);
            this.assertFalse(st.isDirectory());
            this.assertTrue(st.isRegularFile());
            this.assertFalse(st.isSymbolicLink());
        }));
        this.await();
    }

    @Test
    public void testPropsFileDoesNotExist() throws Exception {
        String fileName = "some-file.txt";
        this.testProps(fileName, false, false, null);
        this.await();
    }

    @Test
    public void testPropsFollowLink() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        long start = 1000L * (System.currentTimeMillis() / 1000L - 1L);
        this.createFileWithJunk(fileName, fileSize);
        long end = 1000L * (System.currentTimeMillis() / 1000L + 1L);
        String linkName = "some-link.txt";
        Files.createSymbolicLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0]), Paths.get(fileName, new String[0]), new FileAttribute[0]);
        this.testProps(linkName, false, true, (Handler<FileProps>)((Handler)st -> {
            this.assertNotNull(st);
            this.assertEquals(fileSize, st.size());
            this.assertTrue(st.creationTime() >= start);
            this.assertTrue(st.creationTime() <= end);
            this.assertTrue(st.lastAccessTime() >= start);
            this.assertTrue(st.lastAccessTime() <= end);
            this.assertTrue(st.lastModifiedTime() >= start);
            this.assertTrue(st.lastModifiedTime() <= end);
            this.assertFalse(st.isDirectory());
            this.assertFalse(st.isOther());
            this.assertTrue(st.isRegularFile());
            this.assertFalse(st.isSymbolicLink());
        }));
        this.await();
    }

    @Test
    public void testPropsDontFollowLink() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String linkName = "some-link.txt";
        Files.createSymbolicLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0]), Paths.get(fileName, new String[0]), new FileAttribute[0]);
        this.testProps(linkName, true, true, (Handler<FileProps>)((Handler)st -> {
            this.assertNotNull(st != null);
            this.assertTrue(st.isSymbolicLink());
        }));
        this.await();
    }

    private void testProps(String fileName, boolean link, boolean shouldPass, Handler<FileProps> afterOK) throws Exception {
        AsyncResultHandler handler = ar -> {
            if (ar.failed()) {
                if (shouldPass) {
                    this.fail(ar.cause().getMessage());
                } else {
                    this.assertTrue(ar.cause() instanceof FileSystemException);
                    if (afterOK != null) {
                        afterOK.handle(ar.result());
                    }
                    this.testComplete();
                }
            } else if (shouldPass) {
                if (afterOK != null) {
                    afterOK.handle(ar.result());
                }
                this.testComplete();
            } else {
                this.fail("stat should fail");
            }
        };
        if (link) {
            this.vertx.fileSystem().lprops(this.testDir + this.pathSep + fileName, (Handler)handler);
        } else {
            this.vertx.fileSystem().props(this.testDir + this.pathSep + fileName, (Handler)handler);
        }
    }

    @Test
    public void testLink() throws Exception {
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String linkName = "some-link.txt";
        this.testLink(linkName, fileName, false, true, (Handler<Void>)((Handler)v -> {
            this.assertEquals(fileSize, this.fileLength(linkName));
            this.assertFalse(Files.isSymbolicLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0])));
        }));
        this.await();
    }

    @Test
    public void testSymLink() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String symlinkName = "some-sym-link.txt";
        this.testLink(symlinkName, fileName, true, true, (Handler<Void>)((Handler)v -> {
            this.assertEquals(fileSize, this.fileLength(symlinkName));
            this.assertTrue(Files.isSymbolicLink(Paths.get(this.testDir + this.pathSep + symlinkName, new String[0])));
            String read = this.vertx.fileSystem().readSymlinkBlocking(this.testDir + this.pathSep + symlinkName);
            this.assertEquals(fileName, read);
        }));
        this.await();
    }

    private void testLink(String from, String to, boolean symbolic, boolean shouldPass, Handler<Void> afterOK) throws Exception {
        if (symbolic) {
            this.vertx.fileSystem().symlink(this.testDir + this.pathSep + from, to, this.createHandler(shouldPass, afterOK));
        } else {
            this.vertx.fileSystem().link(this.testDir + this.pathSep + from, this.testDir + this.pathSep + to, this.createHandler(shouldPass, afterOK));
        }
    }

    @Test
    public void testUnlink() throws Exception {
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String linkName = "some-link.txt";
        Files.createLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0]), Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
        this.assertEquals(fileSize, this.fileLength(linkName));
        this.vertx.fileSystem().unlink(this.testDir + this.pathSep + linkName, this.createHandler(true, (Handler<Void>)((Handler)v -> this.assertFalse(this.fileExists(linkName)))));
        this.await();
    }

    @Test
    public void testReadSymLink() throws Exception {
        Assume.assumeFalse((boolean)Utils.isWindows());
        String fileName = "some-file.txt";
        long fileSize = 1234L;
        this.createFileWithJunk(fileName, fileSize);
        String linkName = "some-link.txt";
        Files.createSymbolicLink(Paths.get(this.testDir + this.pathSep + linkName, new String[0]), Paths.get(fileName, new String[0]), new FileAttribute[0]);
        this.vertx.fileSystem().readSymlink(this.testDir + this.pathSep + linkName, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause().getMessage());
            } else {
                this.assertEquals(fileName, ar.result());
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testSimpleDelete() throws Exception {
        String fileName = "some-file.txt";
        this.createFileWithJunk(fileName, 100L);
        this.assertTrue(this.fileExists(fileName));
        this.testDelete(fileName, false, true, (Handler<Void>)((Handler)v -> this.assertFalse(this.fileExists(fileName))));
        this.await();
    }

    @Test
    public void testDeleteEmptyDir() throws Exception {
        String dirName = "some-dir";
        this.mkDir(dirName);
        this.assertTrue(this.fileExists(dirName));
        this.testDelete(dirName, false, true, (Handler<Void>)((Handler)v -> this.assertFalse(this.fileExists(dirName))));
        this.await();
    }

    @Test
    public void testDeleteNonExistent() throws Exception {
        String dirName = "some-dir";
        this.assertFalse(this.fileExists(dirName));
        this.testDelete(dirName, false, false, null);
        this.await();
    }

    @Test
    public void testDeleteNonEmptyFails() throws Exception {
        String dirName = "some-dir";
        this.mkDir(dirName);
        String file1 = "some-file.txt";
        this.createFileWithJunk(dirName + this.pathSep + file1, 100L);
        this.testDelete(dirName, false, false, null);
        this.await();
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        String dir = "some-dir";
        String file1 = this.pathSep + "file1.dat";
        String file2 = this.pathSep + "index.html";
        String dir2 = "next-dir";
        String file3 = this.pathSep + "blah.java";
        this.mkDir(dir);
        this.createFileWithJunk(dir + file1, 100L);
        this.createFileWithJunk(dir + file2, 100L);
        this.mkDir(dir + this.pathSep + dir2);
        this.createFileWithJunk(dir + this.pathSep + dir2 + file3, 100L);
        this.testDelete(dir, true, true, (Handler<Void>)((Handler)v -> this.assertFalse(this.fileExists(dir))));
        this.await();
    }

    private void testDelete(String fileName, boolean recursive, boolean shouldPass, Handler<Void> afterOK) throws Exception {
        if (recursive) {
            this.vertx.fileSystem().deleteRecursive(this.testDir + this.pathSep + fileName, recursive, this.createHandler(shouldPass, afterOK));
        } else {
            this.vertx.fileSystem().delete(this.testDir + this.pathSep + fileName, this.createHandler(shouldPass, afterOK));
        }
    }

    @Test
    public void testMkdirSimple() throws Exception {
        String dirName = "some-dir";
        this.testMkdir(dirName, null, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
        }));
        this.await();
    }

    @Test
    public void testMkdirWithParentsFails() throws Exception {
        String dirName = "top-dir" + this.pathSep + "some-dir";
        this.testMkdir(dirName, null, false, false, null);
        this.await();
    }

    @Test
    public void testMkdirWithPerms() throws Exception {
        String dirName = "some-dir";
        String perms = "rwx--x--x";
        this.testMkdir(dirName, perms, false, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.azzertPerms(perms, dirName);
        }));
        this.await();
    }

    @Test
    public void testMkdirCreateParents() throws Exception {
        String dirName = "top-dir" + this.pathSep + "/some-dir";
        this.testMkdir(dirName, null, true, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
        }));
        this.await();
    }

    @Test
    public void testMkdirCreateParentsWithPerms() throws Exception {
        String dirName = "top-dir" + this.pathSep + "/some-dir";
        String perms = "rwx--x--x";
        this.testMkdir(dirName, perms, true, true, (Handler<Void>)((Handler)v -> {
            this.assertTrue(this.fileExists(dirName));
            this.assertTrue(Files.isDirectory(Paths.get(this.testDir + this.pathSep + dirName, new String[0]), new LinkOption[0]));
            this.azzertPerms(perms, dirName);
        }));
        this.await();
    }

    private void testMkdir(String dirName, String perms, boolean createParents, boolean shouldPass, Handler<Void> afterOK) throws Exception {
        AsyncResultHandler<Void> handler = this.createHandler(shouldPass, afterOK);
        if (createParents) {
            if (perms != null) {
                this.vertx.fileSystem().mkdirs(this.testDir + this.pathSep + dirName, perms, handler);
            } else {
                this.vertx.fileSystem().mkdirs(this.testDir + this.pathSep + dirName, handler);
            }
        } else if (perms != null) {
            this.vertx.fileSystem().mkdir(this.testDir + this.pathSep + dirName, perms, handler);
        } else {
            this.vertx.fileSystem().mkdir(this.testDir + this.pathSep + dirName, handler);
        }
    }

    @Test
    public void testReadDirSimple() throws Exception {
        String dirName = "some-dir";
        this.mkDir(dirName);
        int numFiles = 10;
        for (int i = 0; i < numFiles; ++i) {
            this.createFileWithJunk(dirName + this.pathSep + "file-" + i + ".dat", 100L);
        }
        this.testReadDir(dirName, null, true, (Handler<List<String>>)((Handler)fileNames -> {
            String root;
            this.assertEquals(numFiles, fileNames.size());
            HashSet<String> fset = new HashSet<String>();
            for (String fileName : fileNames) {
                fset.add(fileName);
            }
            File dir = new File(this.testDir + this.pathSep + dirName);
            try {
                root = dir.getCanonicalPath();
            }
            catch (IOException e) {
                this.fail(e.getMessage());
                return;
            }
            for (int i = 0; i < numFiles; ++i) {
                this.assertTrue(fset.contains(root + this.pathSep + "file-" + i + ".dat"));
            }
        }));
        this.await();
    }

    @Test
    public void testReadDirWithFilter() throws Exception {
        int i;
        String dirName = "some-dir";
        this.mkDir(dirName);
        int numFiles = 10;
        for (i = 0; i < numFiles; ++i) {
            this.createFileWithJunk(dirName + this.pathSep + "foo-" + i + ".txt", 100L);
        }
        for (i = 0; i < numFiles; ++i) {
            this.createFileWithJunk(dirName + this.pathSep + "bar-" + i + ".txt", 100L);
        }
        this.testReadDir(dirName, "foo.+", true, (Handler<List<String>>)((Handler)fileNames -> {
            String root;
            this.assertEquals(numFiles, fileNames.size());
            HashSet<String> fset = new HashSet<String>();
            for (String fileName : fileNames) {
                fset.add(fileName);
            }
            File dir = new File(this.testDir + this.pathSep + dirName);
            try {
                root = dir.getCanonicalPath();
            }
            catch (IOException e) {
                this.fail(e.getMessage());
                return;
            }
            for (int i = 0; i < numFiles; ++i) {
                this.assertTrue(fset.contains(root + this.pathSep + "foo-" + i + ".txt"));
            }
        }));
        this.await();
    }

    private void testReadDir(String dirName, String filter, boolean shouldPass, Handler<List<String>> afterOK) throws Exception {
        AsyncResultHandler handler = ar -> {
            if (ar.failed()) {
                if (shouldPass) {
                    this.fail(ar.cause().getMessage());
                } else {
                    this.assertTrue(ar.cause() instanceof FileSystemException);
                    if (afterOK != null) {
                        afterOK.handle(null);
                    }
                    this.testComplete();
                }
            } else if (shouldPass) {
                if (afterOK != null) {
                    afterOK.handle(ar.result());
                }
                this.testComplete();
            } else {
                this.fail("read should fail");
            }
        };
        if (filter == null) {
            this.vertx.fileSystem().readDir(this.testDir + this.pathSep + dirName, (Handler)handler);
        } else {
            this.vertx.fileSystem().readDir(this.testDir + this.pathSep + dirName, filter, (Handler)handler);
        }
    }

    @Test
    public void testReadFile() throws Exception {
        byte[] content = TestUtils.randomByteArray(1000);
        String fileName = "some-file.dat";
        this.createFile(fileName, content);
        this.vertx.fileSystem().readFile(this.testDir + this.pathSep + fileName, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause().getMessage());
            } else {
                this.assertEquals(Buffer.buffer((byte[])content), ar.result());
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testWriteFile() throws Exception {
        byte[] content = TestUtils.randomByteArray(1000);
        Buffer buff = Buffer.buffer((byte[])content);
        String fileName = "some-file.dat";
        this.vertx.fileSystem().writeFile(this.testDir + this.pathSep + fileName, buff, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause().getMessage());
            } else {
                byte[] readBytes;
                this.assertTrue(this.fileExists(fileName));
                this.assertEquals(content.length, this.fileLength(fileName));
                try {
                    readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                }
                catch (IOException e) {
                    this.fail(e.getMessage());
                    return;
                }
                this.assertEquals(buff, Buffer.buffer((byte[])readBytes));
                this.testComplete();
            }
        });
        this.await();
    }

    @Test
    public void testWriteAsync() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        Buffer buff = Buffer.buffer((byte[])content);
        AtomicInteger count = new AtomicInteger();
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), arr -> {
            if (arr.succeeded()) {
                for (int i = 0; i < chunks; ++i) {
                    Buffer chunk = buff.getBuffer(i * chunkSize, (i + 1) * chunkSize);
                    this.assertEquals(chunkSize, chunk.length());
                    ((AsyncFile)arr.result()).write(chunk, (long)(i * chunkSize), ar -> {
                        if (ar.succeeded()) {
                            if (count.incrementAndGet() == chunks) {
                                ((AsyncFile)arr.result()).close(ar2 -> {
                                    if (ar2.failed()) {
                                        this.fail(ar2.cause().getMessage());
                                    } else {
                                        byte[] readBytes;
                                        this.assertTrue(this.fileExists(fileName));
                                        try {
                                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                                        }
                                        catch (IOException e) {
                                            this.fail(e.getMessage());
                                            return;
                                        }
                                        Buffer read = Buffer.buffer((byte[])readBytes);
                                        this.assertEquals(buff, read);
                                        this.testComplete();
                                    }
                                });
                            }
                        } else {
                            this.fail(ar.cause().getMessage());
                        }
                    });
                }
            } else {
                this.fail(arr.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadAsync() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        Buffer expected = Buffer.buffer((byte[])content);
        this.createFile(fileName, content);
        AtomicInteger reads = new AtomicInteger();
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), arr -> {
            if (arr.succeeded()) {
                Buffer buff = Buffer.buffer((int)(chunks * chunkSize));
                for (int i = 0; i < chunks; ++i) {
                    ((AsyncFile)arr.result()).read(buff, i * chunkSize, (long)(i * chunkSize), chunkSize, arb -> {
                        if (arb.succeeded()) {
                            if (reads.incrementAndGet() == chunks) {
                                ((AsyncFile)arr.result()).close(ar -> {
                                    if (ar.failed()) {
                                        this.fail(ar.cause().getMessage());
                                    } else {
                                        this.assertEquals(expected, buff);
                                        this.assertEquals(buff, arb.result());
                                        this.testComplete();
                                    }
                                });
                            }
                        } else {
                            this.fail(arb.cause().getMessage());
                        }
                    });
                }
            } else {
                this.fail(arr.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testWriteStream() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        Buffer buff = Buffer.buffer((byte[])content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                WriteStream ws = (WriteStream)ar.result();
                ws.exceptionHandler(t -> this.fail(t.getMessage()));
                for (int i = 0; i < chunks; ++i) {
                    Buffer chunk = buff.getBuffer(i * chunkSize, (i + 1) * chunkSize);
                    this.assertEquals(chunkSize, chunk.length());
                    ws.write((Object)chunk);
                }
                ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        byte[] readBytes;
                        this.assertTrue(this.fileExists(fileName));
                        try {
                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                        }
                        catch (IOException e) {
                            this.fail(e.getMessage());
                            return;
                        }
                        this.assertEquals(buff, Buffer.buffer((byte[])readBytes));
                        this.testComplete();
                    }
                });
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testWriteStreamAppend() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] existing = TestUtils.randomByteArray(1000);
        this.createFile(fileName, existing);
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        Buffer buff = Buffer.buffer((byte[])content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AsyncFile ws = (AsyncFile)ar.result();
                long size = this.vertx.fileSystem().propsBlocking(this.testDir + this.pathSep + fileName).size();
                ws.setWritePos(size);
                ws.exceptionHandler(t -> this.fail(t.getMessage()));
                for (int i = 0; i < chunks; ++i) {
                    Buffer chunk = buff.getBuffer(i * chunkSize, (i + 1) * chunkSize);
                    this.assertEquals(chunkSize, chunk.length());
                    ws.write(chunk);
                }
                ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        byte[] readBytes;
                        this.assertTrue(this.fileExists(fileName));
                        try {
                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                        }
                        catch (IOException e) {
                            this.fail(e.getMessage());
                            return;
                        }
                        this.assertEquals(Buffer.buffer((byte[])existing).appendBuffer(buff), Buffer.buffer((byte[])readBytes));
                        this.testComplete();
                    }
                });
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testWriteStreamWithCompositeBuffer() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content1 = TestUtils.randomByteArray(chunkSize * (chunks / 2));
        byte[] content2 = TestUtils.randomByteArray(chunkSize * (chunks / 2));
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[][])new byte[][]{content1, content2});
        Buffer buff = Buffer.buffer((ByteBuf)byteBuf);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                WriteStream ws = (WriteStream)ar.result();
                ws.exceptionHandler(t -> this.fail(t.getMessage()));
                ws.write((Object)buff);
                ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        byte[] readBytes;
                        this.assertTrue(this.fileExists(fileName));
                        try {
                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName, new String[0]));
                        }
                        catch (IOException e) {
                            this.fail(e.getMessage());
                            return;
                        }
                        this.assertEquals(buff, Buffer.buffer((byte[])readBytes));
                        byteBuf.release();
                        this.testComplete();
                    }
                });
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStream() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                ReadStream rs = (ReadStream)ar.result();
                Buffer buff = Buffer.buffer();
                rs.handler(arg_0 -> ((Buffer)buff).appendBuffer(arg_0));
                rs.exceptionHandler(t -> this.fail(t.getMessage()));
                rs.endHandler(v -> ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        this.assertEquals(Buffer.buffer((byte[])content), buff);
                        this.testComplete();
                    }
                }));
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStreamWithBufferSize() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 16384;
        int chunks = 1;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AsyncFile rs = (AsyncFile)ar.result();
                rs.setReadBufferSize(chunkSize);
                Buffer buff = Buffer.buffer();
                int[] callCount = new int[]{0};
                rs.handler(buff1 -> {
                    buff.appendBuffer(buff1);
                    callCount[0] = callCount[0] + 1;
                });
                rs.exceptionHandler(t -> this.fail(t.getMessage()));
                rs.endHandler(v -> ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        this.assertEquals(1L, callCount[0]);
                        this.assertEquals(Buffer.buffer((byte[])content), buff);
                        this.testComplete();
                    }
                }));
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testReadStreamSetReadPos() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] content = TestUtils.randomByteArray(chunkSize * chunks);
        this.createFile(fileName, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                AsyncFile rs = (AsyncFile)ar.result();
                rs.setReadPos((long)(chunkSize * chunks / 2));
                Buffer buff = Buffer.buffer();
                rs.handler(arg_0 -> ((Buffer)buff).appendBuffer(arg_0));
                rs.exceptionHandler(t -> this.fail(t.getMessage()));
                rs.endHandler(v -> ((AsyncFile)ar.result()).close(ar2 -> {
                    if (ar2.failed()) {
                        this.fail(ar2.cause().getMessage());
                    } else {
                        this.assertEquals(chunkSize * chunks / 2, buff.length());
                        byte[] lastHalf = new byte[chunkSize * chunks / 2];
                        System.arraycopy(content, chunkSize * chunks / 2, lastHalf, 0, chunkSize * chunks / 2);
                        this.assertEquals(Buffer.buffer((byte[])lastHalf), buff);
                        this.testComplete();
                    }
                }));
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testPumpFileStreams() throws Exception {
        String fileName1 = "some-file.dat";
        String fileName2 = "some-other-file.dat";
        int fileSize = 8194457;
        byte[] content = TestUtils.randomByteArray(fileSize);
        this.createFile(fileName1, content);
        this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName1, new OpenOptions(), arr -> {
            if (arr.succeeded()) {
                ReadStream rs = (ReadStream)arr.result();
                this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName2, new OpenOptions(), ar -> {
                    if (ar.succeeded()) {
                        WriteStream ws = (WriteStream)ar.result();
                        Pump p = Pump.pump((ReadStream)rs, (WriteStream)ws);
                        p.start();
                        rs.endHandler(v -> ((AsyncFile)arr.result()).close(car -> {
                            if (car.failed()) {
                                this.fail(ar.cause().getMessage());
                            } else {
                                ((AsyncFile)ar.result()).close(ar2 -> {
                                    if (ar2.failed()) {
                                        this.fail(ar2.cause().getMessage());
                                    } else {
                                        byte[] readBytes;
                                        this.assertTrue(this.fileExists(fileName2));
                                        try {
                                            readBytes = Files.readAllBytes(Paths.get(this.testDir + this.pathSep + fileName2, new String[0]));
                                        }
                                        catch (IOException e) {
                                            this.fail(e.getMessage());
                                            return;
                                        }
                                        this.assertEquals(Buffer.buffer((byte[])content), Buffer.buffer((byte[])readBytes));
                                        this.testComplete();
                                    }
                                });
                            }
                        }));
                    } else {
                        this.fail(ar.cause().getMessage());
                    }
                });
            } else {
                this.fail(arr.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testCreateFileNoPerms() throws Exception {
        this.testCreateFile(null, true);
    }

    @Test
    public void testCreateFileWithPerms() throws Exception {
        this.testCreateFile("rwx------", true);
    }

    @Test
    public void testCreateFileAlreadyExists() throws Exception {
        this.createFileWithJunk("some-file.dat", 100L);
        this.testCreateFile(null, false);
    }

    private void testCreateFile(String perms, boolean shouldPass) throws Exception {
        String fileName = "some-file.dat";
        AsyncResultHandler handler = ar -> {
            if (ar.failed()) {
                if (shouldPass) {
                    this.fail(ar.cause().getMessage());
                } else {
                    this.assertTrue(ar.cause() instanceof FileSystemException);
                    this.testComplete();
                }
            } else if (shouldPass) {
                this.assertTrue(this.fileExists(fileName));
                this.assertEquals(0L, this.fileLength(fileName));
                if (perms != null) {
                    this.azzertPerms(perms, fileName);
                }
                this.testComplete();
            } else {
                this.fail("test should fail");
            }
        };
        if (perms != null) {
            this.vertx.fileSystem().createFile(this.testDir + this.pathSep + fileName, perms, (Handler)handler);
        } else {
            this.vertx.fileSystem().createFile(this.testDir + this.pathSep + fileName, (Handler)handler);
        }
        this.await();
    }

    @Test
    public void testExists() throws Exception {
        this.testExists(true);
    }

    @Test
    public void testNotExists() throws Exception {
        this.testExists(false);
    }

    private void testExists(boolean exists) throws Exception {
        String fileName = "some-file.dat";
        if (exists) {
            this.createFileWithJunk(fileName, 100L);
        }
        this.vertx.fileSystem().exists(this.testDir + this.pathSep + fileName, ar -> {
            if (ar.succeeded()) {
                if (exists) {
                    this.assertTrue((Boolean)ar.result());
                } else {
                    this.assertFalse((Boolean)ar.result());
                }
                this.testComplete();
            } else {
                this.fail(ar.cause().getMessage());
            }
        });
        this.await();
    }

    @Test
    public void testFSProps() throws Exception {
        String fileName = "some-file.txt";
        this.createFileWithJunk(fileName, 1234L);
        this.testFSProps(fileName, (Handler<FileSystemProps>)((Handler)props -> {
            this.assertTrue(props.totalSpace() > 0L);
            this.assertTrue(props.unallocatedSpace() > 0L);
            this.assertTrue(props.usableSpace() > 0L);
        }));
        this.await();
    }

    private void testFSProps(String fileName, Handler<FileSystemProps> afterOK) throws Exception {
        this.vertx.fileSystem().fsProps(this.testDir + this.pathSep + fileName, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause().getMessage());
            } else {
                afterOK.handle(ar.result());
                this.testComplete();
            }
        });
    }

    @Test
    public void testOpenOptions() {
        OpenOptions opts = new OpenOptions();
        this.assertNull(opts.getPerms());
        String perms = "rwxrwxrwx";
        this.assertEquals(opts, opts.setPerms(perms));
        this.assertEquals(perms, opts.getPerms());
        this.assertTrue(opts.isCreate());
        this.assertEquals(opts, opts.setCreate(false));
        this.assertFalse(opts.isCreate());
        this.assertFalse(opts.isCreateNew());
        this.assertEquals(opts, opts.setCreateNew(true));
        this.assertTrue(opts.isCreateNew());
        this.assertTrue(opts.isRead());
        this.assertEquals(opts, opts.setRead(false));
        this.assertFalse(opts.isRead());
        this.assertTrue(opts.isWrite());
        this.assertEquals(opts, opts.setWrite(false));
        this.assertFalse(opts.isWrite());
        this.assertFalse(opts.isDsync());
        this.assertEquals(opts, opts.setDsync(true));
        this.assertTrue(opts.isDsync());
        this.assertFalse(opts.isSync());
        this.assertEquals(opts, opts.setSync(true));
        this.assertTrue(opts.isSync());
        this.assertFalse(opts.isDeleteOnClose());
        this.assertEquals(opts, opts.setDeleteOnClose(true));
        this.assertTrue(opts.isDeleteOnClose());
        this.assertFalse(opts.isTruncateExisting());
        this.assertEquals(opts, opts.setTruncateExisting(true));
        this.assertTrue(opts.isTruncateExisting());
        this.assertFalse(opts.isSparse());
        this.assertEquals(opts, opts.setSparse(true));
        this.assertTrue(opts.isSparse());
    }

    @Test
    public void testDefaultOptionOptions() {
        OpenOptions def = new OpenOptions();
        OpenOptions json = new OpenOptions(new JsonObject());
        this.assertEquals(def.getPerms(), json.getPerms());
        this.assertEquals(def.isRead(), json.isRead());
        this.assertEquals(def.isWrite(), json.isWrite());
        this.assertEquals(def.isCreate(), json.isCreate());
        this.assertEquals(def.isCreateNew(), json.isCreateNew());
        this.assertEquals(def.isDeleteOnClose(), json.isDeleteOnClose());
        this.assertEquals(def.isTruncateExisting(), json.isTruncateExisting());
        this.assertEquals(def.isSparse(), json.isSparse());
        this.assertEquals(def.isSync(), json.isSync());
        this.assertEquals(def.isDsync(), json.isDsync());
    }

    @Test
    public void testAsyncFileCloseHandlerIsAsync() throws Exception {
        String fileName = "some-file.dat";
        this.createFileWithJunk(fileName, 100L);
        AsyncFile file = this.vertx.fileSystem().openBlocking(this.testDir + this.pathSep + fileName, new OpenOptions());
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        file.close(ar -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.testComplete();
        });
        this.await();
    }

    private AsyncResultHandler<Void> createHandler(boolean shouldPass, Handler<Void> afterOK) {
        return ar -> {
            if (ar.failed()) {
                if (shouldPass) {
                    this.fail(ar.cause().getMessage());
                } else {
                    this.assertTrue(ar.cause() instanceof FileSystemException);
                    if (afterOK != null) {
                        afterOK.handle(null);
                    }
                    this.testComplete();
                }
            } else if (shouldPass) {
                if (afterOK != null) {
                    afterOK.handle(null);
                }
                this.testComplete();
            } else {
                this.fail("operation should fail");
            }
        };
    }

    private boolean fileExists(String fileName) {
        File file = new File(this.testDir, fileName);
        return file.exists();
    }

    private void createFileWithJunk(String fileName, long length) throws Exception {
        this.createFile(fileName, TestUtils.randomByteArray((int)length));
    }

    private void createFile(String fileName, byte[] bytes) throws Exception {
        File file = new File(this.testDir, fileName);
        Path path = Paths.get(file.getCanonicalPath(), new String[0]);
        Files.write(path, bytes, new OpenOption[0]);
        this.setPerms(path, DEFAULT_FILE_PERMS);
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDir(files[i]);
                continue;
            }
            files[i].delete();
        }
        dir.delete();
    }

    private void deleteDir(String dir) {
        this.deleteDir(new File(this.testDir + this.pathSep + dir));
    }

    private void mkDir(String dirName) throws Exception {
        File dir = new File(this.testDir + this.pathSep + dirName);
        dir.mkdir();
        this.setPerms(Paths.get(dir.getCanonicalPath(), new String[0]), DEFAULT_DIR_PERMS);
    }

    private long fileLength(String fileName) {
        File file = new File(this.testDir, fileName);
        return file.length();
    }

    private void setPerms(Path path, String perms) {
        if (!Utils.isWindows()) {
            try {
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(perms));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private String getPerms(String fileName) {
        try {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(Paths.get(this.testDir + this.pathSep + fileName, new String[0]), new LinkOption[0]);
            return PosixFilePermissions.toString(perms);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void deleteFile(String fileName) {
        File file = new File(this.testDir + this.pathSep + fileName);
        file.delete();
    }
}

