/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.test.core.ConnectHttpProxy;
import io.vertx.test.core.HttpTestBase;
import io.vertx.test.core.SocksProxy;
import io.vertx.test.core.TLSCert;
import io.vertx.test.core.TestProxyBase;
import io.vertx.test.core.VertxTestBase;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class HttpTLSTest
extends HttpTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    private TestProxyBase proxy;

    @Override
    protected void tearDown() throws Exception {
        if (this.proxy != null) {
            this.proxy.stop();
        }
        super.tearDown();
    }

    private void startProxy(String username, ProxyType proxyType) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.proxy = proxyType == ProxyType.HTTP ? new ConnectHttpProxy(username) : new SocksProxy(username);
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> latch.countDown()));
        this.awaitLatch(latch);
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.JKS, TLSCert.NONE).clientTrustAll().pass();
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.PKCS12, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEM() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.PEM, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertJKSRootCAWithJKSRootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS_ROOT_CA, TLSCert.JKS_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertJKSRootCAWithPKCS12RootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PKCS12_ROOT_CA, TLSCert.JKS_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertJKSRootRootCAWithPEMRootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PEM_ROOT_CA, TLSCert.JKS_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12RootCAWithJKSRootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS_ROOT_CA, TLSCert.PKCS12_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12RootCAWithPKCS12RootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PKCS12_ROOT_CA, TLSCert.PKCS12_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12RootCAWithPEMRootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PEM_ROOT_CA, TLSCert.PKCS12_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMRootCAWithJKSRootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS_ROOT_CA, TLSCert.PEM_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMRootCAWithPKCS12RootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PKCS12_ROOT_CA, TLSCert.PEM_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMRootCAWithPEMRootCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PEM_ROOT_CA, TLSCert.PEM_ROOT_CA, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMRootCAWithPEMCAChain() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PEM_ROOT_CA, TLSCert.PEM_CA_CHAIN, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientUntrustedServerCertPEMRootCAWithPEMCA() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PEM_ROOT_CA, TLSCert.PEM_CA, TLSCert.NONE).fail();
    }

    @Test
    public void testTLSClientTrustPKCS12ServerCert() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PKCS12, TLSCert.JKS, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientTrustPEMServerCert() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PEM, TLSCert.JKS, TLSCert.NONE).pass();
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.JKS, TLSCert.NONE).fail();
    }

    @Test
    public void testTLSClientUntrustedServerPEM() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.PEM, TLSCert.NONE).fail();
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(TLSCert.JKS, TLSCert.JKS, TLSCert.JKS, TLSCert.JKS).pass();
    }

    @Test
    public void testTLSClientCertNotRequiredPEM() throws Exception {
        this.testTLS(TLSCert.JKS, TLSCert.JKS, TLSCert.PEM, TLSCert.JKS).pass();
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(TLSCert.JKS, TLSCert.JKS, TLSCert.JKS, TLSCert.JKS).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertRequiredPKCS12() throws Exception {
        this.testTLS(TLSCert.JKS, TLSCert.JKS, TLSCert.JKS, TLSCert.PKCS12).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertRequiredPEM() throws Exception {
        this.testTLS(TLSCert.JKS, TLSCert.JKS, TLSCert.JKS, TLSCert.PEM).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertPKCS12Required() throws Exception {
        this.testTLS(TLSCert.PKCS12, TLSCert.JKS, TLSCert.JKS, TLSCert.JKS).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertPEMRequired() throws Exception {
        this.testTLS(TLSCert.PEM, TLSCert.JKS, TLSCert.JKS, TLSCert.JKS).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertPEM_CARequired() throws Exception {
        this.testTLS(TLSCert.PEM_ROOT_CA, TLSCert.JKS, TLSCert.JKS, TLSCert.PEM_ROOT_CA).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.JKS).requiresClientAuth().fail();
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(TLSCert.JKS, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).requiresClientAuth().fail();
    }

    @Test
    public void testTLSClientRevokedServerCert() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PEM_ROOT_CA, TLSCert.PEM_ROOT_CA, TLSCert.NONE).clientUsesCrl().fail();
    }

    @Test
    public void testTLSRevokedClientCertServer() throws Exception {
        this.testTLS(TLSCert.PEM_ROOT_CA, TLSCert.JKS, TLSCert.JKS, TLSCert.PEM_ROOT_CA).requiresClientAuth().clientUsesCrl().fail();
    }

    @Test
    public void testTLSMatchingCipherSuites() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.JKS, TLSCert.NONE).clientTrustAll().serverEnabledCipherSuites(ENABLED_CIPHER_SUITES).pass();
    }

    @Test
    public void testTLSNonMatchingCipherSuites() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.JKS, TLSCert.NONE).clientTrustAll().serverEnabledCipherSuites(new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"}).clientEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).fail();
    }

    @Test
    public void testTLSMatchingProtocolVersions() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.JKS, TLSCert.NONE).clientTrustAll().serverEnabledSecureTransportProtocol(new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1", "TLSv1.2"}).pass();
    }

    @Test
    public void testTLSInvalidProtocolVersion() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.JKS, TLSCert.NONE).clientTrustAll().serverEnabledSecureTransportProtocol(new String[]{"HelloWorld"}).fail();
    }

    @Test
    public void testTLSNonMatchingProtocolVersions() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.JKS, TLSCert.NONE).clientTrustAll().serverEnabledSecureTransportProtocol(new String[]{"TLSv1.2"}).clientEnabledSecureTransportProtocol(new String[]{"SSLv2Hello"}).fail();
    }

    @Test
    public void testTLSVerifyMatchingHost() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.JKS, TLSCert.NONE).clientTrustAll().clientVerifyHost().pass();
    }

    @Test
    public void testTLSVerifyNonMatchingHost() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.NONE, TLSCert.MIM, TLSCert.NONE).clientTrustAll().clientVerifyHost().fail();
    }

    @Test
    public void testTLSClientTrustServerCertPEMOpenSSL() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.PEM, TLSCert.NONE).serverOpenSSL().pass();
    }

    @Test
    public void testTLSClientTrustServerCertWithJKSOpenSSL() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).clientOpenSSL().pass();
    }

    @Test
    public void testTLSClientTrustServerCertWithPKCS12OpenSSL() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PKCS12, TLSCert.JKS, TLSCert.NONE).clientOpenSSL().pass();
    }

    @Test
    public void testTLSClientTrustServerCertWithPEMOpenSSL() throws Exception {
        this.testTLS(TLSCert.NONE, TLSCert.PEM, TLSCert.JKS, TLSCert.NONE).clientOpenSSL().pass();
    }

    abstract HttpServer createHttpServer(HttpServerOptions var1);

    abstract HttpClient createHttpClient(HttpClientOptions var1);

    protected TLSTest testTLS(TLSCert clientCert, TLSCert clientTrust, TLSCert serverCert, TLSCert serverTrust) throws Exception {
        return new TLSTest(clientCert, clientTrust, serverCert, serverTrust);
    }

    @Test
    public void testJKSInvalidPath() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)TLSCert.JKS.getServerKeyCertOptions()).setPath("/invalid.jks"), "java.nio.file.NoSuchFileException: ", "invalid.jks");
    }

    @Test
    public void testJKSMissingPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)TLSCert.JKS.getServerKeyCertOptions()).setPassword(null), "Password must not be null", null);
    }

    @Test
    public void testJKSInvalidPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)TLSCert.JKS.getServerKeyCertOptions()).setPassword("wrongpassword"), "Keystore was tampered with, or password was incorrect", null);
    }

    @Test
    public void testJKSOpenSSL() {
        HttpServerOptions serverOptions = new HttpServerOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions());
        HttpTLSTest.setOptions((TCPSSLOptions)serverOptions, TLSCert.JKS.getServerKeyCertOptions());
        this.testStore(serverOptions, Collections.singletonList("OpenSSL server key/certificate must be configured with .pem format"), null);
    }

    @Test
    public void testPKCS12OpenSSL() {
        HttpServerOptions serverOptions = new HttpServerOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions());
        HttpTLSTest.setOptions((TCPSSLOptions)serverOptions, TLSCert.JKS.getServerKeyCertOptions());
        this.testStore(serverOptions, Collections.singletonList("OpenSSL server key/certificate must be configured with .pem format"), null);
    }

    @Test
    public void testPKCS12InvalidPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)TLSCert.PKCS12.getServerKeyCertOptions()).setPath("/invalid.p12"), "java.nio.file.NoSuchFileException: ", "invalid.p12");
    }

    @Test
    public void testPKCS12MissingPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)TLSCert.PKCS12.getServerKeyCertOptions()).setPassword(null), "Get Key failed: null", null);
    }

    @Test
    public void testPKCS12InvalidPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)TLSCert.PKCS12.getServerKeyCertOptions()).setPassword("wrongpassword"), Arrays.asList("failed to decrypt safe contents entry: javax.crypto.BadPaddingException: Given final block not properly padded", "keystore password was incorrect"), null);
    }

    @Test
    public void testKeyCertMissingKeyPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)TLSCert.PEM.getServerKeyCertOptions()).setKeyPath(null), "Missing private key", null);
    }

    @Test
    public void testKeyCertInvalidKeyPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)TLSCert.PEM.getServerKeyCertOptions()).setKeyPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testKeyCertMissingCertPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)TLSCert.PEM.getServerKeyCertOptions()).setCertPath(null), "Missing X.509 certificate", null);
    }

    @Test
    public void testKeyCertInvalidCertPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)TLSCert.PEM.getServerKeyCertOptions()).setCertPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testKeyCertInvalidPem() throws IOException {
        String[] contents = new String[]{"", "-----BEGIN PRIVATE KEY-----", "-----BEGIN PRIVATE KEY-----\n-----END PRIVATE KEY-----", "-----BEGIN PRIVATE KEY-----\n*\n-----END PRIVATE KEY-----"};
        String[] messages = new String[]{"Missing -----BEGIN PRIVATE KEY----- delimiter", "Missing -----END PRIVATE KEY----- delimiter", "Empty pem file", "Input byte[] should at least have 2 bytes for base64 bytes"};
        for (int i = 0; i < contents.length; ++i) {
            Path file = this.testFolder.newFile("vertx" + UUID.randomUUID().toString() + ".pem").toPath();
            Files.write(file, Collections.singleton(contents[i]), new OpenOption[0]);
            String expectedMessage = messages[i];
            this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)TLSCert.PEM.getServerKeyCertOptions()).setKeyPath(file.toString()), expectedMessage, null);
        }
    }

    @Test
    public void testNoKeyCert() {
        this.testInvalidKeyStore(null, "Key/certificate is mandatory for SSL", null);
    }

    @Test
    public void testCaInvalidPath() {
        this.testInvalidTrustStore((TrustOptions)new PemTrustOptions().addCertPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testCaInvalidPem() throws IOException {
        String[] contents = new String[]{"", "-----BEGIN CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\n-----END CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\n*\n-----END CERTIFICATE-----"};
        String[] messages = new String[]{"Missing -----BEGIN CERTIFICATE----- delimiter", "Missing -----END CERTIFICATE----- delimiter", "Empty pem file", "Input byte[] should at least have 2 bytes for base64 bytes"};
        for (int i = 0; i < contents.length; ++i) {
            Path file = this.testFolder.newFile("vertx" + UUID.randomUUID().toString() + ".pem").toPath();
            Files.write(file, Collections.singleton(contents[i]), new OpenOption[0]);
            String expectedMessage = messages[i];
            this.testInvalidTrustStore((TrustOptions)new PemTrustOptions().addCertPath(file.toString()), expectedMessage, null);
        }
    }

    private void testInvalidKeyStore(KeyCertOptions options, String expectedPrefix, String expectedSuffix) {
        HttpServerOptions serverOptions = new HttpServerOptions();
        HttpTLSTest.setOptions((TCPSSLOptions)serverOptions, options);
        this.testStore(serverOptions, Collections.singletonList(expectedPrefix), expectedSuffix);
    }

    private void testInvalidKeyStore(KeyCertOptions options, List<String> expectedPossiblePrefixes, String expectedSuffix) {
        HttpServerOptions serverOptions = new HttpServerOptions();
        HttpTLSTest.setOptions((TCPSSLOptions)serverOptions, options);
        this.testStore(serverOptions, expectedPossiblePrefixes, expectedSuffix);
    }

    private void testInvalidTrustStore(TrustOptions options, String expectedPrefix, String expectedSuffix) {
        HttpServerOptions serverOptions = new HttpServerOptions();
        HttpTLSTest.setOptions((TCPSSLOptions)serverOptions, options);
        this.testStore(serverOptions, Collections.singletonList(expectedPrefix), expectedSuffix);
    }

    private void testStore(HttpServerOptions serverOptions, List<String> expectedPossiblePrefixes, String expectedSuffix) {
        serverOptions.setSsl(true);
        serverOptions.setPort(4043);
        HttpServer server = this.vertx.createHttpServer(serverOptions);
        server.requestHandler(req -> {});
        try {
            server.listen();
            this.fail("Was expecting a failure");
        }
        catch (VertxException e) {
            Throwable cause = e.getCause();
            if (expectedSuffix == null) {
                boolean ok = expectedPossiblePrefixes.isEmpty();
                for (String expectedPossiblePrefix : expectedPossiblePrefixes) {
                    ok |= expectedPossiblePrefix.equals(cause.getMessage());
                }
                if (!ok) {
                    this.fail("Was expecting <" + cause.getMessage() + ">  to be equals to one of " + expectedPossiblePrefixes);
                }
            }
            boolean ok = expectedPossiblePrefixes.isEmpty();
            for (String expectedPossiblePrefix : expectedPossiblePrefixes) {
                ok |= cause.getMessage().startsWith(expectedPossiblePrefix);
            }
            if (!ok) {
                this.fail("Was expecting e.getCause().getMessage() to be prefixed by one of " + expectedPossiblePrefixes);
            }
            this.assertTrue(cause.getMessage().endsWith(expectedSuffix));
        }
    }

    @Test
    public void testCrlInvalidPath() throws Exception {
        HttpClientOptions clientOptions = new HttpClientOptions();
        HttpTLSTest.setOptions((TCPSSLOptions)clientOptions, TLSCert.PEM_ROOT_CA.getClientTrustOptions());
        clientOptions.setSsl(true);
        clientOptions.addCrlPath("/invalid.pem");
        HttpClient client = this.vertx.createHttpClient(clientOptions);
        HttpClientRequest req = client.request(HttpMethod.CONNECT, 8080, "localhost", "/", handler -> {});
        try {
            req.end();
            this.fail("Was expecting a failure");
        }
        catch (VertxException e) {
            this.assertNotNull(e.getCause());
            this.assertEquals(NoSuchFileException.class, e.getCause().getCause().getClass());
        }
    }

    @Test
    public void testHttpsProxy() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).useProxy().pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "localhost:4043", this.proxy.getLastUri());
    }

    @Test
    public void testHttpsProxyAuthFail() throws Exception {
        this.startProxy("username", ProxyType.HTTP);
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).useProxy().useProxyAuth().fail();
    }

    @Test
    public void testHttpsProxyAuth() throws Exception {
        this.startProxy("username", ProxyType.HTTP);
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).useProxy().useProxyAuth().pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "localhost:4043", this.proxy.getLastUri());
    }

    @Test
    public void testHttpsProxyUnknownHost() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.proxy.setForceUri("localhost:4043");
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).useProxy().useProxyAuth().connectHostname("doesnt-resolve.host-name").clientTrustAll().clientVerifyHost(false).pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "doesnt-resolve.host-name:4043", this.proxy.getLastUri());
    }

    @Test
    public void testHttpsSocks() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).useProxy().useSocksProxy().pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "localhost:4043", this.proxy.getLastUri());
    }

    @Test
    public void testHttpsSocksAuth() throws Exception {
        this.startProxy("username", ProxyType.SOCKS5);
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).useProxy().useSocksProxy().useProxyAuth().pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "localhost:4043", this.proxy.getLastUri());
    }

    @Test
    public void testSocksProxyUnknownHost() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.proxy.setForceUri("localhost:4043");
        this.testTLS(TLSCert.NONE, TLSCert.JKS, TLSCert.JKS, TLSCert.NONE).useProxy().useSocksProxy().connectHostname("doesnt-resolve.host-name").clientTrustAll().clientVerifyHost(false).pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "doesnt-resolve.host-name:4043", this.proxy.getLastUri());
    }

    class TLSTest {
        HttpVersion version;
        TLSCert clientCert;
        TLSCert clientTrust;
        TLSCert serverCert;
        TLSCert serverTrust;
        boolean clientTrustAll;
        boolean clientUsesCrl;
        boolean clientUsesAlpn;
        boolean clientOpenSSL;
        boolean clientVerifyHost = true;
        boolean requiresClientAuth;
        boolean serverUsesCrl;
        boolean serverOpenSSL;
        boolean serverUsesAlpn;
        boolean useProxy;
        boolean useProxyAuth;
        boolean useSocksProxy;
        String[] clientEnabledCipherSuites = new String[0];
        String[] serverEnabledCipherSuites = new String[0];
        String[] clientEnabledSecureTransportProtocol = new String[0];
        String[] serverEnabledSecureTransportProtocol = new String[0];
        private String connectHostname;

        public TLSTest(TLSCert clientCert, TLSCert clientTrust, TLSCert serverCert, TLSCert serverTrust) {
            this.version = HttpVersion.HTTP_1_1;
            this.clientCert = clientCert;
            this.clientTrust = clientTrust;
            this.serverCert = serverCert;
            this.serverTrust = serverTrust;
        }

        TLSTest version(HttpVersion version) {
            this.version = version;
            return this;
        }

        TLSTest requiresClientAuth() {
            this.requiresClientAuth = true;
            return this;
        }

        TLSTest serverUsesCrl() {
            this.serverUsesCrl = true;
            return this;
        }

        TLSTest serverOpenSSL() {
            this.serverOpenSSL = true;
            return this;
        }

        TLSTest clientOpenSSL() {
            this.clientOpenSSL = true;
            return this;
        }

        TLSTest clientUsesCrl() {
            this.clientUsesCrl = true;
            return this;
        }

        TLSTest clientTrustAll() {
            this.clientTrustAll = true;
            return this;
        }

        TLSTest clientVerifyHost() {
            this.clientVerifyHost = true;
            return this;
        }

        TLSTest clientVerifyHost(boolean verify) {
            this.clientVerifyHost = verify;
            return this;
        }

        TLSTest clientEnabledCipherSuites(String[] value) {
            this.clientEnabledCipherSuites = value;
            return this;
        }

        TLSTest serverEnabledCipherSuites(String[] value) {
            this.serverEnabledCipherSuites = value;
            return this;
        }

        TLSTest clientEnabledSecureTransportProtocol(String[] value) {
            this.clientEnabledSecureTransportProtocol = value;
            return this;
        }

        TLSTest serverEnabledSecureTransportProtocol(String[] value) {
            this.serverEnabledSecureTransportProtocol = value;
            return this;
        }

        TLSTest clientUsesAlpn() {
            this.clientUsesAlpn = true;
            return this;
        }

        TLSTest serverUsesAlpn() {
            this.serverUsesAlpn = true;
            return this;
        }

        TLSTest useProxy() {
            this.useProxy = true;
            return this;
        }

        TLSTest useProxyAuth() {
            this.useProxyAuth = true;
            return this;
        }

        TLSTest useSocksProxy() {
            this.useSocksProxy = true;
            return this;
        }

        TLSTest connectHostname(String connectHostname) {
            this.connectHostname = connectHostname;
            return this;
        }

        void pass() {
            this.run(true);
        }

        void fail() {
            this.run(false);
        }

        void run(boolean shouldPass) {
            HttpTLSTest.this.server.close();
            HttpClientOptions options = new HttpClientOptions();
            options.setProtocolVersion(this.version);
            options.setSsl(true);
            if (this.clientTrustAll) {
                options.setTrustAll(true);
            }
            if (this.clientUsesCrl) {
                options.addCrlPath("tls/root-ca/crl.pem");
            }
            if (this.clientOpenSSL) {
                options.setOpenSslEngineOptions(new OpenSSLEngineOptions());
            }
            if (this.clientUsesAlpn) {
                options.setUseAlpn(true);
            }
            options.setVerifyHost(this.clientVerifyHost);
            VertxTestBase.setOptions((TCPSSLOptions)options, this.clientTrust.getClientTrustOptions());
            VertxTestBase.setOptions((TCPSSLOptions)options, this.clientCert.getClientKeyCertOptions());
            for (String suite : this.clientEnabledCipherSuites) {
                options.addEnabledCipherSuite(suite);
            }
            for (String protocols : this.clientEnabledSecureTransportProtocol) {
                options.addEnabledSecureTransportProtocol(protocols);
            }
            if (this.useProxy) {
                ProxyOptions proxyOptions = this.useSocksProxy ? new ProxyOptions().setHost("localhost").setPort(11080).setType(ProxyType.SOCKS5) : new ProxyOptions().setHost("localhost").setPort(13128).setType(ProxyType.HTTP);
                if (this.useProxyAuth) {
                    proxyOptions.setUsername("username").setPassword("username");
                }
                options.setProxyOptions(proxyOptions);
            }
            HttpTLSTest.this.client = HttpTLSTest.this.createHttpClient(options);
            HttpServerOptions serverOptions = new HttpServerOptions();
            serverOptions.setSsl(true);
            VertxTestBase.setOptions((TCPSSLOptions)serverOptions, this.serverTrust.getServerTrustOptions());
            VertxTestBase.setOptions((TCPSSLOptions)serverOptions, this.serverCert.getServerKeyCertOptions());
            if (this.requiresClientAuth) {
                serverOptions.setClientAuth(ClientAuth.REQUIRED);
            }
            if (this.serverUsesCrl) {
                serverOptions.addCrlPath("tls/root-ca/crl.pem");
            }
            if (this.serverOpenSSL) {
                serverOptions.setOpenSslEngineOptions(new OpenSSLEngineOptions());
            }
            if (this.serverUsesAlpn) {
                serverOptions.setUseAlpn(true);
            }
            for (String suite : this.serverEnabledCipherSuites) {
                serverOptions.addEnabledCipherSuite(suite);
            }
            for (String protocols : this.serverEnabledSecureTransportProtocol) {
                serverOptions.addEnabledSecureTransportProtocol(protocols);
            }
            HttpTLSTest.this.server = HttpTLSTest.this.createHttpServer(serverOptions.setPort(4043));
            HttpTLSTest.this.server.requestHandler(req -> {
                HttpTLSTest.this.assertEquals(this.version, req.version());
                req.bodyHandler(buffer -> {
                    HttpTLSTest.this.assertEquals(true, req.isSSL());
                    HttpTLSTest.this.assertEquals("foo", buffer.toString());
                    req.response().end("bar");
                });
            });
            HttpTLSTest.this.server.listen(ar -> {
                HttpTLSTest.this.assertTrue(ar.succeeded());
                String httpHost = this.connectHostname != null ? this.connectHostname : "localhost";
                HttpClientRequest req = HttpTLSTest.this.client.request(HttpMethod.GET, 4043, httpHost, "some-uri", response -> {
                    response.version();
                    response.bodyHandler(data -> HttpTLSTest.this.assertEquals("bar", data.toString()));
                    HttpTLSTest.this.testComplete();
                });
                req.exceptionHandler(t -> {
                    if (shouldPass) {
                        t.printStackTrace();
                        HttpTLSTest.this.fail("Should not throw exception");
                    } else {
                        HttpTLSTest.this.testComplete();
                    }
                });
                req.end("foo");
            });
            HttpTLSTest.this.await();
        }
    }
}

