/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;

public class HttpTestBase
extends VertxTestBase {
    public static final String DEFAULT_HTTP_HOST = "localhost";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final String DEFAULT_HTTPS_HOST = "localhost";
    public static final int DEFAULT_HTTPS_PORT = 4043;
    public static final String DEFAULT_HTTPS_HOST_AND_PORT = "localhost:4043";
    public static final String DEFAULT_TEST_URI = "some-uri";
    protected HttpServer server;
    protected HttpClient client;
    private static final Handler noOp = e -> {};

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.close(asyncResult -> {
                this.assertTrue(asyncResult.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        super.tearDown();
    }

    protected <E> Handler<E> noOpHandler() {
        return noOp;
    }

    protected void startServer() throws Exception {
        this.startServer(this.vertx.getOrCreateContext());
    }

    protected void startServer(Context context) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        context.runOnContext(v -> this.server.listen(this.onSuccess(s -> latch.countDown())));
        this.awaitLatch(latch);
    }
}

