/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.metrics.impl.DummyVertxMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.test.core.SimpleVertxMetricsFactory;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakemetrics.FakeVertxMetrics;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import org.junit.Test;

public class MetricsOptionsTest
extends VertxTestBase {
    @Test
    public void testOptions() {
        MetricsOptions options = new MetricsOptions();
        this.assertFalse(options.isEnabled());
        this.assertEquals(options, options.setEnabled(true));
        this.assertTrue(options.isEnabled());
    }

    @Test
    public void testCopyOptions() {
        MetricsOptions options = new MetricsOptions();
        Random rand = new Random();
        boolean metricsEnabled = rand.nextBoolean();
        options.setEnabled(metricsEnabled);
        options = new MetricsOptions(options);
        this.assertEquals(metricsEnabled, options.isEnabled());
    }

    @Test
    public void testJsonOptions() {
        MetricsOptions options = new MetricsOptions(new JsonObject());
        this.assertFalse(options.isEnabled());
        Random rand = new Random();
        boolean metricsEnabled = rand.nextBoolean();
        String customValue = TestUtils.randomAlphaString(10);
        options = new MetricsOptions(new JsonObject().put("enabled", Boolean.valueOf(metricsEnabled)).put("custom", customValue));
        this.assertEquals(metricsEnabled, options.isEnabled());
        this.assertEquals(metricsEnabled, options.toJson().getBoolean("enabled"));
        this.assertEquals(customValue, options.toJson().getString("custom"));
    }

    @Test
    public void testMetricsEnabledWithoutConfig() {
        this.vertx.close();
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true)));
        VertxMetrics metrics = ((VertxInternal)this.vertx).metricsSPI();
        this.assertNotNull(metrics);
        this.assertTrue(metrics instanceof DummyVertxMetrics);
    }

    @Test
    public void testSetMetricsInstance() {
        DummyVertxMetrics metrics = DummyVertxMetrics.INSTANCE;
        this.vertx.close();
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory(new SimpleVertxMetricsFactory<DummyVertxMetrics>(metrics))));
        this.assertSame(metrics, ((VertxInternal)this.vertx).metricsSPI());
    }

    @Test
    public void testMetricsFromServiceLoader() {
        this.vertx.close();
        VertxOptions options = new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true));
        this.vertx = MetricsOptionsTest.createVertxLoadingMetricsFromMetaInf(options, "io.vertx.test.fakemetrics.FakeMetricsFactory");
        VertxMetrics metrics = ((VertxInternal)this.vertx).metricsSPI();
        this.assertNotNull(metrics);
        this.assertTrue(metrics instanceof FakeVertxMetrics);
    }

    @Test
    public void testSetMetricsInstanceTakesPrecedenceOverServiceLoader() {
        DummyVertxMetrics metrics = DummyVertxMetrics.INSTANCE;
        this.vertx.close();
        VertxOptions options = new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory(new SimpleVertxMetricsFactory<DummyVertxMetrics>(metrics)));
        this.vertx = MetricsOptionsTest.createVertxLoadingMetricsFromMetaInf(options, "io.vertx.test.fakemetrics.FakeMetricsFactory");
        this.assertSame(metrics, ((VertxInternal)this.vertx).metricsSPI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vertx createVertxLoadingMetricsFromMetaInf(VertxOptions options, String factoryFqn) {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = MetricsOptionsTest.createMetricsFromMetaInfLoader(factoryFqn);
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Vertx vertx = Vertx.vertx((VertxOptions)options);
            return vertx;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    static ClassLoader createMetricsFromMetaInfLoader(final String factoryFqn) {
        return new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader()){

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                if (name.equals("META-INF/services/io.vertx.core.spi.VertxMetricsFactory")) {
                    File f = File.createTempFile("vertx", ".txt");
                    f.deleteOnExit();
                    Files.write(f.toPath(), factoryFqn.getBytes(), new OpenOption[0]);
                    return Collections.enumeration(Collections.singleton(f.toURI().toURL()));
                }
                return super.findResources(name);
            }
        };
    }
}

