/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.metrics.Measured;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakemetrics.EndpointMetric;
import io.vertx.test.fakemetrics.FakeDatagramSocketMetrics;
import io.vertx.test.fakemetrics.FakeEventBusMetrics;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.FakeMetricsFactory;
import io.vertx.test.fakemetrics.FakePoolMetrics;
import io.vertx.test.fakemetrics.FakeVertxMetrics;
import io.vertx.test.fakemetrics.HandlerMetric;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.HttpServerMetric;
import io.vertx.test.fakemetrics.PacketMetric;
import io.vertx.test.fakemetrics.ReceivedMessage;
import io.vertx.test.fakemetrics.SentMessage;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.hamcrest.core.Is;
import org.junit.Test;

public class MetricsTest
extends VertxTestBase {
    private static final String ADDRESS1 = "some-address1";

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new FakeMetricsFactory()));
        return options;
    }

    @Test
    public void testSendMessage() {
        this.testBroadcastMessage(this.vertx, new Vertx[]{this.vertx}, false, true, false);
    }

    @Test
    public void testSendMessageInCluster() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], new Vertx[]{this.vertices[1]}, false, false, true);
    }

    @Test
    public void testEventBusInitializedWithCluster() {
        this.startNodes(1);
        this.waitUntil(() -> FakeVertxMetrics.eventBus.get() != null);
    }

    @Test
    public void testEventBusInitializedLocal() {
        this.waitUntil(() -> FakeVertxMetrics.eventBus.get() != null);
    }

    @Test
    public void testPublishMessageToSelf() {
        this.testBroadcastMessage(this.vertx, new Vertx[]{this.vertx}, true, true, false);
    }

    @Test
    public void testPublishMessageToRemote() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], new Vertx[]{this.vertices[1]}, true, false, true);
    }

    @Test
    public void testPublishMessageToCluster() {
        this.startNodes(2);
        this.testBroadcastMessage(this.vertices[0], this.vertices, true, true, true);
    }

    private void testBroadcastMessage(Vertx from, Vertx[] to, boolean publish, boolean expectedLocal, boolean expectedRemote) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)from.eventBus());
        AtomicInteger broadcastCount = new AtomicInteger();
        AtomicInteger receiveCount = new AtomicInteger();
        for (Vertx vertx : to) {
            MessageConsumer consumer = vertx.eventBus().consumer(ADDRESS1);
            consumer.completionHandler(done -> {
                this.assertTrue(done.succeeded());
                if (broadcastCount.incrementAndGet() == to.length) {
                    String msg = TestUtils.randomAlphaString(10);
                    if (publish) {
                        from.eventBus().publish(ADDRESS1, (Object)msg);
                    } else {
                        from.eventBus().send(ADDRESS1, (Object)msg);
                    }
                }
            });
            consumer.handler(msg -> {
                if (receiveCount.incrementAndGet() == to.length) {
                    this.assertEquals(Arrays.asList(new SentMessage(ADDRESS1, publish, expectedLocal, expectedRemote)), eventBusMetrics.getSentMessages());
                    this.testComplete();
                }
            });
        }
        this.await();
    }

    @Test
    public void testReceiveSentMessageFromSelf() {
        this.testReceiveMessageSent(this.vertx, this.vertx, true, 1);
    }

    @Test
    public void testReceiveMessageSentFromRemote() {
        this.startNodes(2);
        this.testReceiveMessageSent(this.vertices[0], this.vertices[1], false, 1);
    }

    private void testReceiveMessageSent(Vertx from, Vertx to, boolean expectedLocal, int expectedHandlers) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        consumer.completionHandler(done -> {
            this.assertTrue(done.succeeded());
            String msg = TestUtils.randomAlphaString(10);
            from.eventBus().send(ADDRESS1, (Object)msg);
        });
        consumer.handler(msg -> {
            this.assertEquals(Arrays.asList(new ReceivedMessage(ADDRESS1, false, expectedLocal, expectedHandlers)), eventBusMetrics.getReceivedMessages());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testReceivePublishedMessageFromSelf() {
        this.testReceiveMessagePublished(this.vertx, this.vertx, true, 3);
    }

    @Test
    public void testReceiveMessagePublishedFromRemote() {
        this.startNodes(2);
        this.testReceiveMessagePublished(this.vertices[0], this.vertices[1], false, 3);
    }

    private void testReceiveMessagePublished(Vertx from, Vertx to, boolean expectedLocal, int expectedHandlers) {
        FakeEventBusMetrics eventBusMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        AtomicInteger count = new AtomicInteger();
        int i = 0;
        while (i < expectedHandlers) {
            MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
            consumer.completionHandler(done -> {
                this.assertTrue(done.succeeded());
                if (count.incrementAndGet() == expectedHandlers) {
                    String msg = TestUtils.randomAlphaString(10);
                    from.eventBus().publish(ADDRESS1, (Object)msg);
                }
            });
            int index = i++;
            consumer.handler(msg -> {
                if (index == 0) {
                    this.assertEquals(Arrays.asList(new ReceivedMessage(ADDRESS1, true, expectedLocal, expectedHandlers)), eventBusMetrics.getReceivedMessages());
                    this.testComplete();
                }
            });
        }
        this.await();
    }

    @Test
    public void testReplyMessageFromSelf() {
        this.testReply(this.vertx, this.vertx, true, false);
    }

    @Test
    public void testReplyMessageFromRemote() {
        this.startNodes(2);
        this.testReply(this.vertices[0], this.vertices[1], false, true);
    }

    private void testReply(Vertx from, Vertx to, boolean expectedLocal, boolean expectedRemote) {
        FakeEventBusMetrics fromMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)from.eventBus());
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        MessageConsumer consumer = to.eventBus().consumer(ADDRESS1);
        consumer.completionHandler(done -> {
            this.assertTrue(done.succeeded());
            String msg = TestUtils.randomAlphaString(10);
            from.eventBus().send(ADDRESS1, (Object)msg, reply -> {
                this.assertEquals(1L, fromMetrics.getReceivedMessages().size());
                ReceivedMessage receivedMessage = fromMetrics.getReceivedMessages().get(0);
                this.assertEquals(false, receivedMessage.publish);
                this.assertEquals(expectedLocal, receivedMessage.local);
                this.assertEquals(1L, receivedMessage.handlers);
                this.assertEquals(1L, toMetrics.getSentMessages().size());
                SentMessage sentMessage = toMetrics.getSentMessages().get(0);
                this.assertEquals(false, sentMessage.publish);
                this.assertEquals(expectedLocal, sentMessage.local);
                this.assertEquals(expectedRemote, sentMessage.remote);
                this.assertEquals(sentMessage.address, receivedMessage.address);
                this.testComplete();
            });
        });
        consumer.handler(msg -> {
            toMetrics.getReceivedMessages().clear();
            toMetrics.getSentMessages().clear();
            msg.reply((Object)TestUtils.randomAlphaString(10));
        });
        this.await();
    }

    @Test
    public void testHandlerRegistration() throws Exception {
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        MessageConsumer consumer = this.vertx.eventBus().consumer(ADDRESS1, msg -> {});
        CountDownLatch latch = new CountDownLatch(1);
        consumer.completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertEquals(1L, metrics.getRegistrations().size());
        HandlerMetric registration = metrics.getRegistrations().get(0);
        this.assertEquals(ADDRESS1, registration.address);
        this.assertEquals(null, registration.repliedAddress);
        consumer.unregister(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, metrics.getRegistrations().size());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testHandlerProcessMessage() {
        this.testHandlerProcessMessage(this.vertx, this.vertx, 1);
    }

    @Test
    public void testHandlerProcessMessageFromRemote() {
        this.startNodes(2);
        this.testHandlerProcessMessage(this.vertices[0], this.vertices[1], 0);
    }

    private HandlerMetric assertRegistration(FakeEventBusMetrics metrics) {
        Optional<HandlerMetric> registration = metrics.getRegistrations().stream().filter(reg -> reg.address.equals(ADDRESS1)).findFirst();
        this.assertTrue(registration.isPresent());
        return registration.get();
    }

    private void testHandlerProcessMessage(Vertx from, Vertx to, int expectedLocalCount) {
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)to.eventBus());
        to.eventBus().consumer(ADDRESS1, msg -> {
            HandlerMetric registration = this.assertRegistration(metrics);
            this.assertEquals(ADDRESS1, registration.address);
            this.assertEquals(null, registration.repliedAddress);
            this.assertEquals(1L, registration.beginCount.get());
            this.assertEquals(0L, registration.endCount.get());
            this.assertEquals(0L, registration.failureCount.get());
            this.assertEquals(expectedLocalCount, registration.localCount.get());
            msg.reply((Object)"pong");
        }).completionHandler(this.onSuccess(v -> from.eventBus().send(ADDRESS1, (Object)"ping", reply -> {
            HandlerMetric registration = this.assertRegistration(metrics);
            this.assertEquals(ADDRESS1, registration.address);
            this.assertEquals(null, registration.repliedAddress);
            this.assertEquals(1L, registration.beginCount.get());
            this.waitUntil(() -> 1 == registration.endCount.get());
            this.assertEquals(0L, registration.failureCount.get());
            this.assertEquals(expectedLocalCount, registration.localCount.get());
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testHandlerProcessMessageFailure() throws Exception {
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        MessageConsumer consumer = this.vertx.eventBus().consumer(ADDRESS1, msg -> {
            this.assertEquals(1L, metrics.getReceivedMessages().size());
            HandlerMetric registration = metrics.getRegistrations().get(0);
            this.assertEquals(1L, registration.beginCount.get());
            this.assertEquals(0L, registration.endCount.get());
            this.assertEquals(0L, registration.failureCount.get());
            throw new RuntimeException();
        });
        CountDownLatch latch = new CountDownLatch(1);
        consumer.completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.vertx.eventBus().send(ADDRESS1, (Object)"ping");
        this.assertEquals(1L, metrics.getReceivedMessages().size());
        HandlerMetric registration = metrics.getRegistrations().get(0);
        long now = System.currentTimeMillis();
        while (registration.failureCount.get() < 1 && System.currentTimeMillis() - now < 10000L) {
            Thread.sleep(10L);
        }
        this.assertEquals(1L, registration.beginCount.get());
        this.assertEquals(1L, registration.endCount.get());
        this.assertEquals(1L, registration.failureCount.get());
    }

    @Test
    public void testHandlerMetricReply() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertx.eventBus());
        this.vertx.eventBus().consumer(ADDRESS1, msg -> {
            this.assertEquals(ADDRESS1, metrics.getRegistrations().get((int)0).address);
            this.waitUntil(() -> metrics.getRegistrations().size() == 2);
            HandlerMetric registration = metrics.getRegistrations().get(1);
            this.assertEquals(ADDRESS1, registration.repliedAddress);
            this.assertEquals(0L, registration.beginCount.get());
            this.assertEquals(0L, registration.endCount.get());
            this.assertEquals(0L, registration.localCount.get());
            msg.reply((Object)"pong");
        }).completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.vertx.eventBus().send(ADDRESS1, (Object)"ping", reply -> {
            this.assertEquals(ADDRESS1, metrics.getRegistrations().get((int)0).address);
            HandlerMetric registration = metrics.getRegistrations().get(1);
            this.assertEquals(ADDRESS1, registration.repliedAddress);
            this.assertEquals(1L, registration.beginCount.get());
            this.assertEquals(0L, registration.endCount.get());
            this.assertEquals(1L, registration.localCount.get());
            this.vertx.runOnContext(v -> {
                this.assertEquals(ADDRESS1, metrics.getRegistrations().get((int)0).address);
                this.assertEquals(ADDRESS1, registration.repliedAddress);
                this.assertEquals(1L, registration.beginCount.get());
                this.assertEquals(1L, registration.endCount.get());
                this.assertEquals(1L, registration.localCount.get());
            });
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testBytesCodec() throws Exception {
        this.startNodes(2);
        FakeEventBusMetrics fromMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertices[0].eventBus());
        FakeEventBusMetrics toMetrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)this.vertices[1].eventBus());
        this.vertices[1].eventBus().consumer(ADDRESS1, msg -> {
            int encoded = fromMetrics.getEncodedBytes(ADDRESS1);
            int decoded = toMetrics.getDecodedBytes(ADDRESS1);
            this.assertTrue("Expected to have more " + encoded + " > 1000 encoded bytes", encoded > 1000);
            this.assertTrue("Expected to have more " + decoded + " > 1000 decoded bytes", decoded > 1000);
            this.testComplete();
        }).completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, fromMetrics.getEncodedBytes(ADDRESS1));
            this.assertEquals(0L, toMetrics.getDecodedBytes(ADDRESS1));
            this.vertices[0].eventBus().send(ADDRESS1, (Object)Buffer.buffer((byte[])new byte[1000]));
        });
        this.await();
    }

    @Test
    public void testReplyFailureNoHandlers() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        EventBus eb = this.vertx.eventBus();
        eb.send(ADDRESS1, (Object)"bar", new DeliveryOptions().setSendTimeout(10L), ar -> {
            this.assertTrue(ar.failed());
            latch.countDown();
        });
        this.awaitLatch(latch);
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)eb);
        this.assertEquals(Collections.singletonList(ADDRESS1), metrics.getReplyFailureAddresses());
        this.assertEquals(Collections.singletonList(ReplyFailure.NO_HANDLERS), metrics.getReplyFailures());
    }

    @Test
    public void testReplyFailureTimeout1() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        EventBus eb = this.vertx.eventBus();
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)eb);
        eb.consumer(ADDRESS1, msg -> {});
        eb.send(ADDRESS1, (Object)"bar", new DeliveryOptions().setSendTimeout(10L), ar -> {
            this.assertTrue(ar.failed());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertEquals(1L, metrics.getReplyFailureAddresses().size());
        this.assertEquals(Collections.singletonList(ReplyFailure.TIMEOUT), metrics.getReplyFailures());
    }

    @Test
    public void testReplyFailureTimeout2() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        EventBus eb = this.vertx.eventBus();
        eb.consumer(ADDRESS1, msg -> msg.reply((Object)"juu", new DeliveryOptions().setSendTimeout(10L), ar -> {
            this.assertTrue(ar.failed());
            latch.countDown();
        }));
        eb.send(ADDRESS1, (Object)"bar", ar -> {});
        this.awaitLatch(latch);
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)eb);
        this.assertEquals(1L, metrics.getReplyFailureAddresses().size());
        this.assertEquals(Collections.singletonList(ReplyFailure.TIMEOUT), metrics.getReplyFailures());
    }

    @Test
    public void testReplyFailureRecipientFailure() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        EventBus eb = this.vertx.eventBus();
        FakeEventBusMetrics metrics = (FakeEventBusMetrics)FakeMetricsBase.getMetrics((Measured)eb);
        AtomicReference replyAddress = new AtomicReference();
        CountDownLatch regLatch = new CountDownLatch(1);
        eb.consumer("foo", msg -> {
            replyAddress.set(msg.replyAddress());
            msg.fail(0, "whatever");
        }).completionHandler(this.onSuccess(v -> regLatch.countDown()));
        this.awaitLatch(regLatch);
        eb.send("foo", (Object)"bar", new DeliveryOptions(), ar -> {
            this.assertTrue(ar.failed());
            latch.countDown();
        });
        this.awaitLatch(latch);
        this.assertEquals(Collections.singletonList(replyAddress.get()), metrics.getReplyFailureAddresses());
        this.assertEquals(Collections.singletonList(ReplyFailure.RECIPIENT_FAILURE), metrics.getReplyFailures());
    }

    @Test
    public void testServerWebSocket() throws Exception {
        HttpServer server = this.vertx.createHttpServer();
        server.websocketHandler(ws -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)server);
            WebSocketMetric metric = metrics.getMetric((ServerWebSocket)ws);
            this.assertNotNull(metric);
            this.assertNotNull(metric.soMetric);
            ws.handler(buffer -> ws.close());
            ws.closeHandler(closed -> {
                this.assertNull(metrics.getMetric((ServerWebSocket)ws));
                this.testComplete();
            });
        });
        server.listen(8080, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", "/", ws -> ws.write(Buffer.buffer((String)"wibble")));
        });
        this.await();
    }

    @Test
    public void testServerWebSocketUpgrade() throws Exception {
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)server);
            this.assertNotNull(metrics.getMetric((HttpServerRequest)req));
            ServerWebSocket ws = req.upgrade();
            this.assertNull(metrics.getMetric((HttpServerRequest)req));
            WebSocketMetric metric = metrics.getMetric(ws);
            this.assertNotNull(metric);
            this.assertNotNull(metric.soMetric);
            ws.handler(buffer -> ws.close());
            ws.closeHandler(closed -> {
                this.assertNull(metrics.getMetric(ws));
                this.testComplete();
            });
        });
        server.listen(8080, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", "/", ws -> ws.write(Buffer.buffer((String)"wibble")));
        });
        this.await();
    }

    @Test
    public void testWebSocket() throws Exception {
        HttpServer server = this.vertx.createHttpServer();
        server.websocketHandler(ws -> ws.write(Buffer.buffer((String)"wibble")));
        server.listen(8080, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", "/", ws -> {
                FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client);
                WebSocketMetric metric = metrics.getMetric((WebSocket)ws);
                this.assertNotNull(metric);
                this.assertNotNull(metric.soMetric);
                ws.closeHandler(closed -> {
                    this.assertNull(metrics.getMetric((WebSocket)ws));
                    this.testComplete();
                });
                ws.handler(buffer -> ws.close());
            });
        });
        this.await();
    }

    @Test
    public void testHttpClientName() throws Exception {
        HttpClient client1 = this.vertx.createHttpClient();
        FakeHttpClientMetrics metrics1 = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client1);
        this.assertEquals("", metrics1.getName());
        String name = TestUtils.randomAlphaString(10);
        HttpClient client2 = this.vertx.createHttpClient(new HttpClientOptions().setMetricsName(name));
        FakeHttpClientMetrics metrics2 = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client2);
        this.assertEquals(name, metrics2.getName());
    }

    @Test
    public void testHttpClientMetricsQueueLength() throws Exception {
        int i;
        HttpServer server = this.vertx.createHttpServer();
        List requests = Collections.synchronizedList(new ArrayList());
        server.requestHandler(req -> requests.add(() -> this.vertx.runOnContext(v -> req.response().end())));
        CountDownLatch listenLatch = new CountDownLatch(1);
        server.listen(8080, "localhost", this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        HttpClient client = this.vertx.createHttpClient();
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeHttpClientMetrics.getMetrics((Measured)client);
        CountDownLatch responsesLatch = new CountDownLatch(5);
        for (i = 0; i < 5; ++i) {
            client.getNow(8080, "localhost", "/somepath", resp -> responsesLatch.countDown());
        }
        this.waitUntil(() -> requests.size() == 5);
        this.assertEquals(Collections.singleton("localhost:8080"), metrics.endpoints());
        this.assertEquals(0L, metrics.queueSize("localhost:8080").intValue());
        this.assertEquals(5L, metrics.connectionCount("localhost:8080").intValue());
        for (i = 0; i < 8; ++i) {
            client.getNow(8080, "localhost", "/somepath", resp -> {});
        }
        this.assertEquals(Collections.singleton("localhost:8080"), metrics.endpoints());
        this.assertEquals(8L, metrics.queueSize("localhost:8080").intValue());
        this.assertEquals(5L, metrics.connectionCount("localhost:8080").intValue());
        ArrayList<Runnable> copy = new ArrayList<Runnable>(requests);
        requests.clear();
        copy.forEach(Runnable::run);
        this.awaitLatch(responsesLatch);
        this.waitUntil(() -> requests.size() == 5);
        this.assertEquals(Collections.singleton("localhost:8080"), metrics.endpoints());
        this.assertEquals(3L, metrics.queueSize("localhost:8080").intValue());
        this.assertEquals(5L, metrics.connectionCount("localhost:8080").intValue());
        copy = new ArrayList(requests);
        requests.clear();
        copy.forEach(Runnable::run);
        this.waitUntil(() -> requests.size() == 3);
        this.assertEquals(Collections.singleton("localhost:8080"), metrics.endpoints());
        this.assertEquals(0L, metrics.queueSize("localhost:8080").intValue());
        this.assertEquals(5L, metrics.connectionCount("localhost:8080").intValue());
    }

    @Test
    public void testHttpClientMetricsQueueClose() throws Exception {
        HttpServer server = this.vertx.createHttpServer();
        List requests = Collections.synchronizedList(new ArrayList());
        server.requestHandler(req -> requests.add(() -> this.vertx.runOnContext(v -> req.connection().close())));
        CountDownLatch listenLatch = new CountDownLatch(1);
        server.listen(8080, "localhost", this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        HttpClient client = this.vertx.createHttpClient();
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeHttpClientMetrics.getMetrics((Measured)client);
        for (int i = 0; i < 5; ++i) {
            client.getNow(8080, "localhost", "/somepath", resp -> {});
        }
        this.waitUntil(() -> requests.size() == 5);
        EndpointMetric endpoint = metrics.endpoint("localhost:8080");
        this.assertEquals(5L, endpoint.connectionCount.get());
        ArrayList<Runnable> copy = new ArrayList<Runnable>(requests);
        requests.clear();
        copy.forEach(Runnable::run);
        this.waitUntil(() -> metrics.endpoints().isEmpty());
        this.assertEquals(0L, endpoint.connectionCount.get());
    }

    @Test
    public void testHttpClientConnectionCloseAfterRequestEnd() throws Exception {
        CountDownLatch started = new CountDownLatch(1);
        HttpClient client = this.vertx.createHttpClient();
        AtomicReference endpointMetrics = new AtomicReference();
        this.vertx.createHttpServer().requestHandler(req -> {
            endpointMetrics.set(((FakeHttpClientMetrics)FakeHttpClientMetrics.getMetrics((Measured)client)).endpoint("localhost:8080"));
            req.response().end();
        }).listen(8080, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            started.countDown();
        });
        this.awaitLatch(started);
        CountDownLatch closed = new CountDownLatch(1);
        HttpClientRequest req2 = client.get(8080, "localhost", "/somepath");
        req2.handler(resp -> resp.endHandler(v1 -> {
            HttpConnection conn = req2.connection();
            conn.closeHandler(v2 -> closed.countDown());
            conn.close();
        }));
        req2.end();
        this.awaitLatch(closed);
        EndpointMetric val = (EndpointMetric)endpointMetrics.get();
        this.waitUntil(() -> val.connectionCount.get() == 0);
        this.assertEquals(0L, val.queueSize.get());
        this.assertEquals(0L, val.requests.get());
    }

    @Test
    public void testMulti() {
        HttpServer s1 = this.vertx.createHttpServer();
        s1.requestHandler(req -> {});
        s1.listen(8080, ar1 -> {
            this.assertTrue(ar1.succeeded());
            HttpServer s2 = this.vertx.createHttpServer();
            s2.requestHandler(req -> req.response().end());
            s2.listen(8080, ar2 -> {
                this.assertTrue(ar2.succeeded());
                FakeHttpServerMetrics metrics1 = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)ar1.result());
                this.assertSame(ar1.result(), metrics1.server);
                FakeHttpServerMetrics metrics2 = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)ar2.result());
                this.assertSame(ar2.result(), metrics2.server);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testHttpConnect1() throws Exception {
        this.testHttpConnect("localhost", socketMetric -> this.assertEquals("localhost", socketMetric.remoteName));
    }

    @Test
    public void testHttpConnect2() throws Exception {
        this.testHttpConnect(InetAddress.getLocalHost().getHostAddress(), socketMetric -> this.assertEquals(socketMetric.remoteAddress.host(), socketMetric.remoteName));
    }

    private void testHttpConnect(String host, Consumer<SocketMetric> checker) {
        AtomicReference clientMetric = new AtomicReference();
        HttpServer server = this.vertx.createHttpServer();
        server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)server);
            HttpServerMetric serverMetric = metrics.getMetric((HttpServerRequest)req);
            this.assertNotNull(serverMetric);
            req.response().setStatusCode(200);
            req.response().setStatusMessage("Connection established");
            req.response().end();
            NetSocket so = req.netSocket();
            so.handler(arg_0 -> ((NetSocket)req.netSocket()).write(arg_0));
            so.closeHandler(v -> {
                this.assertNull(metrics.getMetric((HttpServerRequest)req));
                this.assertFalse(serverMetric.socket.connected.get());
                this.assertEquals(5L, serverMetric.socket.bytesRead.get());
                this.assertEquals(5L, serverMetric.socket.bytesWritten.get());
                this.assertEquals(serverMetric.socket.remoteAddress.host(), serverMetric.socket.remoteName);
                this.assertFalse(((HttpClientMetric)clientMetric.get()).socket.connected.get());
                this.assertEquals(5L, ((HttpClientMetric)clientMetric.get()).socket.bytesRead.get());
                this.assertEquals(5L, ((HttpClientMetric)clientMetric.get()).socket.bytesWritten.get());
                checker.accept(((HttpClientMetric)clientMetric.get()).socket);
                this.testComplete();
            });
        }).listen(8080, ar1 -> {
            this.assertTrue(ar1.succeeded());
            HttpClient client = this.vertx.createHttpClient();
            HttpClientRequest request = client.request(HttpMethod.CONNECT, 8080, host, "/");
            FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client);
            request.handler(resp -> {
                this.assertEquals(200L, resp.statusCode());
                clientMetric.set(metrics.getMetric(request));
                this.assertNotNull(clientMetric.get());
                NetSocket socket = resp.netSocket();
                socket.write(Buffer.buffer((String)"hello"));
                socket.handler(buf -> {
                    this.assertEquals("hello", buf.toString());
                    this.assertNull(metrics.getMetric(request));
                    socket.close();
                });
            }).end();
        });
        this.await();
    }

    @Test
    public void testDatagram1() throws Exception {
        this.testDatagram("127.0.0.1", packet -> {
            this.assertEquals("127.0.0.1", packet.remoteAddress.host());
            this.assertEquals(1234L, packet.remoteAddress.port());
            this.assertEquals(5L, packet.numberOfBytes);
        });
    }

    @Test
    public void testDatagram2() throws Exception {
        this.testDatagram("localhost", packet -> {
            this.assertEquals("localhost", packet.remoteAddress.host());
            this.assertEquals(1234L, packet.remoteAddress.port());
            this.assertEquals(5L, packet.numberOfBytes);
        });
    }

    private void testDatagram(String host, Consumer<PacketMetric> checker) throws Exception {
        DatagramSocket peer1 = this.vertx.createDatagramSocket();
        DatagramSocket peer2 = this.vertx.createDatagramSocket();
        CountDownLatch latch = new CountDownLatch(1);
        peer1.handler(packet -> {
            FakeDatagramSocketMetrics peer1Metrics = (FakeDatagramSocketMetrics)FakeMetricsBase.getMetrics((Measured)peer1);
            FakeDatagramSocketMetrics peer2Metrics = (FakeDatagramSocketMetrics)FakeMetricsBase.getMetrics((Measured)peer2);
            this.assertEquals(host, peer1Metrics.getLocalName());
            this.assertEquals("127.0.0.1", peer1Metrics.getLocalAddress().host());
            this.assertNull(peer2Metrics.getLocalAddress());
            this.assertEquals(1L, peer1Metrics.getReads().size());
            PacketMetric read = peer1Metrics.getReads().get(0);
            this.assertEquals(5L, read.numberOfBytes);
            this.assertEquals(0L, peer1Metrics.getWrites().size());
            this.assertEquals(0L, peer2Metrics.getReads().size());
            this.assertEquals(1L, peer2Metrics.getWrites().size());
            checker.accept(peer2Metrics.getWrites().get(0));
            this.testComplete();
        });
        peer1.listen(1234, host, ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        peer2.send("hello", 1234, host, ar -> this.assertTrue(ar.succeeded()));
        this.await();
    }

    @Test
    public void testThreadPoolMetricsWithExecuteBlocking() {
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics = (FakePoolMetrics)all.get("vert.x-worker-thread");
        this.assertThat(metrics.getPoolSize(), Is.is((Object)this.getOptions().getInternalBlockingPoolSize()));
        this.assertThat(metrics.numberOfIdleThreads(), Is.is((Object)this.getOptions().getWorkerPoolSize()));
        Handler<Future<Void>> job = this.getSomeDumbTask();
        AtomicInteger counter = new AtomicInteger();
        AtomicBoolean hadWaitingQueue = new AtomicBoolean();
        AtomicBoolean hadIdle = new AtomicBoolean();
        AtomicBoolean hadRunning = new AtomicBoolean();
        for (int i = 0; i < 100; ++i) {
            this.vertx.executeBlocking(job, ar -> {
                if (metrics.numberOfWaitingTasks() > 0) {
                    hadWaitingQueue.set(true);
                }
                if (metrics.numberOfIdleThreads() > 0) {
                    hadIdle.set(true);
                }
                if (metrics.numberOfRunningTasks() > 0) {
                    hadRunning.set(true);
                }
                if (counter.incrementAndGet() == 100) {
                    this.testComplete();
                }
            });
        }
        this.await();
        this.assertEquals(metrics.numberOfSubmittedTask(), 100L);
        this.assertEquals(metrics.numberOfCompletedTasks(), 100L);
        this.assertTrue(hadIdle.get());
        this.assertTrue(hadWaitingQueue.get());
        this.assertTrue(hadRunning.get());
        this.assertEquals(metrics.numberOfIdleThreads(), this.getOptions().getWorkerPoolSize());
        this.assertEquals(metrics.numberOfRunningTasks(), 0L);
        this.assertEquals(metrics.numberOfWaitingTasks(), 0L);
    }

    @Test
    public void testThreadPoolMetricsWithInternalExecuteBlocking() {
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics = (FakePoolMetrics)all.get("vert.x-internal-blocking");
        this.assertThat(metrics.getPoolSize(), Is.is((Object)this.getOptions().getInternalBlockingPoolSize()));
        this.assertThat(metrics.numberOfIdleThreads(), Is.is((Object)this.getOptions().getInternalBlockingPoolSize()));
        AtomicInteger counter = new AtomicInteger();
        AtomicBoolean hadWaitingQueue = new AtomicBoolean();
        AtomicBoolean hadIdle = new AtomicBoolean();
        AtomicBoolean hadRunning = new AtomicBoolean();
        FileSystem system = this.vertx.fileSystem();
        for (int i = 0; i < 100; ++i) {
            this.vertx.executeBlocking(fut -> system.readFile("afile.html", buffer -> fut.complete(null)), ar -> {
                if (metrics.numberOfWaitingTasks() > 0) {
                    hadWaitingQueue.set(true);
                }
                if (metrics.numberOfIdleThreads() > 0) {
                    hadIdle.set(true);
                }
                if (metrics.numberOfRunningTasks() > 0) {
                    hadRunning.set(true);
                }
                if (counter.incrementAndGet() == 100) {
                    this.testComplete();
                }
            });
        }
        this.await();
        this.assertEquals(metrics.numberOfSubmittedTask(), 100L);
        this.assertEquals(metrics.numberOfCompletedTasks(), 100L);
        this.assertTrue(hadIdle.get());
        this.assertTrue(hadWaitingQueue.get());
        this.assertTrue(hadRunning.get());
        this.assertEquals(metrics.numberOfIdleThreads(), this.getOptions().getWorkerPoolSize());
        this.assertEquals(metrics.numberOfRunningTasks(), 0L);
        this.assertEquals(metrics.numberOfWaitingTasks(), 0L);
    }

    @Test
    public void testThreadPoolMetricsWithWorkerVerticle() {
        this.testWithWorkerVerticle(new DeploymentOptions().setWorker(true));
    }

    @Test
    public void testThreadPoolMetricsWithWorkerVerticleAndMultiThread() {
        this.testWithWorkerVerticle(new DeploymentOptions().setWorker(true).setMultiThreaded(true));
    }

    private void testWithWorkerVerticle(DeploymentOptions options) {
        final AtomicInteger counter = new AtomicInteger();
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        final FakePoolMetrics metrics = (FakePoolMetrics)all.get("vert.x-worker-thread");
        this.assertThat(metrics.getPoolSize(), Is.is((Object)this.getOptions().getInternalBlockingPoolSize()));
        this.assertThat(metrics.numberOfIdleThreads(), Is.is((Object)this.getOptions().getWorkerPoolSize()));
        final AtomicBoolean hadWaitingQueue = new AtomicBoolean();
        final AtomicBoolean hadIdle = new AtomicBoolean();
        final AtomicBoolean hadRunning = new AtomicBoolean();
        final int count = 100;
        AbstractVerticle worker = new AbstractVerticle(){

            public void start(Future<Void> done) throws Exception {
                this.vertx.eventBus().localConsumer("message", d -> {
                    try {
                        Thread.sleep(10L);
                        if (metrics.numberOfWaitingTasks() > 0) {
                            hadWaitingQueue.set(true);
                        }
                        if (metrics.numberOfIdleThreads() > 0) {
                            hadIdle.set(true);
                        }
                        if (metrics.numberOfRunningTasks() > 0) {
                            hadRunning.set(true);
                        }
                        if (counter.incrementAndGet() == count) {
                            MetricsTest.this.testComplete();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().isInterrupted();
                    }
                });
                done.complete();
            }
        };
        this.vertx.deployVerticle((Verticle)worker, options, s -> {
            for (int i = 0; i < count; ++i) {
                this.vertx.eventBus().send("message", (Object)i);
            }
        });
        this.await();
        this.assertEquals(metrics.numberOfSubmittedTask(), count + 1);
        this.assertEquals(metrics.numberOfCompletedTasks(), count + 1);
        this.assertTrue(hadIdle.get());
        this.assertTrue(hadWaitingQueue.get());
        this.assertTrue(hadRunning.get());
        this.assertEquals(metrics.numberOfIdleThreads(), this.getOptions().getWorkerPoolSize());
        this.assertEquals(metrics.numberOfRunningTasks(), 0L);
        this.assertEquals(metrics.numberOfWaitingTasks(), 0L);
    }

    @Test
    public void testThreadPoolMetricsWithNamedExecuteBlocking() {
        this.vertx.close();
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new FakeMetricsFactory())));
        WorkerExecutor workerExec = this.vertx.createSharedWorkerExecutor("my-pool", 10);
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics = (FakePoolMetrics)all.get("my-pool");
        this.assertThat(metrics.getPoolSize(), Is.is((Object)10));
        this.assertThat(metrics.numberOfIdleThreads(), Is.is((Object)10));
        Handler<Future<Void>> job = this.getSomeDumbTask();
        AtomicInteger counter = new AtomicInteger();
        AtomicBoolean hadWaitingQueue = new AtomicBoolean();
        AtomicBoolean hadIdle = new AtomicBoolean();
        AtomicBoolean hadRunning = new AtomicBoolean();
        for (int i = 0; i < 100; ++i) {
            workerExec.executeBlocking(job, false, ar -> {
                if (metrics.numberOfWaitingTasks() > 0) {
                    hadWaitingQueue.set(true);
                }
                if (metrics.numberOfIdleThreads() > 0) {
                    hadIdle.set(true);
                }
                if (metrics.numberOfRunningTasks() > 0) {
                    hadRunning.set(true);
                }
                if (counter.incrementAndGet() == 100) {
                    this.testComplete();
                }
            });
        }
        this.await();
        this.assertEquals(metrics.numberOfSubmittedTask(), 100L);
        this.assertEquals(metrics.numberOfCompletedTasks(), 100L);
        this.assertTrue(hadIdle.get());
        this.assertTrue(hadWaitingQueue.get());
        this.assertTrue(hadRunning.get());
        this.assertEquals(metrics.numberOfIdleThreads(), 10L);
        this.assertEquals(metrics.numberOfRunningTasks(), 0L);
        this.assertEquals(metrics.numberOfWaitingTasks(), 0L);
    }

    @Test
    public void testWorkerPoolClose() {
        WorkerExecutor ex1 = this.vertx.createSharedWorkerExecutor("ex1");
        WorkerExecutor ex1_ = this.vertx.createSharedWorkerExecutor("ex1");
        WorkerExecutor ex2 = this.vertx.createSharedWorkerExecutor("ex2");
        Map<String, PoolMetrics> all = FakePoolMetrics.getPoolMetrics();
        FakePoolMetrics metrics1 = (FakePoolMetrics)all.get("ex1");
        FakePoolMetrics metrics2 = (FakePoolMetrics)all.get("ex2");
        this.assertNotNull(metrics1);
        this.assertNotNull(metrics2);
        this.assertNotSame(metrics1, metrics2);
        this.assertFalse(metrics1.isClosed());
        this.assertFalse(metrics2.isClosed());
        ex1_.close();
        this.assertFalse(metrics1.isClosed());
        this.assertFalse(metrics2.isClosed());
        ex1.close();
        this.assertTrue(metrics1.isClosed());
        this.assertFalse(metrics2.isClosed());
        ex2.close();
        this.assertTrue(metrics1.isClosed());
        this.assertTrue(metrics2.isClosed());
    }

    private Handler<Future<Void>> getSomeDumbTask() {
        return future -> {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().isInterrupted();
            }
            future.complete(null);
        };
    }
}

