/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.SslContext;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.test.core.TLSCert;
import io.vertx.test.core.VertxTestBase;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.junit.Test;

public class SSLHelperTest
extends VertxTestBase {
    @Test
    public void testUseJdkCiphersWhenNotSpecified() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLEngine engine = context.createSSLEngine();
        String[] expected = engine.getEnabledCipherSuites();
        SSLHelper helper = new SSLHelper(new HttpClientOptions(), TLSCert.JKS.getClientKeyCertOptions(), TLSCert.JKS.getClientTrustOptions());
        SslContext ctx = helper.getContext((VertxInternal)this.vertx);
        this.assertEquals(new HashSet<String>(Arrays.asList(expected)), new HashSet(ctx.cipherSuites()));
    }

    @Test
    public void testUseOpenSSLCiphersWhenNotSpecified() throws Exception {
        Set expected = OpenSsl.availableCipherSuites();
        SSLHelper helper = new SSLHelper(new HttpClientOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions()), TLSCert.PEM.getClientKeyCertOptions(), TLSCert.PEM.getClientTrustOptions());
        SslContext ctx = helper.getContext((VertxInternal)this.vertx);
        this.assertEquals(expected, new HashSet(ctx.cipherSuites()));
    }

    @Test
    public void testDefaultOpenSslServerSessionContext() throws Exception {
        this.testOpenSslServerSessionContext(true);
    }

    @Test
    public void testUserSetOpenSslServerSessionContext() throws Exception {
        this.testOpenSslServerSessionContext(false);
    }

    private void testOpenSslServerSessionContext(boolean testDefault) {
        HttpServerOptions httpServerOptions = new HttpServerOptions().setOpenSslEngineOptions(new OpenSSLEngineOptions());
        if (!testDefault) {
            httpServerOptions.setOpenSslEngineOptions(new OpenSSLEngineOptions().setSessionCacheEnabled(false));
        }
        SSLHelper defaultHelper = new SSLHelper(httpServerOptions, TLSCert.PEM.getServerKeyCertOptions(), TLSCert.PEM.getServerTrustOptions());
        SslContext ctx = defaultHelper.getContext((VertxInternal)this.vertx);
        this.assertTrue(ctx instanceof OpenSslServerContext);
        SSLSessionContext sslSessionContext = ctx.sessionContext();
        this.assertTrue(sslSessionContext instanceof OpenSslServerSessionContext);
        if (sslSessionContext instanceof OpenSslServerSessionContext) {
            this.assertEquals(testDefault, ((OpenSslServerSessionContext)sslSessionContext).isSessionCacheEnabled());
        }
    }
}

