/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher;

import io.vertx.core.Launcher;
import io.vertx.core.Vertx;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.impl.launcher.commands.CommandTestBase;
import io.vertx.core.impl.launcher.commands.HttpTestVerticle;
import io.vertx.core.impl.launcher.commands.RunCommandTest;
import io.vertx.core.spi.launcher.DefaultCommand;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class LauncherExtensibilityTest
extends CommandTestBase {
    static AtomicReference<Boolean> spy = new AtomicReference();
    private Vertx vertx;

    @Override
    @After
    public void tearDown() throws InterruptedException {
        spy.set(false);
        super.tearDown();
        this.close(this.vertx);
    }

    @Test
    public void testExtendingMainVerticle() {
        Launcher myLauncher = new Launcher(){

            protected String getMainVerticle() {
                return HttpTestVerticle.class.getName();
            }

            public void afterStartingVertx(Vertx vertx) {
                LauncherExtensibilityTest.this.vertx = vertx;
            }
        };
        myLauncher.dispatch(new String[0]);
        this.waitUntil(() -> {
            try {
                return RunCommandTest.getHttpCode() == 200;
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    @Test
    public void testThatALauncherCanAddACommand() {
        Launcher myLauncher = new Launcher(){

            protected void load() {
                super.load();
                this.register(FooCommand.class);
            }
        };
        myLauncher.dispatch(new String[]{"foo"});
        Assertions.assertThat((Iterable)myLauncher.getCommandNames()).contains((Object[])new String[]{"foo"});
        this.waitUntil(spy::get);
    }

    @Test
    public void testThatALauncherCanHideACommand() {
        Launcher myLauncher = new Launcher(){

            protected void load() {
                super.load();
                this.unregister("start");
            }
        };
        this.record();
        myLauncher.dispatch(new String[]{"start"});
        this.stop();
        Assertions.assertThat((String)this.output.toString()).contains(new CharSequence[]{"The command 'start' is not a valid command."});
        Assertions.assertThat((Iterable)myLauncher.getCommandNames()).doesNotContain((Object[])new String[]{"start"});
    }

    @Name(value="foo")
    public static class FooCommand
    extends DefaultCommand {
        public void run() throws CLIException {
            spy.set(true);
        }
    }
}

