/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.Vertx;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import io.vertx.core.logging.JULLogDelegateFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.logging.LogManager;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;

public class CommandTestBase {
    protected static final PrintStream originalOutputPrintStream = System.out;
    protected static final PrintStream originalErrorPrintStream = System.err;
    protected ByteArrayOutputStream output;
    protected ByteArrayOutputStream error;
    protected PrintStream os;
    protected PrintStream err;
    protected VertxCommandLauncher cli;

    @Before
    public void setUp() throws IOException {
        this.cli = new VertxCommandLauncher();
        this.output = new ByteArrayOutputStream();
        this.error = new ByteArrayOutputStream();
        LogManager.getLogManager().reset();
        JULLogDelegateFactory.loadConfig();
    }

    @After
    public void tearDown() throws InterruptedException {
        this.stop();
        if (this.os != null) {
            this.os.close();
        }
        if (this.err != null) {
            this.err.close();
        }
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.error.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void record() {
        this.os = new PrintStream(this.output);
        this.err = new PrintStream(this.error);
        System.setOut(this.os);
        System.setErr(this.err);
    }

    public void stop() {
        if (System.out != originalOutputPrintStream) {
            System.setOut(originalOutputPrintStream);
        }
        if (System.err != originalErrorPrintStream) {
            System.setErr(originalErrorPrintStream);
        }
    }

    protected void waitUntil(BooleanSupplier supplier) {
        this.waitUntil(supplier, 10000L);
    }

    protected void waitUntil(BooleanSupplier supplier, long timeout) {
        long start = System.currentTimeMillis();
        while (!supplier.getAsBoolean()) {
            long now;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            if ((now = System.currentTimeMillis()) - start <= timeout) continue;
            throw new IllegalStateException("Timed out");
        }
    }

    protected void awaitLatch(CountDownLatch latch) throws InterruptedException {
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
    }

    protected void close(Vertx vertx) throws InterruptedException {
        if (vertx == null) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        vertx.close(ar -> latch.countDown());
        this.awaitLatch(latch);
    }
}

