/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.impl.launcher.commands.CommandTestBase;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import io.vertx.core.impl.launcher.commands.Watcher;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WatcherTest
extends CommandTestBase {
    private Watcher watcher;
    private AtomicInteger deploy;
    private AtomicInteger undeploy;
    private File root;

    @Before
    public void prepare() {
        this.root = new File("target/junk/watcher");
        WatcherTest.deleteRecursive(this.root);
        this.root.mkdirs();
        this.deploy = new AtomicInteger();
        this.undeploy = new AtomicInteger();
        this.watcher = new Watcher(this.root, Collections.unmodifiableList(Arrays.asList("**" + File.separator + "*.txt", "windows\\*.win", "unix/*.nix", "FOO.bar")), next -> {
            this.deploy.incrementAndGet();
            if (next != null) {
                next.handle(null);
            }
        }, next -> {
            this.undeploy.incrementAndGet();
            if (next != null) {
                next.handle(null);
            }
        }, null, 10L, 10L);
    }

    @After
    public void close() {
        this.watcher.close();
    }

    @Test
    public void testFileAddition() throws IOException {
        this.watcher.watch();
        this.waitUntil(() -> this.deploy.get() == 1);
        File file = new File(this.root, "foo.txt");
        file.createNewFile();
        this.waitUntil(() -> this.undeploy.get() == 1 && this.deploy.get() == 2);
    }

    @Test
    public void testWithANonMatchingFile() throws IOException, InterruptedException {
        this.watcher.watch();
        this.waitUntil(() -> this.deploy.get() == 1);
        File file = new File(this.root, "foo.nope");
        file.createNewFile();
        Thread.sleep(500L);
        Assertions.assertThat((int)this.undeploy.get()).isEqualTo(0);
        Assertions.assertThat((int)this.deploy.get()).isEqualTo(1);
    }

    @Test
    public void testFileModification() throws IOException, InterruptedException {
        File file = new File(this.root, "foo.txt");
        file.createNewFile();
        this.watcher.watch();
        this.waitUntil(() -> this.deploy.get() == 1);
        Thread.sleep(500L);
        file.setLastModified(System.currentTimeMillis());
        this.waitUntil(() -> this.undeploy.get() == 1 && this.deploy.get() == 2);
    }

    @Test
    public void testFileDeletion() throws IOException, InterruptedException {
        File file = new File(this.root, "foo.txt");
        file.createNewFile();
        this.watcher.watch();
        this.waitUntil(() -> this.deploy.get() == 1);
        Thread.sleep(500L);
        file.delete();
        this.waitUntil(() -> this.undeploy.get() == 1 && this.deploy.get() == 2);
    }

    @Test
    public void testFileAdditionAndModificationInDirectory() throws IOException, InterruptedException {
        this.watcher.watch();
        Thread.sleep(500L);
        this.waitUntil(() -> this.deploy.get() == 1);
        File newDir = new File(this.root, "directory");
        newDir.mkdir();
        Thread.sleep(500L);
        File file = new File(newDir, "foo.txt");
        file.createNewFile();
        this.waitUntil(() -> this.undeploy.get() == 1 && this.deploy.get() == 2);
        Thread.sleep(1000L);
        file.setLastModified(System.currentTimeMillis());
        this.waitUntil(() -> this.undeploy.get() == 2 && this.deploy.get() == 3);
        Thread.sleep(1000L);
        WatcherTest.deleteRecursive(newDir);
        this.waitUntil(() -> this.undeploy.get() == 3 && this.deploy.get() == 4);
    }

    @Test
    public void testOSSpecificIncludePaths() throws IOException, InterruptedException {
        this.watcher.watch();
        this.waitUntil(() -> this.deploy.get() == 1);
        File winDir = new File(this.root, "windows");
        winDir.mkdir();
        Thread.sleep(500L);
        File winFile = new File(winDir, "foo.win");
        winFile.createNewFile();
        this.waitUntil(() -> this.undeploy.get() == 1 && this.deploy.get() == 2);
        Thread.sleep(1000L);
        File nixDir = new File(this.root, "unix");
        nixDir.mkdir();
        Thread.sleep(500L);
        File nixFile = new File(nixDir, "foo.nix");
        nixFile.createNewFile();
        this.waitUntil(() -> this.undeploy.get() == 2 && this.deploy.get() == 3);
    }

    @Test
    public void testCaseSensitivity() throws IOException, InterruptedException {
        this.watcher.watch();
        this.waitUntil(() -> this.deploy.get() == 1);
        File file = new File(this.root, "fOo.BAr");
        file.createNewFile();
        if (ExecUtils.isWindows()) {
            this.waitUntil(() -> this.undeploy.get() == 1 && this.deploy.get() == 2);
        } else {
            Thread.sleep(500L);
            Assertions.assertThat((int)this.undeploy.get()).isEqualTo(0);
            Assertions.assertThat((int)this.deploy.get()).isEqualTo(1);
        }
    }

    public static boolean deleteRecursive(File path) {
        File[] files;
        if (!path.exists()) {
            return false;
        }
        boolean ret = true;
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            for (File f : files) {
                ret = ret && WatcherTest.deleteRecursive(f);
            }
        }
        return ret && path.delete();
    }
}

