/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.junit.Test;

public class ComplexHATest
extends VertxTestBase {
    private Random random = new Random();
    protected final int maxVerticlesPerNode = 20;
    protected Set<Deployment>[] deploymentSnapshots;
    protected volatile int totDeployed;
    protected volatile int killedNode;
    protected List<Integer> aliveNodes;

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deploymentSnapshots = null;
        this.totDeployed = 0;
        this.killedNode = 0;
        this.aliveNodes = null;
    }

    @Test
    @Repeat(times=10)
    public void testComplexFailover() {
        try {
            int numNodes = 8;
            this.createNodes(numNodes);
            this.deployRandomVerticles(() -> this.killRandom());
            this.await(10L, TimeUnit.MINUTES);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.fail(t.getMessage());
        }
    }

    protected void deployRandomVerticles(Runnable runner) {
        int toDeploy = 0;
        AtomicInteger deployCount = new AtomicInteger();
        ArrayList<Integer> numbersToDeploy = new ArrayList<Integer>();
        for (int i = 0; i < this.aliveNodes.size(); ++i) {
            int numToDeploy = this.random.nextInt(21);
            numbersToDeploy.add(numToDeploy);
            toDeploy += numToDeploy;
        }
        int index = 0;
        for (int pos : this.aliveNodes) {
            Vertx v = this.vertices[pos];
            int numToDeploy = (Integer)numbersToDeploy.get(index);
            ++index;
            for (int j = 0; j < numToDeploy; ++j) {
                JsonObject config = new JsonObject();
                config.put("foo", TestUtils.randomAlphaString(100));
                DeploymentOptions options = new DeploymentOptions().setHa(true).setConfig(config);
                String verticleName = "java:io.vertx.test.core.HAVerticle" + (this.random.nextInt(3) + 1);
                v.deployVerticle(verticleName, options, ar -> {
                    this.assertTrue(ar.succeeded());
                    deployCount.incrementAndGet();
                });
            }
        }
        int ttoDeploy = toDeploy;
        this.eventLoopWaitUntil(() -> ttoDeploy == deployCount.get(), () -> {
            this.totDeployed += ttoDeploy;
            runner.run();
        });
    }

    protected void undeployRandomVerticles(Runnable runner) {
        int toUndeploy = 0;
        AtomicInteger undeployCount = new AtomicInteger();
        for (int pos : this.aliveNodes) {
            Vertx v = this.vertices[pos];
            int deployedNum = v.deploymentIDs().size();
            int numToUnDeploy = this.random.nextInt(deployedNum + 1);
            ArrayList deployed = new ArrayList(v.deploymentIDs());
            int ii = pos;
            for (int j = 0; j < numToUnDeploy; ++j) {
                int depPos = this.random.nextInt(deployed.size());
                String depID = (String)deployed.remove(depPos);
                ++toUndeploy;
                v.undeploy(depID, this.onSuccess(d -> undeployCount.incrementAndGet()));
            }
        }
        int totUndeployed = toUndeploy;
        this.eventLoopWaitUntil(() -> totUndeployed == undeployCount.get(), () -> {
            this.totDeployed -= totUndeployed;
            runner.run();
        });
    }

    private void eventLoopWaitUntil(BooleanSupplier supplier, Runnable runner) {
        long start = System.currentTimeMillis();
        this.doEventLoopWaitUntil(start, supplier, runner);
    }

    private void doEventLoopWaitUntil(long start, BooleanSupplier supplier, Runnable runner) {
        long now = System.currentTimeMillis();
        if (now - start > 10000L) {
            this.fail("Timedout in waiting until");
        } else if (supplier.getAsBoolean()) {
            runner.run();
        } else {
            this.vertx.setTimer(1L, tid -> this.doEventLoopWaitUntil(start, supplier, runner));
        }
    }

    protected void takeDeploymentSnapshots() {
        for (int i = 0; i < this.vertices.length; ++i) {
            VertxInternal v = (VertxInternal)this.vertices[i];
            if (v.isKilled()) continue;
            this.deploymentSnapshots[i] = this.takeDeploymentSnapshot(i);
        }
    }

    protected Set<Deployment> takeDeploymentSnapshot(int pos) {
        ConcurrentHashSet snapshot = new ConcurrentHashSet();
        VertxInternal v = (VertxInternal)this.vertices[pos];
        for (String depID : v.deploymentIDs()) {
            snapshot.add(v.getDeployment(depID));
        }
        return snapshot;
    }

    protected void kill(int pos) {
        this.takeDeploymentSnapshots();
        VertxInternal v = (VertxInternal)this.vertices[pos];
        this.killedNode = pos;
        v.executeBlocking(fut -> {
            v.simulateKill();
            fut.complete();
        }, ar -> this.assertTrue(ar.succeeded()));
    }

    protected void createNodes(int nodes) {
        this.startNodes(nodes, new VertxOptions().setHAEnabled(true));
        this.aliveNodes = new CopyOnWriteArrayList<Integer>();
        for (int i = 0; i < nodes; ++i) {
            this.aliveNodes.add(i);
            int pos = i;
            ((VertxInternal)this.vertices[i]).failoverCompleteHandler((nodeID, haInfo, succeeded) -> this.failedOverOnto(pos));
        }
        this.deploymentSnapshots = new Set[nodes];
    }

    protected void failedOverOnto(int node) {
        this.checkDeployments();
        this.checkHasDeployments(node, this.killedNode);
        if (this.aliveNodes.size() > 1) {
            this.undeployRandomVerticles(() -> this.deployRandomVerticles(() -> this.killRandom()));
        } else {
            this.testComplete();
        }
    }

    protected void checkDeployments() {
        int totalDeployed = 0;
        for (int i = 0; i < this.vertices.length; ++i) {
            VertxInternal v = (VertxInternal)this.vertices[i];
            if (v.isKilled()) continue;
            totalDeployed += this.checkHasDeployments(i, i);
        }
        this.assertEquals(this.totDeployed, totalDeployed);
    }

    protected int checkHasDeployments(int pos, int prevPos) {
        Set<Deployment> prevSet = this.deploymentSnapshots[prevPos];
        Set<Deployment> currSet = this.takeDeploymentSnapshot(pos);
        for (Deployment prev : prevSet) {
            boolean contains = false;
            for (Deployment curr : currSet) {
                if (!curr.verticleIdentifier().equals(prev.verticleIdentifier()) || !curr.deploymentOptions().equals((Object)prev.deploymentOptions())) continue;
                contains = true;
                break;
            }
            this.assertTrue(contains);
        }
        return currSet.size();
    }

    protected void killRandom() {
        int i = this.random.nextInt(this.aliveNodes.size());
        int pos = this.aliveNodes.get(i);
        this.aliveNodes.remove(i);
        this.kill(pos);
    }
}

