/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.impl.verticle.CompilingClassLoader;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.ExtraCPVerticleAlreadyInParentLoader;
import io.vertx.test.core.ExtraCPVerticleNotInParentLoader;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.TestVerticle;
import io.vertx.test.core.TestVerticle2;
import io.vertx.test.core.TestVerticle3;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.core.sourceverticle.SourceVerticle;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.Test;

public class DeploymentTest
extends VertxTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestVerticle.instanceCount.set(0);
    }

    @Test
    public void testOptions() {
        DeploymentOptions options = new DeploymentOptions();
        this.assertNull(options.getConfig());
        JsonObject config = new JsonObject().put("foo", "bar").put("obj", new JsonObject().put("quux", Integer.valueOf(123)));
        this.assertEquals(options, options.setConfig(config));
        this.assertEquals(config, options.getConfig());
        this.assertFalse(options.isWorker());
        this.assertEquals(options, options.setWorker(true));
        this.assertTrue(options.isWorker());
        this.assertFalse(options.isMultiThreaded());
        this.assertEquals(options, options.setMultiThreaded(true));
        this.assertTrue(options.isMultiThreaded());
        this.assertNull(options.getIsolationGroup());
        String rand = TestUtils.randomUnicodeString(1000);
        this.assertEquals(options, options.setIsolationGroup(rand));
        this.assertEquals(rand, options.getIsolationGroup());
        this.assertFalse(options.isHa());
        this.assertEquals(options, options.setHa(true));
        this.assertTrue(options.isHa());
        this.assertNull(options.getExtraClasspath());
        List<String> cp = Arrays.asList("foo", "bar");
        this.assertEquals(options, options.setExtraClasspath(cp));
        this.assertNull(options.getIsolatedClasses());
        List<String> isol = Arrays.asList("com.foo.MyClass", "org.foo.*");
        this.assertEquals(options, options.setIsolatedClasses(isol));
        this.assertSame(isol, options.getIsolatedClasses());
        String workerPoolName = TestUtils.randomAlphaString(10);
        this.assertEquals(options, options.setWorkerPoolName(workerPoolName));
        this.assertEquals(workerPoolName, options.getWorkerPoolName());
        int workerPoolSize = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setWorkerPoolSize(workerPoolSize));
        this.assertEquals(workerPoolSize, options.getWorkerPoolSize());
        long maxWorkerExecuteTime = TestUtils.randomPositiveLong();
        this.assertEquals(options, options.setMaxWorkerExecuteTime(maxWorkerExecuteTime));
        this.assertEquals(maxWorkerExecuteTime, options.getMaxWorkerExecuteTime());
    }

    @Test
    public void testCopyOptions() {
        DeploymentOptions options = new DeploymentOptions();
        JsonObject config = new JsonObject().put("foo", "bar");
        Random rand = new Random();
        boolean worker = rand.nextBoolean();
        boolean multiThreaded = rand.nextBoolean();
        String isolationGroup = TestUtils.randomAlphaString(100);
        boolean ha = rand.nextBoolean();
        List<String> cp = Arrays.asList("foo", "bar");
        List<String> isol = Arrays.asList("com.foo.MyClass", "org.foo.*");
        String poolName = TestUtils.randomAlphaString(10);
        int poolSize = TestUtils.randomPositiveInt();
        long maxWorkerExecuteTime = TestUtils.randomPositiveLong();
        options.setConfig(config);
        options.setWorker(worker);
        options.setMultiThreaded(multiThreaded);
        options.setIsolationGroup(isolationGroup);
        options.setHa(ha);
        options.setExtraClasspath(cp);
        options.setIsolatedClasses(isol);
        options.setWorkerPoolName(poolName);
        options.setWorkerPoolSize(poolSize);
        options.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        DeploymentOptions copy = new DeploymentOptions(options);
        this.assertEquals(worker, copy.isWorker());
        this.assertEquals(multiThreaded, copy.isMultiThreaded());
        this.assertEquals(isolationGroup, copy.getIsolationGroup());
        this.assertNotSame(config, copy.getConfig());
        this.assertEquals("bar", copy.getConfig().getString("foo"));
        this.assertEquals(ha, copy.isHa());
        this.assertEquals(cp, copy.getExtraClasspath());
        this.assertNotSame(cp, copy.getExtraClasspath());
        this.assertEquals(isol, copy.getIsolatedClasses());
        this.assertNotSame(isol, copy.getIsolatedClasses());
        this.assertEquals(poolName, copy.getWorkerPoolName());
        this.assertEquals(poolSize, copy.getWorkerPoolSize());
        this.assertEquals(maxWorkerExecuteTime, copy.getMaxWorkerExecuteTime());
    }

    @Test
    public void testDefaultJsonOptions() {
        DeploymentOptions def = new DeploymentOptions();
        DeploymentOptions json = new DeploymentOptions(new JsonObject());
        this.assertEquals(def.getConfig(), json.getConfig());
        this.assertEquals(def.isWorker(), json.isWorker());
        this.assertEquals(def.isMultiThreaded(), json.isMultiThreaded());
        this.assertEquals(def.getIsolationGroup(), json.getIsolationGroup());
        this.assertEquals(def.isHa(), json.isHa());
        this.assertEquals(def.getExtraClasspath(), json.getExtraClasspath());
        this.assertEquals(def.getIsolatedClasses(), json.getIsolatedClasses());
        this.assertEquals(def.getWorkerPoolName(), json.getWorkerPoolName());
        this.assertEquals(def.getWorkerPoolSize(), json.getWorkerPoolSize());
        this.assertEquals(def.getMaxWorkerExecuteTime(), json.getMaxWorkerExecuteTime());
    }

    @Test
    public void testJsonOptions() {
        JsonObject config = new JsonObject().put("foo", "bar");
        Random rand = new Random();
        boolean worker = rand.nextBoolean();
        boolean multiThreaded = rand.nextBoolean();
        String isolationGroup = TestUtils.randomAlphaString(100);
        boolean ha = rand.nextBoolean();
        List<String> cp = Arrays.asList("foo", "bar");
        List<String> isol = Arrays.asList("com.foo.MyClass", "org.foo.*");
        String poolName = TestUtils.randomAlphaString(10);
        int poolSize = TestUtils.randomPositiveInt();
        long maxWorkerExecuteTime = TestUtils.randomPositiveLong();
        JsonObject json = new JsonObject();
        json.put("config", config);
        json.put("worker", Boolean.valueOf(worker));
        json.put("multiThreaded", Boolean.valueOf(multiThreaded));
        json.put("isolationGroup", isolationGroup);
        json.put("ha", Boolean.valueOf(ha));
        json.put("extraClasspath", new JsonArray(cp));
        json.put("isolatedClasses", new JsonArray(isol));
        json.put("workerPoolName", poolName);
        json.put("workerPoolSize", Integer.valueOf(poolSize));
        json.put("maxWorkerExecuteTime", Long.valueOf(maxWorkerExecuteTime));
        DeploymentOptions options = new DeploymentOptions(json);
        this.assertEquals(worker, options.isWorker());
        this.assertEquals(multiThreaded, options.isMultiThreaded());
        this.assertEquals(isolationGroup, options.getIsolationGroup());
        this.assertEquals("bar", options.getConfig().getString("foo"));
        this.assertEquals(ha, options.isHa());
        this.assertEquals(cp, options.getExtraClasspath());
        this.assertEquals(isol, options.getIsolatedClasses());
        this.assertEquals(poolName, options.getWorkerPoolName());
        this.assertEquals(poolSize, options.getWorkerPoolSize());
        this.assertEquals(maxWorkerExecuteTime, options.getMaxWorkerExecuteTime());
    }

    @Test
    public void testToJson() {
        DeploymentOptions options = new DeploymentOptions();
        JsonObject config = new JsonObject().put("foo", "bar");
        Random rand = new Random();
        boolean worker = rand.nextBoolean();
        boolean multiThreaded = rand.nextBoolean();
        String isolationGroup = TestUtils.randomAlphaString(100);
        boolean ha = rand.nextBoolean();
        List<String> cp = Arrays.asList("foo", "bar");
        List<String> isol = Arrays.asList("com.foo.MyClass", "org.foo.*");
        String poolName = TestUtils.randomAlphaString(10);
        int poolSize = TestUtils.randomPositiveInt();
        long maxWorkerExecuteTime = TestUtils.randomPositiveLong();
        options.setConfig(config);
        options.setWorker(worker);
        options.setMultiThreaded(multiThreaded);
        options.setIsolationGroup(isolationGroup);
        options.setHa(ha);
        options.setExtraClasspath(cp);
        options.setIsolatedClasses(isol);
        options.setWorkerPoolName(poolName);
        options.setWorkerPoolSize(poolSize);
        options.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        JsonObject json = options.toJson();
        DeploymentOptions copy = new DeploymentOptions(json);
        this.assertEquals(worker, copy.isWorker());
        this.assertEquals(multiThreaded, copy.isMultiThreaded());
        this.assertEquals(isolationGroup, copy.getIsolationGroup());
        this.assertEquals("bar", copy.getConfig().getString("foo"));
        this.assertEquals(ha, copy.isHa());
        this.assertEquals(cp, copy.getExtraClasspath());
        this.assertEquals(isol, copy.getIsolatedClasses());
        this.assertEquals(poolName, copy.getWorkerPoolName());
        this.assertEquals(poolSize, copy.getWorkerPoolSize());
        this.assertEquals(maxWorkerExecuteTime, copy.getMaxWorkerExecuteTime());
    }

    @Test
    public void testDeployFromTestThread() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertDeployment(1, verticle, null, (AsyncResult<String>)ar);
            this.assertFalse(verticle.startContext.isMultiThreadedWorkerContext());
            this.assertFalse(verticle.startContext.isWorkerContext());
            this.assertTrue(verticle.startContext.isEventLoopContext());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployFromTestThreadNoHandler() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle);
        this.waitUntil(() -> this.vertx.deploymentIDs().size() == 1);
    }

    @Test
    public void testDeployWithConfig() throws Exception {
        MyVerticle verticle = new MyVerticle();
        JsonObject config = this.generateJSONObject();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setConfig(config), ar -> {
            this.assertDeployment(1, verticle, config, (AsyncResult<String>)ar);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployFromContext() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            Context ctx = Vertx.currentContext();
            MyVerticle verticle2 = new MyVerticle();
            this.vertx.deployVerticle((Verticle)verticle2, ar2 -> {
                this.assertDeployment(2, verticle2, null, (AsyncResult<String>)ar2);
                Context ctx2 = Vertx.currentContext();
                this.assertEquals(ctx, ctx2);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDeployWorkerFromTestThread() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true), ar -> {
            this.assertDeployment(1, verticle, null, (AsyncResult<String>)ar);
            this.assertTrue(verticle.startContext instanceof WorkerContext);
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(verticle.startContext, verticle.stopContext);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDeployWorkerWithConfig() throws Exception {
        MyVerticle verticle = new MyVerticle();
        JsonObject conf = this.generateJSONObject();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setConfig(conf).setWorker(true), ar -> {
            this.assertDeployment(1, verticle, conf, (AsyncResult<String>)ar);
            this.assertFalse(verticle.startContext.isMultiThreadedWorkerContext());
            this.assertTrue(verticle.startContext.isWorkerContext());
            this.assertFalse(verticle.startContext.isEventLoopContext());
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(verticle.startContext, verticle.stopContext);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDeployMultithreadedWorkerWithConfig() throws Exception {
        MyVerticle verticle = new MyVerticle();
        JsonObject conf = this.generateJSONObject();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setConfig(conf).setWorker(true).setMultiThreaded(true), ar -> {
            this.assertDeployment(1, verticle, conf, (AsyncResult<String>)ar);
            this.assertTrue(verticle.startContext.isMultiThreadedWorkerContext());
            this.assertTrue(verticle.startContext.isWorkerContext());
            this.assertFalse(verticle.startContext.isEventLoopContext());
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(verticle.startContext, verticle.stopContext);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWorkerRightThread() throws Exception {
        this.assertFalse(Context.isOnVertxThread());
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertTrue(Context.isOnWorkerThread());
                DeploymentTest.this.assertFalse(Context.isOnEventLoopThread());
            }

            public void stop() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertTrue(Context.isOnWorkerThread());
                DeploymentTest.this.assertFalse(Context.isOnEventLoopThread());
            }
        };
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true), this.onSuccess(res -> {
            this.assertTrue(Context.isOnVertxThread());
            this.assertFalse(Context.isOnWorkerThread());
            this.assertTrue(Context.isOnEventLoopThread());
            this.vertx.undeploy(res, this.onSuccess(res2 -> {
                this.assertTrue(Context.isOnVertxThread());
                this.assertFalse(Context.isOnWorkerThread());
                this.assertTrue(Context.isOnEventLoopThread());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testMTWorkerRightThread() throws Exception {
        this.assertFalse(Context.isOnVertxThread());
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertTrue(Context.isOnWorkerThread());
                DeploymentTest.this.assertFalse(Context.isOnEventLoopThread());
            }

            public void stop() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertTrue(Context.isOnWorkerThread());
                DeploymentTest.this.assertFalse(Context.isOnEventLoopThread());
            }
        };
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true).setMultiThreaded(true), this.onSuccess(res -> {
            this.assertTrue(Context.isOnVertxThread());
            this.assertFalse(Context.isOnWorkerThread());
            this.assertTrue(Context.isOnEventLoopThread());
            this.vertx.undeploy(res, this.onSuccess(res2 -> {
                this.assertTrue(Context.isOnVertxThread());
                this.assertFalse(Context.isOnWorkerThread());
                this.assertTrue(Context.isOnEventLoopThread());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testStandardRightThread() throws Exception {
        this.assertFalse(Context.isOnVertxThread());
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertFalse(Context.isOnWorkerThread());
                DeploymentTest.this.assertTrue(Context.isOnEventLoopThread());
            }

            public void stop() throws Exception {
                DeploymentTest.this.assertTrue(Context.isOnVertxThread());
                DeploymentTest.this.assertFalse(Context.isOnWorkerThread());
                DeploymentTest.this.assertTrue(Context.isOnEventLoopThread());
            }
        };
        this.vertx.deployVerticle((Verticle)verticle, this.onSuccess(res -> {
            this.assertTrue(Context.isOnVertxThread());
            this.assertFalse(Context.isOnWorkerThread());
            this.assertTrue(Context.isOnEventLoopThread());
            this.vertx.undeploy(res, this.onSuccess(res2 -> {
                this.assertTrue(Context.isOnVertxThread());
                this.assertFalse(Context.isOnWorkerThread());
                this.assertTrue(Context.isOnEventLoopThread());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testDeployMultithreadedNotWorker() throws Exception {
        MyVerticle verticle = new MyVerticle();
        try {
            this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(false).setMultiThreaded(true), ar -> {});
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDeployFromContextExceptionInStart() throws Exception {
        this.testDeployFromThrowableInStart(1, Exception.class);
    }

    @Test
    public void testDeployFromContextErrorInStart() throws Exception {
        this.testDeployFromThrowableInStart(2, Error.class);
    }

    private void testDeployFromThrowableInStart(int startAction, Class<? extends Throwable> expectedThrowable) throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            Context ctx = Vertx.currentContext();
            MyVerticle verticle2 = new MyVerticle(startAction, 0);
            this.vertx.deployVerticle((Verticle)verticle2, ar2 -> {
                this.assertFalse(ar2.succeeded());
                this.assertEquals(expectedThrowable, ar2.cause().getClass());
                this.assertEquals("FooBar!", ar2.cause().getMessage());
                this.assertEquals(1L, this.vertx.deploymentIDs().size());
                Context ctx2 = Vertx.currentContext();
                this.assertEquals(ctx, ctx2);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDeployFromContextExceptonInStop() throws Exception {
        this.testDeployFromContextThrowableInStop(1, Exception.class);
    }

    @Test
    public void testDeployFromContextErrorInStop() throws Exception {
        this.testDeployFromContextThrowableInStop(2, Error.class);
    }

    private void testDeployFromContextThrowableInStop(int stopAction, Class<? extends Throwable> expectedThrowable) throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            Context ctx = Vertx.currentContext();
            MyVerticle verticle2 = new MyVerticle(0, stopAction);
            this.vertx.deployVerticle((Verticle)verticle2, ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.vertx.undeploy((String)ar2.result(), ar3 -> {
                    this.assertFalse(ar3.succeeded());
                    this.assertEquals(expectedThrowable, ar3.cause().getClass());
                    this.assertEquals("BooFar!", ar3.cause().getMessage());
                    this.assertEquals(1L, this.vertx.deploymentIDs().size());
                    this.assertEquals(ctx, Vertx.currentContext());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testUndeploy() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertNull(ar2.result());
                this.assertFalse(this.vertx.deploymentIDs().contains(ar.result()));
                this.assertEquals(verticle.startContext, verticle.stopContext);
                Context currentContext = Vertx.currentContext();
                this.assertNotSame(currentContext, verticle.startContext);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testUndeployNoHandler() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            this.vertx.undeploy((String)ar.result());
        });
        this.waitUntil(() -> this.vertx.deploymentIDs().isEmpty());
    }

    @Test
    public void testUndeployTwice() throws Exception {
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.vertx.undeploy((String)ar.result(), ar3 -> {
                    this.assertFalse(ar3.succeeded());
                    this.assertTrue(ar3.cause() instanceof IllegalStateException);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testUndeployInvalidID() throws Exception {
        this.vertx.undeploy("uqhwdiuhqwd", ar -> {
            this.assertFalse(ar.succeeded());
            this.assertTrue(ar.cause() instanceof IllegalStateException);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployExceptionInStart() throws Exception {
        this.testDeployThrowableInStart(1, Exception.class);
    }

    @Test
    public void testDeployErrorInStart() throws Exception {
        this.testDeployThrowableInStart(2, Error.class);
    }

    private void testDeployThrowableInStart(int startAction, Class<? extends Throwable> expectedThrowable) throws Exception {
        MyVerticle verticle = new MyVerticle(startAction, 0);
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertFalse(ar.succeeded());
            this.assertEquals(expectedThrowable, ar.cause().getClass());
            this.assertEquals("FooBar!", ar.cause().getMessage());
            this.assertTrue(this.vertx.deploymentIDs().isEmpty());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testUndeployExceptionInStop() throws Exception {
        this.testUndeployThrowableInStop(1, Exception.class);
    }

    @Test
    public void testUndeployErrorInStop() throws Exception {
        this.testUndeployThrowableInStop(2, Error.class);
    }

    private void testUndeployThrowableInStop(int stopAction, Class<? extends Throwable> expectedThrowable) throws Exception {
        MyVerticle verticle = new MyVerticle(0, stopAction);
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertFalse(ar2.succeeded());
                this.assertEquals(expectedThrowable, ar2.cause().getClass());
                this.assertEquals("BooFar!", ar2.cause().getMessage());
                this.assertTrue(this.vertx.deploymentIDs().isEmpty());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDeployUndeployMultiple() throws Exception {
        int num = 10;
        CountDownLatch deployLatch = new CountDownLatch(num);
        for (int i = 0; i < num; ++i) {
            MyVerticle verticle = new MyVerticle();
            this.vertx.deployVerticle((Verticle)verticle, ar -> {
                this.assertTrue(ar.succeeded());
                this.assertTrue(this.vertx.deploymentIDs().contains(ar.result()));
                deployLatch.countDown();
            });
        }
        this.assertTrue(deployLatch.await(10L, TimeUnit.SECONDS));
        this.assertEquals(num, this.vertx.deploymentIDs().size());
        CountDownLatch undeployLatch = new CountDownLatch(num);
        for (String deploymentID : this.vertx.deploymentIDs()) {
            this.vertx.undeploy(deploymentID, ar -> {
                this.assertTrue(ar.succeeded());
                this.assertFalse(this.vertx.deploymentIDs().contains(deploymentID));
                undeployLatch.countDown();
            });
        }
        this.assertTrue(undeployLatch.await(10L, TimeUnit.SECONDS));
        this.assertTrue(this.vertx.deploymentIDs().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeployInstanceSetInstances() throws Exception {
        this.vertx.deployVerticle((Verticle)new MyVerticle(), new DeploymentOptions().setInstances(2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeployInstanceSetExtraClasspath() throws Exception {
        this.vertx.deployVerticle((Verticle)new MyVerticle(), new DeploymentOptions().setExtraClasspath(Arrays.asList("foo")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeployInstanceSetIsolationGroup() throws Exception {
        this.vertx.deployVerticle((Verticle)new MyVerticle(), new DeploymentOptions().setIsolationGroup("foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeployInstanceSetIsolatedClasses() throws Exception {
        this.vertx.deployVerticle((Verticle)new MyVerticle(), new DeploymentOptions().setIsolatedClasses(Arrays.asList("foo")));
    }

    @Test
    public void testDeployUsingClassName() throws Exception {
        this.vertx.deployVerticle("java:" + TestVerticle.class.getCanonicalName(), ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployUsingClassAndConfig() throws Exception {
        JsonObject config = this.generateJSONObject();
        this.vertx.deployVerticle("java:" + TestVerticle.class.getCanonicalName(), new DeploymentOptions().setConfig(config), ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployUsingClassFails() throws Exception {
        this.vertx.deployVerticle("java:uhqwuhiqwduhwd", ar -> {
            this.assertFalse(ar.succeeded());
            this.assertTrue(ar.cause() instanceof ClassNotFoundException);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployUndeployMultipleInstancesUsingClassName() throws Exception {
        int numInstances = 10;
        DeploymentOptions options = new DeploymentOptions().setInstances(numInstances);
        AtomicInteger deployCount = new AtomicInteger();
        AtomicInteger undeployCount = new AtomicInteger();
        AtomicInteger deployHandlerCount = new AtomicInteger();
        AtomicInteger undeployHandlerCount = new AtomicInteger();
        this.vertx.eventBus().consumer("tvstarted").handler(msg -> deployCount.incrementAndGet());
        this.vertx.eventBus().consumer("tvstopped").handler(msg -> {
            undeployCount.incrementAndGet();
            msg.reply((Object)"whatever");
        });
        CountDownLatch deployLatch = new CountDownLatch(1);
        this.vertx.deployVerticle(TestVerticle2.class.getCanonicalName(), options, this.onSuccess(depID -> {
            this.assertEquals(1L, deployHandlerCount.incrementAndGet());
            deployLatch.countDown();
        }));
        this.awaitLatch(deployLatch);
        this.waitUntil(() -> deployCount.get() == numInstances);
        this.assertEquals(1L, this.vertx.deploymentIDs().size());
        Deployment deployment = ((VertxInternal)this.vertx).getDeployment((String)this.vertx.deploymentIDs().iterator().next());
        Set verticles = deployment.getVerticles();
        this.assertEquals(numInstances, verticles.size());
        CountDownLatch undeployLatch = new CountDownLatch(1);
        this.assertEquals(numInstances, deployCount.get());
        this.vertx.undeploy(deployment.deploymentID(), this.onSuccess(v -> {
            this.assertEquals(1L, undeployHandlerCount.incrementAndGet());
            undeployLatch.countDown();
        }));
        this.awaitLatch(undeployLatch);
        this.waitUntil(() -> deployCount.get() == numInstances);
        this.assertTrue(this.vertx.deploymentIDs().isEmpty());
    }

    @Test
    public void testDeployClassNotFound1() throws Exception {
        this.testDeployClassNotFound("iqwjdiqwjdoiqwjdqwij");
    }

    @Test
    public void testDeployClassNotFound2() throws Exception {
        this.testDeployClassNotFound("foo.bar.wibble.CiejdioqjdoiqwjdoiqjwdClass");
    }

    private void testDeployClassNotFound(String className) throws Exception {
        this.vertx.deployVerticle(className, ar -> {
            this.assertTrue(ar.failed());
            this.assertTrue(ar.cause() instanceof ClassNotFoundException);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDeployAsSource() throws Exception {
        String sourceFile = SourceVerticle.class.getName().replace('.', '/');
        sourceFile = sourceFile + ".java";
        this.vertx.deployVerticle("java:" + sourceFile, this.onSuccess(res -> this.testComplete()));
        this.await();
    }

    @Test
    public void testSimpleChildDeployment() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> {
            Context parentContext = Vertx.currentContext();
            MyAsyncVerticle child1 = new MyAsyncVerticle(f2 -> {
                Context childContext = Vertx.currentContext();
                this.assertNotSame(parentContext, childContext);
                f2.complete(null);
                this.testComplete();
            }, f2 -> f2.complete(null));
            this.vertx.deployVerticle((Verticle)child1, ar -> this.assertTrue(ar.succeeded()));
            f.complete(null);
        }, f -> f.complete(null));
        this.vertx.deployVerticle((Verticle)verticle, ar -> this.assertTrue(ar.succeeded()));
        this.await();
    }

    @Test
    public void testSimpleChildUndeploymentOrder() throws Exception {
        AtomicBoolean childStopCalled = new AtomicBoolean();
        AtomicBoolean parentStopCalled = new AtomicBoolean();
        AtomicReference parentDepID = new AtomicReference();
        AtomicReference childDepID = new AtomicReference();
        CountDownLatch deployLatch = new CountDownLatch(1);
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> {
            MyAsyncVerticle child1 = new MyAsyncVerticle(f2 -> f2.complete(null), f2 -> {
                this.assertFalse(parentStopCalled.get());
                this.assertFalse(childStopCalled.get());
                childStopCalled.set(true);
                f2.complete(null);
            });
            this.vertx.deployVerticle((Verticle)child1, ar -> {
                this.assertTrue(ar.succeeded());
                childDepID.set(ar.result());
                f.complete(null);
            });
        }, f2 -> {
            this.assertFalse(parentStopCalled.get());
            this.assertTrue(childStopCalled.get());
            this.assertTrue(this.vertx.deploymentIDs().contains(parentDepID.get()));
            this.assertFalse(this.vertx.deploymentIDs().contains(childDepID.get()));
            parentStopCalled.set(true);
            this.testComplete();
            f2.complete(null);
        });
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            parentDepID.set(ar.result());
            this.assertTrue(ar.succeeded());
            deployLatch.countDown();
        });
        this.assertTrue(deployLatch.await(10L, TimeUnit.SECONDS));
        this.assertTrue(this.vertx.deploymentIDs().contains(parentDepID.get()));
        this.assertTrue(this.vertx.deploymentIDs().contains(childDepID.get()));
        this.vertx.undeploy((String)parentDepID.get(), ar -> this.assertTrue(ar.succeeded()));
        this.await();
    }

    @Test
    public void testAsyncDeployCalledSynchronously() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> f.complete(null));
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAsyncDeployFailureCalledSynchronously() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.fail((Throwable)new Exception("foobar")), null);
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertFalse(ar.succeeded());
            this.assertEquals("foobar", ar.cause().getMessage());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAsyncDeploy() throws Exception {
        long start = System.currentTimeMillis();
        long delay = 1000L;
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> this.vertx.setTimer(delay, id -> f.complete(null)), f -> f.complete(null));
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            long now = System.currentTimeMillis();
            this.assertTrue(now - start >= delay);
            this.assertTrue(this.vertx.deploymentIDs().contains(ar.result()));
            this.testComplete();
        });
        Thread.sleep(delay / 2L);
        this.assertTrue(this.vertx.deploymentIDs().isEmpty());
        this.await();
    }

    @Test
    public void testAsyncDeployFailure() throws Exception {
        long start = System.currentTimeMillis();
        long delay = 1000L;
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> this.vertx.setTimer(delay, id -> f.fail((Throwable)new Exception("foobar"))), null);
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertFalse(ar.succeeded());
            this.assertEquals("foobar", ar.cause().getMessage());
            long now = System.currentTimeMillis();
            this.assertTrue(now - start >= delay);
            this.assertTrue(this.vertx.deploymentIDs().isEmpty());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testAsyncUndeployCalledSynchronously() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> f.complete(null));
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertFalse(this.vertx.deploymentIDs().contains(ar.result()));
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testAsyncUndeployFailureCalledSynchronously() throws Exception {
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> f.fail((Throwable)new Exception("foobar")));
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertFalse(ar2.succeeded());
                this.assertEquals("foobar", ar2.cause().getMessage());
                this.assertFalse(this.vertx.deploymentIDs().contains(ar.result()));
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testAsyncUndeploy() throws Exception {
        long delay = 1000L;
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> this.vertx.setTimer(delay, id -> f.complete(null)));
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            long start = System.currentTimeMillis();
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                long now = System.currentTimeMillis();
                this.assertTrue(now - start >= delay);
                this.assertFalse(this.vertx.deploymentIDs().contains(ar.result()));
                this.testComplete();
            });
            this.vertx.setTimer(delay / 2L, id -> this.assertFalse(this.vertx.deploymentIDs().isEmpty()));
        });
        this.await();
    }

    @Test
    public void testAsyncUndeployFailure() throws Exception {
        long delay = 1000L;
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> f.complete(null), f -> this.vertx.setTimer(delay, id -> f.fail((Throwable)new Exception("foobar"))));
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            long start = System.currentTimeMillis();
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertFalse(ar2.succeeded());
                long now = System.currentTimeMillis();
                this.assertTrue(now - start >= delay);
                this.assertFalse(this.vertx.deploymentIDs().contains(ar.result()));
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testChildUndeployedDirectly() throws Exception {
        AbstractVerticle parent = new AbstractVerticle(){

            public void start(Future<Void> startFuture) throws Exception {
                AbstractVerticle child = new AbstractVerticle(){

                    public void start(Future<Void> startFuture) throws Exception {
                        startFuture.complete();
                        this.vertx.runOnContext(v -> this.vertx.undeploy(this.context.deploymentID()));
                    }
                };
                this.vertx.deployVerticle((Verticle)child, DeploymentTest.this.onSuccess(depID -> startFuture.complete()));
            }

            public void stop(Future<Void> stopFuture) throws Exception {
                super.stop(stopFuture);
            }
        };
        this.vertx.deployVerticle((Verticle)parent, this.onSuccess(depID -> this.vertx.setTimer(10L, tid -> this.vertx.undeploy(depID, this.onSuccess(v -> this.testComplete())))));
        this.await();
    }

    @Test
    public void testCloseHooksCalled() throws Exception {
        AtomicInteger closedCount = new AtomicInteger();
        Closeable myCloseable1 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.handle((Object)Future.succeededFuture());
        };
        Closeable myCloseable2 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.handle((Object)Future.succeededFuture());
        };
        MyAsyncVerticle verticle = new MyAsyncVerticle(f -> {
            ContextImpl ctx = (ContextImpl)Vertx.currentContext();
            ctx.addCloseHook(myCloseable1);
            ctx.addCloseHook(myCloseable2);
            f.complete(null);
        }, f -> f.complete(null));
        this.vertx.deployVerticle((Verticle)verticle, ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, closedCount.get());
            this.vertx.undeploy((String)ar.result(), ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.assertEquals(2L, closedCount.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDeployWhenClosedShouldFail() throws Exception {
        CountDownLatch closed = new CountDownLatch(1);
        this.vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            closed.countDown();
        });
        this.awaitLatch(closed);
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){}, ar -> {
            this.assertFalse(ar.succeeded());
            this.assertEquals("Vert.x closed", ar.cause().getMessage());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testIsolationGroup1() throws Exception {
        List<String> isolatedClasses = Arrays.asList(TestVerticle.class.getCanonicalName());
        this.vertx.deployVerticle("java:" + TestVerticle.class.getCanonicalName(), new DeploymentOptions().setIsolationGroup("somegroup").setIsolatedClasses(isolatedClasses), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, TestVerticle.instanceCount.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testNullIsolationGroup() throws Exception {
        this.vertx.deployVerticle("java:" + TestVerticle.class.getCanonicalName(), new DeploymentOptions().setIsolationGroup(null), ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(1L, TestVerticle.instanceCount.get());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testIsolationGroupSameGroup() throws Exception {
        List<String> isolatedClasses = Arrays.asList(TestVerticle.class.getCanonicalName());
        this.testIsolationGroup("somegroup", "somegroup", 1, 2, isolatedClasses, "java:" + TestVerticle.class.getCanonicalName());
    }

    @Test
    public void testIsolationGroupSameGroupWildcard() throws Exception {
        List<String> isolatedClasses = Arrays.asList("io.vertx.test.core.*");
        this.testIsolationGroup("somegroup", "somegroup", 1, 2, isolatedClasses, "java:" + TestVerticle.class.getCanonicalName());
    }

    @Test
    public void testIsolationGroupDifferentGroup() throws Exception {
        List<String> isolatedClasses = Arrays.asList(TestVerticle.class.getCanonicalName());
        this.testIsolationGroup("somegroup", "someothergroup", 1, 1, isolatedClasses, "java:" + TestVerticle.class.getCanonicalName());
    }

    private String createClassOutsideClasspath(String className) throws Exception {
        File dir = Files.createTempDirectory("vertx", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        File source = new File(dir, className + ".java");
        Files.write(source.toPath(), ("public class " + className + " extends io.vertx.core.AbstractVerticle {} ").getBytes(), new OpenOption[0]);
        URLClassLoader loader = new URLClassLoader(new URL[]{dir.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        CompilingClassLoader compilingClassLoader = new CompilingClassLoader((ClassLoader)loader, className + ".java");
        compilingClassLoader.loadClass(className);
        byte[] bytes = compilingClassLoader.getClassBytes(className);
        this.assertNotNull(bytes);
        File classFile = new File(dir, className + ".class");
        Files.write(classFile.toPath(), bytes, new OpenOption[0]);
        return dir.getAbsolutePath();
    }

    @Test
    public void testExtraClasspathLoaderNotInParentLoader() throws Exception {
        String dir = this.createClassOutsideClasspath("MyVerticle");
        List<String> extraClasspath = Arrays.asList(dir);
        this.vertx.deployVerticle("java:" + ExtraCPVerticleNotInParentLoader.class.getCanonicalName(), new DeploymentOptions().setIsolationGroup("somegroup").setExtraClasspath(extraClasspath), ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtraClasspathLoaderAlreadyInParentLoader() throws Exception {
        String dir = this.createClassOutsideClasspath("MyVerticle");
        URLClassLoader loader = new URLClassLoader(new URL[]{new File(dir).toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        List<String> extraClasspath = Arrays.asList(dir);
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            this.vertx.deployVerticle("java:" + ExtraCPVerticleAlreadyInParentLoader.class.getCanonicalName(), new DeploymentOptions().setIsolationGroup("somegroup").setExtraClasspath(extraClasspath), ar -> {
                this.assertTrue(ar.succeeded());
                this.testComplete();
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
        }
        this.await();
    }

    @Test
    public void testUndeployAll() throws Exception {
        int numVerticles = 10;
        ArrayList<MyVerticle> verticles = new ArrayList<MyVerticle>();
        CountDownLatch latch = new CountDownLatch(numVerticles);
        for (int i = 0; i < numVerticles; ++i) {
            MyVerticle verticle = new MyVerticle();
            verticles.add(verticle);
            this.vertx.deployVerticle("java:" + ParentVerticle.class.getName(), this.onSuccess(res -> latch.countDown()));
        }
        this.awaitLatch(latch);
        this.assertEquals(2 * numVerticles, this.vertx.deploymentIDs().size());
        this.vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertEquals(0L, this.vertx.deploymentIDs().size());
            this.testComplete();
        });
        this.await();
        this.vertx = null;
    }

    @Test
    public void testUndeployAllFailureInUndeploy() throws Exception {
        int numVerticles = 10;
        ArrayList<MyVerticle> verticles = new ArrayList<MyVerticle>();
        CountDownLatch latch = new CountDownLatch(numVerticles);
        for (int i = 0; i < numVerticles; ++i) {
            MyVerticle verticle = new MyVerticle(0, 1);
            verticles.add(verticle);
            this.vertx.deployVerticle((Verticle)verticle, ar2 -> {
                this.assertTrue(ar2.succeeded());
                latch.countDown();
            });
        }
        this.awaitLatch(latch);
        this.vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            for (MyVerticle verticle : verticles) {
                this.assertFalse(verticle.stopCalled);
            }
            this.testComplete();
        });
        this.await();
        this.vertx = null;
    }

    @Test
    public void testUndeployAllNoDeployments() throws Exception {
        this.vertx.close(ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
        this.vertx = null;
    }

    @Test
    public void testGetInstanceCount() throws Exception {
        class MultiInstanceVerticle
        extends AbstractVerticle {
            MultiInstanceVerticle() {
            }

            public void start() {
                DeploymentTest.this.assertEquals(this.vertx.getOrCreateContext().getInstanceCount(), 1L);
            }
        }
        this.vertx.deployVerticle((Verticle)new MultiInstanceVerticle(), ar -> {
            this.assertTrue(ar.succeeded());
            this.testComplete();
        });
        this.await();
        Deployment deployment = ((VertxInternal)this.vertx).getDeployment((String)this.vertx.deploymentIDs().iterator().next());
        this.vertx.undeploy(deployment.deploymentID());
    }

    @Test
    public void testGetInstanceCountMultipleVerticles() throws Exception {
        AtomicInteger messageCount = new AtomicInteger(0);
        AtomicInteger totalReportedInstances = new AtomicInteger(0);
        this.vertx.eventBus().consumer("instanceCount", event -> {
            messageCount.incrementAndGet();
            totalReportedInstances.addAndGet((Integer)event.body());
            if (messageCount.intValue() == 3) {
                this.assertEquals(9L, totalReportedInstances.get());
                this.testComplete();
            }
        });
        this.vertx.deployVerticle(TestVerticle3.class.getCanonicalName(), new DeploymentOptions().setInstances(3), ar -> this.assertTrue(ar.succeeded()));
        this.await();
        Deployment deployment = ((VertxInternal)this.vertx).getDeployment((String)this.vertx.deploymentIDs().iterator().next());
        this.vertx.undeploy(deployment.deploymentID());
    }

    @Test
    public void testFailedVerticleStopNotCalled() {
        AbstractVerticle verticleChild = new AbstractVerticle(){

            public void start(Future<Void> startFuture) throws Exception {
                startFuture.fail("wibble");
            }

            public void stop() {
                DeploymentTest.this.fail("stop should not be called");
            }
        };
        AbstractVerticle verticleParent = new AbstractVerticle((Verticle)verticleChild){
            final /* synthetic */ Verticle val$verticleChild;
            {
                this.val$verticleChild = verticle;
            }

            public void start(Future<Void> startFuture) throws Exception {
                this.vertx.deployVerticle(this.val$verticleChild, DeploymentTest.this.onFailure(v -> startFuture.complete()));
            }
        };
        this.vertx.deployVerticle((Verticle)verticleParent, this.onSuccess(depID -> this.vertx.undeploy(depID, this.onSuccess(v -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testUndeployWhenUndeployIsInProgress() throws Exception {
        int numIts = 10;
        CountDownLatch latch = new CountDownLatch(numIts);
        for (int i = 0; i < numIts; ++i) {
            AbstractVerticle parent = new AbstractVerticle(){

                public void start() throws Exception {
                    this.vertx.deployVerticle((Verticle)new AbstractVerticle(){}, id -> this.vertx.undeploy((String)id.result()));
                }
            };
            this.vertx.deployVerticle((Verticle)parent, id -> this.vertx.undeploy((String)id.result(), res -> latch.countDown()));
        }
        this.awaitLatch(latch);
    }

    private void testIsolationGroup(String group1, String group2, int count1, int count2, List<String> isolatedClasses, String verticleID) throws Exception {
        ConcurrentHashMap countMap = new ConcurrentHashMap();
        this.vertx.eventBus().consumer("testcounts").handler(msg -> countMap.put(((JsonObject)msg.body()).getString("deploymentID"), ((JsonObject)msg.body()).getInteger("count")));
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference deploymentID1 = new AtomicReference();
        AtomicReference deploymentID2 = new AtomicReference();
        this.vertx.deployVerticle(verticleID, new DeploymentOptions().setIsolationGroup(group1).setIsolatedClasses(isolatedClasses), ar -> {
            this.assertTrue(ar.succeeded());
            deploymentID1.set(ar.result());
            this.assertEquals(0L, TestVerticle.instanceCount.get());
            this.vertx.deployVerticle(verticleID, new DeploymentOptions().setIsolationGroup(group2).setIsolatedClasses(isolatedClasses), ar2 -> {
                this.assertTrue(ar2.succeeded());
                deploymentID2.set(ar2.result());
                this.assertEquals(0L, TestVerticle.instanceCount.get());
                latch.countDown();
            });
        });
        this.awaitLatch(latch);
        this.waitUntil(() -> countMap.size() == 2);
        this.assertEquals(count1, ((Integer)countMap.get(deploymentID1.get())).intValue());
        this.assertEquals(count2, ((Integer)countMap.get(deploymentID2.get())).intValue());
    }

    private void assertDeployment(int instances, MyVerticle verticle, JsonObject config, AsyncResult<String> ar) {
        this.assertTrue(ar.succeeded());
        this.assertEquals(this.vertx, verticle.getVertx());
        String deploymentID = (String)ar.result();
        this.assertNotNull(ar.result());
        this.assertEquals(deploymentID, verticle.deploymentID);
        if (config == null) {
            this.assertEquals(0L, verticle.config.size());
        } else {
            this.assertEquals(config, verticle.config);
        }
        this.assertTrue(verticle.startCalled);
        this.assertFalse(verticle.stopCalled);
        this.assertTrue(this.vertx.deploymentIDs().contains(deploymentID));
        this.assertEquals(instances, this.vertx.deploymentIDs().size());
        Context currentContext = Vertx.currentContext();
        this.assertNotSame(currentContext, verticle.startContext);
    }

    private JsonObject generateJSONObject() {
        return new JsonObject().put("foo", "bar").put("blah", Integer.valueOf(123)).put("obj", new JsonObject().put("quux", "flip"));
    }

    public class MyAsyncVerticle
    extends AbstractVerticle {
        private final Consumer<Future<Void>> startConsumer;
        private final Consumer<Future<Void>> stopConsumer;

        public MyAsyncVerticle(Consumer<Future<Void>> startConsumer, Consumer<Future<Void>> stopConsumer) {
            this.startConsumer = startConsumer;
            this.stopConsumer = stopConsumer;
        }

        public void start(Future<Void> startFuture) throws Exception {
            if (this.startConsumer != null) {
                this.startConsumer.accept(startFuture);
            }
        }

        public void stop(Future<Void> stopFuture) throws Exception {
            if (this.stopConsumer != null) {
                this.stopConsumer.accept(stopFuture);
            }
        }
    }

    public class MyVerticle
    extends AbstractVerticle {
        static final int NOOP = 0;
        static final int THROW_EXCEPTION = 1;
        static final int THROW_ERROR = 2;
        boolean startCalled;
        boolean stopCalled;
        Context startContext;
        Context stopContext;
        int startAction;
        int stopAction;
        String deploymentID;
        JsonObject config;

        MyVerticle() {
            this(0, 0);
        }

        MyVerticle(int startAction, int stopAction) {
            this.startAction = startAction;
            this.stopAction = stopAction;
        }

        public void start() throws Exception {
            switch (this.startAction) {
                case 1: {
                    throw new Exception("FooBar!");
                }
                case 2: {
                    throw new Error("FooBar!");
                }
            }
            this.startCalled = true;
            this.startContext = Vertx.currentContext();
            this.deploymentID = Vertx.currentContext().deploymentID();
            this.config = this.context.config();
        }

        public void stop() throws Exception {
            switch (this.stopAction) {
                case 1: {
                    throw new Exception("BooFar!");
                }
                case 2: {
                    throw new Error("BooFar!");
                }
            }
            this.stopCalled = true;
            this.stopContext = Vertx.currentContext();
        }
    }

    public static class ChildVerticle
    extends AbstractVerticle {
    }

    public static class ParentVerticle
    extends AbstractVerticle {
        public void start(Future<Void> startFuture) throws Exception {
            this.vertx.deployVerticle("java:" + ChildVerticle.class.getName(), ar -> {
                if (ar.succeeded()) {
                    startFuture.complete(null);
                } else {
                    ar.cause().printStackTrace();
                }
            });
        }
    }
}

