/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.test.core.VertxTestBase;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class EventLoopGroupTest
extends VertxTestBase {
    @Test
    public void testGetEventLoopGroup() {
        EventLoopGroup elp = this.vertx.nettyEventLoopGroup();
        this.assertNotNull(elp);
    }

    @Test
    public void testNettyServerUsesContextEventLoop() throws Exception {
        final ContextInternal context = (ContextInternal)this.vertx.getOrCreateContext();
        final AtomicReference contextThread = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        context.runOnContext(v -> {
            contextThread.set(Thread.currentThread());
            latch.countDown();
        });
        this.awaitLatch(latch);
        ServerBootstrap bs = new ServerBootstrap();
        bs.group((EventLoopGroup)context.nettyEventLoop());
        bs.channel(NioServerSocketChannel.class);
        bs.option(ChannelOption.SO_BACKLOG, (Object)100);
        bs.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                context.executeFromIO(() -> {
                    EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                    EventLoopGroupTest.this.assertSame(context, Vertx.currentContext());
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                            context.executeFromIO(() -> {
                                EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                                EventLoopGroupTest.this.assertSame(context, Vertx.currentContext());
                            });
                        }

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            ByteBuf buf = (ByteBuf)msg;
                            EventLoopGroupTest.this.assertEquals("hello", buf.toString(StandardCharsets.UTF_8));
                            EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                            context.executeFromIO(() -> {
                                EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                                EventLoopGroupTest.this.assertSame(context, Vertx.currentContext());
                            });
                        }

                        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                            EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                            context.executeFromIO(() -> {
                                EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                                EventLoopGroupTest.this.assertSame(context, Vertx.currentContext());
                                ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            });
                        }

                        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                            EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                            context.executeFromIO(() -> {
                                EventLoopGroupTest.this.assertSame(contextThread.get(), Thread.currentThread());
                                EventLoopGroupTest.this.assertSame(context, Vertx.currentContext());
                                EventLoopGroupTest.this.testComplete();
                            });
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            EventLoopGroupTest.this.fail(cause.getMessage());
                        }
                    }});
                });
            }
        });
        bs.bind("localhost", 1234).sync();
        this.vertx.createNetClient(new NetClientOptions()).connect(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            NetSocket so = (NetSocket)ar.result();
            so.write(Buffer.buffer((String)"hello"));
        });
        this.await();
    }
}

