/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.junit.Test;

public class FutureTest
extends VertxTestBase {
    @Test
    public void testStateAfterCompletion() {
        Object foo = new Object();
        Future future = Future.succeededFuture((Object)foo);
        this.assertTrue(future.succeeded());
        this.assertFalse(future.failed());
        this.assertTrue(future.isComplete());
        this.assertEquals(foo, future.result());
        this.assertNull(future.cause());
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        this.assertFalse(future.succeeded());
        this.assertTrue(future.failed());
        this.assertTrue(future.isComplete());
        this.assertNull(future.result());
        this.assertEquals(cause, future.cause());
    }

    @Test
    public void testSetResultOnCompletedFuture() {
        ArrayList<Future> futures = new ArrayList<Future>();
        futures.add(Future.succeededFuture());
        futures.add(Future.succeededFuture());
        futures.add(Future.succeededFuture((Object)new Object()));
        futures.add(Future.succeededFuture((Object)new Object()));
        futures.add(Future.failedFuture((Throwable)new Exception()));
        futures.add(Future.failedFuture((Throwable)new Exception()));
        for (Future future : futures) {
            try {
                future.complete(new Object());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                future.complete(null);
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                future.fail((Throwable)new Exception());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    @Test
    public void testCallSetHandlerBeforeCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Future future = Future.future();
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertFalse(called.get());
        future.complete(null);
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        future = Future.future();
        future.setHandler(result -> {
            called.set(true);
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
        });
        this.assertFalse(called.get());
        future.complete(foo);
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        future = Future.future();
        future.setHandler(result -> {
            called.set(true);
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
        });
        this.assertFalse(called.get());
        future.fail((Throwable)cause);
        this.assertTrue(called.get());
    }

    @Test
    public void testCallSetHandlerAfterCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Future future = Future.succeededFuture();
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        future = Future.succeededFuture((Object)foo);
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        future.setHandler(result -> {
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
    }

    @Test
    public void testResolveFutureToHandler() {
        Consumer<Handler> consumer = handler -> handler.handle((Object)Future.succeededFuture((Object)"the-result"));
        Future fut = Future.future();
        consumer.accept(fut.completer());
        this.assertTrue(fut.isComplete());
        this.assertTrue(fut.succeeded());
        this.assertEquals("the-result", fut.result());
    }

    @Test
    public void testFailFutureToHandler() {
        Throwable cause = new Throwable();
        Consumer<Handler> consumer = handler -> handler.handle((Object)Future.failedFuture((Throwable)cause));
        Future fut = Future.future();
        consumer.accept(fut.completer());
        this.assertTrue(fut.isComplete());
        this.assertTrue(fut.failed());
        this.assertEquals(cause, fut.cause());
    }

    @Test
    public void testCreateFailedWithNullFailure() {
        Future future = Future.failedFuture((Throwable)null);
        Checker checker = new Checker(future);
        NoStackTraceThrowable failure = (NoStackTraceThrowable)checker.assertFailed();
        this.assertNull(failure.getMessage());
    }

    @Test
    public void testFailurFutureWithNullFailure() {
        Future future = Future.future();
        future.fail((Throwable)null);
        Checker checker = new Checker(future);
        NoStackTraceThrowable failure = (NoStackTraceThrowable)checker.assertFailed();
        this.assertNull(failure.getMessage());
    }

    @Test
    public void testAllSucceeded() {
        this.testAllSucceeded(CompositeFuture::all);
    }

    @Test
    public void testAllSucceededWithList() {
        this.testAllSucceeded((f1, f2) -> CompositeFuture.all(Arrays.asList(f1, f2)));
    }

    private void testAllSucceeded(BiFunction<Future<String>, Future<Integer>, CompositeFuture> all) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = all.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        this.assertEquals(null, composite.result(0));
        this.assertEquals(null, composite.result(1));
        f1.complete((Object)"something");
        checker.assertNotCompleted();
        this.assertEquals("something", composite.result(0));
        this.assertEquals(null, composite.result(1));
        f2.complete((Object)3);
        checker.assertSucceeded(composite);
        this.assertEquals("something", composite.result(0));
        this.assertEquals(3L, ((Integer)composite.result(1)).intValue());
    }

    @Test
    public void testAllWithEmptyList() {
        CompositeFuture composite = CompositeFuture.all(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testAllFailed() {
        this.testAllFailed(CompositeFuture::all);
    }

    @Test
    public void testAllFailedWithList() {
        this.testAllFailed((f1, f2) -> CompositeFuture.all(Arrays.asList(f1, f2)));
    }

    private void testAllFailed(BiFunction<Future<String>, Future<Integer>, CompositeFuture> all) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = all.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        f1.complete((Object)"s");
        Exception cause = new Exception();
        f2.fail((Throwable)cause);
        checker.assertFailed(cause);
        this.assertEquals("s", composite.result(0));
        this.assertEquals(null, composite.result(1));
    }

    @Test
    public void testAllLargeList() {
        this.testAllLargeList(63);
        this.testAllLargeList(64);
        this.testAllLargeList(65);
        this.testAllLargeList(100);
    }

    private void testAllLargeList(int size) {
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < size; ++i) {
            list.add(Future.succeededFuture());
        }
        CompositeFuture composite = CompositeFuture.all(list);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertSucceeded(composite);
        for (int i = 0; i < size; ++i) {
            int j;
            list.clear();
            Exception cause = new Exception();
            for (j = 0; j < size; ++j) {
                list.add(i == j ? Future.failedFuture((Throwable)cause) : Future.succeededFuture());
            }
            composite = CompositeFuture.all(list);
            checker = new Checker(composite);
            checker.assertFailed(cause);
            for (j = 0; j < size; ++j) {
                if (i == j) {
                    this.assertTrue(composite.failed(j));
                    continue;
                }
                this.assertTrue(composite.succeeded(j));
            }
        }
    }

    @Test
    public void testAnySucceeded1() {
        this.testAnySucceeded1(CompositeFuture::any);
    }

    @Test
    public void testAnySucceeded1WithList() {
        this.testAnySucceeded1((f1, f2) -> CompositeFuture.any(Arrays.asList(f1, f2)));
    }

    private void testAnySucceeded1(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        this.assertEquals(null, composite.result(0));
        this.assertEquals(null, composite.result(1));
        f1.complete((Object)"something");
        checker.assertSucceeded(composite);
        f2.complete((Object)3);
        checker.assertSucceeded(composite);
    }

    @Test
    public void testAnyWithEmptyList() {
        CompositeFuture composite = CompositeFuture.any(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testAnySucceeded2() {
        this.testAnySucceeded2(CompositeFuture::any);
    }

    @Test
    public void testAnySucceeded2WithList() {
        this.testAnySucceeded2(CompositeFuture::any);
    }

    private void testAnySucceeded2(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        f1.fail("failure");
        checker.assertNotCompleted();
        f2.complete((Object)3);
        checker.assertSucceeded(composite);
    }

    @Test
    public void testAnyFailed() {
        this.testAnyFailed(CompositeFuture::any);
    }

    @Test
    public void testAnyFailedWithList() {
        this.testAnyFailed((f1, f2) -> CompositeFuture.any(Arrays.asList(f1, f2)));
    }

    private void testAnyFailed(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        f1.fail("failure");
        checker.assertNotCompleted();
        Exception cause = new Exception();
        f2.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testAnyLargeList() {
        this.testAnyLargeList(63);
        this.testAnyLargeList(64);
        this.testAnyLargeList(65);
        this.testAnyLargeList(100);
    }

    private void testAnyLargeList(int size) {
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < size; ++i) {
            list.add(Future.failedFuture((Throwable)new Exception()));
        }
        CompositeFuture composite = CompositeFuture.any(list);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertFailed();
        for (int i = 0; i < size; ++i) {
            int j;
            list.clear();
            for (j = 0; j < size; ++j) {
                list.add(i == j ? Future.succeededFuture() : Future.failedFuture((Throwable)new RuntimeException()));
            }
            composite = CompositeFuture.any(list);
            checker = new Checker(composite);
            checker.assertSucceeded(composite);
            for (j = 0; j < size; ++j) {
                if (i == j) {
                    this.assertTrue(composite.succeeded(j));
                    continue;
                }
                this.assertTrue(composite.failed(j));
            }
        }
    }

    @Test
    public void testCompositeFutureToList() {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = CompositeFuture.all((Future)f1, (Future)f2);
        this.assertEquals(Arrays.asList(null, null), composite.list());
        f1.complete((Object)"foo");
        this.assertEquals(Arrays.asList("foo", null), composite.list());
        f2.complete((Object)4);
        this.assertEquals(Arrays.asList("foo", 4), composite.list());
    }

    @Test
    public void testComposeSucceed() {
        Future f1 = Future.future();
        Future f2 = Future.future();
        Checker<Integer> checker = new Checker<Integer>(f2);
        f1.compose(string -> f2.complete((Object)string.length()), f2);
        f1.complete((Object)"abcdef");
        checker.assertSucceeded(6);
        Future f3 = Future.future();
        Future f4 = f3.compose(string -> Future.succeededFuture((Object)string.length()));
        checker = new Checker(f4);
        f3.complete((Object)"abcdef");
        checker.assertSucceeded(6);
    }

    @Test
    public void testComposeFail() {
        Exception cause = new Exception();
        Future f1 = Future.future();
        Future f2 = Future.future();
        Checker checker = new Checker(f2);
        f1.compose(string -> f2.complete((Object)string.length()), f2);
        f1.fail((Throwable)cause);
        checker.assertFailed(cause);
        Future f3 = Future.future();
        Future f4 = f3.compose(string -> Future.succeededFuture((Object)string.length()));
        checker = new Checker(f4);
        f3.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeHandlerFail() {
        RuntimeException cause = new RuntimeException();
        Future f1 = Future.future();
        Future f2 = Future.future();
        Checker checker = new Checker(f2);
        f1.compose(string -> {
            throw cause;
        }, f2);
        f1.complete((Object)"foo");
        checker.assertFailed(cause);
        Future f3 = Future.future();
        Future f4 = f3.compose(string -> {
            throw cause;
        });
        checker = new Checker(f4);
        f3.complete((Object)"foo");
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeHandlerFailAfterCompletion() {
        Future f1 = Future.future();
        Future f2 = Future.future();
        Checker<Integer> checker = new Checker<Integer>(f2);
        RuntimeException cause = new RuntimeException();
        f1.compose(string -> {
            f2.complete((Object)46);
            throw cause;
        }, f2);
        try {
            f1.complete((Object)"foo");
            this.fail();
        }
        catch (Exception e) {
            this.assertEquals(cause, e);
        }
        checker.assertSucceeded(46);
    }

    @Test
    public void testMapSucceeded() {
        Future fut = Future.future();
        Future mapped = fut.map(Object::toString);
        Checker<String> checker = new Checker<String>(mapped);
        fut.complete((Object)3);
        checker.assertSucceeded("3");
    }

    @Test
    public void testMapFailed() {
        Throwable cause = new Throwable();
        Future fut = Future.future();
        Future mapped = fut.map(Object::toString);
        Checker checker = new Checker(mapped);
        fut.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapperFailure() {
        RuntimeException cause = new RuntimeException();
        Future fut = Future.future();
        Future mapped = fut.map(i -> {
            throw cause;
        });
        Checker checker = new Checker(mapped);
        fut.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testDefaultCompleter() {
        AsyncResult<Object> succeededAsyncResult = new AsyncResult<Object>(){
            Object result = new Object();

            public Object result() {
                return this.result;
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                return true;
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }
        };
        AsyncResult<Object> failedAsyncResult = new AsyncResult<Object>(){
            Throwable cause = new Throwable();

            public Object result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                return this.cause;
            }

            public boolean succeeded() {
                return false;
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }
        };
        class DefaultCompleterTestFuture<T>
        implements Future<T> {
            boolean succeeded;
            boolean failed;
            T result;
            Throwable cause;

            DefaultCompleterTestFuture() {
            }

            public boolean isComplete() {
                throw new UnsupportedOperationException();
            }

            public Future<T> setHandler(Handler<AsyncResult<T>> handler) {
                throw new UnsupportedOperationException();
            }

            public void complete(T result) {
                this.succeeded = true;
                this.result = result;
            }

            public void complete() {
                throw new UnsupportedOperationException();
            }

            public void fail(Throwable throwable) {
                this.failed = true;
                this.cause = throwable;
            }

            public void fail(String failureMessage) {
                throw new UnsupportedOperationException();
            }

            public T result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                throw new UnsupportedOperationException();
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }
        }
        DefaultCompleterTestFuture successFuture = new DefaultCompleterTestFuture();
        successFuture.completer().handle((Object)succeededAsyncResult);
        this.assertTrue(successFuture.succeeded);
        this.assertEquals(succeededAsyncResult.result(), successFuture.result);
        DefaultCompleterTestFuture failureFuture = new DefaultCompleterTestFuture();
        failureFuture.completer().handle((Object)failedAsyncResult);
        this.assertTrue(failureFuture.failed);
        this.assertEquals(failedAsyncResult.cause(), failureFuture.cause);
    }

    class Checker<T> {
        private final Future<T> future;
        private final AtomicReference<AsyncResult<T>> result = new AtomicReference();
        private final AtomicInteger count = new AtomicInteger();

        Checker(Future<T> future) {
            future.setHandler(ar -> {
                this.count.incrementAndGet();
                this.result.set((AsyncResult<T>)ar);
            });
            this.future = future;
        }

        void assertNotCompleted() {
            FutureTest.this.assertFalse(this.future.isComplete());
            FutureTest.this.assertFalse(this.future.succeeded());
            FutureTest.this.assertFalse(this.future.failed());
            FutureTest.this.assertNull(this.future.cause());
            FutureTest.this.assertNull(this.future.result());
            FutureTest.this.assertEquals(0L, this.count.get());
            FutureTest.this.assertNull(this.result.get());
        }

        void assertSucceeded(T expected) {
            FutureTest.this.assertTrue(this.future.isComplete());
            FutureTest.this.assertTrue(this.future.succeeded());
            FutureTest.this.assertFalse(this.future.failed());
            FutureTest.this.assertNull(this.future.cause());
            FutureTest.this.assertEquals(expected, this.future.result());
            FutureTest.this.assertEquals(1L, this.count.get());
            AsyncResult<T> ar = this.result.get();
            FutureTest.this.assertNotNull(ar);
            FutureTest.this.assertTrue(ar.succeeded());
            FutureTest.this.assertFalse(ar.failed());
            FutureTest.this.assertNull(ar.cause());
            FutureTest.this.assertEquals(expected, this.future.result());
        }

        void assertFailed(Throwable expected) {
            FutureTest.this.assertEquals(expected, this.assertFailed());
        }

        Throwable assertFailed() {
            FutureTest.this.assertTrue(this.future.isComplete());
            FutureTest.this.assertFalse(this.future.succeeded());
            FutureTest.this.assertTrue(this.future.failed());
            FutureTest.this.assertEquals(null, this.future.result());
            FutureTest.this.assertEquals(1L, this.count.get());
            AsyncResult<T> ar = this.result.get();
            FutureTest.this.assertNotNull(ar);
            FutureTest.this.assertFalse(ar.succeeded());
            FutureTest.this.assertTrue(ar.failed());
            FutureTest.this.assertNull(ar.result());
            return this.future.cause();
        }
    }
}

