/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServer;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakedns.FakeDNSServer;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class HostnameResolutionTest
extends VertxTestBase {
    private FakeDNSServer dnsServer;
    private InetSocketAddress dnsServerAddress;

    @Override
    public void setUp() throws Exception {
        this.dnsServer = FakeDNSServer.testResolveASameServer("127.0.0.1");
        this.dnsServer.start();
        this.dnsServerAddress = (InetSocketAddress)this.dnsServer.getTransports()[0].getAcceptor().getLocalAddress();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.dnsServer.isStarted()) {
            this.dnsServer.stop();
        }
        super.tearDown();
    }

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort());
        options.getAddressResolverOptions().setOptResourceEnabled(false);
        return options;
    }

    @Test
    public void testAsyncResolve() throws Exception {
        ((VertxImpl)this.vertx).resolveAddress("vertx.io", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.1", resolved.getHostAddress());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testAsyncResolveFail() throws Exception {
        ((VertxImpl)this.vertx).resolveAddress("vertx.com", this.onFailure(failure -> {
            this.assertEquals(UnknownHostException.class, failure.getClass());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNet() throws Exception {
        this.testNet("vertx.io");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNet(String hostname) throws Exception {
        NetClient client = this.vertx.createNetClient();
        NetServer server = this.vertx.createNetServer().connectHandler(so -> so.handler(buff -> {
            so.write(buff);
            so.close();
        }));
        try {
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(1234, hostname, this.onSuccess(s -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            client.connect(1234, hostname, this.onSuccess(so -> {
                Buffer buffer = Buffer.buffer();
                so.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
                so.closeHandler(v -> {
                    this.assertEquals(Buffer.buffer((String)"foo"), buffer);
                    this.testComplete();
                });
                so.write(Buffer.buffer((String)"foo"));
            }));
            this.await();
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp() throws Exception {
        HttpClient client = this.vertx.createHttpClient();
        HttpServer server = this.vertx.createHttpServer().requestHandler(req -> req.response().end("foo"));
        try {
            CountDownLatch listenLatch = new CountDownLatch(1);
            server.listen(8080, "vertx.io", this.onSuccess(s -> listenLatch.countDown()));
            this.awaitLatch(listenLatch);
            client.getNow(8080, "vertx.io", "/somepath", resp -> {
                Buffer buffer = Buffer.buffer();
                resp.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
                resp.endHandler(v -> {
                    this.assertEquals(Buffer.buffer((String)"foo"), buffer);
                    this.testComplete();
                });
            });
            this.await();
        }
        finally {
            client.close();
            server.close();
        }
    }

    @Test
    public void testOptions() {
        AddressResolverOptions options = new AddressResolverOptions();
        this.assertEquals(true, options.isOptResourceEnabled());
        this.assertEquals(AddressResolverOptions.DEFAULT_SERVERS, options.getServers());
        this.assertEquals(0L, options.getCacheMinTimeToLive());
        this.assertEquals(Integer.MAX_VALUE, options.getCacheMaxTimeToLive());
        this.assertEquals(0L, options.getCacheNegativeTimeToLive());
        this.assertEquals(5000L, options.getQueryTimeout());
        this.assertEquals(3L, options.getMaxQueries());
        this.assertEquals(true, options.getRdFlag());
        this.assertEquals(1L, options.getNdots());
        this.assertEquals(AddressResolverOptions.DEFAULT_SEACH_DOMAINS, options.getSearchDomains());
        boolean optResourceEnabled = TestUtils.randomBoolean();
        List<String> servers = Arrays.asList("1.2.3.4", "5.6.7.8");
        int minTTL = TestUtils.randomPositiveInt();
        int maxTTL = minTTL + 1000;
        int negativeTTL = TestUtils.randomPositiveInt();
        int queryTimeout = 1 + TestUtils.randomPositiveInt();
        int maxQueries = 1 + TestUtils.randomPositiveInt();
        boolean rdFlag = TestUtils.randomBoolean();
        int ndots = TestUtils.randomPositiveInt();
        ArrayList<String> searchDomains = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            searchDomains.add(TestUtils.randomAlphaString(15));
        }
        this.assertSame(options, options.setOptResourceEnabled(optResourceEnabled));
        this.assertSame(options, options.setServers(new ArrayList<String>(servers)));
        this.assertSame(options, options.setCacheMinTimeToLive(0));
        this.assertSame(options, options.setCacheMinTimeToLive(minTTL));
        try {
            options.setCacheMinTimeToLive(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setCacheMaxTimeToLive(0));
        this.assertSame(options, options.setCacheMaxTimeToLive(maxTTL));
        try {
            options.setCacheMaxTimeToLive(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setCacheNegativeTimeToLive(0));
        this.assertSame(options, options.setCacheNegativeTimeToLive(negativeTTL));
        try {
            options.setCacheNegativeTimeToLive(-1);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setQueryTimeout((long)queryTimeout));
        try {
            options.setQueryTimeout(0L);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setMaxQueries(maxQueries));
        try {
            options.setMaxQueries(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertSame(options, options.setRdFlag(rdFlag));
        this.assertSame(options, options.setSearchDomains(searchDomains));
        this.assertSame(options, options.setNdots(ndots));
        try {
            options.setNdots(0);
            this.fail("Should throw exception");
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        this.assertEquals(optResourceEnabled, options.isOptResourceEnabled());
        this.assertEquals(servers, options.getServers());
        this.assertEquals(minTTL, options.getCacheMinTimeToLive());
        this.assertEquals(maxTTL, options.getCacheMaxTimeToLive());
        this.assertEquals(negativeTTL, options.getCacheNegativeTimeToLive());
        this.assertEquals(queryTimeout, options.getQueryTimeout());
        this.assertEquals(maxQueries, options.getMaxQueries());
        this.assertEquals(rdFlag, options.getRdFlag());
        this.assertEquals(ndots, options.getNdots());
        this.assertEquals(searchDomains, options.getSearchDomains());
        AddressResolverOptions copy = new AddressResolverOptions(options);
        AddressResolverOptions jsonCopy = new AddressResolverOptions(options.toJson());
        options.setOptResourceEnabled(true);
        options.getServers().clear();
        options.setCacheMinTimeToLive(0);
        options.setCacheMaxTimeToLive(Integer.MAX_VALUE);
        options.setCacheNegativeTimeToLive(0);
        options.setQueryTimeout(5000L);
        options.setMaxQueries(3);
        options.setRdFlag(true);
        options.setNdots(1);
        options.setSearchDomains(AddressResolverOptions.DEFAULT_SEACH_DOMAINS);
        this.assertEquals(optResourceEnabled, copy.isOptResourceEnabled());
        this.assertEquals(servers, copy.getServers());
        this.assertEquals(minTTL, copy.getCacheMinTimeToLive());
        this.assertEquals(maxTTL, copy.getCacheMaxTimeToLive());
        this.assertEquals(negativeTTL, copy.getCacheNegativeTimeToLive());
        this.assertEquals(queryTimeout, copy.getQueryTimeout());
        this.assertEquals(maxQueries, copy.getMaxQueries());
        this.assertEquals(rdFlag, copy.getRdFlag());
        this.assertEquals(ndots, copy.getNdots());
        this.assertEquals(searchDomains, copy.getSearchDomains());
        this.assertEquals(optResourceEnabled, jsonCopy.isOptResourceEnabled());
        this.assertEquals(servers, jsonCopy.getServers());
        this.assertEquals(minTTL, jsonCopy.getCacheMinTimeToLive());
        this.assertEquals(maxTTL, jsonCopy.getCacheMaxTimeToLive());
        this.assertEquals(negativeTTL, jsonCopy.getCacheNegativeTimeToLive());
        this.assertEquals(queryTimeout, jsonCopy.getQueryTimeout());
        this.assertEquals(maxQueries, jsonCopy.getMaxQueries());
        this.assertEquals(rdFlag, jsonCopy.getRdFlag());
        this.assertEquals(ndots, jsonCopy.getNdots());
        this.assertEquals(searchDomains, jsonCopy.getSearchDomains());
    }

    @Test
    public void testDefaultJsonOptions() {
        AddressResolverOptions options = new AddressResolverOptions(new JsonObject());
        this.assertEquals(true, options.isOptResourceEnabled());
        this.assertEquals(AddressResolverOptions.DEFAULT_SERVERS, options.getServers());
        this.assertEquals(0L, options.getCacheMinTimeToLive());
        this.assertEquals(Integer.MAX_VALUE, options.getCacheMaxTimeToLive());
        this.assertEquals(0L, options.getCacheNegativeTimeToLive());
        this.assertEquals(5000L, options.getQueryTimeout());
        this.assertEquals(3L, options.getMaxQueries());
        this.assertEquals(true, options.getRdFlag());
        this.assertEquals(AddressResolverOptions.DEFAULT_SEACH_DOMAINS, options.getSearchDomains());
        this.assertEquals(1L, options.getNdots());
    }

    @Test
    public void testAsyncResolveConnectIsNotifiedOnChannelEventLoop() throws Exception {
        CountDownLatch listenLatch = new CountDownLatch(1);
        NetServer s = this.vertx.createNetServer().connectHandler(so -> {});
        s.listen(1234, "localhost", this.onSuccess(v -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        final AtomicReference channelThread = new AtomicReference();
        final CountDownLatch connectLatch = new CountDownLatch(1);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.group(this.vertx.nettyEventLoopGroup());
        bootstrap.resolver(((VertxInternal)this.vertx).addressResolver().nettyAddressResolverGroup());
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                channelThread.set(Thread.currentThread());
                connectLatch.countDown();
            }
        });
        ChannelFuture channelFut = bootstrap.connect("localhost", 1234);
        this.awaitLatch(connectLatch);
        channelFut.addListener(v -> {
            this.assertTrue(v.isSuccess());
            this.assertEquals(channelThread.get(), Thread.currentThread());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testInvalidHostsConfig() {
        try {
            AddressResolverOptions options = new AddressResolverOptions().setHostsPath("whatever.txt");
            this.vertx(new VertxOptions().setAddressResolverOptions(options));
            this.fail();
        }
        catch (VertxException vertxException) {
            // empty catch block
        }
    }

    @Test
    public void testResolveFromClasspath() {
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsPath("hosts_config.txt")));
        vertx.resolveAddress("server.net", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testResolveFromFile() {
        File f = new File(new File(new File(new File("src"), "test"), "resources"), "hosts_config.txt");
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsPath(f.getAbsolutePath())));
        vertx.resolveAddress("server.net", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testResolveFromBuffer() {
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsValue(Buffer.buffer((String)"192.168.0.15 server.net"))));
        vertx.resolveAddress("server.net", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCaseInsensitiveResolveFromHosts() {
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsPath("hosts_config.txt")));
        vertx.resolveAddress("SERVER.NET", this.onSuccess(addr -> {
            this.assertEquals("192.168.0.15", addr.getHostAddress());
            this.assertEquals("server.net", addr.getHostName());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testResolveMissingLocalhost() throws Exception {
        InetAddress localhost = InetAddress.getByName("localhost");
        this.dnsServer.stop();
        this.dnsServer = FakeDNSServer.testResolveASameServer("127.0.0.1");
        this.dnsServer.start();
        this.dnsServerAddress = (InetSocketAddress)this.dnsServer.getTransports()[0].getAcceptor().getLocalAddress();
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().setHostsValue(Buffer.buffer((String)"")).addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false)));
        CompletableFuture test1 = new CompletableFuture();
        vertx.resolveAddress("localhost", ar -> {
            if (ar.succeeded()) {
                InetAddress resolved = (InetAddress)ar.result();
                if (resolved.equals(localhost)) {
                    test1.complete(null);
                } else {
                    test1.completeExceptionally((Throwable)((Object)new AssertionError((Object)("Unexpected localhost value " + resolved))));
                }
            } else {
                test1.completeExceptionally(ar.cause());
            }
        });
        test1.get(10L, TimeUnit.SECONDS);
        CompletableFuture test2 = new CompletableFuture();
        vertx.resolveAddress("LOCALHOST", ar -> {
            if (ar.succeeded()) {
                InetAddress resolved = (InetAddress)ar.result();
                if (resolved.equals(localhost)) {
                    test2.complete(null);
                } else {
                    test2.completeExceptionally((Throwable)((Object)new AssertionError((Object)("Unexpected localhost value " + resolved))));
                }
            } else {
                test2.completeExceptionally(ar.cause());
            }
        });
        test2.get(10L, TimeUnit.SECONDS);
        CompletableFuture test3 = new CompletableFuture();
        NetServer server = vertx.createNetServer(new NetServerOptions().setPort(1234).setHost(localhost.getHostAddress()));
        server.connectHandler(so -> so.write("hello").end());
        server.listen(ar -> {
            if (ar.succeeded()) {
                test3.complete(null);
            } else {
                test3.completeExceptionally(ar.cause());
            }
        });
        test3.get(10L, TimeUnit.SECONDS);
        CompletableFuture test4 = new CompletableFuture();
        NetClient client = vertx.createNetClient();
        client.connect(1234, "localhost", ar -> {
            if (ar.succeeded()) {
                test4.complete(null);
            } else {
                test4.completeExceptionally(ar.cause());
            }
        });
        test4.get(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testSearchDomain() throws Exception {
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1.foo.com", "127.0.0.1");
        records.put("host1", "127.0.0.2");
        records.put("host3", "127.0.0.3");
        records.put("host4.sub.foo.com", "127.0.0.4");
        records.put("host5.sub.foo.com", "127.0.0.5");
        records.put("host5.sub", "127.0.0.6");
        this.dnsServer.stop();
        this.dnsServer = FakeDNSServer.testResolveA(records);
        this.dnsServer.start();
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).addSearchDomain("foo.com")));
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx.resolveAddress("host1", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.1", resolved.getHostAddress());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx.resolveAddress("host1.", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.2", resolved.getHostAddress());
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
        CountDownLatch latch3 = new CountDownLatch(1);
        vertx.resolveAddress("host2", this.onFailure(cause -> {
            this.assertTrue(cause instanceof UnknownHostException);
            latch3.countDown();
        }));
        this.awaitLatch(latch3);
        CountDownLatch latch4 = new CountDownLatch(1);
        vertx.resolveAddress("host3", this.onFailure(cause -> {
            this.assertTrue(cause instanceof UnknownHostException);
            latch4.countDown();
        }));
        this.awaitLatch(latch4);
        CountDownLatch latch5 = new CountDownLatch(1);
        vertx.resolveAddress("host3.", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.3", resolved.getHostAddress());
            latch5.countDown();
        }));
        this.awaitLatch(latch5);
        CountDownLatch latch6 = new CountDownLatch(1);
        vertx.resolveAddress("host4.sub", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.4", resolved.getHostAddress());
            latch6.countDown();
        }));
        this.awaitLatch(latch6);
        CountDownLatch latch7 = new CountDownLatch(1);
        vertx.resolveAddress("host5.sub", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.6", resolved.getHostAddress());
            latch7.countDown();
        }));
        this.awaitLatch(latch7);
    }

    @Test
    public void testMultipleSearchDomain() throws Exception {
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1.foo.com", "127.0.0.1");
        records.put("host2.bar.com", "127.0.0.2");
        records.put("host3.bar.com", "127.0.0.3");
        records.put("host3.foo.com", "127.0.0.4");
        this.dnsServer.stop();
        this.dnsServer = FakeDNSServer.testResolveA(records);
        this.dnsServer.start();
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).addSearchDomain("foo.com").addSearchDomain("bar.com")));
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx.resolveAddress("host1", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.1", resolved.getHostAddress());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx.resolveAddress("host2", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.2", resolved.getHostAddress());
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
        CountDownLatch latch3 = new CountDownLatch(1);
        vertx.resolveAddress("host3", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.4", resolved.getHostAddress());
            latch3.countDown();
        }));
        this.awaitLatch(latch3);
        vertx.resolveAddress("host4", this.onFailure(cause -> {
            this.assertTrue(cause instanceof UnknownHostException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSearchDomainWithNdots2() throws Exception {
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1.sub.foo.com", "127.0.0.1");
        records.put("host2.sub.foo.com", "127.0.0.2");
        records.put("host2.sub", "127.0.0.3");
        this.dnsServer.stop();
        this.dnsServer = FakeDNSServer.testResolveA(records);
        this.dnsServer.start();
        VertxInternal vertx = (VertxInternal)this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).addSearchDomain("foo.com").setNdots(2)));
        CountDownLatch latch1 = new CountDownLatch(1);
        vertx.resolveAddress("host1.sub", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.1", resolved.getHostAddress());
            latch1.countDown();
        }));
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        vertx.resolveAddress("host2.sub", this.onSuccess(resolved -> {
            this.assertEquals("127.0.0.2", resolved.getHostAddress());
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
    }

    @Test
    public void testNetSearchDomain() throws Exception {
        HashMap<String, String> records = new HashMap<String, String>();
        records.put("host1.foo.com", "127.0.0.1");
        this.dnsServer.stop();
        this.dnsServer = FakeDNSServer.testResolveA(records);
        this.dnsServer.start();
        this.vertx = this.vertx(new VertxOptions().setAddressResolverOptions(new AddressResolverOptions().addServer(this.dnsServerAddress.getAddress().getHostAddress() + ":" + this.dnsServerAddress.getPort()).setOptResourceEnabled(false).addSearchDomain("foo.com")));
        this.testNet("host1");
    }
}

