/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.test.core.Http2TestBase;
import io.vertx.test.core.HttpTest;
import io.vertx.test.core.TLSCert;
import io.vertx.test.core.TestUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class Http2Test
extends HttpTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setHandle100ContinueAutomatically(true));
    }

    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return Http2TestBase.createHttp2ServerOptions(8080, "localhost");
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return Http2TestBase.createHttp2ClientOptions();
    }

    @Test
    public void testServerResponseWriteBufferFromOtherThread() throws Exception {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().write("hello ").end("world"))).listen(this.onSuccess(v -> this.client.get(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)"hello world"), buff);
                this.testComplete();
            });
        }).exceptionHandler(this::fail).end()));
        this.await();
    }

    @Test
    public void testServerResponseResetFromOtherThread() throws Exception {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().reset(0L))).listen(this.onSuccess(v -> this.client.get(8080, "localhost", "/somepath", resp -> this.fail()).exceptionHandler(err -> {
            this.assertTrue(err instanceof StreamResetException);
            this.testComplete();
        }).sendHead()));
        this.await();
    }

    void runAsync(Runnable runnable) {
        new Thread(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.fail(e);
            }
        }).start();
    }

    @Test
    public void testClientRequestWriteFromOtherThread() throws Exception {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            latch2.countDown();
            req.endHandler(v -> req.response().end());
        }).listen(this.onSuccess(v -> latch1.countDown()));
        this.awaitLatch(latch1);
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setChunked(true).sendHead();
        this.awaitLatch(latch2);
        req2.write("hello ").end("world");
        this.await();
    }

    @Test
    public void testServerOpenSSL() throws Exception {
        HttpServerOptions opts = new HttpServerOptions().setPort(4043).setHost("localhost").setUseAlpn(true).setSsl(true).addEnabledCipherSuite("TLS_RSA_WITH_AES_128_CBC_SHA").setPemKeyCertOptions((PemKeyCertOptions)TLSCert.PEM.getServerKeyCertOptions()).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
        this.server.close();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.server = this.vertx.createHttpServer(opts);
        this.server.requestHandler(req -> req.response().end());
        CountDownLatch latch = new CountDownLatch(1);
        System.out.println("starting");
        try {
            this.server.listen(this.onSuccess(v -> latch.countDown()));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.out.println("listening");
        this.awaitLatch(latch);
        this.client.get(4043, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).exceptionHandler(this::fail).end();
        this.await();
    }

    @Test
    public void testServerStreamPausedWhenConnectionIsPaused() throws Exception {
        CountDownLatch fullLatch = new CountDownLatch(1);
        CompletableFuture resumeLatch = new CompletableFuture();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            switch (req.path()) {
                case "/0": {
                    this.vertx.setPeriodic(1L, timerID -> {
                        if (resp.writeQueueFull()) {
                            this.vertx.cancelTimer(timerID.longValue());
                            fullLatch.countDown();
                        } else {
                            resp.write(Buffer.buffer((String)TestUtils.randomAlphaString(512)));
                        }
                    });
                    break;
                }
                case "/1": {
                    this.assertTrue(resp.writeQueueFull());
                    resp.drainHandler(v -> resp.end());
                    resumeLatch.complete(null);
                }
            }
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "/0", resp -> {
            resp.pause();
            Context ctx = this.vertx.getOrCreateContext();
            resumeLatch.thenAccept(v1 -> ctx.runOnContext(v2 -> {
                resp.endHandler(v -> this.testComplete());
                resp.resume();
            }));
        });
        this.awaitLatch(fullLatch);
        this.client.getNow(8080, "localhost", "/1", resp -> resp.endHandler(v -> this.complete()));
        resumeLatch.get(20L, TimeUnit.SECONDS);
        this.await();
    }

    @Test
    public void testClientStreamPausedWhenConnectionIsPaused() throws Exception {
        this.waitFor(2);
        Buffer buffer = TestUtils.randomBuffer(512);
        CompletableFuture resumeLatch = new CompletableFuture();
        this.server.requestHandler(req -> {
            switch (req.path()) {
                case "/0": {
                    req.pause();
                    resumeLatch.thenAccept(v -> req.resume());
                    req.endHandler(v -> req.response().end());
                    break;
                }
                case "/1": {
                    req.bodyHandler(v -> {
                        this.assertEquals(v, buffer);
                        req.response().end();
                    });
                }
            }
        });
        this.startServer();
        HttpClientRequest req1 = this.client.get(8080, "localhost", "/0", resp -> this.complete()).setChunked(true);
        while (!req1.writeQueueFull()) {
            req1.write(Buffer.buffer((String)TestUtils.randomAlphaString(512)));
            Thread.sleep(1L);
        }
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/1", resp -> this.complete()).setChunked(true);
        this.assertFalse(req2.writeQueueFull());
        req2.sendHead(v -> {
            this.assertTrue(req2.writeQueueFull());
            resumeLatch.complete(null);
        });
        resumeLatch.get(20L, TimeUnit.SECONDS);
        this.waitUntil(() -> !req2.writeQueueFull());
        req1.end();
        req2.end(buffer);
        this.await();
    }
}

