/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JksOptions;
import io.vertx.test.core.HttpTestBase;
import io.vertx.test.core.TLSCert;

public class Http2TestBase
extends HttpTestBase {
    protected HttpServerOptions serverOptions;
    protected HttpClientOptions clientOptions;

    static HttpServerOptions createHttp2ServerOptions(int port, String host) {
        return new HttpServerOptions().setPort(port).setHost(host).setUseAlpn(true).setSsl(true).addEnabledCipherSuite("TLS_RSA_WITH_AES_128_CBC_SHA").setKeyStoreOptions((JksOptions)TLSCert.JKS.getServerKeyCertOptions());
    }

    static HttpClientOptions createHttp2ClientOptions() {
        return new HttpClientOptions().setUseAlpn(true).setTrustStoreOptions((JksOptions)TLSCert.JKS.getClientTrustOptions()).setProtocolVersion(HttpVersion.HTTP_2);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.serverOptions = Http2TestBase.createHttp2ServerOptions(4043, "localhost");
        this.clientOptions = Http2TestBase.createHttp2ClientOptions();
        this.server = this.vertx.createHttpServer(this.serverOptions);
    }

    protected void assertOnIOContext(Context context) {
        Context current = Vertx.currentContext();
        this.assertNotNull(current);
        this.assertEquals(context, current);
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            if (!elt.getMethodName().equals("executeFromIO")) continue;
            return;
        }
        this.fail("Not from IO");
    }
}

