/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Context;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.metrics.Measured;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.test.core.HttpTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.FakeMetricsFactory;
import io.vertx.test.fakemetrics.HttpClientMetric;
import io.vertx.test.fakemetrics.HttpServerMetric;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class HttpMetricsTest
extends HttpTestBase {
    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.setMetricsOptions(new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new FakeMetricsFactory()));
        return options;
    }

    @Test
    public void testHttp1MetricsLifecycle() throws Exception {
        this.testHttpMetricsLifecycle(HttpVersion.HTTP_1_1);
    }

    @Test
    public void testHttp2MetricsLifecycle() throws Exception {
        this.testHttpMetricsLifecycle(HttpVersion.HTTP_2);
    }

    private void testHttpMetricsLifecycle(HttpVersion protocol) throws Exception {
        this.waitFor(2);
        int numBuffers = 10;
        int contentLength = numBuffers * 1000;
        AtomicReference serverMetric = new AtomicReference();
        this.server.requestHandler(req -> {
            this.assertEquals(protocol, req.version());
            FakeHttpServerMetrics serverMetrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            this.assertNotNull(serverMetrics);
            serverMetric.set(serverMetrics.getMetric((HttpServerRequest)req));
            this.assertNotNull(serverMetric.get());
            this.assertNotNull(((HttpServerMetric)serverMetric.get()).socket);
            this.assertTrue(((HttpServerMetric)serverMetric.get()).socket.connected.get());
            req.bodyHandler(buff -> {
                this.assertEquals(contentLength, buff.length());
                HttpServerResponse resp = req.response().putHeader("Content-Length", "" + contentLength);
                AtomicInteger numBuffer = new AtomicInteger(numBuffers);
                this.vertx.setPeriodic(1L, timerID -> {
                    if (numBuffer.getAndDecrement() == 0) {
                        resp.end();
                        this.assertNull(serverMetrics.getMetric((HttpServerRequest)req));
                        this.vertx.cancelTimer(timerID.longValue());
                    } else {
                        resp.write(TestUtils.randomBuffer(1000));
                    }
                });
            });
        });
        this.startServer();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference clientMetric = new AtomicReference();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(protocol));
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v -> {
            HttpClientRequest req = this.client.get(8080, "localhost", "/somepath").exceptionHandler(this::fail);
            this.assertNull(metrics.getMetric(req));
            req.setChunked(true).handler(resp -> {
                clientMetric.set(metrics.getMetric(req));
                this.assertNotNull(clientMetric.get());
                this.assertNotNull(((HttpClientMetric)clientMetric.get()).socket);
                this.assertTrue(((HttpClientMetric)clientMetric.get()).socket.connected.get());
                resp.bodyHandler(buff -> {
                    this.assertNull(metrics.getMetric(req));
                    this.assertEquals(contentLength, buff.length());
                    latch.countDown();
                });
            });
            for (int i = 0; i < numBuffers; ++i) {
                req.write(TestUtils.randomBuffer(1000));
            }
            req.end();
        });
        this.awaitLatch(latch);
        this.client.close();
        this.waitUntil(() -> !((HttpServerMetric)serverMetric.get()).socket.connected.get());
        this.assertEquals(contentLength, ((HttpServerMetric)serverMetric.get()).socket.bytesRead.get());
        this.assertEquals(contentLength, ((HttpServerMetric)serverMetric.get()).socket.bytesWritten.get());
        this.waitUntil(() -> !((HttpClientMetric)clientMetric.get()).socket.connected.get());
        this.assertEquals(contentLength, ((HttpClientMetric)clientMetric.get()).socket.bytesRead.get());
        this.assertEquals(contentLength, ((HttpClientMetric)clientMetric.get()).socket.bytesWritten.get());
    }

    @Test
    public void testHttp1ClientLifecycle() throws Exception {
        this.testHttpClientLifecycle(HttpVersion.HTTP_1_1);
    }

    @Test
    public void testHttp2ClientLifecycle() throws Exception {
        this.testHttpClientLifecycle(HttpVersion.HTTP_2);
    }

    private void testHttpClientLifecycle(HttpVersion protocol) throws Exception {
        HttpServer server = this.vertx.createHttpServer();
        CountDownLatch requestBeginLatch = new CountDownLatch(1);
        CountDownLatch requestBodyLatch = new CountDownLatch(1);
        CountDownLatch requestEndLatch = new CountDownLatch(1);
        CompletableFuture<Object> beginResponse = new CompletableFuture<Object>();
        CompletableFuture<Object> endResponse = new CompletableFuture<Object>();
        server.requestHandler(req -> {
            this.assertEquals(protocol, req.version());
            requestBeginLatch.countDown();
            req.handler(buff -> requestBodyLatch.countDown());
            req.endHandler(v -> requestEndLatch.countDown());
            Context ctx = this.vertx.getOrCreateContext();
            beginResponse.thenAccept(v1 -> ctx.runOnContext(v2 -> req.response().setChunked(true).write(TestUtils.randomAlphaString(1024))));
            endResponse.thenAccept(v1 -> ctx.runOnContext(v2 -> req.response().end()));
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        server.listen(8080, "localhost", this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(protocol));
        FakeHttpClientMetrics clientMetrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)client);
        CountDownLatch responseBeginLatch = new CountDownLatch(1);
        CountDownLatch responseEndLatch = new CountDownLatch(1);
        HttpClientRequest req2 = client.post(8080, "localhost", "/somepath", resp -> {
            responseBeginLatch.countDown();
            resp.endHandler(v -> responseEndLatch.countDown());
        }).setChunked(true);
        req2.sendHead();
        this.awaitLatch(requestBeginLatch);
        HttpClientMetric reqMetric = clientMetrics.getMetric(req2);
        this.assertEquals(0L, reqMetric.requestEnded.get());
        this.assertEquals(0L, reqMetric.responseBegin.get());
        req2.write(TestUtils.randomAlphaString(1024));
        this.awaitLatch(requestBodyLatch);
        this.assertEquals(0L, reqMetric.requestEnded.get());
        this.assertEquals(0L, reqMetric.responseBegin.get());
        req2.end();
        this.awaitLatch(requestEndLatch);
        this.assertEquals(1L, reqMetric.requestEnded.get());
        this.assertEquals(0L, reqMetric.responseBegin.get());
        beginResponse.complete(null);
        this.awaitLatch(responseBeginLatch);
        this.assertEquals(1L, reqMetric.requestEnded.get());
        this.assertEquals(1L, reqMetric.responseBegin.get());
        endResponse.complete(null);
        this.awaitLatch(responseEndLatch);
        this.assertNull(clientMetrics.getMetric(req2));
        this.assertEquals(1L, reqMetric.requestEnded.get());
        this.assertEquals(1L, reqMetric.responseBegin.get());
    }

    @Test
    public void testHttp1ClientConnectionClosed() throws Exception {
        this.testClientConnectionClosed(HttpVersion.HTTP_1_1);
    }

    @Test
    public void testHttp2ClientConnectionClosed() throws Exception {
        this.testClientConnectionClosed(HttpVersion.HTTP_2);
    }

    private void testClientConnectionClosed(HttpVersion protocol) throws Exception {
        this.server.requestHandler(req -> req.response().setChunked(true).write(Buffer.buffer((String)"some-data")));
        this.startServer();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(protocol).setIdleTimeout(2));
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/somepath");
        req2.handler(resp -> {
            HttpClientMetric metric = metrics.getMetric(req2);
            this.assertNotNull(metric);
            this.assertFalse(metric.failed.get());
            resp.exceptionHandler(err -> {
                this.assertNull(metrics.getMetric(req2));
                this.assertTrue(metric.failed.get());
                this.testComplete();
            });
        });
        req2.end();
        this.await();
    }

    @Test
    public void testHttp1ServerConnectionClosed() throws Exception {
        this.testServerConnectionClosed(HttpVersion.HTTP_1_1);
    }

    @Test
    public void testHttp2ServerConnectionClosed() throws Exception {
        this.testServerConnectionClosed(HttpVersion.HTTP_2);
    }

    private void testServerConnectionClosed(HttpVersion protocol) throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost").setIdleTimeout(2));
        this.server.requestHandler(req -> {
            FakeHttpServerMetrics metrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            HttpServerMetric metric = metrics.getMetric((HttpServerRequest)req);
            this.assertNotNull(metric);
            this.assertFalse(metric.failed.get());
            req.response().closeHandler(v -> {
                this.assertNull(metrics.getMetric((HttpServerRequest)req));
                this.assertTrue(metric.failed.get());
                this.testComplete();
            });
        });
        this.startServer();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(protocol));
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/somepath");
        req2.handler(resp -> {}).end();
        this.await();
    }

    @Test
    public void testPushPromise() throws Exception {
        this.waitFor(2);
        int numBuffers = 10;
        int contentLength = numBuffers * 1000;
        this.server.requestHandler(req -> req.response().push(HttpMethod.GET, "/wibble", ar -> {
            HttpServerResponse pushedResp = (HttpServerResponse)ar.result();
            FakeHttpServerMetrics serverMetrics = (FakeHttpServerMetrics)FakeMetricsBase.getMetrics((Measured)this.server);
            HttpServerMetric serverMetric = serverMetrics.getMetric(pushedResp);
            this.assertNotNull(serverMetric);
            pushedResp.putHeader("content-length", "" + contentLength);
            AtomicInteger numBuffer = new AtomicInteger(numBuffers);
            this.vertx.setPeriodic(1L, timerID -> {
                if (numBuffer.getAndDecrement() == 0) {
                    pushedResp.end();
                    this.assertNull(serverMetrics.getMetric(pushedResp));
                    this.vertx.cancelTimer(timerID.longValue());
                    this.complete();
                } else {
                    pushedResp.write(TestUtils.randomBuffer(1000));
                }
            });
        }));
        this.startServer();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2));
        FakeHttpClientMetrics metrics = (FakeHttpClientMetrics)FakeMetricsBase.getMetrics((Measured)this.client);
        HttpClientRequest req2 = this.client.get(8080, "localhost", "/somepath", resp -> {});
        req2.pushHandler(pushedReq -> {
            HttpClientMetric metric = metrics.getMetric((HttpClientRequest)pushedReq);
            this.assertNotNull(metric);
            this.assertSame(pushedReq, metric.request);
            pushedReq.handler(resp -> resp.endHandler(v -> {
                this.assertNull(metrics.getMetric((HttpClientRequest)pushedReq));
                this.complete();
            }));
        });
        req2.end();
        this.await();
    }
}

