/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequestStream;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.ReadStream;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class HttpRequestStreamTest
extends VertxTestBase {
    private HttpServer server;
    private NetClient netClient;
    private HttpClient client;

    @Override
    protected void tearDown() throws Exception {
        if (this.netClient != null) {
            this.netClient.close();
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.server.close(asyncResult -> {
                this.assertTrue(asyncResult.succeeded());
                latch.countDown();
            });
            this.awaitLatch(latch);
        }
        super.tearDown();
    }

    @Test
    public void testReadStreamPauseResume() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setAcceptBacklog(10).setPort(8080));
        HttpServerRequestStream httpStream = this.server.requestStream();
        AtomicBoolean paused = new AtomicBoolean();
        httpStream.handler(req -> {
            this.assertFalse(paused.get());
            HttpServerResponse response = req.response();
            response.setStatusCode(200).end();
            response.close();
        });
        this.server.listen(arg_0 -> this.lambda$testReadStreamPauseResume$5(paused, (ReadStream)httpStream, path, arg_0));
        this.await();
    }

    @Test
    public void testClosingServerClosesRequestStreamEndHandler() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        HttpServerRequestStream stream = this.server.requestStream();
        AtomicBoolean closed = new AtomicBoolean();
        stream.endHandler(v -> closed.set(true));
        stream.handler(req -> {});
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.assertFalse(closed.get());
            this.server.close(v -> {
                this.assertTrue(ar.succeeded());
                this.assertTrue(closed.get());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testCloseServerAsynchronously() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger done = new AtomicInteger();
        HttpServerRequestStream stream = this.server.requestStream();
        stream.handler(req -> {});
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        stream.endHandler(v -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            if (done.incrementAndGet() == 2) {
                this.testComplete();
            }
        });
        this.server.listen(ar -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            ThreadLocal<Boolean> stack2 = new ThreadLocal<Boolean>();
            stack2.set(true);
            this.server.close(v -> {
                this.assertTrue(Vertx.currentContext().isEventLoopContext());
                this.assertNull(stack2.get());
                if (done.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
            stack2.set(null);
        });
        this.await();
    }

    private /* synthetic */ void lambda$testReadStreamPauseResume$5(AtomicBoolean paused, ReadStream httpStream, String path, AsyncResult listenAR) {
        this.assertTrue(listenAR.succeeded());
        paused.set(true);
        httpStream.pause();
        this.netClient = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(1000));
        this.netClient.connect(8080, "localhost", socketAR -> {
            this.assertTrue(socketAR.succeeded());
            NetSocket socket = (NetSocket)socketAR.result();
            Buffer buffer = Buffer.buffer();
            socket.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
            socket.closeHandler(v -> {
                this.assertEquals(0L, buffer.length());
                paused.set(false);
                httpStream.resume();
                this.client = this.vertx.createHttpClient(new HttpClientOptions());
                this.client.request(HttpMethod.GET, 8080, "localhost", path, resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    this.testComplete();
                }).end();
            });
        });
    }
}

