/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.SharedData;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import org.junit.Test;

public class LocalSharedDataTest
extends VertxTestBase {
    private SharedData sharedData;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sharedData = this.vertx.sharedData();
    }

    @Test
    public void testMap() throws Exception {
        TestUtils.assertNullPointerException(() -> this.sharedData.getLocalMap(null));
        LocalMap map = this.sharedData.getLocalMap("foo");
        LocalMap map2 = this.sharedData.getLocalMap("foo");
        this.assertTrue(map == map2);
        LocalMap map3 = this.sharedData.getLocalMap("bar");
        this.assertFalse(map3 == map2);
        map.close();
        LocalMap map4 = this.sharedData.getLocalMap("foo");
        this.assertFalse(map4 == map3);
    }

    @Test
    public void testMapTypes() throws Exception {
        LocalMap map = this.sharedData.getLocalMap("foo");
        String key = "key";
        double d = new Random().nextDouble();
        map.put((Object)key, (Object)d);
        this.assertEquals((Object)d, map.get((Object)key));
        float f = new Random().nextFloat();
        map.put((Object)key, (Object)Float.valueOf(f));
        this.assertEquals(Float.valueOf(f), map.get((Object)key));
        byte b = (byte)new Random().nextInt();
        map.put((Object)key, (Object)b);
        this.assertEquals((Object)b, map.get((Object)key));
        short s = (short)new Random().nextInt();
        map.put((Object)key, (Object)s);
        this.assertEquals((Object)s, map.get((Object)key));
        int i = new Random().nextInt();
        map.put((Object)key, (Object)i);
        this.assertEquals((Object)i, map.get((Object)key));
        long l = new Random().nextLong();
        map.put((Object)key, (Object)l);
        this.assertEquals((Object)l, map.get((Object)key));
        map.put((Object)key, (Object)true);
        this.assertTrue((Boolean)map.get((Object)key));
        map.put((Object)key, (Object)false);
        this.assertFalse((Boolean)map.get((Object)key));
        char c = (char)new Random().nextLong();
        map.put((Object)key, (Object)Character.valueOf(c));
        this.assertEquals(Character.valueOf(c), map.get((Object)key));
        Buffer buff = TestUtils.randomBuffer(100);
        map.put((Object)key, (Object)buff);
        Buffer got1 = (Buffer)map.get((Object)key);
        this.assertTrue(got1 != buff);
        this.assertEquals(buff, map.get((Object)key));
        Buffer got2 = (Buffer)map.get((Object)key);
        this.assertTrue(got1 != got2);
        this.assertTrue(got2 != buff);
        this.assertEquals(buff, map.get((Object)key));
        byte[] bytes = TestUtils.randomByteArray(100);
        map.put((Object)key, (Object)bytes);
        byte[] bgot1 = (byte[])map.get((Object)key);
        this.assertTrue(bgot1 != bytes);
        this.assertTrue(TestUtils.byteArraysEqual(bytes, bgot1));
        byte[] bgot2 = (byte[])map.get((Object)key);
        this.assertTrue(bgot2 != bytes);
        this.assertTrue(bgot1 != bgot2);
        this.assertTrue(TestUtils.byteArraysEqual(bytes, bgot2));
        TestUtils.assertIllegalArgumentException(() -> map.put((Object)key, (Object)new SomeOtherClass()));
        JsonObject obj = new JsonObject().put("foo", "bar");
        map.put((Object)"obj", (Object)obj);
        JsonObject other = (JsonObject)map.get((Object)"obj");
        this.assertEquals(obj, other);
        this.assertNotSame(obj, other);
        JsonArray arr = new JsonArray().add("foo");
        map.put((Object)"arr", (Object)arr);
        JsonArray otherArr = (JsonArray)map.get((Object)"arr");
        this.assertEquals(arr, otherArr);
        this.assertNotSame(arr, otherArr);
    }

    @Test
    public void testKeys() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        map.put((Object)"foo1", (Object)"val1");
        map.put((Object)"foo2", (Object)"val2");
        map.put((Object)"foo3", (Object)"val3");
        this.assertEquals(3L, map.size());
        Set keys = map.keySet();
        this.assertEquals(3L, keys.size());
        this.assertTrue(keys.contains("foo1"));
        this.assertTrue(keys.contains("foo2"));
        this.assertTrue(keys.contains("foo3"));
    }

    @Test
    public void testKeysCopied() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        JsonObject json1 = new JsonObject().put("foo1", "val1");
        JsonObject json2 = new JsonObject().put("foo2", "val1");
        JsonObject json3 = new JsonObject().put("foo3", "val1");
        map.put((Object)json1, (Object)"val1");
        map.put((Object)json2, (Object)"val2");
        map.put((Object)json3, (Object)"val3");
        this.assertEquals(3L, map.size());
        Set keys = map.keySet();
        this.assertEquals(3L, keys.size());
        this.assertTrue(keys.contains(json1));
        this.assertTrue(keys.contains(json2));
        this.assertTrue(keys.contains(json3));
        this.assertFalse(this.containsExact(keys, json1));
        this.assertFalse(this.containsExact(keys, json2));
        this.assertFalse(this.containsExact(keys, json3));
    }

    private boolean containsExact(Collection<JsonObject> coll, JsonObject obj) {
        for (JsonObject j : coll) {
            if (j != obj) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testValues() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        map.put((Object)"foo1", (Object)"val1");
        map.put((Object)"foo2", (Object)"val2");
        map.put((Object)"foo3", (Object)"val3");
        this.assertEquals(3L, map.size());
        Collection values = map.values();
        this.assertEquals(3L, values.size());
        this.assertTrue(values.contains("val1"));
        this.assertTrue(values.contains("val2"));
        this.assertTrue(values.contains("val3"));
    }

    @Test
    public void testValuesCopied() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        JsonObject json1 = new JsonObject().put("foo1", "val1");
        JsonObject json2 = new JsonObject().put("foo2", "val1");
        JsonObject json3 = new JsonObject().put("foo3", "val1");
        map.put((Object)"key1", (Object)json1);
        map.put((Object)"key2", (Object)json2);
        map.put((Object)"key3", (Object)json3);
        this.assertEquals(3L, map.size());
        Collection values = map.values();
        this.assertEquals(3L, values.size());
        this.assertTrue(values.contains(json1));
        this.assertTrue(values.contains(json2));
        this.assertTrue(values.contains(json3));
        this.assertFalse(this.containsExact(values, json1));
        this.assertFalse(this.containsExact(values, json2));
        this.assertFalse(this.containsExact(values, json3));
    }

    class SomeOtherClass {
        SomeOtherClass() {
        }
    }
}

