/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.util.internal.logging.InternalLoggerFactory;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.NetSocketStream;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.test.core.ConnectHttpProxy;
import io.vertx.test.core.Socks4Proxy;
import io.vertx.test.core.SocksProxy;
import io.vertx.test.core.TestProxyBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.netty.TestLoggerFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NetTest
extends VertxTestBase {
    private static final Logger log = LoggerFactory.getLogger(NetTest.class);
    private NetServer server;
    private NetClient client;
    private TestProxyBase proxy;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createNetClient(new NetClientOptions().setConnectTimeout(1000));
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost"));
    }

    protected void awaitClose(NetServer server) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        server.close(asyncResult -> latch.countDown());
        this.awaitLatch(latch);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            this.awaitClose(this.server);
        }
        if (this.proxy != null) {
            this.proxy.stop();
        }
        super.tearDown();
    }

    @Test
    public void testClientOptions() {
        NetClientOptions options = new NetClientOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        this.assertFalse(options.isUsePooledBuffers());
        this.assertEquals(options, options.setUsePooledBuffers(true));
        this.assertTrue(options.isUsePooledBuffers());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(rand));
        this.assertEquals(rand, options.getIdleTimeout());
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertFalse(options.isTrustAll());
        this.assertEquals(options, options.setTrustAll(true));
        this.assertTrue(options.isTrustAll());
        String randomAlphaString = TestUtils.randomAlphaString(10);
        this.assertTrue(options.getHostnameVerificationAlgorithm().isEmpty());
        this.assertEquals(options, options.setHostnameVerificationAlgorithm(randomAlphaString));
        this.assertEquals(randomAlphaString, options.getHostnameVerificationAlgorithm());
        this.assertEquals(0L, options.getReconnectAttempts());
        TestUtils.assertIllegalArgumentException(() -> options.setReconnectAttempts(-2));
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReconnectAttempts(rand));
        this.assertEquals(rand, options.getReconnectAttempts());
        this.assertEquals(1000L, options.getReconnectInterval());
        TestUtils.assertIllegalArgumentException(() -> options.setReconnectInterval(0L));
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReconnectInterval((long)rand));
        this.assertEquals(rand, options.getReconnectInterval());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(true));
        this.assertEquals(true, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        this.testComplete();
    }

    @Test
    public void testServerOptions() {
        NetServerOptions options = new NetServerOptions();
        this.assertEquals(-1L, options.getSendBufferSize());
        int rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSendBufferSize(rand));
        this.assertEquals(rand, options.getSendBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setSendBufferSize(-123));
        this.assertEquals(-1L, options.getReceiveBufferSize());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setReceiveBufferSize(rand));
        this.assertEquals(rand, options.getReceiveBufferSize());
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(0));
        TestUtils.assertIllegalArgumentException(() -> options.setReceiveBufferSize(-123));
        this.assertTrue(options.isReuseAddress());
        this.assertEquals(options, options.setReuseAddress(false));
        this.assertFalse(options.isReuseAddress());
        this.assertEquals(-1L, options.getTrafficClass());
        rand = 23;
        this.assertEquals(options, options.setTrafficClass(rand));
        this.assertEquals(rand, options.getTrafficClass());
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(-2));
        TestUtils.assertIllegalArgumentException(() -> options.setTrafficClass(256));
        this.assertTrue(options.isTcpNoDelay());
        this.assertEquals(options, options.setTcpNoDelay(false));
        this.assertFalse(options.isTcpNoDelay());
        boolean tcpKeepAlive = false;
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(options, options.setTcpKeepAlive(!tcpKeepAlive));
        this.assertEquals(!tcpKeepAlive, options.isTcpKeepAlive());
        int soLinger = -1;
        this.assertEquals(soLinger, options.getSoLinger());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setSoLinger(rand));
        this.assertEquals(rand, options.getSoLinger());
        TestUtils.assertIllegalArgumentException(() -> options.setSoLinger(-2));
        this.assertFalse(options.isUsePooledBuffers());
        this.assertEquals(options, options.setUsePooledBuffers(true));
        this.assertTrue(options.isUsePooledBuffers());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(0L, options.getIdleTimeout());
        this.assertEquals(options, options.setIdleTimeout(rand));
        this.assertEquals(rand, options.getIdleTimeout());
        TestUtils.assertIllegalArgumentException(() -> options.setIdleTimeout(-1));
        this.assertFalse(options.isSsl());
        this.assertEquals(options, options.setSsl(true));
        this.assertTrue(options.isSsl());
        this.assertNull(options.getKeyCertOptions());
        JksOptions keyStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setKeyStoreOptions(keyStoreOptions));
        this.assertEquals(keyStoreOptions, options.getKeyCertOptions());
        this.assertNull(options.getTrustOptions());
        JksOptions trustStoreOptions = new JksOptions().setPath(TestUtils.randomAlphaString(100)).setPassword(TestUtils.randomAlphaString(100));
        this.assertEquals(options, options.setTrustStoreOptions(trustStoreOptions));
        this.assertEquals(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(-1L, options.getAcceptBacklog());
        rand = TestUtils.randomPositiveInt();
        this.assertEquals(options, options.setAcceptBacklog(rand));
        this.assertEquals(rand, options.getAcceptBacklog());
        this.assertEquals(0L, options.getPort());
        this.assertEquals(options, options.setPort(1234));
        this.assertEquals(1234L, options.getPort());
        TestUtils.assertIllegalArgumentException(() -> options.setPort(-1));
        TestUtils.assertIllegalArgumentException(() -> options.setPort(65536));
        this.assertEquals("0.0.0.0", options.getHost());
        String randString = TestUtils.randomUnicodeString(100);
        this.assertEquals(options, options.setHost(randString));
        this.assertEquals(randString, options.getHost());
        this.assertTrue(options.getEnabledCipherSuites().isEmpty());
        this.assertEquals(options, options.addEnabledCipherSuite("foo"));
        this.assertEquals(options, options.addEnabledCipherSuite("bar"));
        this.assertNotNull(options.getEnabledCipherSuites());
        this.assertTrue(options.getEnabledCipherSuites().contains("foo"));
        this.assertTrue(options.getEnabledCipherSuites().contains("bar"));
        this.assertEquals(false, options.isUseAlpn());
        this.assertEquals(options, options.setUseAlpn(false));
        this.assertEquals(false, options.isUseAlpn());
        this.assertNull(options.getSslEngineOptions());
        this.assertEquals(options, options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions()));
        this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
        this.testComplete();
    }

    @Test
    public void testCopyClientOptions() {
        NetClientOptions options = new NetClientOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        String hostnameVerificationAlgorithm = TestUtils.randomAlphaString(10);
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int reconnectAttempts = TestUtils.randomPositiveInt();
        long reconnectInterval = TestUtils.randomPositiveInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setSsl(ssl);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setUsePooledBuffers(usePooledBuffers);
        options.setIdleTimeout(idleTimeout);
        options.setKeyStoreOptions(keyStoreOptions);
        options.setTrustStoreOptions(trustStoreOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.setConnectTimeout(connectTimeout);
        options.setTrustAll(trustAll);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setReconnectAttempts(reconnectAttempts);
        options.setReconnectInterval(reconnectInterval);
        options.setUseAlpn(useAlpn);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        options.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        NetClientOptions copy = new NetClientOptions(options);
        this.assertEquals(sendBufferSize, copy.getSendBufferSize());
        this.assertEquals(receiverBufferSize, copy.getReceiveBufferSize());
        this.assertEquals(reuseAddress, copy.isReuseAddress());
        this.assertEquals(trafficClass, copy.getTrafficClass());
        this.assertEquals(tcpNoDelay, copy.isTcpNoDelay());
        this.assertEquals(tcpKeepAlive, copy.isTcpKeepAlive());
        this.assertEquals(soLinger, copy.getSoLinger());
        this.assertEquals(usePooledBuffers, copy.isUsePooledBuffers());
        this.assertEquals(idleTimeout, copy.getIdleTimeout());
        this.assertEquals(ssl, copy.isSsl());
        this.assertNotSame(keyStoreOptions, copy.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)copy.getKeyCertOptions()).getPassword());
        this.assertNotSame(trustStoreOptions, copy.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)copy.getTrustOptions()).getPassword());
        this.assertEquals(1L, copy.getEnabledCipherSuites().size());
        this.assertTrue(copy.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, copy.getConnectTimeout());
        this.assertEquals(trustAll, copy.isTrustAll());
        this.assertEquals(1L, copy.getCrlPaths().size());
        this.assertEquals(crlPath, copy.getCrlPaths().get(0));
        this.assertEquals(1L, copy.getCrlValues().size());
        this.assertEquals(crlValue, copy.getCrlValues().get(0));
        this.assertEquals(reconnectAttempts, copy.getReconnectAttempts());
        this.assertEquals(reconnectInterval, copy.getReconnectInterval());
        this.assertEquals(useAlpn, copy.isUseAlpn());
        this.assertEquals(sslEngine, copy.getSslEngineOptions());
        this.assertEquals(hostnameVerificationAlgorithm, copy.getHostnameVerificationAlgorithm());
    }

    @Test
    public void testDefaultClientOptionsJson() {
        NetClientOptions def = new NetClientOptions();
        NetClientOptions json = new NetClientOptions(new JsonObject());
        this.assertEquals(def.getReconnectAttempts(), json.getReconnectAttempts());
        this.assertEquals(def.getReconnectInterval(), json.getReconnectInterval());
        this.assertEquals(def.isTrustAll(), json.isTrustAll());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getConnectTimeout(), json.getConnectTimeout());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isUsePooledBuffers(), json.isUsePooledBuffers());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
        this.assertEquals(def.getHostnameVerificationAlgorithm(), json.getHostnameVerificationAlgorithm());
    }

    @Test
    public void testClientOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        int connectTimeout = TestUtils.randomPositiveInt();
        boolean trustAll = rand.nextBoolean();
        String crlPath = TestUtils.randomUnicodeString(100);
        int reconnectAttempts = TestUtils.randomPositiveInt();
        long reconnectInterval = TestUtils.randomPositiveInt();
        boolean useAlpn = TestUtils.randomBoolean();
        String hostnameVerificationAlgorithm = TestUtils.randomAlphaString(10);
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", Integer.valueOf(sendBufferSize)).put("receiveBufferSize", Integer.valueOf(receiverBufferSize)).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("trafficClass", Integer.valueOf(trafficClass)).put("tcpNoDelay", Boolean.valueOf(tcpNoDelay)).put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive)).put("soLinger", Integer.valueOf(soLinger)).put("usePooledBuffers", Boolean.valueOf(usePooledBuffers)).put("idleTimeout", Integer.valueOf(idleTimeout)).put("ssl", Boolean.valueOf(ssl)).put("enabledCipherSuites", new JsonArray().add(enabledCipher)).put("connectTimeout", Integer.valueOf(connectTimeout)).put("trustAll", Boolean.valueOf(trustAll)).put("crlPaths", new JsonArray().add(crlPath)).put("keyStoreOptions", new JsonObject().put("password", ksPassword).put("path", ksPath)).put("trustStoreOptions", new JsonObject().put("password", tsPassword).put("path", tsPath)).put("reconnectAttempts", Integer.valueOf(reconnectAttempts)).put("reconnectInterval", Long.valueOf(reconnectInterval)).put("useAlpn", Boolean.valueOf(useAlpn)).put(sslEngine, new JsonObject()).put("hostnameVerificationAlgorithm", hostnameVerificationAlgorithm).put("openSslSessionCacheEnabled", Boolean.valueOf(openSslSessionCacheEnabled));
        NetClientOptions options = new NetClientOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(usePooledBuffers, options.isUsePooledBuffers());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(connectTimeout, options.getConnectTimeout());
        this.assertEquals(trustAll, options.isTrustAll());
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(reconnectAttempts, options.getReconnectAttempts());
        this.assertEquals(reconnectInterval, options.getReconnectInterval());
        this.assertEquals(useAlpn, options.isUseAlpn());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        this.assertEquals(hostnameVerificationAlgorithm, options.getHostnameVerificationAlgorithm());
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", new JsonObject().put("password", ksPassword)).put("pfxTrustOptions", new JsonObject().put("password", tsPassword));
        options = new NetClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", new JsonObject()).put("pemTrustOptions", new JsonObject());
        options = new NetClientOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Test
    public void testCopyServerOptions() {
        NetServerOptions options = new NetServerOptions();
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        Buffer crlValue = TestUtils.randomBuffer(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        JdkSSLEngineOptions sslEngine = TestUtils.randomBoolean() ? new JdkSSLEngineOptions() : new OpenSSLEngineOptions();
        options.setSendBufferSize(sendBufferSize);
        options.setReceiveBufferSize(receiverBufferSize);
        options.setReuseAddress(reuseAddress);
        options.setTrafficClass(trafficClass);
        options.setTcpNoDelay(tcpNoDelay);
        options.setTcpKeepAlive(tcpKeepAlive);
        options.setSoLinger(soLinger);
        options.setUsePooledBuffers(usePooledBuffers);
        options.setIdleTimeout(idleTimeout);
        options.setSsl(ssl);
        options.setKeyStoreOptions(keyStoreOptions);
        options.setTrustStoreOptions(trustStoreOptions);
        options.addEnabledCipherSuite(enabledCipher);
        options.addCrlPath(crlPath);
        options.addCrlValue(crlValue);
        options.setPort(port);
        options.setHost(host);
        options.setAcceptBacklog(acceptBacklog);
        options.setUseAlpn(useAlpn);
        options.setSslEngineOptions((SSLEngineOptions)sslEngine);
        NetServerOptions copy = new NetServerOptions(options);
        this.assertEquals(sendBufferSize, copy.getSendBufferSize());
        this.assertEquals(receiverBufferSize, copy.getReceiveBufferSize());
        this.assertEquals(reuseAddress, copy.isReuseAddress());
        this.assertEquals(trafficClass, copy.getTrafficClass());
        this.assertEquals(tcpNoDelay, copy.isTcpNoDelay());
        this.assertEquals(tcpKeepAlive, copy.isTcpKeepAlive());
        this.assertEquals(soLinger, copy.getSoLinger());
        this.assertEquals(usePooledBuffers, copy.isUsePooledBuffers());
        this.assertEquals(idleTimeout, copy.getIdleTimeout());
        this.assertEquals(ssl, copy.isSsl());
        this.assertNotSame(keyStoreOptions, copy.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)copy.getKeyCertOptions()).getPassword());
        this.assertNotSame(trustStoreOptions, copy.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)copy.getTrustOptions()).getPassword());
        this.assertEquals(1L, copy.getEnabledCipherSuites().size());
        this.assertTrue(copy.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, copy.getCrlPaths().size());
        this.assertEquals(crlPath, copy.getCrlPaths().get(0));
        this.assertEquals(1L, copy.getCrlValues().size());
        this.assertEquals(crlValue, copy.getCrlValues().get(0));
        this.assertEquals(port, copy.getPort());
        this.assertEquals(host, copy.getHost());
        this.assertEquals(acceptBacklog, copy.getAcceptBacklog());
        this.assertEquals(useAlpn, copy.isUseAlpn());
        this.assertEquals(sslEngine, copy.getSslEngineOptions());
    }

    @Test
    public void testDefaultServerOptionsJson() {
        NetServerOptions def = new NetServerOptions();
        NetServerOptions json = new NetServerOptions(new JsonObject());
        this.assertEquals(def.isClientAuthRequired(), json.isClientAuthRequired());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.isClientAuthRequired(), json.isClientAuthRequired());
        this.assertEquals(def.getCrlPaths(), json.getCrlPaths());
        this.assertEquals(def.getCrlValues(), json.getCrlValues());
        this.assertEquals(def.getAcceptBacklog(), json.getAcceptBacklog());
        this.assertEquals(def.getPort(), json.getPort());
        this.assertEquals(def.getHost(), json.getHost());
        this.assertEquals(def.isTcpNoDelay(), json.isTcpNoDelay());
        this.assertEquals(def.isTcpKeepAlive(), json.isTcpKeepAlive());
        this.assertEquals(def.getSoLinger(), json.getSoLinger());
        this.assertEquals(def.isUsePooledBuffers(), json.isUsePooledBuffers());
        this.assertEquals(def.isSsl(), json.isSsl());
        this.assertEquals(def.isUseAlpn(), json.isUseAlpn());
        this.assertEquals(def.getSslEngineOptions(), json.getSslEngineOptions());
    }

    @Test
    public void testServerOptionsJson() {
        int sendBufferSize = TestUtils.randomPositiveInt();
        int receiverBufferSize = TestUtils.randomPortInt();
        Random rand = new Random();
        boolean reuseAddress = rand.nextBoolean();
        int trafficClass = TestUtils.randomByte() + 128;
        boolean tcpNoDelay = rand.nextBoolean();
        boolean tcpKeepAlive = rand.nextBoolean();
        int soLinger = TestUtils.randomPositiveInt();
        boolean usePooledBuffers = rand.nextBoolean();
        int idleTimeout = TestUtils.randomPositiveInt();
        boolean ssl = rand.nextBoolean();
        JksOptions keyStoreOptions = new JksOptions();
        String ksPassword = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPassword(ksPassword);
        String ksPath = TestUtils.randomAlphaString(100);
        keyStoreOptions.setPath(ksPath);
        JksOptions trustStoreOptions = new JksOptions();
        String tsPassword = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPassword(tsPassword);
        String tsPath = TestUtils.randomAlphaString(100);
        trustStoreOptions.setPath(tsPath);
        String enabledCipher = TestUtils.randomAlphaString(100);
        String crlPath = TestUtils.randomUnicodeString(100);
        int port = 1234;
        String host = TestUtils.randomAlphaString(100);
        int acceptBacklog = TestUtils.randomPortInt();
        boolean useAlpn = TestUtils.randomBoolean();
        boolean openSslSessionCacheEnabled = rand.nextBoolean();
        String sslEngine = TestUtils.randomBoolean() ? "jdkSslEngineOptions" : "openSslEngineOptions";
        JsonObject json = new JsonObject();
        json.put("sendBufferSize", Integer.valueOf(sendBufferSize)).put("receiveBufferSize", Integer.valueOf(receiverBufferSize)).put("reuseAddress", Boolean.valueOf(reuseAddress)).put("trafficClass", Integer.valueOf(trafficClass)).put("tcpNoDelay", Boolean.valueOf(tcpNoDelay)).put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive)).put("soLinger", Integer.valueOf(soLinger)).put("usePooledBuffers", Boolean.valueOf(usePooledBuffers)).put("idleTimeout", Integer.valueOf(idleTimeout)).put("ssl", Boolean.valueOf(ssl)).put("enabledCipherSuites", new JsonArray().add(enabledCipher)).put("crlPaths", new JsonArray().add(crlPath)).put("keyStoreOptions", new JsonObject().put("password", ksPassword).put("path", ksPath)).put("trustStoreOptions", new JsonObject().put("password", tsPassword).put("path", tsPath)).put("port", Integer.valueOf(port)).put("host", host).put("acceptBacklog", Integer.valueOf(acceptBacklog)).put("useAlpn", Boolean.valueOf(useAlpn)).put(sslEngine, new JsonObject()).put("openSslSessionCacheEnabled", Boolean.valueOf(openSslSessionCacheEnabled));
        NetServerOptions options = new NetServerOptions(json);
        this.assertEquals(sendBufferSize, options.getSendBufferSize());
        this.assertEquals(receiverBufferSize, options.getReceiveBufferSize());
        this.assertEquals(reuseAddress, options.isReuseAddress());
        this.assertEquals(trafficClass, options.getTrafficClass());
        this.assertEquals(tcpKeepAlive, options.isTcpKeepAlive());
        this.assertEquals(tcpNoDelay, options.isTcpNoDelay());
        this.assertEquals(soLinger, options.getSoLinger());
        this.assertEquals(usePooledBuffers, options.isUsePooledBuffers());
        this.assertEquals(idleTimeout, options.getIdleTimeout());
        this.assertEquals(ssl, options.isSsl());
        this.assertNotSame(keyStoreOptions, options.getKeyCertOptions());
        this.assertEquals(ksPassword, ((JksOptions)options.getKeyCertOptions()).getPassword());
        this.assertEquals(ksPath, ((JksOptions)options.getKeyCertOptions()).getPath());
        this.assertNotSame(trustStoreOptions, options.getTrustOptions());
        this.assertEquals(tsPassword, ((JksOptions)options.getTrustOptions()).getPassword());
        this.assertEquals(tsPath, ((JksOptions)options.getTrustOptions()).getPath());
        this.assertEquals(1L, options.getEnabledCipherSuites().size());
        this.assertTrue(options.getEnabledCipherSuites().contains(enabledCipher));
        this.assertEquals(1L, options.getCrlPaths().size());
        this.assertEquals(crlPath, options.getCrlPaths().get(0));
        this.assertEquals(port, options.getPort());
        this.assertEquals(host, options.getHost());
        this.assertEquals(acceptBacklog, options.getAcceptBacklog());
        this.assertEquals(useAlpn, options.isUseAlpn());
        switch (sslEngine) {
            case "jdkSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof JdkSSLEngineOptions);
                break;
            }
            case "openSslEngineOptions": {
                this.assertTrue(options.getSslEngineOptions() instanceof OpenSSLEngineOptions);
                break;
            }
            default: {
                this.fail();
            }
        }
        json.remove("keyStoreOptions");
        json.remove("trustStoreOptions");
        json.put("pfxKeyCertOptions", new JsonObject().put("password", ksPassword)).put("pfxTrustOptions", new JsonObject().put("password", tsPassword));
        options = new NetServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PfxOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PfxOptions);
        json.remove("pfxKeyCertOptions");
        json.remove("pfxTrustOptions");
        json.put("pemKeyCertOptions", new JsonObject()).put("pemTrustOptions", new JsonObject());
        options = new NetServerOptions(json);
        this.assertTrue(options.getTrustOptions() instanceof PemTrustOptions);
        this.assertTrue(options.getKeyCertOptions() instanceof PemKeyCertOptions);
    }

    @Test
    public void testSocketAddress() throws Exception {
        TestUtils.assertNullPointerException(() -> new SocketAddressImpl(0, null));
        TestUtils.assertIllegalArgumentException(() -> new SocketAddressImpl(0, ""));
        TestUtils.assertIllegalArgumentException(() -> new SocketAddressImpl(-1, "someHost"));
        TestUtils.assertIllegalArgumentException(() -> new SocketAddressImpl(65536, "someHost"));
    }

    @Test
    public void testEchoBytes() {
        Buffer sent = TestUtils.randomBuffer(100);
        this.testEcho(sock -> sock.write(sent), buff -> this.assertEquals(sent, buff), sent.length());
    }

    @Test
    public void testEchoString() {
        String sent = TestUtils.randomUnicodeString(100);
        Buffer buffSent = Buffer.buffer((String)sent);
        this.testEcho(sock -> sock.write(sent), buff -> this.assertEquals(buffSent, buff), buffSent.length());
    }

    @Test
    public void testEchoStringUTF8() {
        this.testEchoStringWithEncoding("UTF-8");
    }

    @Test
    public void testEchoStringUTF16() {
        this.testEchoStringWithEncoding("UTF-16");
    }

    void testEchoStringWithEncoding(String encoding) {
        String sent = TestUtils.randomUnicodeString(100);
        Buffer buffSent = Buffer.buffer((String)sent, (String)encoding);
        this.testEcho(sock -> sock.write(sent, encoding), buff -> this.assertEquals(buffSent, buff), buffSent.length());
    }

    void testEcho(Consumer<NetSocket> writer, Consumer<Buffer> dataChecker, int length) {
        Handler clientHandler = asyncResult -> {
            if (asyncResult.succeeded()) {
                NetSocket sock = (NetSocket)asyncResult.result();
                Buffer buff = Buffer.buffer();
                sock.handler(buffer -> {
                    buff.appendBuffer(buffer);
                    if (buff.length() == length) {
                        dataChecker.accept(buff);
                        this.testComplete();
                    }
                    if (buff.length() > length) {
                        this.fail("Too many bytes received");
                    }
                });
                writer.accept(sock);
            } else {
                this.fail("failed to connect");
            }
        };
        this.startEchoServer((Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(1234, "localhost", clientHandler)));
        this.await();
    }

    void startEchoServer(Handler<AsyncResult<NetServer>> listenHandler) {
        Handler serverHandler = socket -> socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0));
        this.server.connectHandler(serverHandler).listen(listenHandler);
    }

    @Test
    public void testConnectLocalHost() {
        this.connect(1234, "localhost");
    }

    void connect(int port, String host) {
        this.startEchoServer((Handler<AsyncResult<NetServer>>)((Handler)s -> {
            int numConnections = 100;
            AtomicInteger connCount = new AtomicInteger(0);
            for (int i = 0; i < 100; ++i) {
                AsyncResultHandler handler = res -> {
                    if (res.succeeded()) {
                        ((NetSocket)res.result()).close();
                        if (connCount.incrementAndGet() == 100) {
                            this.testComplete();
                        }
                    }
                };
                this.client.connect(port, host, (Handler)handler);
            }
        }));
        this.await();
    }

    @Test
    public void testConnectInvalidPort() {
        TestUtils.assertIllegalArgumentException(() -> this.client.connect(-1, "localhost", res -> {}));
        TestUtils.assertIllegalArgumentException(() -> this.client.connect(65536, "localhost", res -> {}));
        this.client.connect(9998, "localhost", res -> {
            this.assertTrue(res.failed());
            this.assertFalse(res.succeeded());
            this.assertNotNull(res.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testConnectInvalidHost() {
        TestUtils.assertNullPointerException(() -> this.client.connect(80, null, res -> {}));
        this.client.connect(1234, "127.0.0.2", res -> {
            this.assertTrue(res.failed());
            this.assertFalse(res.succeeded());
            this.assertNotNull(res.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testConnectInvalidConnectHandler() throws Exception {
        TestUtils.assertNullPointerException(() -> this.client.connect(80, "localhost", null));
    }

    @Test
    public void testListenInvalidPort() {
        Assume.assumeFalse((boolean)System.getProperty("os.name").startsWith("Windows"));
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(80));
        this.server.connectHandler(netSocket -> {}).listen(ar -> {
            this.assertTrue(ar.failed());
            this.assertFalse(ar.succeeded());
            this.assertNotNull(ar.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenInvalidHost() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("uhqwduhqwudhqwuidhqwiudhqwudqwiuhd"));
        this.server.connectHandler(netSocket -> {}).listen(ar -> {
            this.assertTrue(ar.failed());
            this.assertFalse(ar.succeeded());
            this.assertNotNull(ar.cause());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenOnWildcardPort() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(0));
        this.server.connectHandler(netSocket -> {}).listen(ar -> {
            this.assertFalse(ar.failed());
            this.assertTrue(ar.succeeded());
            this.assertNull(ar.cause());
            this.assertTrue(this.server.actualPort() > 1024);
            this.assertEquals(this.server, ar.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testClientCloseHandlersCloseFromClient() {
        this.startEchoServer((Handler<AsyncResult<NetServer>>)((Handler)s -> this.clientCloseHandlers(true)));
        this.await();
    }

    @Test
    public void testClientCloseHandlersCloseFromServer() {
        this.server.connectHandler(netSocket -> netSocket.close()).listen(s -> this.clientCloseHandlers(false));
        this.await();
    }

    void clientCloseHandlers(boolean closeFromClient) {
        this.client.connect(1234, "localhost", ar -> {
            AtomicInteger counter = new AtomicInteger(0);
            ((NetSocket)ar.result()).endHandler(v -> this.assertEquals(1L, counter.incrementAndGet()));
            ((NetSocket)ar.result()).closeHandler(v -> {
                this.assertEquals(2L, counter.incrementAndGet());
                this.testComplete();
            });
            if (closeFromClient) {
                ((NetSocket)ar.result()).close();
            }
        });
    }

    @Test
    public void testServerCloseHandlersCloseFromClient() {
        this.serverCloseHandlers(false, (Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(1234, "localhost", ar -> ((NetSocket)ar.result()).close())));
        this.await();
    }

    @Test
    public void testServerCloseHandlersCloseFromServer() {
        this.serverCloseHandlers(true, (Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(1234, "localhost", ar -> {})));
        this.await();
    }

    void serverCloseHandlers(boolean closeFromServer, Handler<AsyncResult<NetServer>> listenHandler) {
        this.server.connectHandler(sock -> {
            AtomicInteger counter = new AtomicInteger(0);
            sock.endHandler(v -> this.assertEquals(1L, counter.incrementAndGet()));
            sock.closeHandler(v -> {
                this.assertEquals(2L, counter.incrementAndGet());
                this.testComplete();
            });
            if (closeFromServer) {
                sock.close();
            }
        }).listen(listenHandler);
    }

    @Test
    public void testClientDrainHandler() {
        this.pausingServer((Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(1234, "localhost", ar -> {
            NetSocket sock = (NetSocket)ar.result();
            this.assertFalse(sock.writeQueueFull());
            sock.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                sock.write(buff.copy());
                if (sock.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    sock.drainHandler(v -> {
                        this.assertFalse(sock.writeQueueFull());
                        this.testComplete();
                    });
                    this.vertx.eventBus().send("server_resume", (Object)"");
                }
            });
        })));
        this.await();
    }

    void pausingServer(Handler<AsyncResult<NetServer>> listenHandler) {
        this.server.connectHandler(sock -> {
            sock.pause();
            Handler resumeHandler = m -> sock.resume();
            MessageConsumer reg = this.vertx.eventBus().consumer("server_resume").handler(resumeHandler);
            sock.closeHandler(v -> reg.unregister());
        }).listen(listenHandler);
    }

    @Test
    public void testServerDrainHandler() {
        this.drainingServer((Handler<AsyncResult<NetServer>>)((Handler)s -> this.client.connect(1234, "localhost", ar -> {
            NetSocket sock = (NetSocket)ar.result();
            sock.pause();
            this.setHandlers(sock);
            sock.handler(buf -> {});
        })));
        this.await();
    }

    void setHandlers(NetSocket sock) {
        Handler resumeHandler = m -> sock.resume();
        MessageConsumer reg = this.vertx.eventBus().consumer("client_resume").handler(resumeHandler);
        sock.closeHandler(v -> reg.unregister());
    }

    void drainingServer(Handler<AsyncResult<NetServer>> listenHandler) {
        this.server.connectHandler(sock -> {
            this.assertFalse(sock.writeQueueFull());
            sock.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                sock.write(buff.copy());
                if (sock.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    sock.drainHandler(v -> {
                        this.assertFalse(sock.writeQueueFull());
                        this.vertx.setTimer(100L, id2 -> this.testComplete());
                    });
                    this.vertx.eventBus().send("client_resume", (Object)"");
                }
            });
        }).listen(listenHandler);
    }

    @Test
    public void testReconnectAttemptsInfinite() {
        this.reconnectAttempts(-1);
    }

    @Test
    public void testReconnectAttemptsMany() {
        this.reconnectAttempts(100000);
    }

    void reconnectAttempts(int attempts) {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setReconnectAttempts(attempts).setReconnectInterval(10L));
        this.client.connect(1234, "localhost", res -> {
            this.assertTrue(res.succeeded());
            this.assertFalse(res.failed());
            this.testComplete();
        });
        this.vertx.setTimer(2000L, id -> this.startEchoServer((Handler<AsyncResult<NetServer>>)((Handler)s -> {})));
        this.await();
    }

    @Test
    public void testReconnectAttemptsNotEnough() {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setReconnectAttempts(100).setReconnectInterval(10L));
        this.client.connect(1234, "localhost", res -> {
            this.assertFalse(res.succeeded());
            this.assertTrue(res.failed());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testServerIdleTimeout() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost").setIdleTimeout(1));
        this.server.connectHandler(s -> {}).listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", res -> {
                this.assertTrue(res.succeeded());
                NetSocket socket = (NetSocket)res.result();
                socket.closeHandler(v -> this.testComplete());
            });
        });
        this.await();
    }

    @Test
    public void testClientIdleTimeout() {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setIdleTimeout(1));
        this.server.connectHandler(s -> {}).listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", res -> {
                this.assertTrue(res.succeeded());
                NetSocket socket = (NetSocket)res.result();
                socket.closeHandler(v -> this.testComplete());
            });
        });
        this.await();
    }

    @Test
    public void testStartTLSClientTrustAll() throws Exception {
        this.testTLS(false, false, true, false, false, true, true, true);
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(false, false, true, false, false, true, true, false);
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(false, true, true, false, false, false, true, false);
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(false, false, true, false, false, false, false, false);
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(true, true, true, true, false, false, true, false);
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(true, true, true, true, true, false, true, false);
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(false, true, true, true, true, false, false, false);
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(true, true, true, false, true, false, false, false);
    }

    @Test
    public void testTLSCipherSuites() throws Exception {
        this.testTLS(false, false, true, false, false, true, true, false, ENABLED_CIPHER_SUITES);
    }

    @Test
    public void testInvalidTlsProtocolVersion() throws Exception {
        this.testTLS(false, false, true, false, false, true, false, false, new String[0], new String[]{"TLSv1.999"});
    }

    @Test
    public void testSpecificTlsProtocolVersion() throws Exception {
        this.testTLS(false, false, true, false, false, true, true, false, new String[0], new String[]{"TLSv1.2"});
    }

    void testTLS(boolean clientCert, boolean clientTrust, boolean serverCert, boolean serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS) throws Exception {
        this.testTLS(clientCert, clientTrust, serverCert, serverTrust, requireClientAuth, clientTrustAll, shouldPass, startTLS, new String[0], new String[0]);
    }

    void testTLS(boolean clientCert, boolean clientTrust, boolean serverCert, boolean serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS, String[] enabledCipherSuites) throws Exception {
        this.testTLS(clientCert, clientTrust, serverCert, serverTrust, requireClientAuth, clientTrustAll, shouldPass, startTLS, enabledCipherSuites, new String[0]);
    }

    void testTLS(boolean clientCert, boolean clientTrust, boolean serverCert, boolean serverTrust, boolean requireClientAuth, boolean clientTrustAll, boolean shouldPass, boolean startTLS, String[] enabledCipherSuites, String[] enabledSecureTransportProtocols) throws Exception {
        this.server.close();
        NetServerOptions options = new NetServerOptions();
        if (!startTLS) {
            options.setSsl(true);
        }
        if (serverTrust) {
            options.setTrustStoreOptions(new JksOptions().setPath("tls/server-truststore.jks").setPassword("wibble"));
        }
        if (serverCert) {
            options.setKeyStoreOptions(new JksOptions().setPath("tls/server-keystore.jks").setPassword("wibble"));
        }
        if (requireClientAuth) {
            options.setClientAuth(ClientAuth.REQUIRED);
        }
        for (String suite : enabledCipherSuites) {
            options.addEnabledCipherSuite(suite);
        }
        for (String protocol : enabledSecureTransportProtocols) {
            options.addEnabledSecureTransportProtocol(protocol);
        }
        Consumer<NetSocket> certificateChainChecker = socket -> {
            try {
                X509Certificate[] certs = socket.peerCertificateChain();
                if (clientCert) {
                    this.assertNotNull(certs);
                    this.assertEquals(1L, certs.length);
                } else {
                    this.assertNull(certs);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                this.assertTrue(clientTrust || clientTrustAll);
            }
        };
        options.setPort(4043);
        this.server = this.vertx.createNetServer(options);
        Handler serverHandler = socket -> {
            if (socket.isSsl()) {
                certificateChainChecker.accept((NetSocket)socket);
            }
            AtomicBoolean upgradedServer = new AtomicBoolean();
            AtomicInteger upgradedServerCount = new AtomicInteger();
            socket.handler(buff -> {
                socket.write(buff);
                if (startTLS) {
                    if (upgradedServer.compareAndSet(false, true)) {
                        this.assertFalse(socket.isSsl());
                        socket.upgradeToSsl(v -> {
                            certificateChainChecker.accept((NetSocket)socket);
                            upgradedServerCount.incrementAndGet();
                            this.assertTrue(socket.isSsl());
                        });
                    } else {
                        this.assertTrue(socket.isSsl());
                        this.assertEquals(1L, upgradedServerCount.get());
                    }
                } else {
                    this.assertTrue(socket.isSsl());
                }
            });
        };
        this.server.connectHandler(serverHandler).listen(ar -> {
            this.client.close();
            NetClientOptions clientOptions = new NetClientOptions();
            if (!startTLS) {
                clientOptions.setSsl(true);
            }
            if (clientTrustAll) {
                clientOptions.setTrustAll(true);
            }
            if (clientTrust) {
                clientOptions.setTrustStoreOptions(new JksOptions().setPath("tls/client-truststore.jks").setPassword("wibble"));
            }
            if (clientCert) {
                clientOptions.setKeyStoreOptions(new JksOptions().setPath("tls/client-keystore.jks").setPassword("wibble"));
            }
            for (String suite : enabledCipherSuites) {
                clientOptions.addEnabledCipherSuite(suite);
            }
            for (String protocol : enabledSecureTransportProtocols) {
                clientOptions.addEnabledSecureTransportProtocol(protocol);
            }
            this.client = this.vertx.createNetClient(clientOptions);
            this.client.connect(4043, "localhost", ar2 -> {
                if (ar2.succeeded()) {
                    if (!shouldPass) {
                        this.fail("Should not connect");
                        return;
                    }
                    int numChunks = 100;
                    int chunkSize = 100;
                    ArrayList<Buffer> toSend = new ArrayList<Buffer>();
                    Buffer expected = Buffer.buffer();
                    for (int i = 0; i < 100; ++i) {
                        Buffer chunk = TestUtils.randomBuffer(100);
                        toSend.add(chunk);
                        expected.appendBuffer(chunk);
                    }
                    Buffer received = Buffer.buffer();
                    NetSocket socket = (NetSocket)ar2.result();
                    AtomicBoolean upgradedClient = new AtomicBoolean();
                    socket.handler(buffer -> {
                        received.appendBuffer(buffer);
                        if (received.length() == expected.length()) {
                            this.assertEquals(expected, received);
                            this.testComplete();
                        }
                        if (startTLS && !upgradedClient.get()) {
                            upgradedClient.set(true);
                            this.assertFalse(socket.isSsl());
                            socket.upgradeToSsl(v -> {
                                this.assertTrue(socket.isSsl());
                                for (int i = 1; i < 100; ++i) {
                                    socket.write((Buffer)toSend.get(i));
                                }
                            });
                        } else {
                            this.assertTrue(socket.isSsl());
                        }
                    });
                    int numToSend = startTLS ? 1 : 100;
                    for (int i = 0; i < numToSend; ++i) {
                        socket.write((Buffer)toSend.get(i));
                    }
                } else if (shouldPass) {
                    this.fail("Should not fail to connect");
                } else {
                    this.testComplete();
                }
            });
        });
        this.await();
    }

    @Test
    public void testSharedServersRoundRobin() throws Exception {
        int numServers = 5;
        int numConnections = numServers * 20;
        ArrayList<NetServer> servers = new ArrayList<NetServer>();
        ConcurrentHashSet connectedServers = new ConcurrentHashSet();
        ConcurrentHashMap connectCount = new ConcurrentHashMap();
        CountDownLatch latchListen = new CountDownLatch(numServers);
        CountDownLatch latchConns = new CountDownLatch(numConnections);
        for (int i = 0; i < numServers; ++i) {
            NetServer theServer = this.vertx.createNetServer(new NetServerOptions().setHost("localhost").setPort(1234));
            servers.add(theServer);
            theServer.connectHandler(arg_0 -> NetTest.lambda$testSharedServersRoundRobin$100((Set)connectedServers, theServer, connectCount, latchConns, arg_0)).listen(ar -> {
                if (ar.succeeded()) {
                    latchListen.countDown();
                } else {
                    this.fail("Failed to bind server");
                }
            });
        }
        this.assertTrue(latchListen.await(10L, TimeUnit.SECONDS));
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions());
        CountDownLatch latchClient = new CountDownLatch(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            this.client.connect(1234, "localhost", res -> {
                if (res.succeeded()) {
                    latchClient.countDown();
                } else {
                    res.cause().printStackTrace();
                    this.fail("Failed to connect");
                }
            });
        }
        this.assertTrue(latchClient.await(10L, TimeUnit.SECONDS));
        this.assertTrue(latchConns.await(10L, TimeUnit.SECONDS));
        this.assertEquals(numServers, connectedServers.size());
        for (NetServer server : servers) {
            this.assertTrue(connectedServers.contains(server));
        }
        this.assertEquals(numServers, connectCount.size());
        Iterator<Object> i = connectCount.values().iterator();
        while (i.hasNext()) {
            int cnt = (Integer)i.next();
            this.assertEquals(numConnections / numServers, cnt);
        }
        CountDownLatch closeLatch = new CountDownLatch(numServers);
        for (NetServer server : servers) {
            server.close(ar -> {
                this.assertTrue(ar.succeeded());
                closeLatch.countDown();
            });
        }
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSharedServersRoundRobinWithOtherServerRunningOnDifferentPort() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(4321));
        this.server.connectHandler(sock -> this.fail("Should not connect")).listen(ar2 -> {
            if (ar2.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testSharedServersRoundRobinButFirstStartAndStopServer() throws Exception {
        this.server.close();
        CountDownLatch latch = new CountDownLatch(1);
        this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234));
        this.server.connectHandler(sock -> this.fail("Should not connect")).listen(ar -> {
            if (ar.succeeded()) {
                latch.countDown();
            } else {
                this.fail("Failed to bind server");
            }
        });
        this.awaitLatch(latch);
        CountDownLatch closeLatch = new CountDownLatch(1);
        this.server.close(ar -> {
            this.assertTrue(ar.succeeded());
            closeLatch.countDown();
        });
        this.assertTrue(closeLatch.await(10L, TimeUnit.SECONDS));
        this.testSharedServersRoundRobin();
    }

    @Test
    public void testFanout() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ConcurrentHashSet connections = new ConcurrentHashSet();
        this.server.connectHandler(arg_0 -> this.lambda$testFanout$111((Set)connections, arg_0));
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            latch.countDown();
        });
        this.awaitLatch(latch);
        int numConnections = 10;
        CountDownLatch connectLatch = new CountDownLatch(numConnections);
        CountDownLatch receivedLatch = new CountDownLatch(numConnections);
        for (int i = 0; i < numConnections; ++i) {
            this.client.connect(1234, "localhost", res -> {
                connectLatch.countDown();
                ((NetSocket)res.result()).handler(data -> receivedLatch.countDown());
            });
        }
        this.assertTrue(connectLatch.await(10L, TimeUnit.SECONDS));
        this.client.connect(1234, "localhost", res -> ((NetSocket)res.result()).write("foo"));
        this.assertTrue(receivedLatch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testRemoteAddress() throws Exception {
        this.server.connectHandler(socket -> {
            SocketAddress addr = socket.remoteAddress();
            this.assertEquals("127.0.0.1", addr.host());
        }).listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.vertx.createNetClient(new NetClientOptions()).connect(1234, "localhost", result -> {
                NetSocket socket = (NetSocket)result.result();
                SocketAddress addr = socket.remoteAddress();
                this.assertEquals("127.0.0.1", addr.host());
                this.assertEquals(addr.port(), 1234L);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testWriteSameBufferMoreThanOnce() throws Exception {
        this.server.connectHandler(socket -> {
            Buffer received = Buffer.buffer();
            socket.handler(buff -> {
                received.appendBuffer(buff);
                if (received.toString().equals("foofoo")) {
                    this.testComplete();
                }
            });
        }).listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", result -> {
                NetSocket socket = (NetSocket)result.result();
                Buffer buff = Buffer.buffer((String)"foo");
                socket.write(buff);
                socket.write(buff);
            });
        });
        this.await();
    }

    @Test
    public void sendFileClientToServer() throws Exception {
        File fDir = this.testFolder.newFolder();
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile(fDir.toString(), "some-file.txt", content);
        Buffer expected = Buffer.buffer((String)content);
        Buffer received = Buffer.buffer();
        this.server.connectHandler(sock -> {
            sock.handler(buff -> {
                received.appendBuffer(buff);
                if (received.length() == expected.length()) {
                    this.assertEquals(expected, received);
                    this.testComplete();
                }
            });
            sock.write("foo");
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket sock = (NetSocket)ar2.result();
                sock.handler(buf -> sock.sendFile(file.getAbsolutePath()));
            });
        });
        this.await();
    }

    @Test
    public void sendFileServerToClient() throws Exception {
        File fDir = this.testFolder.newFolder();
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile(fDir.toString(), "some-file.txt", content);
        Buffer expected = Buffer.buffer((String)content);
        Buffer received = Buffer.buffer();
        this.server.connectHandler(sock -> sock.handler(buf -> sock.sendFile(file.getAbsolutePath())));
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket sock = (NetSocket)ar2.result();
                sock.handler(buff -> {
                    received.appendBuffer(buff);
                    if (received.length() == expected.length()) {
                        this.assertEquals(expected, received);
                        this.testComplete();
                    }
                });
                sock.write("foo");
            });
        });
        this.await();
    }

    @Test
    public void testSendFileDirectory() throws Exception {
        File fDir = this.testFolder.newFolder();
        this.server.connectHandler(socket -> {
            SocketAddress addr = socket.remoteAddress();
            this.assertEquals("127.0.0.1", addr.host());
        }).listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", result -> {
                this.assertTrue(result.succeeded());
                NetSocket socket = (NetSocket)result.result();
                try {
                    socket.sendFile(fDir.getAbsolutePath().toString());
                    this.fail("Should throw exception");
                }
                catch (IllegalArgumentException e) {
                    this.testComplete();
                }
            });
        });
        this.await();
    }

    @Test
    public void testServerOptionsCopiedBeforeUse() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234);
        NetServer server = this.vertx.createNetServer(options);
        options.setPort(1235);
        server.connectHandler(sock -> this.testComplete());
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", ar2 -> this.assertTrue(ar2.succeeded()));
        });
        this.await();
    }

    @Test
    public void testClientOptionsCopiedBeforeUse() {
        this.client.close();
        NetClientOptions options = new NetClientOptions();
        this.client = this.vertx.createNetClient(options);
        options.setSsl(true);
        this.server.connectHandler(sock -> this.testComplete());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.connect(1234, "localhost", ar2 -> this.assertTrue(ar2.succeeded()));
        });
        this.await();
    }

    @Test
    public void testListenWithNoHandler() {
        try {
            this.server.listen();
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testListenWithNoHandler2() {
        try {
            this.server.listen(ar -> this.assertFalse(ar.succeeded()));
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSetHandlerAfterListen() {
        this.server.connectHandler(sock -> {});
        this.server.listen();
        try {
            this.server.connectHandler(sock -> {});
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSetHandlerAfterListen2() {
        this.server.connectHandler(sock -> {});
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            try {
                this.server.connectHandler(sock -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testListenTwice() {
        this.server.connectHandler(sock -> {});
        this.server.listen(this.onSuccess(s -> {
            try {
                this.server.listen(res -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException e) {
                this.testComplete();
            }
            catch (Exception e) {
                this.fail(e.getMessage());
            }
        }));
        this.await();
    }

    @Test
    public void testListenTwice2() {
        this.server.connectHandler(sock -> {});
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            try {
                this.server.listen(sock -> {});
                this.fail("Should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testCloseTwice() {
        this.client.close();
        this.client.close();
    }

    @Test
    public void testAttemptConnectAfterClose() {
        this.client.close();
        try {
            this.client.connect(1234, "localhost", ar -> {});
            this.fail("Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testClientMultiThreaded() throws Exception {
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch latch = new CountDownLatch(numThreads);
        this.server.connectHandler(socket -> socket.handler(arg_0 -> ((NetSocket)socket).write(arg_0))).listen(ar -> {
            this.assertTrue(ar.succeeded());
            for (int i = 0; i < numThreads; ++i) {
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        NetTest.this.client.connect(1234, "localhost", result -> {
                            NetTest.this.assertTrue(result.succeeded());
                            Buffer buff = TestUtils.randomBuffer(100000);
                            NetSocket sock = (NetSocket)result.result();
                            sock.write(buff);
                            Buffer received = Buffer.buffer();
                            sock.handler(rec -> {
                                received.appendBuffer(rec);
                                if (received.length() == buff.length()) {
                                    NetTest.this.assertEquals(buff, received);
                                    latch.countDown();
                                }
                            });
                        });
                    }
                };
                threads[i].start();
            }
        });
        this.awaitLatch(latch);
        for (int i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }

    @Test
    public void testInVerticle() throws Exception {
        this.testInVerticle(false);
    }

    private void testInVerticle(final boolean worker) throws Exception {
        this.client.close();
        this.server.close();
        class MyVerticle
        extends AbstractVerticle {
            Context ctx;

            MyVerticle() {
            }

            public void start() {
                this.ctx = this.context;
                if (worker) {
                    NetTest.this.assertTrue(this.ctx instanceof WorkerContext);
                } else {
                    NetTest.this.assertTrue(this.ctx instanceof EventLoopContext);
                }
                Thread thr = Thread.currentThread();
                NetTest.this.server = this.vertx.createNetServer(new NetServerOptions().setPort(1234).setHost("localhost"));
                NetTest.this.server.connectHandler(sock -> {
                    sock.handler(buff -> sock.write(buff));
                    NetTest.this.assertSame(this.ctx, this.context);
                    if (!worker) {
                        NetTest.this.assertSame(thr, Thread.currentThread());
                    }
                });
                NetTest.this.server.listen(ar -> {
                    NetTest.this.assertTrue(ar.succeeded());
                    NetTest.this.assertSame(this.ctx, this.context);
                    if (!worker) {
                        NetTest.this.assertSame(thr, Thread.currentThread());
                    }
                    NetTest.this.client = this.vertx.createNetClient(new NetClientOptions());
                    NetTest.this.client.connect(1234, "localhost", ar2 -> {
                        NetTest.this.assertSame(this.ctx, this.context);
                        if (!worker) {
                            NetTest.this.assertSame(thr, Thread.currentThread());
                        }
                        NetTest.this.assertTrue(ar2.succeeded());
                        NetSocket sock = (NetSocket)ar2.result();
                        Buffer buff = TestUtils.randomBuffer(10000);
                        sock.write(buff);
                        Buffer brec = Buffer.buffer();
                        sock.handler(rec -> {
                            NetTest.this.assertSame(this.ctx, this.context);
                            if (!worker) {
                                NetTest.this.assertSame(thr, Thread.currentThread());
                            }
                            brec.appendBuffer(rec);
                            if (brec.length() == buff.length()) {
                                NetTest.this.testComplete();
                            }
                        });
                    });
                });
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(worker));
        this.await();
    }

    @Test
    public void testInMultithreadedWorker() throws Exception {
        class MyVerticle
        extends AbstractVerticle {
            MyVerticle() {
            }

            public void start() {
                try {
                    NetTest.this.server = this.vertx.createNetServer(new NetServerOptions());
                    NetTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    NetTest.this.client = this.vertx.createNetClient(new NetClientOptions());
                    NetTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                NetTest.this.testComplete();
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testContexts() throws Exception {
        ConcurrentHashSet contexts = new ConcurrentHashSet();
        AtomicInteger cnt = new AtomicInteger();
        AtomicReference serverConnectContext = new AtomicReference();
        this.server.connectHandler(sock -> {
            sock.handler(arg_0 -> ((NetSocket)sock).write(arg_0));
            ContextImpl serverContext = ((VertxInternal)this.vertx).getContext();
            if (serverConnectContext.get() != null) {
                this.assertSame(serverConnectContext.get(), serverContext);
            } else {
                serverConnectContext.set(serverContext);
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference listenContext = new AtomicReference();
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            listenContext.set(((VertxInternal)this.vertx).getContext());
            latch.countDown();
        });
        this.awaitLatch(latch);
        CountDownLatch latch2 = new CountDownLatch(1);
        int numConns = 10;
        for (int i = 0; i < numConns; ++i) {
            this.client.connect(1234, "localhost", arg_0 -> this.lambda$testContexts$159((Set)contexts, cnt, numConns, latch2, arg_0));
        }
        this.awaitLatch(latch2);
        this.server.close(arg_0 -> this.lambda$testContexts$160((Set)contexts, serverConnectContext, listenContext, arg_0));
        this.server = null;
        this.await();
    }

    @Test
    public void testReadStreamPauseResume() {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setAcceptBacklog(1).setPort(1234).setHost("localhost"));
        NetSocketStream socketStream = this.server.connectStream();
        AtomicBoolean paused = new AtomicBoolean();
        socketStream.handler(so -> {
            this.assertTrue(!paused.get());
            so.write("hello");
            so.close();
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            paused.set(true);
            socketStream.pause();
            this.client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                NetSocket so2 = (NetSocket)ar2.result();
                so2.handler(buffer -> this.fail());
                so2.closeHandler(v -> {
                    paused.set(false);
                    socketStream.resume();
                    this.client.connect(1234, "localhost", ar3 -> {
                        this.assertTrue(ar3.succeeded());
                        NetSocket so3 = (NetSocket)ar3.result();
                        Buffer buffer = Buffer.buffer();
                        so3.handler(arg_0 -> ((Buffer)buffer).appendBuffer(arg_0));
                        so3.closeHandler(v3 -> {
                            this.assertEquals("hello", buffer.toString("utf-8"));
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testNetSocketStreamCallbackIsAsync() {
        this.server = this.vertx.createNetServer(new NetServerOptions());
        AtomicInteger done = new AtomicInteger();
        NetSocketStream stream = this.server.connectStream();
        stream.handler(req -> {});
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        stream.endHandler(v -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            if (done.incrementAndGet() == 2) {
                this.testComplete();
            }
        });
        this.server.listen(ar -> {
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.assertNull(stack.get());
            ThreadLocal<Boolean> stack2 = new ThreadLocal<Boolean>();
            stack2.set(true);
            this.server.close(v -> {
                this.assertTrue(Vertx.currentContext().isEventLoopContext());
                this.assertNull(stack2.get());
                if (done.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
            stack2.set(null);
        });
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createNetServer(new NetServerOptions());
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.connectStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testInWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                NetTest.this.assertTrue(Context.isOnWorkerThread());
                Context context = Vertx.currentContext();
                NetServer server1 = this.vertx.createNetServer(new NetServerOptions().setHost("localhost").setPort(1234));
                server1.connectHandler(conn -> {
                    NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    NetTest.this.assertTrue(Context.isOnWorkerThread());
                    NetTest.this.assertSame(context, Vertx.currentContext());
                    conn.handler(arg_0 -> ((NetSocket)conn).write(arg_0));
                    conn.closeHandler(v -> NetTest.this.testComplete());
                }).listen(NetTest.this.onSuccess(s -> {
                    NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                    NetTest.this.assertTrue(Context.isOnWorkerThread());
                    NetTest.this.assertSame(context, Vertx.currentContext());
                    NetClient client = this.vertx.createNetClient();
                    client.connect(1234, "localhost", NetTest.this.onSuccess(res -> {
                        NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                        NetTest.this.assertTrue(Context.isOnWorkerThread());
                        NetTest.this.assertSame(context, Vertx.currentContext());
                        res.write("foo");
                        res.handler(buff -> {
                            NetTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                            NetTest.this.assertTrue(Context.isOnWorkerThread());
                            NetTest.this.assertSame(context, Vertx.currentContext());
                            res.close();
                        });
                    }));
                }));
            }
        }, new DeploymentOptions().setWorker(true));
        this.await();
    }

    private File setupFile(String testDir, String fileName, String content) throws Exception {
        File file = new File(testDir, fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.write(content);
        out.close();
        return file;
    }

    @Test
    public void testServerWorkerMissBufferWhenBufferArriveBeforeConnectCallback() throws Exception {
        int size = this.getOptions().getWorkerPoolSize();
        List<Context> workers = this.createWorkers(size + 1);
        CountDownLatch latch1 = new CountDownLatch(workers.size() - 1);
        workers.get(0).runOnContext(v -> {
            NetServer server = this.vertx.createNetServer();
            server.connectHandler(so -> so.handler(buf -> {
                this.assertEquals("hello", buf.toString());
                this.testComplete();
            }));
            server.listen(1234, ar -> {
                this.assertTrue(ar.succeeded());
                for (int i = 1; i < workers.size(); ++i) {
                    ((Context)workers.get(i)).runOnContext(v2 -> {
                        latch1.countDown();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    });
                }
            });
        });
        this.awaitLatch(latch1);
        NetClient client = this.vertx.createNetClient();
        client.connect(1234, "localhost", ar -> {
            this.assertTrue(ar.succeeded());
            NetSocket so = (NetSocket)ar.result();
            so.write(Buffer.buffer((String)"hello"));
        });
        this.await();
    }

    @Test
    public void testClientWorkerMissBufferWhenBufferArriveBeforeConnectCallback() throws Exception {
        int size = this.getOptions().getWorkerPoolSize();
        List<Context> workers = this.createWorkers(size + 1);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(size);
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> {
            try {
                this.awaitLatch(latch2);
            }
            catch (InterruptedException e) {
                this.fail(e.getMessage());
                return;
            }
            so.write(Buffer.buffer((String)"hello"));
        });
        server.listen(1234, ar -> {
            this.assertTrue(ar.succeeded());
            latch1.countDown();
        });
        this.awaitLatch(latch1);
        workers.get(0).runOnContext(v -> {
            NetClient client = this.vertx.createNetClient();
            client.connect(1234, "localhost", ar -> {
                this.assertTrue(ar.succeeded());
                NetSocket so = (NetSocket)ar.result();
                so.handler(buf -> {
                    this.assertEquals("hello", buf.toString());
                    this.testComplete();
                });
            });
            for (int i = 1; i < workers.size(); ++i) {
                ((Context)workers.get(i)).runOnContext(v2 -> {
                    latch2.countDown();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
            }
        });
        this.await();
    }

    @Test
    public void testHostVerificationHttpsNotMatching() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyStoreOptions(new JksOptions().setPath("tls/mim-server-keystore.jks").setPassword("wibble"));
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true).setHostnameVerificationAlgorithm("HTTPS");
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.failed());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testHostVerificationHttpsMatching() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setPort(1234).setHost("localhost").setSsl(true).setKeyStoreOptions(new JksOptions().setPath("tls/server-keystore.jks").setPassword("wibble"));
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setSsl(true).setTrustAll(true).setHostnameVerificationAlgorithm("HTTPS");
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                this.assertTrue(ar2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testNoLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging();
        this.assertFalse(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    @Test
    public void testServerLogging() throws Exception {
        this.server.close();
        this.server = this.vertx.createNetServer(new NetServerOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    @Test
    public void testClientLogging() throws Exception {
        this.client.close();
        this.client = this.vertx.createNetClient(new NetClientOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
    }

    private TestLoggerFactory testLogging() throws Exception {
        InternalLoggerFactory prev = InternalLoggerFactory.getDefaultFactory();
        TestLoggerFactory factory = new TestLoggerFactory();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)factory);
        try {
            this.server.connectHandler(so -> so.write("fizzbuzz").end());
            this.server.listen(1234, "localhost", this.onSuccess(v1 -> this.client.connect(1234, "localhost", this.onSuccess(so -> so.closeHandler(v2 -> this.testComplete())))));
            this.await();
        }
        finally {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)prev);
        }
        return factory;
    }

    @Test
    public void testWithSocks5Proxy() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setHost("localhost").setPort(1234);
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        this.proxy = new SocksProxy(null);
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        })));
        this.await();
    }

    @Test
    public void testWithSocks5ProxyAuth() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setHost("localhost").setPort(1234);
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS5).setPort(11080).setUsername("username").setPassword("username"));
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        this.proxy = new SocksProxy("username");
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        })));
        this.await();
    }

    @Test
    public void testWithHttpConnectProxy() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setHost("localhost").setPort(1234);
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setPort(13128));
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        this.proxy = new ConnectHttpProxy(null);
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        })));
        this.await();
    }

    @Test
    public void testWithSocks4aProxy() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setHost("localhost").setPort(1234);
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy(null);
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        })));
        this.await();
    }

    @Test
    public void testWithSocks4aProxyAuth() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setHost("localhost").setPort(1234);
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080).setUsername("username"));
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy("username");
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "localhost", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("localhost:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        })));
        this.await();
    }

    @Test
    public void testWithSocks4LocalResolver() {
        this.server.close();
        NetServerOptions options = new NetServerOptions().setHost("localhost").setPort(1234);
        NetServer server = this.vertx.createNetServer(options);
        NetClientOptions clientOptions = new NetClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.SOCKS4).setPort(11080));
        NetClient client = this.vertx.createNetClient(clientOptions);
        server.connectHandler(sock -> {});
        this.proxy = new Socks4Proxy(null);
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            client.connect(1234, "127.0.0.1", ar2 -> {
                if (ar2.failed()) {
                    log.warn((Object)"failed", ar2.cause());
                }
                this.assertTrue(ar2.succeeded());
                this.assertEquals("127.0.0.1:1234", this.proxy.getLastUri());
                this.testComplete();
            });
        })));
        this.await();
    }

    private /* synthetic */ void lambda$testContexts$160(Set contexts, AtomicReference serverConnectContext, AtomicReference listenContext, AsyncResult ar) {
        this.assertTrue(ar.succeeded());
        ContextImpl closeContext = ((VertxInternal)this.vertx).getContext();
        this.assertFalse(contexts.contains(closeContext));
        this.assertNotSame(serverConnectContext.get(), closeContext);
        this.assertFalse(contexts.contains(listenContext.get()));
        this.assertSame(serverConnectContext.get(), listenContext.get());
        this.testComplete();
    }

    private /* synthetic */ void lambda$testContexts$159(Set contexts, AtomicInteger cnt, int numConns, CountDownLatch latch2, AsyncResult conn) {
        contexts.add(((VertxInternal)this.vertx).getContext());
        if (cnt.incrementAndGet() == numConns) {
            this.assertEquals(numConns, contexts.size());
            latch2.countDown();
        }
    }

    private /* synthetic */ void lambda$testFanout$111(Set connections, NetSocket socket) {
        connections.add(socket.writeHandlerID());
        socket.handler(buffer -> {
            for (String actorID : connections) {
                this.vertx.eventBus().publish(actorID, buffer);
            }
        });
        socket.closeHandler(v -> connections.remove(socket.writeHandlerID()));
    }

    private static /* synthetic */ void lambda$testSharedServersRoundRobin$100(Set connectedServers, NetServer theServer, Map connectCount, CountDownLatch latchConns, NetSocket sock) {
        connectedServers.add(theServer);
        Integer cnt = (Integer)connectCount.get(theServer);
        int icnt = cnt == null ? 0 : cnt;
        connectCount.put(theServer, ++icnt);
        latchConns.countDown();
    }
}

