/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.test.core.ConnectHttpProxy;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import org.junit.Test;

public class ProxyErrorTest
extends VertxTestBase {
    private ConnectHttpProxy proxy = null;

    private void startProxy(int error, String username) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.proxy = new ConnectHttpProxy(username);
        this.proxy.setError(error);
        this.proxy.start(this.vertx, (Handler<Void>)((Handler)v -> latch.countDown()));
        latch.await();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.proxy != null) {
            this.proxy.stop();
        }
    }

    @Test
    public void testProxyError() throws Exception {
        this.startProxy(403, null);
        HttpClientOptions options = new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort()));
        HttpClient client = this.vertx.createHttpClient(options);
        client.getAbs("https://localhost/", resp -> this.fail()).exceptionHandler(e -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testProxyAuthFail() throws Exception {
        this.startProxy(0, "user");
        HttpClientOptions options = new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort()));
        HttpClient client = this.vertx.createHttpClient(options);
        client.getAbs("https://localhost/", resp -> this.fail()).exceptionHandler(e -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testProxyHostUnknown() throws Exception {
        this.startProxy(0, null);
        HttpClientOptions options = new HttpClientOptions().setProxyOptions(new ProxyOptions().setType(ProxyType.HTTP).setHost("localhost").setPort(this.proxy.getPort()));
        HttpClient client = this.vertx.createHttpClient(options);
        client.getAbs("https://unknown.hostname/", resp -> this.fail()).exceptionHandler(e -> this.testComplete()).end();
        this.await();
    }
}

