/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.it;

import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.logging.SLF4JLogDelegateFactory;
import io.vertx.core.spi.logging.LogDelegate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.impl.SimpleLogger;

public class SLF4JLogDelegateTest {
    @BeforeClass
    public static void initialize() throws IOException {
        System.setProperty("vertx.logger-delegate-factory-class-name", SLF4JLogDelegateFactory.class.getName());
        LoggerFactory.initialise();
    }

    @AfterClass
    public static void terminate() {
        System.clearProperty("vertx.logger-delegate-factory-class-name");
    }

    @Test
    public void testDelegateUnwrap() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-slf4j-logger");
        LogDelegate delegate = logger.getDelegate();
        Assert.assertNotNull((String)"Delegate is null", (Object)delegate);
        try {
            Logger unwrapped = (Logger)delegate.unwrap();
            Assert.assertNotNull((String)"Unwrapped is null", (Object)unwrapped);
        }
        catch (ClassCastException e) {
            Assert.fail((String)("Unexpected unwrapped type: " + e.getMessage()));
        }
    }

    @Test
    public void testInfo() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-slf4j-logger");
        String result = this.record(() -> logger.info((Object)"hello"));
        this.assertContains("[main] INFO my-slf4j-logger - hello", result);
        result = this.record(() -> logger.info((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("[main] INFO my-slf4j-logger - exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = this.record(() -> logger.info((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        this.assertContains("[main] INFO my-slf4j-logger - hello Paulo and Julien", result);
        result = this.record(() -> logger.info((Object)"hello {}", new Object[]{"vert.x"}));
        this.assertContains("[main] INFO my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.info((Object)"hello {} - {}", new Object[]{"vert.x"}));
        this.assertContains("[main] INFO my-slf4j-logger - hello vert.x - {}", result);
        result = this.record(() -> logger.info((Object)"hello {}", new Object[]{"vert.x", "foo"}));
        this.assertContains("[main] INFO my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.info((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("[main] INFO my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = this.record(() -> logger.info((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("[main] INFO my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    @Test
    public void testError() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-slf4j-logger");
        String result = this.record(() -> logger.error((Object)"hello"));
        this.assertContains("[main] ERROR my-slf4j-logger - hello", result);
        result = this.record(() -> logger.error((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("[main] ERROR my-slf4j-logger - exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = this.record(() -> logger.error((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        this.assertContains("[main] ERROR my-slf4j-logger - hello Paulo and Julien", result);
        result = this.record(() -> logger.error((Object)"hello {}", new Object[]{"vert.x"}));
        this.assertContains("[main] ERROR my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.error((Object)"hello {} - {}", new Object[]{"vert.x"}));
        this.assertContains("[main] ERROR my-slf4j-logger - hello vert.x - {}", result);
        result = this.record(() -> logger.error((Object)"hello {}", new Object[]{"vert.x", "foo"}));
        this.assertContains("[main] ERROR my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.error((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("[main] ERROR my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = this.record(() -> logger.error((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("[main] ERROR my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    private void assertContains(String expectedExcerpt, String object) {
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)object.contains(expectedExcerpt));
    }

    @Test
    public void testWarning() {
        io.vertx.core.logging.Logger logger = LoggerFactory.getLogger((String)"my-slf4j-logger");
        String result = this.record(() -> logger.warn((Object)"hello"));
        this.assertContains("[main] WARN my-slf4j-logger - hello", result);
        result = this.record(() -> logger.warn((Object)"exception", (Throwable)new NullPointerException()));
        Assert.assertTrue((boolean)result.contains("[main] WARN my-slf4j-logger - exception"));
        Assert.assertTrue((boolean)result.contains("java.lang.NullPointerException"));
        result = this.record(() -> logger.warn((Object)"hello {} and {}", new Object[]{"Paulo", "Julien"}));
        this.assertContains("[main] WARN my-slf4j-logger - hello Paulo and Julien", result);
        result = this.record(() -> logger.warn((Object)"hello {}", new Object[]{"vert.x"}));
        this.assertContains("[main] WARN my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.warn((Object)"hello {} - {}", new Object[]{"vert.x"}));
        this.assertContains("[main] WARN my-slf4j-logger - hello vert.x - {}", result);
        result = this.record(() -> logger.warn((Object)"hello {}", new Object[]{"vert.x", "foo"}));
        this.assertContains("[main] WARN my-slf4j-logger - hello vert.x", result);
        result = this.record(() -> logger.warn((Object)"{}, an exception has been thrown", (Throwable)new IllegalStateException(), new Object[]{"Luke"}));
        Assert.assertTrue((boolean)result.contains("[main] WARN my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
        result = this.record(() -> logger.warn((Object)"{}, an exception has been thrown", new Object[]{"Luke", new IllegalStateException()}));
        Assert.assertTrue((boolean)result.contains("[main] WARN my-slf4j-logger - Luke, an exception has been thrown"));
        Assert.assertTrue((boolean)result.contains("java.lang.IllegalStateException"));
    }

    private void setStream(PrintStream stream) {
        try {
            Field field = SimpleLogger.class.getDeclaredField("TARGET_STREAM");
            field.setAccessible(true);
            field.set(null, stream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String record(Runnable runnable) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream written = new PrintStream(stream);
        this.setStream(written);
        runnable.run();
        written.flush();
        String result = stream.toString();
        this.quiet(() -> {
            written.close();
            return null;
        });
        return result;
    }

    private void quiet(Callable<Void> action) {
        try {
            action.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

