/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import java.util.function.Function;

public interface AsyncResult<T> {
    public T result();

    public Throwable cause();

    public boolean succeeded();

    public boolean failed();

    default public <U> AsyncResult<U> map(final Function<T, U> mapper) {
        return new AsyncResult<U>(){

            @Override
            public U result() {
                if (this.succeeded()) {
                    return mapper.apply(AsyncResult.this.result());
                }
                return null;
            }

            @Override
            public Throwable cause() {
                return AsyncResult.this.cause();
            }

            @Override
            public boolean succeeded() {
                return AsyncResult.this.succeeded();
            }

            @Override
            public boolean failed() {
                return AsyncResult.this.failed();
            }
        };
    }

    default public <V> AsyncResult<V> map(final V value) {
        return new AsyncResult<V>(){

            @Override
            public V result() {
                if (this.succeeded()) {
                    return value;
                }
                return null;
            }

            @Override
            public Throwable cause() {
                return AsyncResult.this.cause();
            }

            @Override
            public boolean succeeded() {
                return AsyncResult.this.succeeded();
            }

            @Override
            public boolean failed() {
                return AsyncResult.this.failed();
            }
        };
    }
}

