/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher;

import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.annotations.CLIConfigurator;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import io.vertx.core.impl.launcher.commands.HelloCommand;
import io.vertx.core.spi.launcher.Command;
import io.vertx.core.spi.launcher.DefaultCommand;
import io.vertx.core.spi.launcher.ExecutionContext;
import java.io.File;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DefaultCommandTest {
    HelloCommand command = new HelloCommand();

    private CommandLine parse(CLI cli, String ... args) throws CLIException {
        return cli.parse(Arrays.asList(args));
    }

    @Test
    public void testCWD() throws CLIException {
        CLI cli = CLIConfigurator.define(((Object)((Object)this.command)).getClass());
        CommandLine evaluatedCLI = this.parse(cli, "--name=vert.x");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)((Object)this.command));
        Assertions.assertThat((File)this.command.getCwd()).isEqualTo((Object)new File("."));
        evaluatedCLI = this.parse(cli, "--cwd=target", "--name=vert.x");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)((Object)this.command));
        Assertions.assertThat((File)this.command.getCwd()).isEqualTo((Object)new File("target"));
    }

    @Test
    public void testSystemProperties() throws CLIException {
        CLI cli = CLIConfigurator.define(((Object)((Object)this.command)).getClass());
        VertxCommandLauncher launcher = new VertxCommandLauncher();
        CommandLine evaluatedCLI = this.parse(cli, "--name=vert.x", "-Dfoo=bar", "--systemProp=x=y");
        CLIConfigurator.inject((CommandLine)evaluatedCLI, (Object)((Object)this.command));
        this.command.setUp(new ExecutionContext((Command)this.command, launcher, evaluatedCLI));
        Assertions.assertThat((String)System.getProperty("foo")).isEqualToIgnoringCase((CharSequence)"bar");
        Assertions.assertThat((String)System.getProperty("x")).isEqualToIgnoringCase((CharSequence)"y");
        this.command.tearDown();
        Assertions.assertThat((String)System.getProperty("foo")).isEqualToIgnoringCase((CharSequence)"bar");
        Assertions.assertThat((String)System.getProperty("x")).isEqualToIgnoringCase((CharSequence)"y");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThatCLINeedsAName() {
        CLIConfigurator.define(MyCommandWithoutName.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThatCLINeedsANonEmptyName() {
        CLIConfigurator.define(MyCommandWithoutEmptyName.class);
    }

    @Name(value="")
    public static class MyCommandWithoutEmptyName
    extends DefaultCommand {
        public void run() throws CLIException {
        }
    }

    public static class MyCommandWithoutName
    extends DefaultCommand {
        public void run() throws CLIException {
        }
    }
}

