/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class BlockedThreadCheckerTest
extends VertxTestBase {
    @Test
    public void testBlockCheckDefault() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(6000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        this.vertx.deployVerticle((Verticle)verticle);
        this.await();
    }

    @Test
    public void testBlockCheckExceptionTimeLimit() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(2000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxEventLoopExecuteTime(1000000000L);
        vertxOptions.setWarningExceptionTime(1000000000L);
        Vertx newVertx = this.vertx(vertxOptions);
        newVertx.deployVerticle((Verticle)verticle);
        this.await();
    }

    @Test
    public void testBlockCheckWorker() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(2000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxWorkerExecuteTime(1000000000L);
        vertxOptions.setWarningExceptionTime(1000000000L);
        Vertx newVertx = this.vertx(vertxOptions);
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setWorker(true);
        newVertx.deployVerticle((Verticle)verticle, deploymentOptions);
        this.await();
    }

    @Test
    public void testBlockCheckExecuteBlocking() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                this.vertx.executeBlocking(fut -> {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        BlockedThreadCheckerTest.this.fail();
                    }
                    BlockedThreadCheckerTest.this.testComplete();
                }, ar -> {});
            }
        };
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxWorkerExecuteTime(1000000000L);
        vertxOptions.setWarningExceptionTime(1000000000L);
        Vertx newVertx = this.vertx(vertxOptions);
        newVertx.deployVerticle((Verticle)verticle);
        this.await();
    }
}

