/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Test;

public class FutureTest
extends VertxTestBase {
    @Test
    public void testCreateWithHandler() {
        AtomicInteger count = new AtomicInteger();
        AtomicReference ref = new AtomicReference();
        Future f2 = Future.future(f1 -> {
            this.assertFalse(f1.isComplete());
            count.incrementAndGet();
            ref.set(f1);
        });
        this.assertSame(f2, ref.get());
        this.assertEquals(1L, count.get());
        new Checker(f2).assertNotCompleted();
        ref.set(null);
        count.set(0);
        f2 = Future.future(f1 -> {
            count.incrementAndGet();
            ref.set(f1);
            f1.complete((Object)"the-value");
        });
        this.assertSame(f2, ref.get());
        this.assertEquals(1L, count.get());
        new Checker<String>(f2).assertSucceeded("the-value");
        ref.set(null);
        count.set(0);
        RuntimeException cause = new RuntimeException();
        f2 = Future.future(f1 -> {
            count.incrementAndGet();
            ref.set(f1);
            f1.fail((Throwable)cause);
        });
        this.assertSame(f2, ref.get());
        this.assertEquals(1L, count.get());
        new Checker(f2).assertFailed(cause);
        try {
            Future.future(f -> {
                throw cause;
            });
            this.fail();
        }
        catch (Exception e) {
            this.assertSame(cause, e);
        }
    }

    @Test
    public void testStateAfterCompletion() {
        Object foo = new Object();
        Future future = Future.succeededFuture((Object)foo);
        this.assertTrue(future.succeeded());
        this.assertFalse(future.failed());
        this.assertTrue(future.isComplete());
        this.assertEquals(foo, future.result());
        this.assertNull(future.cause());
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        this.assertFalse(future.succeeded());
        this.assertTrue(future.failed());
        this.assertTrue(future.isComplete());
        this.assertNull(future.result());
        this.assertEquals(cause, future.cause());
    }

    @Test
    public void testSetResultOnCompletedFuture() {
        ArrayList<Future> futures = new ArrayList<Future>();
        futures.add(Future.succeededFuture());
        futures.add(Future.succeededFuture());
        futures.add(Future.succeededFuture((Object)new Object()));
        futures.add(Future.succeededFuture((Object)new Object()));
        futures.add(Future.failedFuture((Throwable)new Exception()));
        futures.add(Future.failedFuture((Throwable)new Exception()));
        for (Future future : futures) {
            try {
                future.complete(new Object());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.assertFalse(future.tryComplete(new Object()));
            try {
                future.complete(null);
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.assertFalse(future.tryComplete(null));
            try {
                future.fail((Throwable)new Exception());
                this.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.assertFalse(future.tryFail((Throwable)new Exception()));
        }
    }

    @Test
    public void testCallSetHandlerBeforeCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Future future = Future.future();
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertFalse(called.get());
        future.complete(null);
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        future = Future.future();
        future.setHandler(result -> {
            called.set(true);
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
        });
        this.assertFalse(called.get());
        future.complete(foo);
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        future = Future.future();
        future.setHandler(result -> {
            called.set(true);
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
        });
        this.assertFalse(called.get());
        future.fail((Throwable)cause);
        this.assertTrue(called.get());
    }

    @Test
    public void testCallSetHandlerAfterCompletion() {
        AtomicBoolean called = new AtomicBoolean();
        Future future = Future.succeededFuture();
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Object foo = new Object();
        future = Future.succeededFuture((Object)foo);
        future.setHandler(result -> {
            this.assertTrue(result.succeeded());
            this.assertFalse(result.failed());
            this.assertEquals(foo, result.result());
            this.assertEquals(null, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
        called.set(false);
        Exception cause = new Exception();
        future = Future.failedFuture((Throwable)cause);
        future.setHandler(result -> {
            this.assertFalse(result.succeeded());
            this.assertTrue(result.failed());
            this.assertEquals(null, result.result());
            this.assertEquals(cause, result.cause());
            called.set(true);
        });
        this.assertTrue(called.get());
    }

    @Test
    public void testResolveFutureToHandler() {
        Consumer<Handler> consumer = handler -> handler.handle((Object)Future.succeededFuture((Object)"the-result"));
        Future fut = Future.future();
        consumer.accept((Handler)fut);
        this.assertTrue(fut.isComplete());
        this.assertTrue(fut.succeeded());
        this.assertEquals("the-result", fut.result());
    }

    @Test
    public void testFailFutureToHandler() {
        Throwable cause = new Throwable();
        Consumer<Handler> consumer = handler -> handler.handle((Object)Future.failedFuture((Throwable)cause));
        Future fut = Future.future();
        consumer.accept((Handler)fut);
        this.assertTrue(fut.isComplete());
        this.assertTrue(fut.failed());
        this.assertEquals(cause, fut.cause());
    }

    @Test
    public void testCreateFailedWithNullFailure() {
        Future future = Future.failedFuture((Throwable)null);
        Checker checker = new Checker(future);
        NoStackTraceThrowable failure = (NoStackTraceThrowable)checker.assertFailed();
        this.assertNull(failure.getMessage());
    }

    @Test
    public void testFailureFutureWithNullFailure() {
        Future future = Future.future();
        future.fail((Throwable)null);
        Checker checker = new Checker(future);
        NoStackTraceThrowable failure = (NoStackTraceThrowable)checker.assertFailed();
        this.assertNull(failure.getMessage());
    }

    @Test
    public void testCompositeComplete() {
        CompositeFuture composite = CompositeFuture.all((Future)Future.future(), (Future)Future.future());
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        composite.complete((Object)composite);
        checker.assertSucceeded(composite);
        composite = CompositeFuture.all((Future)Future.future(), (Future)Future.future());
        checker = new Checker(composite);
        composite.complete();
        checker.assertSucceeded(composite);
    }

    @Test
    public void testCompositeFail() {
        Throwable cause = new Throwable();
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = CompositeFuture.all((Future)f1, (Future)f2);
        Checker checker = new Checker(composite);
        composite.fail(cause);
        checker.assertFailed(cause);
        f1.complete();
        f2.complete();
        checker.assertFailed(cause);
    }

    @Test
    public void testAllSucceeded() {
        this.testAllSucceeded(CompositeFuture::all);
    }

    @Test
    public void testAllSucceededWithList() {
        this.testAllSucceeded((f1, f2) -> CompositeFuture.all(Arrays.asList(f1, f2)));
    }

    private void testAllSucceeded(BiFunction<Future<String>, Future<Integer>, CompositeFuture> all) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = all.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        this.assertEquals(null, composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        f1.complete((Object)"something");
        checker.assertNotCompleted();
        this.assertEquals("something", composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        f2.complete((Object)3);
        checker.assertSucceeded(composite);
        this.assertEquals("something", composite.resultAt(0));
        this.assertEquals(3L, ((Integer)composite.resultAt(1)).intValue());
    }

    @Test
    public void testAllWithEmptyList() {
        CompositeFuture composite = CompositeFuture.all(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testAllFailed() {
        this.testAllFailed(CompositeFuture::all);
    }

    @Test
    public void testAllFailedWithList() {
        this.testAllFailed((f1, f2) -> CompositeFuture.all(Arrays.asList(f1, f2)));
    }

    private void testAllFailed(BiFunction<Future<String>, Future<Integer>, CompositeFuture> all) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = all.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        f1.complete((Object)"s");
        Exception cause = new Exception();
        f2.fail((Throwable)cause);
        checker.assertFailed(cause);
        this.assertEquals("s", composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
    }

    @Test
    public void testAllLargeList() {
        this.testAllLargeList(63);
        this.testAllLargeList(64);
        this.testAllLargeList(65);
        this.testAllLargeList(100);
    }

    private void testAllLargeList(int size) {
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < size; ++i) {
            list.add(Future.succeededFuture());
        }
        CompositeFuture composite = CompositeFuture.all(list);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertSucceeded(composite);
        for (int i = 0; i < size; ++i) {
            int j;
            list.clear();
            Exception cause = new Exception();
            for (j = 0; j < size; ++j) {
                list.add(i == j ? Future.failedFuture((Throwable)cause) : Future.succeededFuture());
            }
            composite = CompositeFuture.all(list);
            checker = new Checker(composite);
            checker.assertFailed(cause);
            for (j = 0; j < size; ++j) {
                if (i == j) {
                    this.assertTrue(composite.failed(j));
                    continue;
                }
                this.assertTrue(composite.succeeded(j));
            }
        }
    }

    @Test
    public void testAnySucceeded1() {
        this.testAnySucceeded1(CompositeFuture::any);
    }

    @Test
    public void testAnySucceeded1WithList() {
        this.testAnySucceeded1((f1, f2) -> CompositeFuture.any(Arrays.asList(f1, f2)));
    }

    private void testAnySucceeded1(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        this.assertEquals(null, composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        f1.complete((Object)"something");
        checker.assertSucceeded(composite);
        f2.complete((Object)3);
        checker.assertSucceeded(composite);
    }

    @Test
    public void testAnyWithEmptyList() {
        CompositeFuture composite = CompositeFuture.any(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testAnySucceeded2() {
        this.testAnySucceeded2(CompositeFuture::any);
    }

    @Test
    public void testAnySucceeded2WithList() {
        this.testAnySucceeded2(CompositeFuture::any);
    }

    private void testAnySucceeded2(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        f1.fail("failure");
        checker.assertNotCompleted();
        f2.complete((Object)3);
        checker.assertSucceeded(composite);
    }

    @Test
    public void testAnyFailed() {
        this.testAnyFailed(CompositeFuture::any);
    }

    @Test
    public void testAnyFailedWithList() {
        this.testAnyFailed((f1, f2) -> CompositeFuture.any(Arrays.asList(f1, f2)));
    }

    private void testAnyFailed(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        f1.fail("failure");
        checker.assertNotCompleted();
        Exception cause = new Exception();
        f2.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testAnyLargeList() {
        this.testAnyLargeList(63);
        this.testAnyLargeList(64);
        this.testAnyLargeList(65);
        this.testAnyLargeList(100);
    }

    private void testAnyLargeList(int size) {
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < size; ++i) {
            list.add(Future.failedFuture((Throwable)new Exception()));
        }
        CompositeFuture composite = CompositeFuture.any(list);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertFailed();
        for (int i = 0; i < size; ++i) {
            int j;
            list.clear();
            for (j = 0; j < size; ++j) {
                list.add(i == j ? Future.succeededFuture() : Future.failedFuture((Throwable)new RuntimeException()));
            }
            composite = CompositeFuture.any(list);
            checker = new Checker(composite);
            checker.assertSucceeded(composite);
            for (j = 0; j < size; ++j) {
                if (i == j) {
                    this.assertTrue(composite.succeeded(j));
                    continue;
                }
                this.assertTrue(composite.failed(j));
            }
        }
    }

    @Test
    public void testJoinSucceeded() {
        this.testJoinSucceeded(CompositeFuture::join);
    }

    @Test
    public void testJoinSucceededWithList() {
        this.testJoinSucceeded((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinSucceeded(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker<CompositeFuture> checker = new Checker<CompositeFuture>((Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        f1.complete((Object)"foo");
        checker.assertNotCompleted();
        f2.complete();
        checker.assertSucceeded(composite);
    }

    @Test
    public void testJoinFailed1() {
        this.testJoinFailed1(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed1WithList() {
        this.testJoinFailed1((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed1(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        checker.assertNotCompleted();
        f1.complete((Object)"foo");
        checker.assertNotCompleted();
        Throwable cause = new Throwable();
        f2.fail(cause);
        this.assertSame(checker.assertFailed(), cause);
    }

    @Test
    public void testJoinFailed2() {
        this.testJoinFailed2(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed2WithList() {
        this.testJoinFailed2((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed2(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        checker.assertNotCompleted();
        Throwable cause = new Throwable();
        f1.fail(cause);
        checker.assertNotCompleted();
        f2.complete((Object)10);
        this.assertSame(cause, checker.assertFailed());
    }

    @Test
    public void testJoinFailed3() {
        this.testJoinFailed3(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed3WithList() {
        this.testJoinFailed3((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed3(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        Checker checker = new Checker(composite);
        checker.assertNotCompleted();
        Throwable cause1 = new Throwable();
        f1.fail(cause1);
        checker.assertNotCompleted();
        Throwable cause2 = new Throwable();
        f2.fail(cause2);
        this.assertSame(cause1, checker.assertFailed());
    }

    @Test
    public void testJoinWithEmptyList() {
        CompositeFuture composite = CompositeFuture.join(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testCompositeFutureToList() {
        Future f1 = Future.future();
        Future f2 = Future.future();
        CompositeFuture composite = CompositeFuture.all((Future)f1, (Future)f2);
        this.assertEquals(Arrays.asList(null, null), composite.list());
        f1.complete((Object)"foo");
        this.assertEquals(Arrays.asList("foo", null), composite.list());
        f2.complete((Object)4);
        this.assertEquals(Arrays.asList("foo", 4), composite.list());
    }

    @Test
    public void testComposeSuccessToSuccess() {
        Future f1 = Future.future();
        Future f2 = Future.future();
        Checker<Integer> checker = new Checker<Integer>(f2);
        f1.compose(string -> f2.complete((Object)string.length()), f2);
        checker.assertNotCompleted();
        f1.complete((Object)"abcdef");
        checker.assertSucceeded(6);
        AtomicReference ref = new AtomicReference();
        Future c = Future.future();
        Future f3 = Future.future();
        Future f4 = f3.compose(string -> {
            ref.set(string);
            return c;
        });
        checker = new Checker(f4);
        f3.complete((Object)"abcdef");
        checker.assertNotCompleted();
        this.assertEquals("abcdef", ref.get());
        c.complete((Object)6);
        checker.assertSucceeded(6);
    }

    @Test
    public void testComposeSuccessToFailure() {
        Throwable cause = new Throwable();
        AtomicReference ref = new AtomicReference();
        Future c = Future.future();
        Future f3 = Future.future();
        Future f4 = f3.compose(string -> {
            ref.set(string);
            return c;
        });
        Checker checker = new Checker(f4);
        f3.complete((Object)"abcdef");
        c.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeFailure() {
        Exception cause = new Exception();
        Future f1 = Future.future();
        Future f2 = Future.future();
        Checker checker = new Checker(f2);
        f1.compose(string -> f2.complete((Object)string.length()), f2);
        f1.fail((Throwable)cause);
        checker.assertFailed(cause);
        Future f3 = Future.future();
        Future f4 = f3.compose(string -> Future.succeededFuture((Object)string.length()));
        checker = new Checker(f4);
        f3.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeFails() {
        RuntimeException cause = new RuntimeException();
        Future f1 = Future.future();
        Future f2 = Future.future();
        Checker checker = new Checker(f2);
        f1.compose(string -> {
            throw cause;
        }, f2);
        f1.complete((Object)"foo");
        checker.assertFailed(cause);
        Future f3 = Future.future();
        Future f4 = f3.compose(string -> {
            throw cause;
        });
        checker = new Checker(f4);
        f3.complete((Object)"foo");
        checker.assertFailed(cause);
    }

    @Test
    public void testComposeFailsAfterCompletion() {
        Future f1 = Future.future();
        Future f2 = Future.future();
        Checker<Integer> checker = new Checker<Integer>(f2);
        RuntimeException cause = new RuntimeException();
        f1.compose(string -> {
            f2.complete((Object)46);
            throw cause;
        }, f2);
        try {
            f1.complete((Object)"foo");
            this.fail();
        }
        catch (Exception e) {
            this.assertEquals(cause, e);
        }
        checker.assertSucceeded(46);
    }

    @Test
    public void testComposeWithNullFunction() {
        Future fut = Future.future();
        try {
            fut.compose((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testMapSuccess() {
        Future fut = Future.future();
        Future mapped = fut.map(Object::toString);
        Checker<String> checker = new Checker<String>(mapped);
        checker.assertNotCompleted();
        fut.complete((Object)3);
        checker.assertSucceeded("3");
    }

    @Test
    public void testMapFailure() {
        Throwable cause = new Throwable();
        Future fut = Future.future();
        Future mapped = fut.map(Object::toString);
        Checker checker = new Checker(mapped);
        checker.assertNotCompleted();
        fut.fail(cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapFails() {
        RuntimeException cause = new RuntimeException();
        Future fut = Future.future();
        Future mapped = fut.map(i -> {
            throw cause;
        });
        Checker checker = new Checker(mapped);
        fut.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testMapWithNullFunction() {
        Future fut = Future.future();
        try {
            fut.map((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.asyncResult(fut).map((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testMapEmpty() {
        Future fut = Future.future();
        Future mapped = fut.mapEmpty();
        Checker checker = new Checker(mapped);
        checker.assertNotCompleted();
        fut.complete((Object)3);
        checker.assertSucceeded(null);
    }

    @Test
    public void testRecoverSuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Future f = Future.future();
        Future r = f.recover(t -> {
            called.set(true);
            throw new AssertionError();
        });
        Checker<String> checker = new Checker<String>(r);
        checker.assertNotCompleted();
        f.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testRecoverFailureWithSuccess() {
        Future f = Future.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        Checker<String> checker = new Checker<String>(r);
        checker.assertNotCompleted();
        f.fail("recovered");
        checker.assertSucceeded("recovered");
    }

    @Test
    public void testRecoverFailureWithFailure() {
        Throwable cause = new Throwable();
        Future f = Future.future();
        Future r = f.recover(t -> Future.failedFuture((Throwable)cause));
        Checker checker = new Checker(r);
        checker.assertNotCompleted();
        f.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testRecoverFailureFails() {
        RuntimeException cause = new RuntimeException("throw");
        Future f = Future.future();
        Future r = f.recover(t -> {
            throw cause;
        });
        Checker checker = new Checker(r);
        checker.assertNotCompleted();
        f.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testRecoverWithNullFunction() {
        Future fut = Future.future();
        try {
            fut.recover(null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testOtherwiseSuccessWithSuccess() {
        AtomicBoolean called = new AtomicBoolean();
        Future f = Future.future();
        Future r = f.otherwise(t -> {
            called.set(true);
            throw new AssertionError();
        });
        Checker<String> checker = new Checker<String>(r);
        checker.assertNotCompleted();
        f.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        checker.assertSucceeded("yeah");
        this.assertFalse(called.get());
    }

    @Test
    public void testOtherwiseFailureWithSuccess() {
        Future f = Future.future();
        Future r = f.otherwise(t -> t.getMessage());
        Checker<String> checker = new Checker<String>(r);
        checker.assertNotCompleted();
        f.fail("recovered");
        checker.assertSucceeded("recovered");
    }

    @Test
    public void testOtherwiseFails() {
        RuntimeException cause = new RuntimeException("throw");
        Future f = Future.future();
        Future r = f.otherwise(t -> {
            throw cause;
        });
        Checker checker = new Checker(r);
        checker.assertNotCompleted();
        f.fail("recovered");
        checker.assertFailed(cause);
    }

    @Test
    public void testDefaultCompleter() {
        AsyncResult<Object> succeededAsyncResult = new AsyncResult<Object>(){
            Object result = new Object();

            public Object result() {
                return this.result;
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                return true;
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public <U> AsyncResult<U> map(Function<Object, U> mapper) {
                throw new UnsupportedOperationException();
            }

            public <V> AsyncResult<V> map(V value) {
                throw new UnsupportedOperationException();
            }
        };
        AsyncResult<Object> failedAsyncResult = new AsyncResult<Object>(){
            Throwable cause = new Throwable();

            public Object result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                return this.cause;
            }

            public boolean succeeded() {
                return false;
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public <U> AsyncResult<U> map(Function<Object, U> mapper) {
                throw new UnsupportedOperationException();
            }

            public <V> AsyncResult<V> map(V value) {
                throw new UnsupportedOperationException();
            }
        };
        class DefaultCompleterTestFuture<T>
        implements Future<T> {
            boolean succeeded;
            boolean failed;
            T result;
            Throwable cause;

            DefaultCompleterTestFuture() {
            }

            public boolean isComplete() {
                throw new UnsupportedOperationException();
            }

            public Future<T> setHandler(Handler<AsyncResult<T>> handler) {
                throw new UnsupportedOperationException();
            }

            public void complete(T result) {
                if (!this.tryComplete(result)) {
                    throw new IllegalStateException();
                }
            }

            public void complete() {
                if (!this.tryComplete()) {
                    throw new IllegalStateException();
                }
            }

            public void fail(Throwable cause) {
                if (!this.tryFail(cause)) {
                    throw new IllegalStateException();
                }
            }

            public void fail(String failureMessage) {
                if (!this.tryFail(failureMessage)) {
                    throw new IllegalStateException();
                }
            }

            public boolean tryComplete(T result) {
                if (this.succeeded || this.failed) {
                    return false;
                }
                this.succeeded = true;
                this.result = result;
                return true;
            }

            public boolean tryComplete() {
                throw new UnsupportedOperationException();
            }

            public boolean tryFail(Throwable cause) {
                if (this.succeeded || this.failed) {
                    return false;
                }
                this.failed = true;
                this.cause = cause;
                return true;
            }

            public boolean tryFail(String failureMessage) {
                throw new UnsupportedOperationException();
            }

            public T result() {
                throw new UnsupportedOperationException();
            }

            public Throwable cause() {
                throw new UnsupportedOperationException();
            }

            public boolean succeeded() {
                throw new UnsupportedOperationException();
            }

            public boolean failed() {
                throw new UnsupportedOperationException();
            }

            public void handle(AsyncResult<T> asyncResult) {
                if (asyncResult.succeeded()) {
                    this.complete(asyncResult.result());
                } else {
                    this.fail(asyncResult.cause());
                }
            }
        }
        DefaultCompleterTestFuture successFuture = new DefaultCompleterTestFuture();
        successFuture.completer().handle((Object)succeededAsyncResult);
        this.assertTrue(successFuture.succeeded);
        this.assertEquals(succeededAsyncResult.result(), successFuture.result);
        DefaultCompleterTestFuture failureFuture = new DefaultCompleterTestFuture();
        failureFuture.completer().handle((Object)failedAsyncResult);
        this.assertTrue(failureFuture.failed);
        this.assertEquals(failedAsyncResult.cause(), failureFuture.cause);
    }

    @Test
    public void testUncompletedAsyncResultMap() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        this.assertNull(map1.result());
        this.assertNull(map1.cause());
        this.assertNull(map2.result());
        this.assertNull(map2.cause());
    }

    @Test
    public void testSucceededAsyncResultMap() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        f.complete((Object)"foobar");
        this.assertEquals(6L, ((Integer)map1.result()).intValue());
        this.assertNull(map1.cause());
        this.assertEquals(17L, ((Integer)map2.result()).intValue());
        this.assertNull(map2.cause());
    }

    @Test
    public void testFailedAsyncResultMap() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map1 = res.map(String::length);
        AsyncResult map2 = res.map((Object)17);
        Throwable cause = new Throwable();
        f.fail(cause);
        this.assertNull(map1.result());
        this.assertSame(cause, map1.cause());
        this.assertNull(map2.result());
        this.assertSame(cause, map2.cause());
    }

    @Test
    public void testAsyncResultMapEmpty() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        AsyncResult map = res.mapEmpty();
        f.complete((Object)"foobar");
        this.assertNull(null, map.result());
        this.assertNull(map.cause());
    }

    @Test
    public void testSucceededFutureRecover() {
        Future f = Future.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        f.complete((Object)"yeah");
        this.assertTrue(r.succeeded());
        this.assertEquals(r.result(), "yeah");
    }

    @Test
    public void testFailedFutureRecover() {
        Future f = Future.future();
        Future r = f.recover(t -> Future.succeededFuture((Object)t.getMessage()));
        f.fail("recovered");
        this.assertTrue(r.succeeded());
        this.assertEquals(r.result(), "recovered");
    }

    @Test
    public void testFailedMapperFutureRecover() {
        Future f = Future.future();
        Future r = f.recover(t -> {
            throw new RuntimeException("throw");
        });
        f.fail("recovered");
        this.assertTrue(r.failed());
        this.assertEquals(r.cause().getMessage(), "throw");
    }

    @Test
    public void testUncompletedAsyncResultOtherwise() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        this.testUncompletedAsyncResultOtherwise(res);
    }

    @Test
    public void testUncompletedFutureOtherwise() {
        Future f = Future.future();
        this.testUncompletedAsyncResultOtherwise((AsyncResult<String>)f);
    }

    private void testUncompletedAsyncResultOtherwise(AsyncResult<String> res) {
        AsyncResult ar1 = res.otherwise((Object)"something-else");
        this.assertFalse(ar1.succeeded());
        this.assertFalse(ar1.failed());
        this.assertNull(ar1.result());
        this.assertNull(ar1.cause());
    }

    @Test
    public void testUncompletedAsyncResultOtherwiseApplyFunction() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        this.testUncompletedOtherwiseApplyFunction(res);
    }

    @Test
    public void testUncompletedFutureOtherwiseApplyFunction() {
        Future f = Future.future();
        this.testUncompletedOtherwiseApplyFunction((AsyncResult<String>)f);
    }

    private void testUncompletedOtherwiseApplyFunction(AsyncResult<String> res) {
        AsyncResult ar1 = res.otherwise(Throwable::getMessage);
        this.assertFalse(ar1.succeeded());
        this.assertFalse(ar1.failed());
        this.assertNull(ar1.result());
        this.assertNull(ar1.cause());
    }

    @Test
    public void testSucceededAsyncResultOtherwise() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        this.testSucceededOtherwise(res, (Future<String>)f);
    }

    @Test
    public void testSucceededFutureOtherwise() {
        Future f = Future.future();
        this.testSucceededOtherwise((AsyncResult<String>)f, (Future<String>)f);
    }

    private void testSucceededOtherwise(AsyncResult<String> res, Future<String> f) {
        AsyncResult ar = res.otherwise(Throwable::getMessage);
        f.complete((Object)"foobar");
        this.assertTrue(ar.succeeded());
        this.assertFalse(ar.failed());
        this.assertEquals("foobar", ar.result());
        this.assertNull(ar.cause());
    }

    @Test
    public void testSucceededAsyncResultOtherwiseApplyFunction() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        this.testSucceededOtherwiseApplyFunction(res, (Future<String>)f);
    }

    @Test
    public void testSucceededFutureOtherwiseApplyFunction() {
        Future f = Future.future();
        this.testSucceededOtherwiseApplyFunction((AsyncResult<String>)f, (Future<String>)f);
    }

    private void testSucceededOtherwiseApplyFunction(AsyncResult<String> res, Future<String> f) {
        AsyncResult ar = res.otherwise((Object)"whatever");
        f.complete((Object)"foobar");
        this.assertTrue(ar.succeeded());
        this.assertFalse(ar.failed());
        this.assertEquals("foobar", ar.result());
        this.assertNull(ar.cause());
    }

    @Test
    public void testFailedAsyncResultOtherwise() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        this.testFailedOtherwise(res, (Future<String>)f);
    }

    @Test
    public void testFailedFutureOtherwise() {
        Future f = Future.future();
        this.testFailedOtherwise((AsyncResult<String>)f, (Future<String>)f);
    }

    private void testFailedOtherwise(AsyncResult<String> res, Future<String> f) {
        AsyncResult map1 = res.otherwise((Object)"something-else");
        Throwable cause = new Throwable("the-failure");
        f.fail(cause);
        this.assertTrue(map1.succeeded());
        this.assertFalse(map1.failed());
        this.assertEquals("something-else", map1.result());
        this.assertNull(map1.cause());
    }

    @Test
    public void testFailedAsyncResultOtherwiseApplyFunction() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        this.testFailedOtherwiseApplyFunction(res, (Future<String>)f);
    }

    @Test
    public void testFailedFutureOtherwiseApplyFunction() {
        Future f = Future.future();
        this.testFailedOtherwiseApplyFunction((AsyncResult<String>)f, (Future<String>)f);
    }

    private void testFailedOtherwiseApplyFunction(AsyncResult<String> res, Future<String> f) {
        AsyncResult map1 = res.otherwise(Throwable::getMessage);
        Throwable cause = new Throwable("the-failure");
        f.fail(cause);
        this.assertTrue(map1.succeeded());
        this.assertFalse(map1.failed());
        this.assertEquals("the-failure", map1.result());
        this.assertNull(map1.cause());
    }

    @Test
    public void testOtherwiseWithNullFunction() {
        Future fut = Future.future();
        try {
            fut.otherwise((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.asyncResult(fut).otherwise((Function)null);
            this.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAsyncResultOtherwiseEmpty() {
        Future f = Future.future();
        AsyncResult res = this.asyncResult(f);
        this.testOtherwiseEmpty(res, (Future<String>)f);
    }

    @Test
    public void testFutureOtherwiseEmpty() {
        Future f = Future.future();
        this.testOtherwiseEmpty((AsyncResult<String>)f, (Future<String>)f);
    }

    private void testOtherwiseEmpty(AsyncResult<String> res, Future<String> f) {
        AsyncResult otherwise = res.otherwiseEmpty();
        Throwable cause = new Throwable("the-failure");
        f.fail(cause);
        this.assertTrue(otherwise.succeeded());
        this.assertFalse(otherwise.failed());
        this.assertEquals(null, otherwise.result());
        this.assertNull(otherwise.cause());
    }

    private <T> AsyncResult<T> asyncResult(final Future<T> fut) {
        return new AsyncResult<T>(){

            public T result() {
                return fut.result();
            }

            public Throwable cause() {
                return fut.cause();
            }

            public boolean succeeded() {
                return fut.succeeded();
            }

            public boolean failed() {
                return fut.failed();
            }
        };
    }

    class Checker<T> {
        private final Future<T> future;
        private final AtomicReference<AsyncResult<T>> result = new AtomicReference();
        private final AtomicInteger count = new AtomicInteger();

        Checker(Future<T> future) {
            future.setHandler(ar -> {
                this.count.incrementAndGet();
                this.result.set((AsyncResult<T>)ar);
            });
            this.future = future;
        }

        void assertNotCompleted() {
            FutureTest.this.assertFalse(this.future.isComplete());
            FutureTest.this.assertFalse(this.future.succeeded());
            FutureTest.this.assertFalse(this.future.failed());
            FutureTest.this.assertNull(this.future.cause());
            FutureTest.this.assertNull(this.future.result());
            FutureTest.this.assertEquals(0L, this.count.get());
            FutureTest.this.assertNull(this.result.get());
        }

        void assertSucceeded(T expected) {
            FutureTest.this.assertTrue(this.future.isComplete());
            FutureTest.this.assertTrue(this.future.succeeded());
            FutureTest.this.assertFalse(this.future.failed());
            FutureTest.this.assertNull(this.future.cause());
            FutureTest.this.assertEquals(expected, this.future.result());
            FutureTest.this.assertEquals(1L, this.count.get());
            AsyncResult<T> ar = this.result.get();
            FutureTest.this.assertNotNull(ar);
            FutureTest.this.assertTrue(ar.succeeded());
            FutureTest.this.assertFalse(ar.failed());
            FutureTest.this.assertNull(ar.cause());
            FutureTest.this.assertEquals(expected, this.future.result());
        }

        void assertFailed(Throwable expected) {
            FutureTest.this.assertEquals(expected, this.assertFailed());
        }

        Throwable assertFailed() {
            FutureTest.this.assertTrue(this.future.isComplete());
            FutureTest.this.assertFalse(this.future.succeeded());
            FutureTest.this.assertTrue(this.future.failed());
            FutureTest.this.assertEquals(null, this.future.result());
            FutureTest.this.assertEquals(1L, this.count.get());
            AsyncResult<T> ar = this.result.get();
            FutureTest.this.assertNotNull(ar);
            FutureTest.this.assertFalse(ar.succeeded());
            FutureTest.this.assertTrue(ar.failed());
            FutureTest.this.assertNull(ar.result());
            return this.future.cause();
        }
    }
}

