/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.http.HttpServer;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.test.core.VertxTestBase;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.junit.Test;

public class HttpConnectionEarlyResetTest
extends VertxTestBase {
    private HttpServer httpServer;
    private AtomicReference<Throwable> caught = new AtomicReference();
    private CountDownLatch resetLatch = new CountDownLatch(1);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.httpServer = this.vertx.createHttpServer().requestHandler(request -> {}).listen(8080, this.onSuccess(server -> listenLatch.countDown()));
        ((HttpServerImpl)this.httpServer).setConnectionExceptionHandler(t -> {
            this.caught.set((Throwable)t);
            this.resetLatch.countDown();
        });
        this.awaitLatch(listenLatch);
    }

    @Test
    public void testExceptionCaught() throws Exception {
        this.vertx.createNetClient(new NetClientOptions().setSoLinger(0)).connect(8080, "localhost", this.onSuccess(NetSocket::close));
        this.awaitLatch(this.resetLatch);
        this.assertThat(this.caught.get(), CoreMatchers.instanceOf(IOException.class));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.httpServer != null) {
            CountDownLatch closeLatch = new CountDownLatch(1);
            this.httpServer.close(event -> closeLatch.countDown());
            this.awaitLatch(closeLatch);
        }
        super.tearDown();
    }
}

