/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import java.io.ByteArrayOutputStream;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.junit.Assert;

public class TestUtils {
    private static Random random = new Random();

    public static Buffer randomBuffer(int length) {
        return TestUtils.randomBuffer(length, false, (byte)0);
    }

    public static byte[] randomByteArray(int length) {
        return TestUtils.randomByteArray(length, false, (byte)0);
    }

    public static byte[] randomByteArray(int length, boolean avoid, byte avoidByte) {
        byte[] line = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte rand;
            do {
                rand = TestUtils.randomByte();
            } while (avoid && rand == avoidByte);
            line[i] = rand;
        }
        return line;
    }

    public static Buffer randomBuffer(int length, boolean avoid, byte avoidByte) {
        byte[] line = TestUtils.randomByteArray(length, avoid, avoidByte);
        return Buffer.buffer((byte[])line);
    }

    public static byte randomByte() {
        return (byte)((int)(Math.random() * 255.0) - 128);
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomPortInt() {
        return random.nextInt(65536);
    }

    public static int randomPositiveInt() {
        int rand;
        while ((rand = random.nextInt()) <= 0) {
        }
        return rand;
    }

    public static long randomPositiveLong() {
        long rand;
        while ((rand = random.nextLong()) <= 0L) {
        }
        return rand;
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static char randomChar() {
        return (char)random.nextInt(16);
    }

    public static short randomShort() {
        return (short)random.nextInt(32768);
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static String randomUnicodeString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c;
            while ((c = (char)(65535.0 * Math.random())) >= '\ufffe' && c <= '\uffff' || c >= '\ud800' && c <= '\udfff') {
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String randomAlphaString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = (char)(65.0 + 25.0 * Math.random());
            builder.append(c);
        }
        return builder.toString();
    }

    public static Http2Settings randomHttp2Settings() {
        long headerTableSize = 10L + (long)TestUtils.randomPositiveInt() % 0xFFFFFFF5L;
        boolean enablePush = TestUtils.randomBoolean();
        long maxConcurrentStreams = 10L + TestUtils.randomPositiveLong() % 0xFFFFFFF5L;
        int initialWindowSize = 10 + TestUtils.randomPositiveInt() % 0x7FFFFFF5;
        int maxFrameSize = 16384 + TestUtils.randomPositiveInt() % 0xFFBFFF;
        long maxHeaderListSize = 10L + TestUtils.randomPositiveLong() % 0xFFFFFFF5L;
        Http2Settings settings = new Http2Settings();
        settings.setHeaderTableSize(headerTableSize);
        settings.setPushEnabled(enablePush);
        settings.setMaxConcurrentStreams(maxConcurrentStreams);
        settings.setInitialWindowSize(initialWindowSize);
        settings.setMaxFrameSize(maxFrameSize);
        settings.setMaxHeaderListSize(maxHeaderListSize);
        settings.set(7, TestUtils.randomPositiveLong() & 0xFFFFFFFFL);
        return settings;
    }

    public static <E extends Enum<E>> Set<E> randomEnumSet(Class<E> enumType) {
        EnumSet<Enum> set = EnumSet.noneOf(enumType);
        for (Enum e : EnumSet.allOf(enumType)) {
            if (TestUtils.randomPositiveInt() % 2 != 1) continue;
            set.add(e);
        }
        return set;
    }

    public static <E> E randomElement(E[] array) {
        return array[TestUtils.randomPositiveInt() % array.length];
    }

    public static boolean byteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static void assertIllegalArgumentException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void assertNullPointerException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void assertIllegalStateException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void assertIndexOutOfBoundsException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static byte[] compressGzip(String source) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        gos.write(source.getBytes());
        gos.close();
        return baos.toByteArray();
    }

    public static KeyCertOptions randomKeyCertOptions() {
        JksOptions keyCertOptions;
        switch (TestUtils.randomPositiveInt() % 3) {
            case 0: {
                keyCertOptions = new JksOptions();
                String jksPassword = TestUtils.randomAlphaString(100);
                keyCertOptions.setPassword(jksPassword);
                break;
            }
            case 1: {
                keyCertOptions = new PemKeyCertOptions();
                Buffer keyValue = TestUtils.randomBuffer(100);
                ((PemKeyCertOptions)keyCertOptions).setKeyValue(keyValue);
                break;
            }
            default: {
                keyCertOptions = new PfxOptions();
                String pfxPassword = TestUtils.randomAlphaString(100);
                ((PfxOptions)keyCertOptions).setPassword(pfxPassword);
            }
        }
        return keyCertOptions;
    }

    public static TrustOptions randomTrustOptions() {
        JksOptions trustOptions;
        switch (TestUtils.randomPositiveInt() % 3) {
            case 0: {
                trustOptions = new JksOptions();
                String tsPassword = TestUtils.randomAlphaString(100);
                trustOptions.setPassword(tsPassword);
                break;
            }
            case 1: {
                trustOptions = new PemTrustOptions();
                Buffer keyValue = TestUtils.randomBuffer(100);
                ((PemTrustOptions)trustOptions).addCertValue(keyValue);
                break;
            }
            default: {
                trustOptions = new PfxOptions();
                String pfxPassword = TestUtils.randomAlphaString(100);
                ((PfxOptions)trustOptions).setPassword(pfxPassword);
            }
        }
        return trustOptions;
    }
}

