/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Launcher;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.core.FaultToleranceVerticle;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.junit.Test;

public abstract class FaultToleranceTest
extends VertxTestBase {
    private static final int NODE_COUNT = 3;
    private static final int ADDRESSES_COUNT = 10;
    private final List<Process> externalNodes = new ArrayList<Process>();
    private final AtomicLong externalNodesStarted = new AtomicLong();
    private final AtomicLong pongsReceived = new AtomicLong();
    private final AtomicLong noHandlersErrors = new AtomicLong();
    protected long timeoutMs = 60000L;

    @Test
    public void testFaultTolerance() throws Exception {
        this.startNodes(1);
        VertxInternal vertx = (VertxInternal)this.vertices[0];
        vertx.eventBus().consumer("control", msg -> {
            switch ((String)msg.body()) {
                case "start": {
                    this.externalNodesStarted.incrementAndGet();
                    break;
                }
                case "pong": {
                    this.pongsReceived.incrementAndGet();
                    break;
                }
                case "noHandlers": {
                    this.noHandlersErrors.incrementAndGet();
                }
            }
        });
        for (int i = 0; i < 3; ++i) {
            Process process = this.startExternalNode(i);
            this.externalNodes.add(process);
        }
        this.waitUntil(() -> this.externalNodesStarted.get() == 3L, this.timeoutMs);
        JsonArray message1 = new JsonArray();
        IntStream.range(0, 3).forEach(arg_0 -> ((JsonArray)message1).add(arg_0));
        vertx.eventBus().publish("ping", (Object)message1);
        this.waitUntil(() -> this.pongsReceived.get() == 90L, this.timeoutMs);
        for (int i = 0; i < 2; ++i) {
            this.externalNodes.get(i).destroyForcibly();
        }
        this.waitForClusterStability(vertx);
        this.pongsReceived.set(0L);
        JsonArray message2 = new JsonArray().add(Integer.valueOf(2));
        vertx.eventBus().publish("ping", (Object)message2);
        this.waitUntil(() -> this.pongsReceived.get() == 10L, this.timeoutMs);
        JsonArray message3 = new JsonArray();
        IntStream.range(0, 2).forEach(arg_0 -> ((JsonArray)message3).add(arg_0));
        vertx.eventBus().publish("ping", (Object)message3);
        this.waitUntil(() -> this.noHandlersErrors.get() == 20L, this.timeoutMs);
    }

    protected void waitForClusterStability(VertxInternal vertx) throws Exception {
        ClusterManager clusterManager = vertx.getClusterManager();
        this.waitUntil(() -> clusterManager.getNodes().size() == 2, this.timeoutMs);
    }

    private Process startExternalNode(int id) throws Exception {
        String javaHome = System.getProperty("java.home");
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaHome + File.separator + "bin" + File.separator + "java");
        command.add("-classpath");
        command.add(classpath);
        command.addAll(this.getExternalNodeSystemProperties());
        command.add(Launcher.class.getName());
        command.add("run");
        command.add(FaultToleranceVerticle.class.getName());
        command.add("-cluster");
        command.add("-conf");
        command.add(new JsonObject().put("id", Integer.valueOf(id)).put("addressesCount", Integer.valueOf(10)).encode());
        return new ProcessBuilder(command).inheritIO().start();
    }

    protected List<String> getExternalNodeSystemProperties() {
        return Collections.emptyList();
    }

    @Override
    protected void tearDown() throws Exception {
        this.externalNodes.forEach(Process::destroyForcibly);
        super.tearDown();
    }
}

