/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;

public class FaultToleranceVerticle
extends AbstractVerticle {
    private int numAddresses;

    public void start() throws Exception {
        JsonObject config = this.config();
        int id = config.getInteger("id");
        this.numAddresses = config.getInteger("addressesCount");
        ArrayList<Future> registrationFutures = new ArrayList<Future>(this.numAddresses);
        for (int i = 0; i < this.numAddresses; ++i) {
            Future registrationFuture = Future.future();
            registrationFutures.add(registrationFuture);
            this.vertx.eventBus().consumer(this.createAddress(id, i), msg -> msg.reply((Object)"pong")).completionHandler(registrationFuture.completer());
        }
        Future registrationFuture = Future.future();
        registrationFutures.add(registrationFuture);
        this.vertx.eventBus().consumer("ping", this::ping).completionHandler(registrationFuture.completer());
        CompositeFuture.all(registrationFutures).setHandler(ar -> {
            if (ar.succeeded()) {
                this.vertx.eventBus().send("control", (Object)"start");
            }
        });
    }

    private void ping(Message<JsonArray> message) {
        JsonArray jsonArray = (JsonArray)message.body();
        for (int i = 0; i < jsonArray.size(); ++i) {
            int node = jsonArray.getInteger(i);
            for (int j = 0; j < this.numAddresses; ++j) {
                this.vertx.eventBus().send(this.createAddress(node, j), (Object)"ping", new DeliveryOptions().setSendTimeout(1000L), ar -> {
                    if (ar.succeeded()) {
                        this.vertx.eventBus().send("control", (Object)"pong");
                    } else {
                        ReplyException replyException;
                        Throwable cause = ar.cause();
                        if (cause instanceof ReplyException && (replyException = (ReplyException)cause).failureType() == ReplyFailure.NO_HANDLERS) {
                            this.vertx.eventBus().send("control", (Object)"noHandlers");
                        }
                    }
                });
            }
        }
    }

    private String createAddress(int id, int i) {
        return "address-" + id + "-" + i;
    }
}

