/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.handler.codec.http2.Http2Settings;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.test.core.HttpTestBase;
import io.vertx.test.core.TestUtils;
import java.util.HashMap;
import org.junit.Test;

public class Http2SettingsTest
extends HttpTestBase {
    long[] min = new long[]{0L, 0L, 0L, 0L, 16384L, 0L};
    long[] max = new long[]{0xFFFFFFFFL, 1L, 0xFFFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFL, Integer.MAX_VALUE};

    @Test
    public void testSettingsMin() {
        for (int i = 1; i <= 6; ++i) {
            try {
                new io.vertx.core.http.Http2Settings().set(i, this.min[i - 1] - 1L);
                this.fail();
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        io.vertx.core.http.Http2Settings settings = new io.vertx.core.http.Http2Settings();
        for (int i = 1; i <= 6; ++i) {
            settings.set(i, this.min[i - 1]);
        }
        HttpUtils.fromVertxSettings((io.vertx.core.http.Http2Settings)settings);
    }

    @Test
    public void testSettinsMax() {
        for (int i = 1; i <= 6; ++i) {
            try {
                new io.vertx.core.http.Http2Settings().set(i, this.max[i - 1] + 1L);
                this.fail("Was expecting setting " + (i - 1) + " update to throw IllegalArgumentException");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        io.vertx.core.http.Http2Settings settings = new io.vertx.core.http.Http2Settings();
        for (int i = 1; i <= 6; ++i) {
            settings.set(i, this.max[i - 1]);
        }
        HttpUtils.fromVertxSettings((io.vertx.core.http.Http2Settings)settings);
    }

    @Test
    public void toNettySettings() {
        int i;
        io.vertx.core.http.Http2Settings settings = new io.vertx.core.http.Http2Settings();
        for (int i2 = 7; i2 <= 65535; ++i2) {
            settings.set(65535, TestUtils.randomPositiveLong());
        }
        Http2Settings conv = HttpUtils.fromVertxSettings((io.vertx.core.http.Http2Settings)settings);
        for (i = 1; i <= 65535; ++i) {
            this.assertEquals(settings.get(i), conv.get((char)i));
        }
        settings = HttpUtils.toVertxSettings((Http2Settings)conv);
        for (i = 1; i <= 65535; ++i) {
            this.assertEquals(settings.get(i), conv.get((char)i));
        }
    }

    @Test
    public void testSettings() {
        io.vertx.core.http.Http2Settings settings = new io.vertx.core.http.Http2Settings();
        this.assertEquals(true, settings.isPushEnabled());
        this.assertEquals(Integer.MAX_VALUE, settings.getMaxHeaderListSize());
        this.assertEquals(0xFFFFFFFFL, settings.getMaxConcurrentStreams());
        this.assertEquals(65535L, settings.getInitialWindowSize());
        this.assertEquals(16384L, settings.getMaxFrameSize());
        this.assertEquals(null, settings.getExtraSettings());
        io.vertx.core.http.Http2Settings update = TestUtils.randomHttp2Settings();
        this.assertFalse(settings.equals((Object)update));
        this.assertNotSame(settings.hashCode(), settings.hashCode());
        this.assertSame(settings, settings.setHeaderTableSize(update.getHeaderTableSize()));
        this.assertEquals(settings.getHeaderTableSize(), update.getHeaderTableSize());
        this.assertSame(settings, settings.setPushEnabled(update.isPushEnabled()));
        this.assertEquals(settings.isPushEnabled(), update.isPushEnabled());
        this.assertSame(settings, settings.setMaxHeaderListSize(update.getMaxHeaderListSize()));
        this.assertEquals(settings.getMaxHeaderListSize(), update.getMaxHeaderListSize());
        this.assertSame(settings, settings.setMaxConcurrentStreams(update.getMaxConcurrentStreams()));
        this.assertEquals(settings.getMaxConcurrentStreams(), update.getMaxConcurrentStreams());
        this.assertSame(settings, settings.setInitialWindowSize(update.getInitialWindowSize()));
        this.assertEquals(settings.getInitialWindowSize(), update.getInitialWindowSize());
        this.assertSame(settings, settings.setMaxFrameSize(update.getMaxFrameSize()));
        this.assertEquals(settings.getMaxFrameSize(), update.getMaxFrameSize());
        this.assertSame(settings, settings.setExtraSettings(update.getExtraSettings()));
        HashMap extraSettings = new HashMap(update.getExtraSettings());
        this.assertEquals(update.getExtraSettings(), extraSettings);
        extraSettings.clear();
        this.assertEquals(update.getExtraSettings(), settings.getExtraSettings());
        this.assertTrue(settings.equals((Object)update));
        this.assertEquals(settings.hashCode(), settings.hashCode());
        settings = new io.vertx.core.http.Http2Settings(update);
        this.assertEquals(settings.getHeaderTableSize(), update.getHeaderTableSize());
        this.assertEquals(settings.isPushEnabled(), update.isPushEnabled());
        this.assertEquals(settings.getMaxHeaderListSize(), update.getMaxHeaderListSize());
        this.assertEquals(settings.getMaxConcurrentStreams(), update.getMaxConcurrentStreams());
        this.assertEquals(settings.getInitialWindowSize(), update.getInitialWindowSize());
        this.assertEquals(settings.getMaxFrameSize(), update.getMaxFrameSize());
        this.assertEquals(update.getExtraSettings(), settings.getExtraSettings());
    }
}

