/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.TestProxyBase;
import java.net.UnknownHostException;
import java.util.Base64;

public class HttpProxy
extends TestProxyBase {
    private static final int PORT = 13128;
    private static final Logger log = LoggerFactory.getLogger(HttpProxy.class);
    private HttpServer server;
    private int error = 0;
    private MultiMap lastRequestHeaders = null;

    public HttpProxy(String username) {
        super(username);
    }

    @Override
    public void start(Vertx vertx, Handler<Void> finishedHandler) {
        HttpServerOptions options = new HttpServerOptions();
        options.setHost("localhost").setPort(13128);
        this.server = vertx.createHttpServer(options);
        this.server.requestHandler(request -> {
            HttpMethod method = request.method();
            String uri = request.uri();
            if (this.username != null) {
                String auth = request.getHeader("Proxy-Authorization");
                String expected = "Basic " + Base64.getEncoder().encodeToString((this.username + ":" + this.username).getBytes());
                if (auth == null || !auth.equals(expected)) {
                    request.response().setStatusCode(407).end("proxy authentication failed");
                    return;
                }
            }
            this.lastRequestHeaders = MultiMap.caseInsensitiveMultiMap().addAll(request.headers());
            if (this.error != 0) {
                request.response().setStatusCode(this.error).end("proxy request failed");
            } else if (method == HttpMethod.CONNECT) {
                if (!uri.contains(":")) {
                    request.response().setStatusCode(403).end("invalid request");
                } else {
                    int port;
                    this.lastUri = uri;
                    if (this.forceUri != null) {
                        uri = this.forceUri;
                    }
                    String[] split = uri.split(":");
                    String host = split[0];
                    try {
                        port = Integer.parseInt(split[1]);
                    }
                    catch (NumberFormatException ex) {
                        port = 443;
                    }
                    if (port == 8080 || port < 1024 && port != 443) {
                        request.response().setStatusCode(403).end("access to port denied");
                        return;
                    }
                    NetSocket serverSocket = request.netSocket();
                    NetClientOptions netOptions = new NetClientOptions();
                    NetClient netClient = vertx.createNetClient(netOptions);
                    netClient.connect(port, host, result -> {
                        if (result.succeeded()) {
                            NetSocket clientSocket = (NetSocket)result.result();
                            serverSocket.write("HTTP/1.0 200 Connection established\n\n");
                            serverSocket.closeHandler(v -> clientSocket.close());
                            clientSocket.closeHandler(v -> serverSocket.close());
                            Pump.pump((ReadStream)serverSocket, (WriteStream)clientSocket).start();
                            Pump.pump((ReadStream)clientSocket, (WriteStream)serverSocket).start();
                        } else {
                            request.response().setStatusCode(403).end("request failed");
                        }
                    });
                }
            } else if (method == HttpMethod.GET) {
                this.lastUri = request.uri();
                HttpClient client = vertx.createHttpClient();
                HttpClientRequest clientRequest = client.getAbs(request.uri(), resp -> {
                    for (String name : resp.headers().names()) {
                        request.response().putHeader(name, (Iterable)resp.headers().getAll(name));
                    }
                    resp.bodyHandler(body -> request.response().end(body));
                });
                for (String name : request.headers().names()) {
                    if (name.equals("Proxy-Authorization")) continue;
                    clientRequest.putHeader(name, (Iterable)request.headers().getAll(name));
                }
                clientRequest.exceptionHandler(e -> {
                    log.debug((Object)"exception", e);
                    int status = e instanceof UnknownHostException ? 504 : 400;
                    request.response().setStatusCode(status).end(e.toString() + " on client request");
                });
                clientRequest.end();
            } else {
                request.response().setStatusCode(405).end("method not supported");
            }
        });
        this.server.listen(server -> finishedHandler.handle(null));
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Override
    public int getPort() {
        return 13128;
    }

    @Override
    public MultiMap getLastRequestHeaders() {
        return this.lastRequestHeaders;
    }

    public HttpProxy setError(int error) {
        this.error = error;
        return this;
    }
}

