/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JsonPOJOMapperTest {
    @Test
    public void testSerialization() {
        final MyType myObj0 = new MyType(){
            {
                this.a = -1;
                this.b = "obj0";
                this.c.put("z", Arrays.asList(7, 8));
                this.e.add(9);
            }
        };
        MyType myObj1 = new MyType(){
            {
                this.a = 5;
                this.b = "obj1";
                this.c.put("x", "1");
                this.c.put("y", 2);
                this.d.add(myObj0);
                this.e.add(3);
            }
        };
        JsonObject jsonObject1 = JsonObject.mapFrom((Object)myObj1);
        String jsonStr1 = jsonObject1.encode();
        Assert.assertEquals((Object)"{\"a\":5,\"b\":\"obj1\",\"c\":{\"x\":\"1\",\"y\":2},\"d\":[{\"a\":-1,\"b\":\"obj0\",\"c\":{\"z\":[7,8]},\"d\":[],\"e\":[9]}],\"e\":[3]}", (Object)jsonStr1);
        MyType myObj1Roundtrip = (MyType)jsonObject1.mapTo(MyType.class);
        Assert.assertEquals((long)myObj1Roundtrip.a, (long)5L);
        Assert.assertEquals((Object)myObj1Roundtrip.b, (Object)"obj1");
        Assert.assertEquals((Object)myObj1Roundtrip.c.get("x"), (Object)"1");
        Assert.assertEquals((Object)myObj1Roundtrip.c.get("y"), (Object)new Integer(2));
        Assert.assertEquals(myObj1Roundtrip.e, Arrays.asList(3));
        MyType myObj0Roundtrip = myObj1Roundtrip.d.get(0);
        Assert.assertEquals((long)myObj0Roundtrip.a, (long)-1L);
        Assert.assertEquals((Object)myObj0Roundtrip.b, (Object)"obj0");
        Assert.assertEquals((Object)myObj0Roundtrip.c.get("z"), Arrays.asList(7, 8));
        Assert.assertEquals(myObj0Roundtrip.e, Arrays.asList(9));
        boolean caughtCycle = false;
        try {
            myObj0.d.add(myObj0);
            JsonObject.mapFrom((Object)myObj0);
        }
        catch (IllegalArgumentException e) {
            caughtCycle = true;
        }
        if (!caughtCycle) {
            Assert.fail();
        }
    }

    public static class MyType {
        public int a;
        public String b;
        public HashMap<String, Object> c = new HashMap();
        public List<MyType> d = new ArrayList<MyType>();
        public List<Integer> e = new ArrayList<Integer>();
    }
}

