/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.metrics.Measured;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.HandlerMetric;
import io.vertx.test.fakemetrics.ReceivedMessage;
import io.vertx.test.fakemetrics.SentMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FakeEventBusMetrics
extends FakeMetricsBase
implements EventBusMetrics<HandlerMetric> {
    private final List<SentMessage> sentMessages = Collections.synchronizedList(new ArrayList());
    private final List<ReceivedMessage> receivedMessages = Collections.synchronizedList(new ArrayList());
    private final List<HandlerMetric> registrations = new ArrayList<HandlerMetric>();
    private final Map<String, AtomicInteger> encoded = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> decoded = new ConcurrentHashMap<String, AtomicInteger>();
    private final List<String> replyFailureAddresses = Collections.synchronizedList(new ArrayList());
    private final List<ReplyFailure> replyFailures = Collections.synchronizedList(new ArrayList());

    public FakeEventBusMetrics(EventBus eventBus) {
        super((Measured)eventBus);
    }

    public Map<String, AtomicInteger> getEncoded() {
        return this.encoded;
    }

    public Map<String, AtomicInteger> getDecoded() {
        return this.decoded;
    }

    public List<SentMessage> getSentMessages() {
        return this.sentMessages;
    }

    public List<ReceivedMessage> getReceivedMessages() {
        return this.receivedMessages;
    }

    public List<HandlerMetric> getRegistrations() {
        return this.registrations;
    }

    public List<String> getReplyFailureAddresses() {
        return this.replyFailureAddresses;
    }

    public List<ReplyFailure> getReplyFailures() {
        return this.replyFailures;
    }

    public int getEncodedBytes(String address) {
        AtomicInteger value = this.encoded.get(address);
        return value != null ? value.get() : 0;
    }

    public int getDecodedBytes(String address) {
        AtomicInteger value = this.decoded.get(address);
        return value != null ? value.get() : 0;
    }

    public HandlerMetric handlerRegistered(String address, String repliedAddress) {
        HandlerMetric registration = new HandlerMetric(address, repliedAddress);
        this.registrations.add(registration);
        return registration;
    }

    public void handlerUnregistered(HandlerMetric handler) {
        this.registrations.remove(handler);
    }

    public void scheduleMessage(HandlerMetric handler, boolean local) {
        handler.scheduleCount.incrementAndGet();
        if (local) {
            handler.localScheduleCount.incrementAndGet();
        }
    }

    public void beginHandleMessage(HandlerMetric handler, boolean local) {
        handler.beginCount.incrementAndGet();
        if (local) {
            handler.localBeginCount.incrementAndGet();
        }
    }

    public void endHandleMessage(HandlerMetric handler, Throwable failure) {
        handler.endCount.incrementAndGet();
        if (failure != null) {
            handler.failureCount.incrementAndGet();
        }
    }

    public void messageSent(String address, boolean publish, boolean local, boolean remote) {
        this.sentMessages.add(new SentMessage(address, publish, local, remote));
    }

    public void messageReceived(String address, boolean publish, boolean local, int handlers) {
        this.receivedMessages.add(new ReceivedMessage(address, publish, local, handlers));
    }

    public void messageWritten(String address, int numberOfBytes) {
        AtomicInteger value = new AtomicInteger();
        AtomicInteger existing = this.encoded.putIfAbsent(address, value);
        if (existing != null) {
            value = existing;
        }
        value.addAndGet(numberOfBytes);
    }

    public void messageRead(String address, int numberOfBytes) {
        AtomicInteger value = new AtomicInteger();
        AtomicInteger existing = this.decoded.putIfAbsent(address, value);
        if (existing != null) {
            value = existing;
        }
        value.addAndGet(numberOfBytes);
    }

    public void replyFailure(String address, ReplyFailure failure) {
        this.replyFailureAddresses.add(address);
        this.replyFailures.add(failure);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
    }
}

