/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.test.fakemetrics.FakeDatagramSocketMetrics;
import io.vertx.test.fakemetrics.FakeEventBusMetrics;
import io.vertx.test.fakemetrics.FakeHttpClientMetrics;
import io.vertx.test.fakemetrics.FakeHttpServerMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.FakePoolMetrics;
import java.util.concurrent.atomic.AtomicReference;

public class FakeVertxMetrics
extends FakeMetricsBase
implements VertxMetrics {
    public static AtomicReference<EventBus> eventBus = new AtomicReference();

    public FakeVertxMetrics(Vertx vertx) {
        super((Measured)vertx);
    }

    public boolean isMetricsEnabled() {
        return true;
    }

    public void verticleDeployed(Verticle verticle) {
    }

    public void verticleUndeployed(Verticle verticle) {
    }

    public void timerCreated(long id) {
    }

    public void timerEnded(long id, boolean cancelled) {
    }

    public EventBusMetrics createMetrics(EventBus eventBus) {
        return new FakeEventBusMetrics(eventBus);
    }

    public HttpServerMetrics<?, ?, ?> createMetrics(HttpServer server, SocketAddress localAddress, HttpServerOptions options) {
        return new FakeHttpServerMetrics(server);
    }

    public HttpClientMetrics<?, ?, ?, ?, Void> createMetrics(HttpClient client, HttpClientOptions options) {
        return new FakeHttpClientMetrics((Measured)client, options.getMetricsName());
    }

    public TCPMetrics<?> createMetrics(SocketAddress localAddress, NetServerOptions options) {
        return new TCPMetrics<Object>(){

            public Object connected(SocketAddress remoteAddress, String remoteName) {
                return null;
            }

            public void disconnected(Object socketMetric, SocketAddress remoteAddress) {
            }

            public void bytesRead(Object socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
            }

            public void bytesWritten(Object socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
            }

            public void exceptionOccurred(Object socketMetric, SocketAddress remoteAddress, Throwable t) {
            }

            public boolean isEnabled() {
                return false;
            }

            public void close() {
            }
        };
    }

    public TCPMetrics<?> createMetrics(NetClient client, NetClientOptions options) {
        return new TCPMetrics<Object>(){

            public Object connected(SocketAddress remoteAddress, String remoteName) {
                return null;
            }

            public void disconnected(Object socketMetric, SocketAddress remoteAddress) {
            }

            public void bytesRead(Object socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
            }

            public void bytesWritten(Object socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
            }

            public void exceptionOccurred(Object socketMetric, SocketAddress remoteAddress, Throwable t) {
            }

            public boolean isEnabled() {
                return false;
            }

            public void close() {
            }
        };
    }

    public DatagramSocketMetrics createMetrics(DatagramSocket socket, DatagramSocketOptions options) {
        return new FakeDatagramSocketMetrics((Measured)socket);
    }

    public <P> PoolMetrics<?> createMetrics(P pool, String poolType, String poolName, int maxPoolSize) {
        return new FakePoolMetrics(poolName, maxPoolSize);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void eventBusInitialized(EventBus bus) {
        eventBus.set(bus);
    }
}

