/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClientOptionsConverter;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@DataObject(generateConverter=true)
public class HttpClientOptions
extends ClientOptionsBase {
    public static final int DEFAULT_MAX_POOL_SIZE = 5;
    public static final int DEFAULT_HTTP2_MAX_POOL_SIZE = 1;
    public static final int DEFAULT_HTTP2_MULTIPLEXING_LIMIT = -1;
    public static final int DEFAULT_HTTP2_CONNECTION_WINDOW_SIZE = -1;
    public static final boolean DEFAULT_KEEP_ALIVE = true;
    public static final boolean DEFAULT_PIPELINING = false;
    public static final int DEFAULT_PIPELINING_LIMIT = 10;
    public static final boolean DEFAULT_TRY_USE_COMPRESSION = false;
    public static final boolean DEFAULT_VERIFY_HOST = true;
    public static final int DEFAULT_MAX_WEBSOCKET_FRAME_SIZE = 65536;
    public static final int DEFAULT_MAX_WEBSOCKET_MESSAGE_SIZE = 262144;
    public static final String DEFAULT_DEFAULT_HOST = "localhost";
    public static final int DEFAULT_DEFAULT_PORT = 80;
    public static final HttpVersion DEFAULT_PROTOCOL_VERSION = HttpVersion.HTTP_1_1;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final int DEFAULT_MAX_WAIT_QUEUE_SIZE = -1;
    public static final List<HttpVersion> DEFAULT_ALPN_VERSIONS = Collections.emptyList();
    public static final boolean DEFAULT_HTTP2_CLEAR_TEXT_UPGRADE = true;
    public static final boolean DEFAULT_SEND_UNMASKED_FRAMES = false;
    public static final int DEFAULT_MAX_REDIRECTS = 16;
    private boolean verifyHost = true;
    private int maxPoolSize;
    private boolean keepAlive;
    private int pipeliningLimit;
    private boolean pipelining;
    private int http2MaxPoolSize;
    private int http2MultiplexingLimit;
    private int http2ConnectionWindowSize;
    private boolean tryUseCompression;
    private int maxWebsocketFrameSize;
    private int maxWebsocketMessageSize;
    private String defaultHost;
    private int defaultPort;
    private HttpVersion protocolVersion;
    private int maxChunkSize;
    private int maxInitialLineLength;
    private int maxHeaderSize;
    private int maxWaitQueueSize;
    private Http2Settings initialSettings;
    private List<HttpVersion> alpnVersions;
    private boolean http2ClearTextUpgrade;
    private boolean sendUnmaskedFrames;
    private int maxRedirects;

    public HttpClientOptions() {
        this.init();
    }

    public HttpClientOptions(HttpClientOptions other) {
        super(other);
        this.verifyHost = other.isVerifyHost();
        this.maxPoolSize = other.getMaxPoolSize();
        this.keepAlive = other.isKeepAlive();
        this.pipelining = other.isPipelining();
        this.pipeliningLimit = other.getPipeliningLimit();
        this.http2MaxPoolSize = other.getHttp2MaxPoolSize();
        this.http2MultiplexingLimit = other.http2MultiplexingLimit;
        this.http2ConnectionWindowSize = other.http2ConnectionWindowSize;
        this.tryUseCompression = other.isTryUseCompression();
        this.maxWebsocketFrameSize = other.maxWebsocketFrameSize;
        this.maxWebsocketMessageSize = other.maxWebsocketMessageSize;
        this.defaultHost = other.defaultHost;
        this.defaultPort = other.defaultPort;
        this.protocolVersion = other.protocolVersion;
        this.maxChunkSize = other.maxChunkSize;
        this.maxInitialLineLength = other.getMaxInitialLineLength();
        this.maxHeaderSize = other.getMaxHeaderSize();
        this.maxWaitQueueSize = other.maxWaitQueueSize;
        this.initialSettings = other.initialSettings != null ? new Http2Settings(other.initialSettings) : null;
        this.alpnVersions = other.alpnVersions != null ? new ArrayList<HttpVersion>(other.alpnVersions) : null;
        this.http2ClearTextUpgrade = other.http2ClearTextUpgrade;
        this.sendUnmaskedFrames = other.isSendUnmaskedFrames();
        this.maxRedirects = other.maxRedirects;
    }

    public HttpClientOptions(JsonObject json) {
        super(json);
        this.init();
        HttpClientOptionsConverter.fromJson(json, this);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        HttpClientOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.verifyHost = true;
        this.maxPoolSize = 5;
        this.keepAlive = true;
        this.pipelining = false;
        this.pipeliningLimit = 10;
        this.http2MultiplexingLimit = -1;
        this.http2MaxPoolSize = 1;
        this.http2ConnectionWindowSize = -1;
        this.tryUseCompression = false;
        this.maxWebsocketFrameSize = 65536;
        this.maxWebsocketMessageSize = 262144;
        this.defaultHost = DEFAULT_DEFAULT_HOST;
        this.defaultPort = 80;
        this.protocolVersion = DEFAULT_PROTOCOL_VERSION;
        this.maxChunkSize = 8192;
        this.maxInitialLineLength = 4096;
        this.maxHeaderSize = 8192;
        this.maxWaitQueueSize = -1;
        this.initialSettings = new Http2Settings();
        this.alpnVersions = new ArrayList<HttpVersion>(DEFAULT_ALPN_VERSIONS);
        this.http2ClearTextUpgrade = true;
        this.sendUnmaskedFrames = false;
        this.maxRedirects = 16;
    }

    @Override
    public HttpClientOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public HttpClientOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public HttpClientOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public HttpClientOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public HttpClientOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public HttpClientOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public HttpClientOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public HttpClientOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public HttpClientOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public HttpClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public HttpClientOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    @Override
    public HttpClientOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    @Override
    public HttpClientOptions setPfxKeyCertOptions(PfxOptions options) {
        return (HttpClientOptions)super.setPfxKeyCertOptions(options);
    }

    @Override
    public HttpClientOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    @Override
    public HttpClientOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (HttpClientOptions)super.setPemKeyCertOptions(options);
    }

    @Override
    public HttpClientOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    @Override
    public HttpClientOptions setPfxTrustOptions(PfxOptions options) {
        return (HttpClientOptions)super.setPfxTrustOptions(options);
    }

    @Override
    public HttpClientOptions setPemTrustOptions(PemTrustOptions options) {
        return (HttpClientOptions)super.setPemTrustOptions(options);
    }

    @Override
    public HttpClientOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public HttpClientOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    @Override
    public HttpClientOptions addCrlPath(String crlPath) throws NullPointerException {
        return (HttpClientOptions)super.addCrlPath(crlPath);
    }

    @Override
    public HttpClientOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (HttpClientOptions)super.addCrlValue(crlValue);
    }

    @Override
    public HttpClientOptions setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public HttpClientOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public HttpClientOptions setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize must be > 0");
        }
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public int getHttp2MultiplexingLimit() {
        return this.http2MultiplexingLimit;
    }

    public HttpClientOptions setHttp2MultiplexingLimit(int limit) {
        if (limit == 0 || limit < -1) {
            throw new IllegalArgumentException("maxPoolSize must be > 0 or -1 (disabled)");
        }
        this.http2MultiplexingLimit = limit;
        return this;
    }

    public int getHttp2MaxPoolSize() {
        return this.http2MaxPoolSize;
    }

    public HttpClientOptions setHttp2MaxPoolSize(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("http2MaxPoolSize must be > 0");
        }
        this.http2MaxPoolSize = max;
        return this;
    }

    public int getHttp2ConnectionWindowSize() {
        return this.http2ConnectionWindowSize;
    }

    public HttpClientOptions setHttp2ConnectionWindowSize(int http2ConnectionWindowSize) {
        this.http2ConnectionWindowSize = http2ConnectionWindowSize;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpClientOptions setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean isPipelining() {
        return this.pipelining;
    }

    public HttpClientOptions setPipelining(boolean pipelining) {
        this.pipelining = pipelining;
        return this;
    }

    public int getPipeliningLimit() {
        return this.pipeliningLimit;
    }

    public HttpClientOptions setPipeliningLimit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("pipeliningLimit must be > 0");
        }
        this.pipeliningLimit = limit;
        return this;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public HttpClientOptions setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    public boolean isTryUseCompression() {
        return this.tryUseCompression;
    }

    public HttpClientOptions setTryUseCompression(boolean tryUseCompression) {
        this.tryUseCompression = tryUseCompression;
        return this;
    }

    public boolean isSendUnmaskedFrames() {
        return this.sendUnmaskedFrames;
    }

    public HttpClientOptions setSendUnmaskedFrames(boolean sendUnmaskedFrames) {
        this.sendUnmaskedFrames = sendUnmaskedFrames;
        return this;
    }

    public int getMaxWebsocketFrameSize() {
        return this.maxWebsocketFrameSize;
    }

    public HttpClientOptions setMaxWebsocketFrameSize(int maxWebsocketFrameSize) {
        this.maxWebsocketFrameSize = maxWebsocketFrameSize;
        return this;
    }

    public int getMaxWebsocketMessageSize() {
        return this.maxWebsocketMessageSize;
    }

    public HttpClientOptions setMaxWebsocketMessageSize(int maxWebsocketMessageSize) {
        this.maxWebsocketMessageSize = maxWebsocketMessageSize;
        return this;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public HttpClientOptions setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
        return this;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public HttpClientOptions setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
        return this;
    }

    public HttpVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public HttpClientOptions setProtocolVersion(HttpVersion protocolVersion) {
        if (protocolVersion == null) {
            throw new IllegalArgumentException("protocolVersion must not be null");
        }
        this.protocolVersion = protocolVersion;
        return this;
    }

    public HttpClientOptions setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public HttpClientOptions setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public HttpClientOptions setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    public HttpClientOptions setMaxWaitQueueSize(int maxWaitQueueSize) {
        this.maxWaitQueueSize = maxWaitQueueSize;
        return this;
    }

    public int getMaxWaitQueueSize() {
        return this.maxWaitQueueSize;
    }

    public Http2Settings getInitialSettings() {
        return this.initialSettings;
    }

    public HttpClientOptions setInitialSettings(Http2Settings settings) {
        this.initialSettings = settings;
        return this;
    }

    @Override
    public HttpClientOptions setUseAlpn(boolean useAlpn) {
        return (HttpClientOptions)super.setUseAlpn(useAlpn);
    }

    @Override
    public HttpClientOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (HttpClientOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public HttpClientOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (HttpClientOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public HttpClientOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (HttpClientOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    public List<HttpVersion> getAlpnVersions() {
        return this.alpnVersions;
    }

    public HttpClientOptions setAlpnVersions(List<HttpVersion> alpnVersions) {
        this.alpnVersions = alpnVersions;
        return this;
    }

    public boolean isHttp2ClearTextUpgrade() {
        return this.http2ClearTextUpgrade;
    }

    public HttpClientOptions setHttp2ClearTextUpgrade(boolean value) {
        this.http2ClearTextUpgrade = value;
        return this;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public HttpClientOptions setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    @Override
    public HttpClientOptions setMetricsName(String metricsName) {
        return (HttpClientOptions)super.setMetricsName(metricsName);
    }

    @Override
    public HttpClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        return (HttpClientOptions)super.setProxyOptions(proxyOptions);
    }

    @Override
    public HttpClientOptions setLocalAddress(String localAddress) {
        return (HttpClientOptions)super.setLocalAddress(localAddress);
    }

    @Override
    public HttpClientOptions setLogActivity(boolean logEnabled) {
        return (HttpClientOptions)super.setLogActivity(logEnabled);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpClientOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpClientOptions that = (HttpClientOptions)o;
        if (this.defaultPort != that.defaultPort) {
            return false;
        }
        if (this.keepAlive != that.keepAlive) {
            return false;
        }
        if (this.maxPoolSize != that.maxPoolSize) {
            return false;
        }
        if (this.http2MultiplexingLimit != that.http2MultiplexingLimit) {
            return false;
        }
        if (this.maxWebsocketFrameSize != that.maxWebsocketFrameSize) {
            return false;
        }
        if (this.maxWebsocketMessageSize != that.maxWebsocketMessageSize) {
            return false;
        }
        if (this.pipelining != that.pipelining) {
            return false;
        }
        if (this.pipeliningLimit != that.pipeliningLimit) {
            return false;
        }
        if (this.tryUseCompression != that.tryUseCompression) {
            return false;
        }
        if (this.verifyHost != that.verifyHost) {
            return false;
        }
        if (!this.defaultHost.equals(that.defaultHost)) {
            return false;
        }
        if (this.protocolVersion != that.protocolVersion) {
            return false;
        }
        if (this.maxChunkSize != that.maxChunkSize) {
            return false;
        }
        if (this.maxWaitQueueSize != that.maxWaitQueueSize) {
            return false;
        }
        if (this.initialSettings == null ? that.initialSettings != null : !this.initialSettings.equals(that.initialSettings)) {
            return false;
        }
        if (this.alpnVersions == null ? that.alpnVersions != null : !this.alpnVersions.equals(that.alpnVersions)) {
            return false;
        }
        if (this.http2ClearTextUpgrade != that.http2ClearTextUpgrade) {
            return false;
        }
        if (this.http2ConnectionWindowSize != that.http2ConnectionWindowSize) {
            return false;
        }
        if (this.sendUnmaskedFrames != that.sendUnmaskedFrames) {
            return false;
        }
        return this.maxRedirects == that.maxRedirects;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.verifyHost ? 1 : 0);
        result = 31 * result + this.maxPoolSize;
        result = 31 * result + this.http2MultiplexingLimit;
        result = 31 * result + (this.keepAlive ? 1 : 0);
        result = 31 * result + (this.pipelining ? 1 : 0);
        result = 31 * result + this.pipeliningLimit;
        result = 31 * result + (this.tryUseCompression ? 1 : 0);
        result = 31 * result + this.maxWebsocketFrameSize;
        result = 31 * result + this.maxWebsocketMessageSize;
        result = 31 * result + this.defaultHost.hashCode();
        result = 31 * result + this.defaultPort;
        result = 31 * result + this.protocolVersion.hashCode();
        result = 31 * result + this.maxChunkSize;
        result = 31 * result + this.maxWaitQueueSize;
        result = 31 * result + (this.initialSettings != null ? this.initialSettings.hashCode() : 0);
        result = 31 * result + (this.alpnVersions != null ? this.alpnVersions.hashCode() : 0);
        result = 31 * result + (this.http2ClearTextUpgrade ? 1 : 0);
        result = 31 * result + this.http2ConnectionWindowSize;
        result = 31 * result + (this.sendUnmaskedFrames ? 1 : 0);
        result = 31 * result + this.maxRedirects;
        return result;
    }
}

