/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.AsyncResolveConnectHelper;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.HandlerManager;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.net.impl.VertxSniHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class NetServerBase<C extends ConnectionBase>
implements Closeable,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(NetServerBase.class);
    protected final VertxInternal vertx;
    protected final NetServerOptions options;
    protected final ContextImpl creatingContext;
    protected final SSLHelper sslHelper;
    protected final boolean logEnabled;
    private final Map<Channel, C> socketMap = new ConcurrentHashMap<Channel, C>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<Handler<? super C>> handlerManager = new HandlerManager(this.availableWorkers);
    private ChannelGroup serverChannelGroup;
    private boolean paused;
    private volatile boolean listening;
    private Handler<? super C> registeredHandler;
    private volatile ServerID id;
    private NetServerBase actualServer;
    private AsyncResolveConnectHelper bindFuture;
    private volatile int actualPort;
    private ContextImpl listenContext;
    private TCPMetrics metrics;

    public NetServerBase(VertxInternal vertx, NetServerOptions options) {
        this.vertx = vertx;
        this.options = new NetServerOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.creatingContext = vertx.getContext();
        this.logEnabled = options.getLogActivity();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use NetServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
    }

    protected synchronized void pauseAccepting() {
        this.paused = true;
    }

    protected synchronized void resumeAccepting() {
        this.paused = false;
    }

    protected synchronized boolean isPaused() {
        return this.paused;
    }

    protected boolean isListening() {
        return this.listening;
    }

    protected abstract void initChannel(ChannelPipeline var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void listen(Handler<? super C> handler, int port, String host, Handler<AsyncResult<Void>> listenHandler) {
        if (handler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        this.listenContext = this.vertx.getOrCreateContext();
        this.registeredHandler = handler;
        Map<ServerID, NetServerBase> map = this.vertx.sharedNetServers();
        synchronized (map) {
            this.actualPort = port;
            this.id = new ServerID(port, host);
            NetServerBase shared = this.vertx.sharedNetServers().get(this.id);
            if (shared == null || port == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group((EventLoopGroup)this.availableWorkers);
                bootstrap.channel(NioServerSocketChannel.class);
                this.sslHelper.validate(this.vertx);
                bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        if (NetServerBase.this.isPaused()) {
                            ch.close();
                            return;
                        }
                        ChannelPipeline pipeline = ch.pipeline();
                        NetServerBase.this.initChannel(ch.pipeline());
                        pipeline.addLast("handler", (ChannelHandler)new ServerHandler(ch));
                    }
                });
                this.applyConnectionOptions(bootstrap);
                this.handlerManager.addHandler(handler, this.listenContext);
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, port, host, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.succeeded()) {
                            Channel ch = (Channel)res.result();
                            log.trace("Net server listening on " + host + ":" + ch.localAddress());
                            this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                            this.id = new ServerID(this.actualPort, this.id.host);
                            this.serverChannelGroup.add((Object)ch);
                            this.vertx.sharedNetServers().put(this.id, this);
                            this.metrics = this.vertx.metricsSPI().createMetrics(new SocketAddressImpl(this.id.port, this.id.host), this.options);
                        } else {
                            this.vertx.sharedNetServers().remove(this.id);
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return;
                }
                if (port != 0) {
                    this.vertx.sharedNetServers().put(this.id, this);
                }
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort();
                this.metrics = this.vertx.metricsSPI().createMetrics(new SocketAddressImpl(this.id.port, this.id.host), this.options);
                this.actualServer.handlerManager.addHandler(handler, this.listenContext);
            }
            this.actualServer.bindFuture.addListener(res -> {
                if (listenHandler != null) {
                    Future ares;
                    if (res.succeeded()) {
                        ares = Future.succeededFuture();
                    } else {
                        this.listening = false;
                        ares = Future.failedFuture(res.cause());
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(ares));
                } else if (res.failed()) {
                    log.error((Object)"Failed to listen", res.cause());
                    this.listening = false;
                }
            });
        }
    }

    public synchronized void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> done) {
        ContextImpl context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            if (done != null) {
                this.executeCloseDone(context, done, null);
            }
            return;
        }
        this.listening = false;
        Map<ServerID, NetServerBase> map = this.vertx.sharedNetServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.handlerManager.removeHandler(this.registeredHandler, this.listenContext);
                if (this.actualServer.handlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, done);
                }
            }
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
    }

    public synchronized int actualPort() {
        return this.actualPort;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void actualClose(ContextImpl closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedNetServers().remove(this.id);
        }
        ContextImpl currCon = this.vertx.getContext();
        for (ConnectionBase sock : this.socketMap.values()) {
            sock.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener(cg -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            this.executeCloseDone(closeContext, done, (Exception)fut.cause());
        });
    }

    private void executeCloseDone(ContextImpl closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e == null ? Future.succeededFuture() : Future.failedFuture(e);
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    protected abstract void handleMsgReceived(C var1, Object var2);

    protected abstract Object safeObject(Object var1, ByteBufAllocator var2);

    protected abstract C createConnection(VertxInternal var1, Channel var2, ContextImpl var3, SSLHelper var4, TCPMetrics var5);

    protected void applyConnectionOptions(ServerBootstrap bootstrap) {
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.options.isTcpNoDelay());
        if (this.options.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.options.getSendBufferSize());
        }
        if (this.options.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.options.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.options.getReceiveBufferSize()));
        }
        if (this.options.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, (Object)this.options.getSoLinger());
        }
        if (this.options.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, (Object)this.options.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.options.isReuseAddress());
        if (this.options.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.options.getAcceptBacklog());
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class ServerHandler
    extends VertxNetHandler<C> {
        public ServerHandler(Channel ch) {
            super(ch, NetServerBase.this.socketMap);
        }

        @Override
        protected void handleMsgReceived(C conn, Object msg) {
            NetServerBase.this.handleMsgReceived(conn, msg);
        }

        @Override
        protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
            return NetServerBase.this.safeObject(msg, allocator);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            Channel ch = ctx.channel();
            EventLoop worker = ch.eventLoop();
            HandlerHolder handler = NetServerBase.this.handlerManager.chooseHandler(worker);
            if (handler == null) {
                return;
            }
            if (NetServerBase.this.sslHelper.isSSL()) {
                io.netty.util.concurrent.Future handshakeFuture;
                if (NetServerBase.this.options.isSni()) {
                    VertxSniHandler sniHandler = new VertxSniHandler(NetServerBase.this.sslHelper, NetServerBase.this.vertx);
                    handshakeFuture = sniHandler.handshakeFuture();
                    ch.pipeline().addFirst("ssl", (ChannelHandler)sniHandler);
                } else {
                    SslHandler sslHandler = new SslHandler(NetServerBase.this.sslHelper.createEngine(NetServerBase.this.vertx));
                    handshakeFuture = sslHandler.handshakeFuture();
                    ch.pipeline().addFirst("ssl", (ChannelHandler)sslHandler);
                }
                handshakeFuture.addListener(future -> {
                    if (future.isSuccess()) {
                        this.connected(ch, handler);
                    } else {
                        log.error("Client from origin " + ch.remoteAddress() + " failed to connect over ssl: " + future.cause());
                    }
                });
            } else {
                this.connected(ch, handler);
            }
        }

        private void connected(Channel ch, HandlerHolder<Handler<? super C>> handler) {
            ContextImpl.setContext(handler.context);
            Object sock = NetServerBase.this.createConnection(NetServerBase.this.vertx, ch, handler.context, NetServerBase.this.sslHelper, NetServerBase.this.metrics);
            NetServerBase.this.socketMap.put(ch, sock);
            VertxNetHandler netHandler = (VertxNetHandler)ch.pipeline().get(VertxNetHandler.class);
            netHandler.conn = sock;
            handler.context.executeFromIO(() -> {
                sock.metric(NetServerBase.this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
                ((Handler)handler.handler).handle(sock);
            });
        }
    }
}

