/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.AsyncResolveConnectHelper;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.HandlerManager;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.net.impl.VertxSniHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.ReadStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NetServerImpl
implements Closeable,
MetricsProvider,
NetServer {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    protected final VertxInternal vertx;
    protected final NetServerOptions options;
    protected final ContextImpl creatingContext;
    protected final SSLHelper sslHelper;
    protected final boolean logEnabled;
    private final Map<Channel, NetSocketImpl> socketMap = new ConcurrentHashMap<Channel, NetSocketImpl>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<Handler<NetSocket>> handlerManager = new HandlerManager(this.availableWorkers);
    private final NetSocketStream connectStream = new NetSocketStream();
    private ChannelGroup serverChannelGroup;
    private boolean paused;
    private volatile boolean listening;
    private Handler<NetSocket> registeredHandler;
    private volatile ServerID id;
    private NetServerImpl actualServer;
    private AsyncResolveConnectHelper bindFuture;
    private volatile int actualPort;
    private ContextImpl listenContext;
    private TCPMetrics metrics;
    private Handler<NetSocket> handler;
    private Handler<Void> endHandler;

    public NetServerImpl(VertxInternal vertx, NetServerOptions options) {
        this.vertx = vertx;
        this.options = new NetServerOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.creatingContext = vertx.getContext();
        this.logEnabled = options.getLogActivity();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use NetServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
    }

    protected synchronized void pauseAccepting() {
        this.paused = true;
    }

    protected synchronized void resumeAccepting() {
        this.paused = false;
    }

    protected synchronized boolean isPaused() {
        return this.paused;
    }

    protected boolean isListening() {
        return this.listening;
    }

    @Override
    public synchronized Handler<NetSocket> connectHandler() {
        return this.handler;
    }

    @Override
    public synchronized NetServer connectHandler(Handler<NetSocket> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set connectHandler when server is listening");
        }
        this.handler = handler;
        return this;
    }

    protected void initChannel(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (this.sslHelper.isSSL()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void listen(Handler<NetSocket> handler, int port, String host, Handler<AsyncResult<Void>> listenHandler) {
        if (handler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        this.listenContext = this.vertx.getOrCreateContext();
        this.registeredHandler = handler;
        Map<ServerID, NetServerImpl> map = this.vertx.sharedNetServers();
        synchronized (map) {
            this.actualPort = port;
            this.id = new ServerID(port, host);
            NetServerImpl shared = this.vertx.sharedNetServers().get(this.id);
            if (shared == null || port == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group((EventLoopGroup)this.availableWorkers);
                bootstrap.channel(NioServerSocketChannel.class);
                this.sslHelper.validate(this.vertx);
                bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        if (NetServerImpl.this.isPaused()) {
                            ch.close();
                            return;
                        }
                        if (NetServerImpl.this.sslHelper.isSSL()) {
                            io.netty.util.concurrent.Future handshakeFuture;
                            if (NetServerImpl.this.options.isSni()) {
                                VertxSniHandler sniHandler = new VertxSniHandler(NetServerImpl.this.sslHelper, NetServerImpl.this.vertx);
                                handshakeFuture = sniHandler.handshakeFuture();
                                ch.pipeline().addFirst("ssl", (ChannelHandler)sniHandler);
                            } else {
                                SslHandler sslHandler = new SslHandler(NetServerImpl.this.sslHelper.createEngine(NetServerImpl.this.vertx));
                                handshakeFuture = sslHandler.handshakeFuture();
                                ch.pipeline().addFirst("ssl", (ChannelHandler)sslHandler);
                            }
                            handshakeFuture.addListener(future -> {
                                if (future.isSuccess()) {
                                    NetServerImpl.this.connected(ch);
                                } else {
                                    log.error("Client from origin " + ch.remoteAddress() + " failed to connect over ssl: " + future.cause());
                                }
                            });
                        } else {
                            NetServerImpl.this.connected(ch);
                        }
                    }
                });
                this.applyConnectionOptions(bootstrap);
                this.handlerManager.addHandler(handler, this.listenContext);
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, port, host, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.succeeded()) {
                            Channel ch = (Channel)res.result();
                            log.trace("Net server listening on " + host + ":" + ch.localAddress());
                            this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                            this.id = new ServerID(this.actualPort, this.id.host);
                            this.serverChannelGroup.add((Object)ch);
                            this.vertx.sharedNetServers().put(this.id, this);
                            VertxMetrics metrics = this.vertx.metricsSPI();
                            if (metrics != null) {
                                this.metrics = metrics.createMetrics(new SocketAddressImpl(this.id.port, this.id.host), this.options);
                            }
                        } else {
                            this.vertx.sharedNetServers().remove(this.id);
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return;
                }
                if (port != 0) {
                    this.vertx.sharedNetServers().put(this.id, this);
                }
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort();
                VertxMetrics metrics = this.vertx.metricsSPI();
                this.metrics = metrics != null ? metrics.createMetrics(new SocketAddressImpl(this.id.port, this.id.host), this.options) : null;
                this.actualServer.handlerManager.addHandler(handler, this.listenContext);
            }
            this.actualServer.bindFuture.addListener(res -> {
                if (listenHandler != null) {
                    Future ares;
                    if (res.succeeded()) {
                        ares = Future.succeededFuture();
                    } else {
                        this.listening = false;
                        ares = Future.failedFuture(res.cause());
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(ares));
                } else if (res.failed()) {
                    log.error((Object)"Failed to listen", res.cause());
                    this.listening = false;
                }
            });
        }
    }

    @Override
    public synchronized void close() {
        this.close(null);
    }

    @Override
    public NetServer listen(int port, String host) {
        return this.listen(port, host, null);
    }

    @Override
    public NetServer listen(int port) {
        return this.listen(port, "0.0.0.0", null);
    }

    @Override
    public NetServer listen(int port, Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(port, "0.0.0.0", listenHandler);
    }

    @Override
    public NetServer listen() {
        this.listen(null);
        return this;
    }

    @Override
    public synchronized NetServer listen(int port, String host, Handler<AsyncResult<NetServer>> listenHandler) {
        this.listen(this.handler, port, host, ar -> {
            if (listenHandler != null) {
                listenHandler.handle(ar.map(this));
            }
        });
        return this;
    }

    @Override
    public synchronized NetServer listen(Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), listenHandler);
    }

    @Override
    public ReadStream<NetSocket> connectStream() {
        return this.connectStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> done) {
        if (this.endHandler != null) {
            Handler<Void> handler = this.endHandler;
            this.endHandler = null;
            Handler<AsyncResult<Void>> next = done;
            done = event -> {
                if (event.succeeded()) {
                    handler.handle((Void)event.result());
                }
                if (next != null) {
                    next.handle((AsyncResult<Void>)event);
                }
            };
        }
        ContextImpl context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            if (done != null) {
                this.executeCloseDone(context, done, null);
            }
            return;
        }
        this.listening = false;
        Map<ServerID, NetServerImpl> map = this.vertx.sharedNetServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.handlerManager.removeHandler(this.registeredHandler, this.listenContext);
                if (this.actualServer.handlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, done);
                }
            }
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
    }

    @Override
    public synchronized int actualPort() {
        return this.actualPort;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void actualClose(ContextImpl closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedNetServers().remove(this.id);
        }
        ContextImpl currCon = this.vertx.getContext();
        for (NetSocketImpl sock : this.socketMap.values()) {
            sock.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener(cg -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            this.executeCloseDone(closeContext, done, (Exception)fut.cause());
        });
    }

    private void connected(Channel ch) {
        EventLoop worker = ch.eventLoop();
        HandlerHolder<Handler<NetSocket>> handler = this.handlerManager.chooseHandler(worker);
        if (handler == null) {
            return;
        }
        ContextImpl.setContext(handler.context);
        this.initChannel(ch.pipeline());
        VertxNetHandler nh = new VertxNetHandler(ctx -> new NetSocketImpl(this.vertx, (ChannelHandlerContext)ctx, handler.context, this.sslHelper, this.metrics)){

            @Override
            protected void handleMessage(NetSocketImpl connection, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
                connection.handleMessageReceived(msg);
            }
        };
        nh.addHandler(conn -> this.socketMap.put(ch, (NetSocketImpl)conn));
        nh.removeHandler(conn -> this.socketMap.remove(ch));
        ch.pipeline().addLast("handler", (ChannelHandler)nh);
        NetSocketImpl sock = (NetSocketImpl)nh.getConnection();
        handler.context.executeFromIO(() -> {
            if (this.metrics != null) {
                sock.metric(this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
            }
            ((Handler)handler.handler).handle(sock);
        });
    }

    private void executeCloseDone(ContextImpl closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e == null ? Future.succeededFuture() : Future.failedFuture(e);
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    protected void applyConnectionOptions(ServerBootstrap bootstrap) {
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.options.isTcpNoDelay());
        if (this.options.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.options.getSendBufferSize());
        }
        if (this.options.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.options.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.options.getReceiveBufferSize()));
        }
        if (this.options.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, (Object)this.options.getSoLinger());
        }
        if (this.options.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, (Object)this.options.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.options.isReuseAddress());
        if (this.options.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.options.getAcceptBacklog());
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class NetSocketStream
    implements ReadStream<NetSocket> {
        private NetSocketStream() {
        }

        public NetSocketStream handler(Handler<NetSocket> handler) {
            NetServerImpl.this.connectHandler(handler);
            return this;
        }

        public NetSocketStream pause() {
            NetServerImpl.this.pauseAccepting();
            return this;
        }

        public NetSocketStream resume() {
            NetServerImpl.this.resumeAccepting();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetSocketStream endHandler(Handler<Void> handler) {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                NetServerImpl.this.endHandler = handler;
                return this;
            }
        }

        @Override
        public NetSocketStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }
}

