/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.codegen;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.test.codegen.AggregatedDataObject;
import io.vertx.test.codegen.ChildInheritingDataObject;
import io.vertx.test.codegen.ChildInheritingDataObjectConverter;
import io.vertx.test.codegen.ChildNotInheritingDataObject;
import io.vertx.test.codegen.ChildNotInheritingDataObjectConverter;
import io.vertx.test.codegen.NoConverterDataObject;
import io.vertx.test.codegen.TestDataObject;
import io.vertx.test.codegen.TestDataObjectConverter;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;

public class DataObjectTest
extends VertxTestBase {
    private static JsonObject toJson(Map<String, Object> map) {
        JsonObject json = new JsonObject();
        map.forEach((arg_0, arg_1) -> ((JsonObject)json).put(arg_0, arg_1));
        return json;
    }

    @Test
    public void testJsonToDataObject() {
        String key = TestUtils.randomAlphaString(10);
        String stringValue = TestUtils.randomAlphaString(20);
        boolean booleanValue = TestUtils.randomBoolean();
        byte byteValue = TestUtils.randomByte();
        short shortValue = TestUtils.randomShort();
        int intValue = TestUtils.randomInt();
        long longValue = TestUtils.randomLong();
        float floatValue = TestUtils.randomFloat();
        double doubleValue = TestUtils.randomDouble();
        char charValue = TestUtils.randomChar();
        Boolean boxedBooleanValue = TestUtils.randomBoolean();
        Byte boxedByteValue = TestUtils.randomByte();
        Short boxedShortValue = TestUtils.randomShort();
        Integer boxedIntValue = TestUtils.randomInt();
        Long boxedLongValue = TestUtils.randomLong();
        Float boxedFloatValue = Float.valueOf(TestUtils.randomFloat());
        Double boxedDoubleValue = TestUtils.randomDouble();
        Character boxedCharValue = Character.valueOf(TestUtils.randomChar());
        AggregatedDataObject aggregatedDataObject = new AggregatedDataObject().setValue(TestUtils.randomAlphaString(20));
        Buffer buffer = TestUtils.randomBuffer(20);
        JsonObject jsonObject = new JsonObject().put("wibble", TestUtils.randomAlphaString(20));
        JsonArray jsonArray = new JsonArray().add(TestUtils.randomAlphaString(20));
        HttpMethod httpMethod = HttpMethod.values()[TestUtils.randomPositiveInt() % HttpMethod.values().length];
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomAlphaString(20));
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomBoolean());
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomInt());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(TestUtils.randomAlphaString(20));
        list.add(TestUtils.randomBoolean());
        list.add(TestUtils.randomInt());
        JsonObject json = new JsonObject();
        json.put("stringValue", stringValue);
        json.put("booleanValue", Boolean.valueOf(booleanValue));
        json.put("byteValue", (Object)byteValue);
        json.put("shortValue", (Object)shortValue);
        json.put("intValue", Integer.valueOf(intValue));
        json.put("longValue", Long.valueOf(longValue));
        json.put("floatValue", Float.valueOf(floatValue));
        json.put("doubleValue", Double.valueOf(doubleValue));
        json.put("charValue", Character.toString(charValue));
        json.put("boxedBooleanValue", boxedBooleanValue);
        json.put("boxedByteValue", (Object)boxedByteValue);
        json.put("boxedShortValue", (Object)boxedShortValue);
        json.put("boxedIntValue", boxedIntValue);
        json.put("boxedLongValue", boxedLongValue);
        json.put("boxedFloatValue", boxedFloatValue);
        json.put("boxedDoubleValue", boxedDoubleValue);
        json.put("boxedCharValue", Character.toString(boxedCharValue.charValue()));
        json.put("aggregatedDataObject", aggregatedDataObject.toJson());
        json.put("buffer", this.toBase64(buffer));
        json.put("jsonObject", jsonObject);
        json.put("jsonArray", jsonArray);
        json.put("httpMethod", httpMethod.toString());
        json.put("stringValues", new JsonArray().add(stringValue));
        json.put("boxedBooleanValues", new JsonArray().add(boxedBooleanValue));
        json.put("boxedByteValues", new JsonArray().add((Object)boxedByteValue));
        json.put("boxedShortValues", new JsonArray().add((Object)boxedShortValue));
        json.put("boxedIntValues", new JsonArray().add(boxedIntValue));
        json.put("boxedLongValues", new JsonArray().add(boxedLongValue));
        json.put("boxedFloatValues", new JsonArray().add(boxedFloatValue));
        json.put("boxedDoubleValues", new JsonArray().add(boxedDoubleValue));
        json.put("boxedCharValues", new JsonArray().add(Character.toString(boxedCharValue.charValue())));
        json.put("aggregatedDataObjects", new JsonArray().add(aggregatedDataObject.toJson()));
        json.put("buffers", new JsonArray().add(this.toBase64(buffer)));
        json.put("jsonObjects", new JsonArray().add(jsonObject));
        json.put("jsonArrays", new JsonArray().add(jsonArray));
        json.put("httpMethods", new JsonArray().add(httpMethod.toString()));
        json.put("objects", new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)));
        json.put("addedStringValues", new JsonArray().add(stringValue));
        json.put("addedBooleanValues", new JsonArray().add(boxedBooleanValue));
        json.put("addedByteValues", new JsonArray().add((Object)boxedByteValue));
        json.put("addedShortValues", new JsonArray().add((Object)boxedShortValue));
        json.put("addedIntValues", new JsonArray().add(boxedIntValue));
        json.put("addedLongValues", new JsonArray().add(boxedLongValue));
        json.put("addedFloatValues", new JsonArray().add(boxedFloatValue));
        json.put("addedDoubleValues", new JsonArray().add(boxedDoubleValue));
        json.put("addedCharValues", new JsonArray().add(Character.toString(boxedCharValue.charValue())));
        json.put("addedBoxedBooleanValues", new JsonArray().add(boxedBooleanValue));
        json.put("addedBoxedByteValues", new JsonArray().add((Object)boxedByteValue));
        json.put("addedBoxedShortValues", new JsonArray().add((Object)boxedShortValue));
        json.put("addedBoxedIntValues", new JsonArray().add(boxedIntValue));
        json.put("addedBoxedLongValues", new JsonArray().add(boxedLongValue));
        json.put("addedBoxedFloatValues", new JsonArray().add(boxedFloatValue));
        json.put("addedBoxedDoubleValues", new JsonArray().add(boxedDoubleValue));
        json.put("addedBoxedCharValues", new JsonArray().add(Character.toString(boxedCharValue.charValue())));
        json.put("addedAggregatedDataObjects", new JsonArray().add(aggregatedDataObject.toJson()));
        json.put("addedBuffers", new JsonArray().add(this.toBase64(buffer)));
        json.put("addedJsonObjects", new JsonArray().add(jsonObject));
        json.put("addedJsonArrays", new JsonArray().add(jsonArray));
        json.put("addedHttpMethods", new JsonArray().add(httpMethod.toString()));
        json.put("addedObjects", new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)));
        json.put("stringValueMap", new JsonObject().put(key, stringValue));
        json.put("boxedBooleanValueMap", new JsonObject().put(key, boxedBooleanValue));
        json.put("boxedByteValueMap", new JsonObject().put(key, (Object)boxedByteValue));
        json.put("boxedShortValueMap", new JsonObject().put(key, (Object)boxedShortValue));
        json.put("boxedIntValueMap", new JsonObject().put(key, boxedIntValue));
        json.put("boxedLongValueMap", new JsonObject().put(key, boxedLongValue));
        json.put("boxedFloatValueMap", new JsonObject().put(key, boxedFloatValue));
        json.put("boxedDoubleValueMap", new JsonObject().put(key, boxedDoubleValue));
        json.put("boxedCharValueMap", new JsonObject().put(key, Character.toString(boxedCharValue.charValue())));
        json.put("aggregatedDataObjectMap", new JsonObject().put(key, aggregatedDataObject.toJson()));
        json.put("bufferMap", new JsonObject().put(key, this.toBase64(buffer)));
        json.put("jsonObjectMap", new JsonObject().put(key, jsonObject));
        json.put("jsonArrayMap", new JsonObject().put(key, jsonArray));
        json.put("httpMethodMap", new JsonObject().put(key, httpMethod.toString()));
        json.put("objectMap", DataObjectTest.toJson(map));
        json.put("keyedStringValues", new JsonObject().put(key, stringValue));
        json.put("keyedBoxedBooleanValues", new JsonObject().put(key, boxedBooleanValue));
        json.put("keyedBoxedByteValues", new JsonObject().put(key, (Object)boxedByteValue));
        json.put("keyedBoxedShortValues", new JsonObject().put(key, (Object)boxedShortValue));
        json.put("keyedBoxedIntValues", new JsonObject().put(key, boxedIntValue));
        json.put("keyedBoxedLongValues", new JsonObject().put(key, boxedLongValue));
        json.put("keyedBoxedFloatValues", new JsonObject().put(key, boxedFloatValue));
        json.put("keyedBoxedDoubleValues", new JsonObject().put(key, boxedDoubleValue));
        json.put("keyedBoxedCharValues", new JsonObject().put(key, Character.toString(boxedCharValue.charValue())));
        json.put("keyedDataObjectValues", new JsonObject().put(key, aggregatedDataObject.toJson()));
        json.put("keyedBufferValues", new JsonObject().put(key, this.toBase64(buffer)));
        json.put("keyedJsonObjectValues", new JsonObject().put(key, jsonObject));
        json.put("keyedJsonArrayValues", new JsonObject().put(key, jsonArray));
        json.put("keyedEnumValues", new JsonObject().put(key, (Enum)httpMethod));
        json.put("keyedObjectValues", DataObjectTest.toJson(map));
        TestDataObject obj = new TestDataObject();
        TestDataObjectConverter.fromJson(json, obj);
        this.assertEquals(stringValue, obj.getStringValue());
        this.assertEquals(booleanValue, obj.isBooleanValue());
        this.assertEquals(byteValue, obj.getByteValue());
        this.assertEquals(shortValue, obj.getShortValue());
        this.assertEquals(intValue, obj.getIntValue());
        this.assertEquals(longValue, obj.getLongValue());
        this.assertEquals(floatValue, (double)obj.getFloatValue(), 0.0);
        this.assertEquals(doubleValue, obj.getDoubleValue(), 0.0);
        this.assertEquals(charValue, obj.getCharValue());
        this.assertEquals(boxedBooleanValue, obj.isBoxedBooleanValue());
        this.assertEquals(boxedByteValue, obj.getBoxedByteValue());
        this.assertEquals(boxedShortValue, obj.getBoxedShortValue());
        this.assertEquals(boxedIntValue, obj.getBoxedIntValue());
        this.assertEquals(boxedLongValue, obj.getBoxedLongValue());
        this.assertEquals(boxedFloatValue.floatValue(), (double)obj.getBoxedFloatValue().floatValue(), 0.0);
        this.assertEquals(boxedDoubleValue, (double)obj.getBoxedDoubleValue(), 0.0);
        this.assertEquals(boxedCharValue, obj.getBoxedCharValue());
        this.assertEquals(aggregatedDataObject, obj.getAggregatedDataObject());
        this.assertEquals(buffer, obj.getBuffer());
        this.assertEquals(jsonObject, obj.getJsonObject());
        this.assertEquals(jsonArray, obj.getJsonArray());
        this.assertEquals(httpMethod, obj.getHttpMethod());
        this.assertEquals(Collections.singletonList(stringValue), obj.getStringValues());
        this.assertEquals(Collections.singletonList(boxedBooleanValue), obj.getBoxedBooleanValues());
        this.assertEquals(Collections.singletonList(boxedByteValue), obj.getBoxedByteValues());
        this.assertEquals(Collections.singletonList(boxedShortValue), obj.getBoxedShortValues());
        this.assertEquals(Collections.singletonList(boxedIntValue), obj.getBoxedIntValues());
        this.assertEquals(Collections.singletonList(boxedLongValue), obj.getBoxedLongValues());
        this.assertEquals(Collections.singletonList(boxedFloatValue), obj.getBoxedFloatValues());
        this.assertEquals(Collections.singletonList(boxedDoubleValue), obj.getBoxedDoubleValues());
        this.assertEquals(Collections.singletonList(boxedCharValue), obj.getBoxedCharValues());
        this.assertEquals(Collections.singletonList(aggregatedDataObject), obj.getAggregatedDataObjects());
        this.assertEquals(Collections.singletonList(buffer), obj.getBuffers());
        this.assertEquals(Collections.singletonList(jsonObject), obj.getJsonObjects());
        this.assertEquals(Collections.singletonList(jsonArray), obj.getJsonArrays());
        this.assertEquals(Collections.singletonList(httpMethod), obj.getHttpMethods());
        this.assertEquals(list, obj.getObjects());
        this.assertEquals(Collections.singletonList(stringValue), obj.getAddedStringValues());
        this.assertEquals(Collections.singletonList(boxedBooleanValue), obj.getAddedBoxedBooleanValues());
        this.assertEquals(Collections.singletonList(boxedByteValue), obj.getAddedBoxedByteValues());
        this.assertEquals(Collections.singletonList(boxedShortValue), obj.getAddedBoxedShortValues());
        this.assertEquals(Collections.singletonList(boxedIntValue), obj.getAddedBoxedIntValues());
        this.assertEquals(Collections.singletonList(boxedLongValue), obj.getAddedBoxedLongValues());
        this.assertEquals(Collections.singletonList(boxedFloatValue), obj.getAddedBoxedFloatValues());
        this.assertEquals(Collections.singletonList(boxedDoubleValue), obj.getAddedBoxedDoubleValues());
        this.assertEquals(Collections.singletonList(boxedCharValue), obj.getAddedBoxedCharValues());
        this.assertEquals(Collections.singletonList(aggregatedDataObject), obj.getAddedAggregatedDataObjects());
        this.assertEquals(Collections.singletonList(buffer), obj.getAddedBuffers());
        this.assertEquals(Collections.singletonList(jsonObject), obj.getAddedJsonObjects());
        this.assertEquals(Collections.singletonList(jsonArray), obj.getAddedJsonArrays());
        this.assertEquals(Collections.singletonList(httpMethod), obj.getAddedHttpMethods());
        this.assertEquals(list, obj.getAddedObjects());
        this.assertEquals(Collections.singletonMap(key, stringValue), obj.getStringValueMap());
        this.assertEquals(Collections.singletonMap(key, boxedBooleanValue), obj.getBoxedBooleanValueMap());
        this.assertEquals(Collections.singletonMap(key, boxedByteValue), obj.getBoxedByteValueMap());
        this.assertEquals(Collections.singletonMap(key, boxedShortValue), obj.getBoxedShortValueMap());
        this.assertEquals(Collections.singletonMap(key, boxedIntValue), obj.getBoxedIntValueMap());
        this.assertEquals(Collections.singletonMap(key, boxedLongValue), obj.getBoxedLongValueMap());
        this.assertEquals(Collections.singletonMap(key, boxedFloatValue), obj.getBoxedFloatValueMap());
        this.assertEquals(Collections.singletonMap(key, boxedDoubleValue), obj.getBoxedDoubleValueMap());
        this.assertEquals(Collections.singletonMap(key, boxedCharValue), obj.getBoxedCharValueMap());
        this.assertEquals(Collections.singletonMap(key, aggregatedDataObject), obj.getAggregatedDataObjectMap());
        this.assertEquals(Collections.singletonMap(key, buffer), obj.getBufferMap());
        this.assertEquals(Collections.singletonMap(key, jsonObject), obj.getJsonObjectMap());
        this.assertEquals(Collections.singletonMap(key, jsonArray), obj.getJsonArrayMap());
        this.assertEquals(Collections.singletonMap(key, httpMethod), obj.getHttpMethodMap());
        this.assertEquals(map, obj.getObjectMap());
        this.assertEquals(Collections.singletonMap(key, stringValue), obj.getKeyedStringValues());
        this.assertEquals(Collections.singletonMap(key, boxedBooleanValue), obj.getKeyedBoxedBooleanValues());
        this.assertEquals(Collections.singletonMap(key, boxedByteValue), obj.getKeyedBoxedByteValues());
        this.assertEquals(Collections.singletonMap(key, boxedShortValue), obj.getKeyedBoxedShortValues());
        this.assertEquals(Collections.singletonMap(key, boxedIntValue), obj.getKeyedBoxedIntValues());
        this.assertEquals(Collections.singletonMap(key, boxedLongValue), obj.getKeyedBoxedLongValues());
        this.assertEquals(Collections.singletonMap(key, boxedFloatValue), obj.getKeyedBoxedFloatValues());
        this.assertEquals(Collections.singletonMap(key, boxedDoubleValue), obj.getKeyedBoxedDoubleValues());
        this.assertEquals(Collections.singletonMap(key, boxedCharValue), obj.getKeyedBoxedCharValues());
        this.assertEquals(Collections.singletonMap(key, aggregatedDataObject), obj.getKeyedDataObjectValues());
        this.assertEquals(Collections.singletonMap(key, buffer), obj.getKeyedBufferValues());
        this.assertEquals(Collections.singletonMap(key, jsonObject), obj.getKeyedJsonObjectValues());
        this.assertEquals(Collections.singletonMap(key, jsonArray), obj.getKeyedJsonArrayValues());
        this.assertEquals(Collections.singletonMap(key, httpMethod), obj.getKeyedEnumValues());
        this.assertEquals(map, obj.getObjectMap());
        json = new JsonObject();
        json.put("aggregatedDataObject", (Object)new JsonObject().put("value", aggregatedDataObject.getValue()).getMap());
        json.put("aggregatedDataObjects", new JsonArray().add((Object)new JsonObject().put("value", aggregatedDataObject.getValue()).getMap()));
        json.put("addedAggregatedDataObjects", new JsonArray().add((Object)new JsonObject().put("value", aggregatedDataObject.getValue()).getMap()));
        obj = new TestDataObject();
        TestDataObjectConverter.fromJson(json, obj);
        this.assertEquals(aggregatedDataObject, obj.getAggregatedDataObject());
        this.assertEquals(Collections.singletonList(aggregatedDataObject), obj.getAggregatedDataObjects());
        this.assertEquals(Collections.singletonList(aggregatedDataObject), obj.getAddedAggregatedDataObjects());
    }

    @Test
    public void testEmptyJsonToDataObject() {
        JsonObject json = new JsonObject();
        TestDataObject obj = new TestDataObject();
        TestDataObjectConverter.fromJson(json, obj);
        this.assertEquals(null, obj.getStringValue());
        this.assertEquals(false, obj.isBooleanValue());
        this.assertEquals(0L, obj.getByteValue());
        this.assertEquals(0L, obj.getShortValue());
        this.assertEquals(0L, obj.getIntValue());
        this.assertEquals(0L, obj.getLongValue());
        this.assertEquals(0.0, (double)obj.getFloatValue(), 0.0);
        this.assertEquals(0.0, obj.getDoubleValue(), 0.0);
        this.assertEquals(0L, obj.getCharValue());
        this.assertEquals(null, obj.isBoxedBooleanValue());
        this.assertEquals(null, obj.getBoxedByteValue());
        this.assertEquals(null, obj.getBoxedShortValue());
        this.assertEquals(null, obj.getBoxedIntValue());
        this.assertEquals(null, obj.getBoxedLongValue());
        this.assertEquals(null, obj.getBoxedFloatValue());
        this.assertEquals(null, obj.getBoxedDoubleValue());
        this.assertEquals(null, obj.getBoxedCharValue());
        this.assertEquals(null, obj.getAggregatedDataObject());
        this.assertEquals(null, obj.getBuffer());
        this.assertEquals(null, obj.getJsonObject());
        this.assertEquals(null, obj.getJsonArray());
        this.assertEquals(null, obj.getStringValues());
        this.assertEquals(null, obj.getBoxedBooleanValues());
        this.assertEquals(null, obj.getBoxedByteValues());
        this.assertEquals(null, obj.getBoxedShortValues());
        this.assertEquals(null, obj.getBoxedIntValues());
        this.assertEquals(null, obj.getBoxedLongValues());
        this.assertEquals(null, obj.getBoxedFloatValues());
        this.assertEquals(null, obj.getBoxedDoubleValues());
        this.assertEquals(null, obj.getBoxedCharValues());
        this.assertEquals(null, obj.getAggregatedDataObjects());
        this.assertEquals(null, obj.getBuffers());
        this.assertEquals(null, obj.getJsonObjects());
        this.assertEquals(null, obj.getJsonArrays());
        this.assertEquals(null, obj.getHttpMethods());
        this.assertEquals(null, obj.getObjects());
        this.assertEquals(Collections.emptyList(), obj.getAddedStringValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedBoxedBooleanValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedBoxedByteValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedBoxedShortValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedBoxedIntValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedBoxedLongValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedBoxedFloatValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedBoxedDoubleValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedBoxedCharValues());
        this.assertEquals(Collections.emptyList(), obj.getAddedAggregatedDataObjects());
        this.assertEquals(Collections.emptyList(), obj.getAddedBuffers());
        this.assertEquals(Collections.emptyList(), obj.getAddedJsonObjects());
        this.assertEquals(Collections.emptyList(), obj.getAddedJsonArrays());
        this.assertEquals(Collections.emptyList(), obj.getAddedHttpMethods());
        this.assertEquals(Collections.emptyList(), obj.getAddedObjects());
        this.assertEquals(null, obj.getStringValueMap());
        this.assertEquals(null, obj.getBoxedBooleanValueMap());
        this.assertEquals(null, obj.getBoxedByteValueMap());
        this.assertEquals(null, obj.getBoxedShortValueMap());
        this.assertEquals(null, obj.getBoxedIntValueMap());
        this.assertEquals(null, obj.getBoxedLongValueMap());
        this.assertEquals(null, obj.getBoxedFloatValueMap());
        this.assertEquals(null, obj.getBoxedDoubleValueMap());
        this.assertEquals(null, obj.getBoxedCharValueMap());
        this.assertEquals(null, obj.getAggregatedDataObjectMap());
        this.assertEquals(null, obj.getBufferMap());
        this.assertEquals(null, obj.getJsonObjectMap());
        this.assertEquals(null, obj.getJsonArrayMap());
        this.assertEquals(null, obj.getHttpMethodMap());
        this.assertEquals(null, obj.getObjectMap());
    }

    @Test
    public void testDataObjectToJson() {
        String key = TestUtils.randomAlphaString(10);
        String stringValue = TestUtils.randomAlphaString(20);
        boolean booleanValue = TestUtils.randomBoolean();
        byte byteValue = TestUtils.randomByte();
        short shortValue = TestUtils.randomShort();
        int intValue = TestUtils.randomInt();
        long longValue = TestUtils.randomLong();
        float floatValue = TestUtils.randomFloat();
        double doubleValue = TestUtils.randomDouble();
        char charValue = TestUtils.randomChar();
        Boolean boxedBooleanValue = TestUtils.randomBoolean();
        Byte boxedByteValue = TestUtils.randomByte();
        Short boxedShortValue = TestUtils.randomShort();
        Integer boxedIntValue = TestUtils.randomInt();
        Long boxedLongValue = TestUtils.randomLong();
        Float boxedFloatValue = Float.valueOf(TestUtils.randomFloat());
        Double boxedDoubleValue = TestUtils.randomDouble();
        Character boxedCharValue = Character.valueOf(TestUtils.randomChar());
        AggregatedDataObject aggregatedDataObject = new AggregatedDataObject().setValue(TestUtils.randomAlphaString(20));
        Buffer buffer = TestUtils.randomBuffer(20);
        JsonObject jsonObject = new JsonObject().put("wibble", TestUtils.randomAlphaString(20));
        JsonArray jsonArray = new JsonArray().add(TestUtils.randomAlphaString(20));
        HttpMethod httpMethod = HttpMethod.values()[TestUtils.randomPositiveInt() % HttpMethod.values().length];
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomAlphaString(20));
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomBoolean());
        map.put(TestUtils.randomAlphaString(10), TestUtils.randomInt());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(TestUtils.randomAlphaString(20));
        list.add(TestUtils.randomBoolean());
        list.add(TestUtils.randomInt());
        TestDataObject obj = new TestDataObject();
        obj.setStringValue(stringValue);
        obj.setBooleanValue(booleanValue);
        obj.setByteValue(byteValue);
        obj.setShortValue(shortValue);
        obj.setIntValue(intValue);
        obj.setLongValue(longValue);
        obj.setFloatValue(floatValue);
        obj.setDoubleValue(doubleValue);
        obj.setCharValue(charValue);
        obj.setBoxedBooleanValue(boxedBooleanValue);
        obj.setBoxedByteValue(boxedByteValue);
        obj.setBoxedShortValue(boxedShortValue);
        obj.setBoxedIntValue(boxedIntValue);
        obj.setBoxedLongValue(boxedLongValue);
        obj.setBoxedFloatValue(boxedFloatValue);
        obj.setBoxedDoubleValue(boxedDoubleValue);
        obj.setBoxedCharValue(boxedCharValue);
        obj.setAggregatedDataObject(aggregatedDataObject);
        obj.setBuffer(buffer);
        obj.setJsonObject(jsonObject);
        obj.setJsonArray(jsonArray);
        obj.setHttpMethod(httpMethod);
        obj.setStringValues(Collections.singletonList(stringValue));
        obj.setBoxedBooleanValues(Collections.singletonList(boxedBooleanValue));
        obj.setBoxedByteValues(Collections.singletonList(boxedByteValue));
        obj.setBoxedShortValues(Collections.singletonList(boxedShortValue));
        obj.setBoxedIntValues(Collections.singletonList(boxedIntValue));
        obj.setBoxedLongValues(Collections.singletonList(boxedLongValue));
        obj.setBoxedFloatValues(Collections.singletonList(boxedFloatValue));
        obj.setBoxedDoubleValues(Collections.singletonList(boxedDoubleValue));
        obj.setBoxedCharValues(Collections.singletonList(boxedCharValue));
        obj.setAggregatedDataObjects(Collections.singletonList(aggregatedDataObject));
        obj.setBuffers(Collections.singletonList(buffer));
        obj.setJsonObjects(Collections.singletonList(jsonObject));
        obj.setJsonArrays(Collections.singletonList(jsonArray));
        obj.setHttpMethods(Collections.singletonList(httpMethod));
        obj.setObjects(list);
        obj.setStringValueMap(Collections.singletonMap(key, stringValue));
        obj.setBoxedBooleanValueMap(Collections.singletonMap(key, boxedBooleanValue));
        obj.setBoxedByteValueMap(Collections.singletonMap(key, boxedByteValue));
        obj.setBoxedShortValueMap(Collections.singletonMap(key, boxedShortValue));
        obj.setBoxedIntValueMap(Collections.singletonMap(key, boxedIntValue));
        obj.setBoxedLongValueMap(Collections.singletonMap(key, boxedLongValue));
        obj.setBoxedFloatValueMap(Collections.singletonMap(key, boxedFloatValue));
        obj.setBoxedDoubleValueMap(Collections.singletonMap(key, boxedDoubleValue));
        obj.setBoxedCharValueMap(Collections.singletonMap(key, boxedCharValue));
        obj.setAggregatedDataObjectMap(Collections.singletonMap(key, aggregatedDataObject));
        obj.setBufferMap(Collections.singletonMap(key, buffer));
        obj.setJsonObjectMap(Collections.singletonMap(key, jsonObject));
        obj.setJsonArrayMap(Collections.singletonMap(key, jsonArray));
        obj.setHttpMethodMap(Collections.singletonMap(key, httpMethod));
        obj.setObjectMap(map);
        obj.addKeyedStringValue(key, stringValue);
        obj.addKeyedBoxedBooleanValue(key, boxedBooleanValue);
        obj.addKeyedBoxedByteValue(key, boxedByteValue);
        obj.addKeyedBoxedShortValue(key, boxedShortValue);
        obj.addKeyedBoxedIntValue(key, boxedIntValue);
        obj.addKeyedBoxedLongValue(key, boxedLongValue);
        obj.addKeyedBoxedFloatValue(key, boxedFloatValue);
        obj.addKeyedBoxedDoubleValue(key, boxedDoubleValue);
        obj.addKeyedBoxedCharValue(key, boxedCharValue);
        obj.addKeyedDataObjectValue(key, aggregatedDataObject);
        obj.addKeyedBufferValue(key, buffer);
        obj.addKeyedJsonObjectValue(key, jsonObject);
        obj.addKeyedJsonArrayValue(key, jsonArray);
        obj.addKeyedEnumValue(key, httpMethod);
        map.forEach(obj::addKeyedObjectValue);
        JsonObject json = new JsonObject();
        TestDataObjectConverter.toJson(obj, json);
        json = new JsonObject(json.encode());
        this.assertEquals(stringValue, json.getString("stringValue"));
        this.assertEquals(booleanValue, json.getBoolean("booleanValue"));
        this.assertEquals(byteValue, json.getInteger("byteValue").intValue());
        this.assertEquals(shortValue, json.getInteger("shortValue").intValue());
        this.assertEquals(intValue, json.getInteger("intValue").intValue());
        this.assertEquals(longValue, json.getLong("longValue"));
        this.assertEquals(floatValue, (double)json.getFloat("floatValue").floatValue(), 0.001);
        this.assertEquals(doubleValue, (double)json.getFloat("doubleValue").floatValue(), 0.001);
        this.assertEquals(Character.toString(charValue), json.getString("charValue"));
        this.assertEquals(boxedBooleanValue, json.getBoolean("boxedBooleanValue"));
        this.assertEquals(boxedByteValue.byteValue(), json.getInteger("boxedByteValue").intValue());
        this.assertEquals(boxedShortValue.shortValue(), json.getInteger("boxedShortValue").intValue());
        this.assertEquals(boxedIntValue, json.getInteger("boxedIntValue"));
        this.assertEquals(boxedLongValue, json.getLong("boxedLongValue"));
        this.assertEquals(boxedFloatValue.floatValue(), (double)json.getFloat("boxedFloatValue").floatValue(), 0.001);
        this.assertEquals(boxedDoubleValue, (double)json.getFloat("boxedDoubleValue").floatValue(), 0.001);
        this.assertEquals(Character.toString(boxedCharValue.charValue()), json.getString("boxedCharValue"));
        this.assertEquals(aggregatedDataObject.toJson(), json.getJsonObject("aggregatedDataObject"));
        this.assertEquals(buffer, Buffer.buffer((byte[])json.getBinary("buffer")));
        this.assertEquals(jsonObject, json.getJsonObject("jsonObject"));
        this.assertEquals(jsonArray, json.getJsonArray("jsonArray"));
        this.assertEquals(httpMethod.name(), json.getString("httpMethod"));
        this.assertEquals(new JsonArray().add(stringValue), json.getJsonArray("stringValues"));
        this.assertEquals(new JsonArray().add(boxedBooleanValue), json.getJsonArray("boxedBooleanValues"));
        this.assertEquals(new JsonArray().add((Object)boxedByteValue), json.getJsonArray("boxedByteValues"));
        this.assertEquals(new JsonArray().add((Object)boxedShortValue), json.getJsonArray("boxedShortValues"));
        this.assertEquals(new JsonArray().add(boxedIntValue), json.getJsonArray("boxedIntValues"));
        this.assertEquals(new JsonArray().add(boxedLongValue), json.getJsonArray("boxedLongValues"));
        this.assertEquals(1L, json.getJsonArray("boxedFloatValues").size());
        this.assertEquals(boxedFloatValue.floatValue(), (double)json.getJsonArray("boxedFloatValues").getFloat(0).floatValue(), 0.001);
        this.assertEquals(1L, json.getJsonArray("boxedDoubleValues").size());
        this.assertEquals(boxedDoubleValue, (double)json.getJsonArray("boxedDoubleValues").getDouble(0), 0.001);
        this.assertEquals(new JsonArray().add(Character.toString(boxedCharValue.charValue())), json.getJsonArray("boxedCharValues"));
        this.assertEquals(new JsonArray().add(aggregatedDataObject.toJson()), json.getJsonArray("aggregatedDataObjects"));
        this.assertEquals(new JsonArray().add(this.toBase64(buffer)), json.getJsonArray("buffers"));
        this.assertEquals(new JsonArray().add(jsonObject), json.getJsonArray("jsonObjects"));
        this.assertEquals(new JsonArray().add(jsonArray), json.getJsonArray("jsonArrays"));
        this.assertEquals(new JsonArray().add(httpMethod.name()), json.getJsonArray("httpMethods"));
        this.assertEquals(new JsonArray().add(list.get(0)).add(list.get(1)).add(list.get(2)), json.getJsonArray("objects"));
        this.assertEquals(new JsonObject().put(key, stringValue), json.getJsonObject("stringValueMap"));
        this.assertEquals(new JsonObject().put(key, boxedBooleanValue), json.getJsonObject("boxedBooleanValueMap"));
        this.assertEquals(new JsonObject().put(key, (Object)boxedByteValue), json.getJsonObject("boxedByteValueMap"));
        this.assertEquals(new JsonObject().put(key, (Object)boxedShortValue), json.getJsonObject("boxedShortValueMap"));
        this.assertEquals(new JsonObject().put(key, boxedIntValue), json.getJsonObject("boxedIntValueMap"));
        this.assertEquals(new JsonObject().put(key, boxedLongValue), json.getJsonObject("boxedLongValueMap"));
        this.assertEquals(1L, json.getJsonObject("boxedFloatValueMap").size());
        this.assertEquals(boxedFloatValue.floatValue(), (double)json.getJsonObject("boxedFloatValueMap").getFloat(key).floatValue(), 0.001);
        this.assertEquals(1L, json.getJsonObject("boxedDoubleValueMap").size());
        this.assertEquals(boxedDoubleValue, (double)json.getJsonObject("boxedDoubleValueMap").getDouble(key), 0.001);
        this.assertEquals(new JsonObject().put(key, Character.toString(boxedCharValue.charValue())), json.getJsonObject("boxedCharValueMap"));
        this.assertEquals(new JsonObject().put(key, aggregatedDataObject.toJson()), json.getJsonObject("aggregatedDataObjectMap"));
        this.assertEquals(new JsonObject().put(key, this.toBase64(buffer)), json.getJsonObject("bufferMap"));
        this.assertEquals(new JsonObject().put(key, jsonObject), json.getJsonObject("jsonObjectMap"));
        this.assertEquals(new JsonObject().put(key, jsonArray), json.getJsonObject("jsonArrayMap"));
        this.assertEquals(new JsonObject().put(key, httpMethod.name()), json.getJsonObject("httpMethodMap"));
        this.assertEquals(DataObjectTest.toJson(map), json.getJsonObject("objectMap"));
        this.assertEquals(new JsonObject().put(key, stringValue), json.getJsonObject("keyedStringValues"));
        this.assertEquals(new JsonObject().put(key, boxedBooleanValue), json.getJsonObject("keyedBoxedBooleanValues"));
        this.assertEquals(new JsonObject().put(key, (Object)boxedByteValue), json.getJsonObject("keyedBoxedByteValues"));
        this.assertEquals(new JsonObject().put(key, (Object)boxedShortValue), json.getJsonObject("keyedBoxedShortValues"));
        this.assertEquals(new JsonObject().put(key, boxedIntValue), json.getJsonObject("keyedBoxedIntValues"));
        this.assertEquals(new JsonObject().put(key, boxedLongValue), json.getJsonObject("keyedBoxedLongValues"));
        this.assertEquals(1L, json.getJsonObject("keyedBoxedFloatValues").size());
        this.assertEquals(boxedFloatValue.floatValue(), (double)json.getJsonObject("keyedBoxedFloatValues").getFloat(key).floatValue(), 0.001);
        this.assertEquals(1L, json.getJsonObject("keyedBoxedDoubleValues").size());
        this.assertEquals(boxedDoubleValue, (double)json.getJsonObject("keyedBoxedDoubleValues").getDouble(key), 0.001);
        this.assertEquals(new JsonObject().put(key, Character.toString(boxedCharValue.charValue())), json.getJsonObject("keyedBoxedCharValues"));
        this.assertEquals(new JsonObject().put(key, aggregatedDataObject.toJson()), json.getJsonObject("keyedDataObjectValues"));
        this.assertEquals(new JsonObject().put(key, this.toBase64(buffer)), json.getJsonObject("keyedBufferValues"));
        this.assertEquals(new JsonObject().put(key, jsonObject), json.getJsonObject("keyedJsonObjectValues"));
        this.assertEquals(new JsonObject().put(key, jsonArray), json.getJsonObject("keyedJsonArrayValues"));
        this.assertEquals(new JsonObject().put(key, httpMethod.name()), json.getJsonObject("keyedEnumValues"));
        this.assertEquals(DataObjectTest.toJson(map), json.getJsonObject("keyedObjectValues"));
    }

    @Test
    public void testEmptyDataObjectToJson() {
        TestDataObject obj = new TestDataObject();
        JsonObject json = new JsonObject();
        TestDataObjectConverter.toJson(obj, json);
        json = new JsonObject(json.encode());
        this.assertEquals(null, json.getString("stringValue"));
        this.assertEquals(false, json.getBoolean("booleanValue"));
        this.assertEquals(0L, json.getInteger("byteValue").intValue());
        this.assertEquals(0L, json.getInteger("shortValue").intValue());
        this.assertEquals(0L, json.getInteger("intValue").intValue());
        this.assertEquals(0L, json.getLong("longValue"));
        this.assertEquals(0.0, (double)json.getFloat("floatValue").floatValue(), 0.0);
        this.assertEquals(0.0, (double)json.getFloat("doubleValue").floatValue(), 0.0);
        this.assertEquals(Character.toString('\u0000'), json.getString("charValue"));
        this.assertEquals(null, json.getBoolean("boxedBooleanValue"));
        this.assertEquals(null, json.getInteger("boxedByteValue"));
        this.assertEquals(null, json.getInteger("boxedShortValue"));
        this.assertEquals(null, json.getInteger("boxedIntValue"));
        this.assertEquals(null, json.getLong("boxedLongValue"));
        this.assertEquals(null, json.getFloat("boxedFloatValue"));
        this.assertEquals(null, json.getFloat("boxedDoubleValue"));
        this.assertEquals(null, json.getString("boxedCharValue"));
        this.assertEquals(null, json.getJsonObject("aggregatedDataObject"));
        this.assertEquals(null, (Object)json.getBinary("buffer"));
        this.assertEquals(null, json.getJsonObject("jsonObject"));
        this.assertEquals(null, json.getJsonArray("jsonArray"));
        this.assertEquals(null, json.getString("httpMethod"));
        this.assertEquals(null, json.getJsonArray("stringValues"));
        this.assertEquals(null, json.getJsonArray("boxedBooleanValues"));
        this.assertEquals(null, json.getJsonArray("boxedByteValues"));
        this.assertEquals(null, json.getJsonArray("boxedShortValues"));
        this.assertEquals(null, json.getJsonArray("boxedIntValues"));
        this.assertEquals(null, json.getJsonArray("boxedLongValues"));
        this.assertEquals(null, json.getJsonArray("boxedFloatValues"));
        this.assertEquals(null, json.getJsonArray("boxedDoubleValues"));
        this.assertEquals(null, json.getJsonArray("boxedCharValues"));
        this.assertEquals(null, json.getJsonArray("aggregatedDataObjects"));
        this.assertEquals(null, json.getJsonArray("buffers"));
        this.assertEquals(null, json.getJsonArray("jsonObjects"));
        this.assertEquals(null, json.getJsonArray("jsonArrays"));
        this.assertEquals(null, json.getJsonArray("httpMethods"));
        this.assertEquals(null, json.getJsonArray("objects"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedStringValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBoxedBooleanValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBoxedByteValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBoxedShortValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBoxedIntValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBoxedLongValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBoxedFloatValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBoxedDoubleValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBoxedCharValues"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedAggregatedDataObjects"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedBuffers"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedJsonObjects"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedJsonArrays"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedHttpMethods"));
        this.assertEquals(new JsonArray(), json.getJsonArray("addedObjects"));
        this.assertEquals(null, json.getJsonArray("stringValueMap"));
        this.assertEquals(null, json.getJsonArray("boxedBooleanValueMap"));
        this.assertEquals(null, json.getJsonArray("boxedByteValueMap"));
        this.assertEquals(null, json.getJsonArray("boxedShortValueMap"));
        this.assertEquals(null, json.getJsonArray("boxedIntValueMap"));
        this.assertEquals(null, json.getJsonArray("boxedLongValueMap"));
        this.assertEquals(null, json.getJsonArray("boxedFloatValueMap"));
        this.assertEquals(null, json.getJsonArray("boxedDoubleValueMap"));
        this.assertEquals(null, json.getJsonArray("boxedCharValueMap"));
        this.assertEquals(null, json.getJsonArray("aggregatedDataObjectMap"));
        this.assertEquals(null, json.getJsonArray("bufferMap"));
        this.assertEquals(null, json.getJsonArray("jsonObjectMap"));
        this.assertEquals(null, json.getJsonArray("jsonArrayMap"));
        this.assertEquals(null, json.getJsonArray("httpMethodMap"));
        this.assertEquals(null, json.getJsonArray("objectMap"));
    }

    @Test
    public void testNoConverters() {
        try {
            NoConverterDataObject.class.getClassLoader().loadClass(NoConverterDataObject.class.getName() + "Converter");
            this.fail("Was not expecting a converter to be generated");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testInherit() {
        ChildInheritingDataObject obj = new ChildInheritingDataObject();
        JsonObject expectedJson = new JsonObject();
        expectedJson.put("childProperty", "childProperty_value");
        expectedJson.put("parentProperty", "parentProperty_value");
        ChildInheritingDataObjectConverter.fromJson(expectedJson, obj);
        this.assertEquals("childProperty_value", obj.getChildProperty());
        this.assertEquals("parentProperty_value", obj.getParentProperty());
        JsonObject json = new JsonObject();
        ChildInheritingDataObjectConverter.toJson(obj, json);
        this.assertEquals(expectedJson, json);
    }

    @Test
    public void testNotInherit() {
        ChildNotInheritingDataObject obj = new ChildNotInheritingDataObject();
        JsonObject expectedJson = new JsonObject();
        expectedJson.put("childProperty", "childProperty_value");
        expectedJson.put("parentProperty", "parentProperty_value");
        ChildNotInheritingDataObjectConverter.fromJson(expectedJson, obj);
        this.assertEquals("childProperty_value", obj.getChildProperty());
        this.assertEquals(null, obj.getParentProperty());
        JsonObject json = new JsonObject();
        ChildNotInheritingDataObjectConverter.toJson(obj, json);
        expectedJson.remove("parentProperty");
        this.assertEquals(expectedJson, json);
    }

    private String toBase64(Buffer buffer) {
        return Base64.getEncoder().encodeToString(buffer.getBytes());
    }
}

