/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class CaseInsensitiveHeadersTest {
    protected MultiMap newMultiMap() {
        return new CaseInsensitiveHeaders();
    }

    @Test
    public void testCaseInsensitiveHeaders() throws Exception {
        MultiMap result = this.newMultiMap();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testAddTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        MultiMap result = mmap.addAll(map);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"a: b\n", (Object)result.toString());
    }

    @Test
    public void testAddTest2() throws Exception {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        map.put("c", "d");
        Assert.assertEquals((Object)"a: b\nc: d\n", (Object)mmap.addAll(map).toString());
    }

    @Test
    public void testAddTest3() throws Exception {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "b");
        Assert.assertEquals((Object)"a: b\n", (Object)mmap.addAll(map).toString());
    }

    @Test
    public void testAddTest4() throws Exception {
        MultiMap mmap = this.newMultiMap();
        HashMap map = new HashMap();
        Assert.assertEquals((Object)"", (Object)mmap.addAll(map).toString());
    }

    @Test
    public void testAddTest5() throws Exception {
        MultiMap mmap = this.newMultiMap();
        MultiMap headers = this.newMultiMap();
        Assert.assertEquals((Object)"", (Object)mmap.addAll(headers).toString());
    }

    @Test
    public void testAddTest7() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        String value = "value";
        Assert.assertEquals((Object)"name: value\n", (Object)mmap.add((CharSequence)name, (CharSequence)value).toString());
    }

    @Test
    public void testAddTest8() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"name: somevalue\n", (Object)mmap.add((CharSequence)name, values).toString());
    }

    @Test
    public void testAddTest9() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)": somevalue\n", (Object)mmap.add((CharSequence)name, values).toString());
    }

    @Test
    public void testAddTest10() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "a";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"a: somevalue\n", (Object)mmap.add((CharSequence)name, values).toString());
    }

    @Test
    public void testAddTest11() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "";
        Assert.assertEquals((Object)": \n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testAddTest12() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "a";
        String strVal = "b";
        Assert.assertEquals((Object)"a: b\n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testAddTest13() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "aaa";
        String strVal = "";
        Assert.assertEquals((Object)"aaa: \n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testAddTest14() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "aaa";
        Assert.assertEquals((Object)": aaa\n", (Object)mmap.add(name, strVal).toString());
    }

    @Test
    public void testAddIterable() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add("value2");
        MultiMap result = mmap.add(name, values);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"name: value1\nname: value2\n", (Object)result.toString());
    }

    @Test
    public void testAddMultiMap() throws Exception {
        MultiMap mmap = this.newMultiMap();
        MultiMap mm = this.newMultiMap();
        mm.add("Header1", "value1");
        mm.add("Header2", "value2");
        MultiMap result = mmap.addAll(mm);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"Header1: value1\nHeader2: value2\n", (Object)result.toString());
    }

    @Test
    public void testClearTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        MultiMap result = mmap.clear();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testContainsTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = String.valueOf(new Object());
        Assert.assertFalse((boolean)mmap.contains((CharSequence)name));
    }

    @Test
    public void testContainsTest2() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        Assert.assertFalse((boolean)mmap.contains(name));
    }

    @Test
    public void testContainsTest3() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "0123456789";
        boolean result = mmap.contains(name);
        Assert.assertFalse((boolean)result);
        mmap.add(name, "");
        result = mmap.contains(name);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testEntriesTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        List result = mmap.entries();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = String.valueOf(new Object());
        Assert.assertNull((Object)mmap.get((CharSequence)name));
    }

    @Test
    public void testGetTest2() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "1";
        Assert.assertNull((Object)mmap.get(name));
    }

    @Test
    public void testGetTest3() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        String result = mmap.get(name);
        Assert.assertNull((Object)result);
        mmap.add(name, "value");
        result = mmap.get(name);
        Assert.assertEquals((Object)"value", (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testGetNPE() {
        new CaseInsensitiveHeaders().get(null);
    }

    @Test
    public void testGetAllTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = String.valueOf(new Object());
        List result = mmap.getAll((CharSequence)name);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetAllTest2() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "1";
        List result = mmap.getAll(name);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetAllTest3() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        List result = mmap.getAll(name);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetAll() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        mmap.add(name, "value1");
        mmap.add(name, "value2");
        List result = mmap.getAll(name);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"value1", result.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void testGetAllNPE() throws Exception {
        new CaseInsensitiveHeaders().getAll(null);
    }

    @Test
    public void testIsEmptyTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        Assert.assertTrue((boolean)mmap.isEmpty());
    }

    @Test
    public void testIsEmptyTest2() throws Exception {
        MultiMap mmap = this.newMultiMap();
        mmap.add("a", "b");
        Assert.assertFalse((boolean)mmap.isEmpty());
    }

    @Test
    public void testIteratorTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        Iterator result = mmap.iterator();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testIteratorTest2() throws Exception {
        MultiMap mmap = this.newMultiMap();
        mmap.add("a", "b");
        Iterator result = mmap.iterator();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.hasNext());
    }

    @Test
    public void testNamesTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        Set result = mmap.names();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testRemoveTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = String.valueOf(new Object());
        MultiMap result = mmap.remove((CharSequence)name);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNPE() throws Exception {
        new CaseInsensitiveHeaders().remove(null);
    }

    @Test
    public void testRemoveTest2() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "1";
        MultiMap result = mmap.remove(name);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testRemoveTest3() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        MultiMap result = mmap.remove(name);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testRemoveTest4() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        String value = "value";
        mmap.add(name, value);
        Assert.assertTrue((boolean)mmap.contains(name));
        MultiMap result = mmap.remove(name);
        Assert.assertFalse((boolean)result.contains(name));
    }

    @Test
    public void testSetTest1() throws Exception {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("", "");
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)": \n", (Object)result.toString());
    }

    @Test
    public void testSetTest2() throws Exception {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("", "");
        headers.put("aaa", "bbb");
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)": \naaa: bbb\n", (Object)result.toString());
    }

    @Test
    public void testSetTest3() throws Exception {
        MultiMap mmap = this.newMultiMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("aaa", "bbb");
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"aaa: bbb\n", (Object)result.toString());
    }

    @Test
    public void testSetTest4() throws Exception {
        MultiMap mmap = this.newMultiMap();
        HashMap headers = new HashMap();
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testSetTest5() throws Exception {
        MultiMap mmap = this.newMultiMap();
        MultiMap headers = this.newMultiMap();
        MultiMap result = mmap.setAll(headers);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testSetTest7() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        String value = "value";
        MultiMap result = mmap.set((CharSequence)name, (CharSequence)value);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"name: value\n", (Object)result.toString());
    }

    @Test
    public void testSetTest8() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"name: somevalue\n", (Object)mmap.set((CharSequence)name, values).toString());
    }

    @Test
    public void testSetTest9() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)": somevalue\n", (Object)mmap.set((CharSequence)name, values).toString());
    }

    @Test
    public void testSetTest10() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "aaa";
        ArrayList<String> values = new ArrayList<String>();
        values.add("somevalue");
        Assert.assertEquals((Object)"aaa: somevalue\n", (Object)mmap.set((CharSequence)name, values).toString());
    }

    @Test
    public void testSetTest11() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)": \n", (Object)result.toString());
    }

    @Test
    public void testSetTest12() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "aaa";
        String strVal = "bbb";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"aaa: bbb\n", (Object)result.toString());
    }

    @Test
    public void testSetTest13() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "aaa";
        String strVal = "";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"aaa: \n", (Object)result.toString());
    }

    @Test
    public void testSetTest14() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "";
        String strVal = "bbb";
        MultiMap result = mmap.set(name, strVal);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)": bbb\n", (Object)result.toString());
    }

    @Test(expected=NullPointerException.class)
    public void testSetIterableNPE() throws Exception {
        new CaseInsensitiveHeaders().set("name", (Iterable)null);
    }

    @Test
    public void testSetIterableEmpty() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList values = new ArrayList();
        MultiMap result = mmap.set(name, values);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((Object)"", (Object)result.toString());
    }

    @Test
    public void testSetIterable() throws Exception {
        MultiMap mmap = this.newMultiMap();
        String name = "name";
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add(null);
        MultiMap result = mmap.set(name, values);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"name: value1\n", (Object)result.toString());
    }

    @Test
    public void testSize() throws Exception {
        MultiMap mmap = this.newMultiMap();
        Assert.assertEquals((long)0L, (long)mmap.size());
        mmap.add("header", "value");
        Assert.assertEquals((long)1L, (long)mmap.size());
        mmap.add("header2", "value2");
        Assert.assertEquals((long)2L, (long)mmap.size());
        mmap.add("header", "value3");
        Assert.assertEquals((long)2L, (long)mmap.size());
    }

    @Test
    public void testGetHashColl() {
        MultiMap mm = this.newMultiMap();
        String name1 = "!~AZ";
        String name2 = "!~\u0080Y";
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
        mm = new CaseInsensitiveHeaders();
        name1 = "";
        name2 = "\u0000";
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
        mm = new CaseInsensitiveHeaders();
        name1 = "AZa";
        name2 = "\u0080YA";
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
        mm = new CaseInsensitiveHeaders();
        name1 = " !";
        name2 = "? ";
        Assert.assertTrue((String)"hash error", (CaseInsensitiveHeadersTest.hash(name1) == CaseInsensitiveHeadersTest.hash(name2) ? 1 : 0) != 0);
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
        mm = new CaseInsensitiveHeaders();
        name1 = "\u0080a";
        name2 = "Ab";
        Assert.assertTrue((String)"hash error", (CaseInsensitiveHeadersTest.hash(name1) == CaseInsensitiveHeadersTest.hash(name2) ? 1 : 0) != 0);
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
        mm = new CaseInsensitiveHeaders();
        name1 = "A";
        name2 = "R";
        Assert.assertTrue((String)"hash error", (CaseInsensitiveHeadersTest.index(CaseInsensitiveHeadersTest.hash(name1)) == CaseInsensitiveHeadersTest.index(CaseInsensitiveHeadersTest.hash(name2)) ? 1 : 0) != 0);
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"value1", (Object)mm.get(name1));
        Assert.assertEquals((Object)"value2", (Object)mm.get(name2));
    }

    @Test
    public void testGetAllHashColl() {
        MultiMap mm = this.newMultiMap();
        String name1 = "AZ";
        String name2 = "\u0080Y";
        Assert.assertTrue((String)"hash error", (CaseInsensitiveHeadersTest.hash(name1) == CaseInsensitiveHeadersTest.hash(name2) ? 1 : 0) != 0);
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"[value1]", (Object)mm.getAll(name1).toString());
        Assert.assertEquals((Object)"[value2]", (Object)mm.getAll(name2).toString());
        mm = new CaseInsensitiveHeaders();
        name1 = "A";
        name2 = "R";
        Assert.assertTrue((String)"hash error", (CaseInsensitiveHeadersTest.index(CaseInsensitiveHeadersTest.hash(name1)) == CaseInsensitiveHeadersTest.index(CaseInsensitiveHeadersTest.hash(name2)) ? 1 : 0) != 0);
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        Assert.assertEquals((Object)"[value1]", (Object)mm.getAll(name1).toString());
        Assert.assertEquals((Object)"[value2]", (Object)mm.getAll(name2).toString());
    }

    @Test
    public void testRemoveHashColl() {
        MultiMap mm = this.newMultiMap();
        String name1 = "AZ";
        String name2 = "\u0080Y";
        String name3 = "RZ";
        Assert.assertTrue((String)"hash error", (CaseInsensitiveHeadersTest.hash(name1) == CaseInsensitiveHeadersTest.hash(name2) ? 1 : 0) != 0);
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        mm.add(name3, "value3");
        mm.add(name1, "value4");
        mm.add(name2, "value5");
        mm.add(name3, "value6");
        Assert.assertEquals((long)3L, (long)mm.size());
        mm.remove(name1);
        mm.remove(name2);
        Assert.assertEquals((long)1L, (long)mm.size());
        mm = new CaseInsensitiveHeaders();
        name1 = "A";
        name2 = "R";
        Assert.assertTrue((String)"hash error", (CaseInsensitiveHeadersTest.index(CaseInsensitiveHeadersTest.hash(name1)) == CaseInsensitiveHeadersTest.index(CaseInsensitiveHeadersTest.hash(name2)) ? 1 : 0) != 0);
        mm.add(name1, "value1");
        mm.add(name2, "value2");
        Assert.assertEquals((long)2L, (long)mm.size());
        mm.remove(name1);
        mm.remove(name2);
        Assert.assertTrue((String)"not empty", (boolean)mm.isEmpty());
    }

    private static int hash(String name) {
        int h = 0;
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private static int index(int hash) {
        return hash % 17;
    }

    @Test
    public void testHashMININT() {
        MultiMap mm = this.newMultiMap();
        String name1 = "";
        long value = Integer.MAX_VALUE;
        ++value;
        int base = 31;
        long pow = 1L;
        while (value > pow * (long)base) {
            pow *= (long)base;
        }
        while (pow != 0L) {
            long mul = value / pow;
            name1 = (char)mul + name1;
            value -= pow * mul;
            pow /= (long)base;
        }
        name1 = (char)value + name1;
        mm.add(name1, "value");
        Assert.assertEquals((Object)"value", (Object)mm.get(name1));
    }

    private String sortByLine(String str) {
        Object[] lines = str.split("\n");
        Arrays.sort(lines);
        StringBuilder sb = new StringBuilder();
        for (Object s : lines) {
            sb.append((String)s);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Test
    public void testToString() {
        MultiMap mm = this.newMultiMap();
        Assert.assertEquals((Object)"", (Object)mm.toString());
        mm.add("Header1", "Value1");
        Assert.assertEquals((Object)"Header1: Value1\n", (Object)this.sortByLine(mm.toString()));
        mm.add("Header2", "Value2");
        Assert.assertEquals((Object)"Header1: Value1\nHeader2: Value2\n", (Object)this.sortByLine(mm.toString()));
        mm.add("Header1", "Value3");
        Assert.assertEquals((Object)"Header1: Value1\nHeader1: Value3\nHeader2: Value2\n", (Object)this.sortByLine(mm.toString()));
        mm.remove("Header1");
        Assert.assertEquals((Object)"Header2: Value2\n", (Object)this.sortByLine(mm.toString()));
        mm.set("Header2", "Value4");
        Assert.assertEquals((Object)"Header2: Value4\n", (Object)this.sortByLine(mm.toString()));
    }

    @Test
    public void testMapEntrySetValue() throws Exception {
        MultiMap mmap = this.newMultiMap();
        mmap.add("Header", "oldvalue");
        for (Map.Entry me : mmap) {
            me.setValue("newvalue");
        }
        Assert.assertEquals((Object)"newvalue", (Object)mmap.get("Header"));
    }

    @Test
    public void testMapEntryToString() throws Exception {
        MultiMap mmap = this.newMultiMap();
        mmap.add("Header", "value");
        Assert.assertEquals((Object)"Header: value", (Object)((Map.Entry)mmap.iterator().next()).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testMapEntrySetValueNull() throws Exception {
        MultiMap mmap = this.newMultiMap();
        mmap.add("Header", "oldvalue");
        for (Map.Entry me : mmap) {
            me.setValue(null);
        }
    }
}

