/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.util.AsciiString;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ConversionHelper;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ConversionHelperTest {
    @Test
    public void testToJsonObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("string", "the_string");
        map.put("integer", 4);
        map.put("boolean", true);
        map.put("charsequence", new AsciiString((CharSequence)"the_charsequence"));
        map.put("biginteger", new BigInteger("1234567"));
        map.put("binary", Buffer.buffer((String)"hello"));
        map.put("object", Collections.singletonMap("nested", 4));
        map.put("array", Arrays.asList(1, 2, 3));
        JsonObject json = (JsonObject)ConversionHelper.toObject(map);
        Assert.assertEquals((long)8L, (long)json.size());
        Assert.assertEquals((Object)"the_string", (Object)json.getString("string"));
        Assert.assertEquals((long)4L, (long)json.getInteger("integer").intValue());
        Assert.assertEquals((Object)true, (Object)json.getBoolean("boolean"));
        Assert.assertEquals((Object)"the_charsequence", (Object)json.getString("charsequence"));
        Assert.assertEquals((long)1234567L, (long)json.getInteger("biginteger").intValue());
        Assert.assertEquals((Object)"hello", (Object)new String(json.getBinary("binary")));
        Assert.assertEquals((Object)new JsonObject().put("nested", Integer.valueOf(4)), (Object)json.getJsonObject("object"));
        Assert.assertEquals((Object)new JsonArray().add(Integer.valueOf(1)).add(Integer.valueOf(2)).add(Integer.valueOf(3)), (Object)json.getJsonArray("array"));
    }

    @Test
    public void testToJsonArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("the_string");
        list.add(4);
        list.add(true);
        list.add(new AsciiString((CharSequence)"the_charsequence"));
        list.add(new BigInteger("1234567"));
        list.add(Buffer.buffer((String)"hello"));
        list.add(Collections.singletonMap("nested", 4));
        list.add(Arrays.asList(1, 2, 3));
        JsonArray json = (JsonArray)ConversionHelper.toObject(list);
        Assert.assertEquals((long)8L, (long)json.size());
        Assert.assertEquals((Object)"the_string", (Object)json.getString(0));
        Assert.assertEquals((long)4L, (long)json.getInteger(1).intValue());
        Assert.assertEquals((Object)true, (Object)json.getBoolean(2));
        Assert.assertEquals((Object)"the_charsequence", (Object)json.getString(3));
        Assert.assertEquals((long)1234567L, (long)json.getInteger(4).intValue());
        Assert.assertEquals((Object)"hello", (Object)new String(json.getBinary(5)));
        Assert.assertEquals((Object)new JsonObject().put("nested", Integer.valueOf(4)), (Object)json.getJsonObject(6));
        Assert.assertEquals((Object)new JsonArray().add(Integer.valueOf(1)).add(Integer.valueOf(2)).add(Integer.valueOf(3)), (Object)json.getJsonArray(7));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"the_string", (Object)ConversionHelper.toObject((Object)new AsciiString((CharSequence)"the_string")));
    }

    @Test
    public void testToObject() {
        Object o = new Object();
        Assert.assertEquals((Object)o, (Object)ConversionHelper.toObject((Object)o));
    }

    @Test
    public void testFromJsonObject() {
        JsonObject object = new JsonObject();
        object.put("string", "the_string");
        object.put("integer", Integer.valueOf(4));
        object.put("boolean", Boolean.valueOf(true));
        object.put("binary", "hello".getBytes());
        object.put("object", new JsonObject().put("nested", Integer.valueOf(4)));
        object.put("array", new JsonArray().add(Integer.valueOf(1)).add(Integer.valueOf(2)).add(Integer.valueOf(3)));
        Map map = (Map)ConversionHelper.fromObject((Object)object);
        Assert.assertEquals((long)6L, (long)map.size());
        Assert.assertEquals((Object)"the_string", map.get("string"));
        Assert.assertEquals((Object)4, map.get("integer"));
        Assert.assertEquals((Object)true, map.get("boolean"));
        Assert.assertEquals((Object)"hello", (Object)new String(Base64.getDecoder().decode((String)map.get("binary"))));
        Assert.assertEquals(Collections.singletonMap("nested", 4), map.get("object"));
        Assert.assertEquals(Arrays.asList(1, 2, 3), map.get("array"));
    }

    @Test
    public void testFromJsonArray() {
        JsonArray object = new JsonArray();
        object.add("the_string");
        object.add(Integer.valueOf(4));
        object.add(Boolean.valueOf(true));
        object.add("hello".getBytes());
        object.add(new JsonObject().put("nested", Integer.valueOf(4)));
        object.add(new JsonArray().add(Integer.valueOf(1)).add(Integer.valueOf(2)).add(Integer.valueOf(3)));
        List map = (List)ConversionHelper.fromObject((Object)object);
        Assert.assertEquals((long)6L, (long)map.size());
        Assert.assertEquals((Object)"the_string", map.get(0));
        Assert.assertEquals((Object)4, map.get(1));
        Assert.assertEquals((Object)true, map.get(2));
        Assert.assertEquals((Object)"hello", (Object)new String(Base64.getDecoder().decode((String)map.get(3))));
        Assert.assertEquals(Collections.singletonMap("nested", 4), map.get(4));
        Assert.assertEquals(Arrays.asList(1, 2, 3), map.get(5));
    }

    @Test
    public void testWrapObject() {
        JsonObject obj = new JsonObject().put("nestedObj", new JsonObject().put("key", "value")).put("nestedList", new JsonArray().add(new JsonObject().put("key", "value")));
        Map wrapped = (Map)ConversionHelper.fromObject((Object)obj);
        Assert.assertTrue((boolean)(wrapped.get("nestedObj") instanceof Map));
        List theList = (List)wrapped.get("nestedList");
        Assert.assertTrue((boolean)(theList.get(0) instanceof Map));
    }
}

