/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.VertxException;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.dns.DnsException;
import io.vertx.core.dns.DnsResponseCode;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.dns.impl.DnsClientImpl;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakedns.FakeDNSServer;
import java.net.InetSocketAddress;
import java.util.List;
import org.junit.Test;

public class DNSTest
extends VertxTestBase {
    private FakeDNSServer dnsServer;

    @Test
    public void testIllegalArguments() throws Exception {
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolveAAAA("::1"));
        TestUtils.assertNullPointerException(() -> dns.lookup(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.lookup4(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.lookup6(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.resolveA(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.resolveAAAA(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.resolveCNAME(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.resolveMX(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.resolveTXT(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.resolvePTR(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.resolveNS(null, ar -> {}));
        TestUtils.assertNullPointerException(() -> dns.resolveSRV(null, ar -> {}));
        this.dnsServer.stop();
    }

    @Test
    public void testResolveA() throws Exception {
        String ip = "10.0.0.1";
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolveA("10.0.0.1"));
        dns.resolveA("vertx.io", this.onSuccess(result -> {
            this.assertFalse(result.isEmpty());
            this.assertEquals(1L, result.size());
            this.assertEquals("10.0.0.1", result.get(0));
            ((DnsClientImpl)dns).inProgressQueries(num -> {
                this.assertEquals(0L, num.intValue());
                this.testComplete();
            });
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testResolveAAAA() throws Exception {
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolveAAAA("::1"));
        dns.resolveAAAA("vertx.io", this.onSuccess(result -> {
            this.assertFalse(result.isEmpty());
            this.assertEquals(1L, result.size());
            this.assertEquals("0:0:0:0:0:0:0:1", result.get(0));
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testResolveMX() throws Exception {
        String mxRecord = "mail.vertx.io";
        int prio = 10;
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolveMX(10, "mail.vertx.io"));
        dns.resolveMX("vertx.io", this.onSuccess(result -> {
            this.assertFalse(result.isEmpty());
            this.assertEquals(1L, result.size());
            MxRecord record = (MxRecord)result.get(0);
            this.assertEquals(10L, record.priority());
            this.assertEquals(record.name(), "mail.vertx.io");
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testResolveTXT() throws Exception {
        String txt = "vertx is awesome";
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolveTXT("vertx is awesome"));
        dns.resolveTXT("vertx.io", this.onSuccess(result -> {
            this.assertFalse(result.isEmpty());
            this.assertEquals(1L, result.size());
            this.assertEquals("vertx is awesome", result.get(0));
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testResolveNS() throws Exception {
        String ns = "ns.vertx.io";
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolveNS("ns.vertx.io"));
        dns.resolveNS("vertx.io", this.onSuccess(result -> {
            this.assertFalse(result.isEmpty());
            this.assertEquals(1L, result.size());
            this.assertEquals("ns.vertx.io", result.get(0));
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testResolveCNAME() throws Exception {
        String cname = "cname.vertx.io";
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolveCNAME("cname.vertx.io"));
        dns.resolveCNAME("vertx.io", this.onSuccess(result -> {
            this.assertFalse(result.isEmpty());
            this.assertEquals(1L, result.size());
            String record = (String)result.get(0);
            this.assertFalse(record.isEmpty());
            this.assertEquals("cname.vertx.io", record);
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testResolvePTR() throws Exception {
        String ptr = "ptr.vertx.io";
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolvePTR("ptr.vertx.io"));
        dns.resolvePTR("10.0.0.1.in-addr.arpa", this.onSuccess(result -> {
            this.assertEquals("ptr.vertx.io", result);
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testResolveSRV() throws Exception {
        int priority = 10;
        boolean weight = true;
        int port = 80;
        String target = "vertx.io";
        DnsClient dns = this.prepareDns(FakeDNSServer.testResolveSRV(10, 1, 80, "vertx.io"));
        dns.resolveSRV("vertx.io", ar -> {
            List result = (List)ar.result();
            this.assertNotNull(result);
            this.assertFalse(result.isEmpty());
            this.assertEquals(1L, result.size());
            SrvRecord record = (SrvRecord)result.get(0);
            this.assertEquals(10L, record.priority());
            this.assertEquals(1L, record.weight());
            this.assertEquals(80L, record.port());
            this.assertEquals("vertx.io", record.target());
            this.testComplete();
        });
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testLookup4() throws Exception {
        String ip = "10.0.0.1";
        DnsClient dns = this.prepareDns(FakeDNSServer.testLookup4("10.0.0.1"));
        dns.lookup4("vertx.io", this.onSuccess(result -> {
            this.assertEquals("10.0.0.1", result);
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testLookup6() throws Exception {
        DnsClient dns = this.prepareDns(FakeDNSServer.testLookup6());
        dns.lookup6("vertx.io", this.onSuccess(result -> {
            this.assertEquals("0:0:0:0:0:0:0:1", result);
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testLookup() throws Exception {
        String ip = "10.0.0.1";
        DnsClient dns = this.prepareDns(FakeDNSServer.testLookup("10.0.0.1"));
        dns.lookup("vertx.io", this.onSuccess(result -> {
            this.assertEquals("10.0.0.1", result);
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testTimeout() throws Exception {
        DnsClient dns = this.vertx.createDnsClient(new DnsClientOptions().setPort(10000).setQueryTimeout(5000L));
        dns.lookup("vertx.io", this.onFailure(result -> {
            this.assertEquals(VertxException.class, result.getClass());
            this.assertEquals("DNS query timeout for vertx.io", result.getMessage());
            ((DnsClientImpl)dns).inProgressQueries(num -> {
                this.assertEquals(0L, num.intValue());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testLookupNonExisting() throws Exception {
        DnsClient dns = this.prepareDns(FakeDNSServer.testLookupNonExisting());
        dns.lookup("gfegjegjf.sg1", ar -> {
            DnsException cause = (DnsException)ar.cause();
            this.assertEquals(DnsResponseCode.NXDOMAIN, cause.code());
            this.testComplete();
        });
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testReverseLookupIpv4() throws Exception {
        String address = "10.0.0.1";
        String ptr = "ptr.vertx.io";
        DnsClient dns = this.prepareDns(FakeDNSServer.testReverseLookup("ptr.vertx.io"));
        dns.reverseLookup(address, this.onSuccess(result -> {
            this.assertEquals("ptr.vertx.io", result);
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testReverseLookupIpv6() throws Exception {
        String ptr = "ptr.vertx.io";
        DnsClient dns = this.prepareDns(FakeDNSServer.testReverseLookup("ptr.vertx.io"));
        dns.reverseLookup("::1", this.onSuccess(result -> {
            this.assertEquals("ptr.vertx.io", result);
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    @Test
    public void testUseInMultithreadedWorker() throws Exception {
        class MyVerticle
        extends AbstractVerticle {
            MyVerticle() {
            }

            public void start() {
                TestUtils.assertIllegalStateException(() -> this.vertx.createDnsClient(1234, "localhost"));
                DNSTest.this.testComplete();
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testLookup4CNAME() throws Exception {
        String cname = "cname.vertx.io";
        String ip = "10.0.0.1";
        DnsClient dns = this.prepareDns(FakeDNSServer.testLookup4CNAME("cname.vertx.io", "10.0.0.1"));
        dns.lookup4("vertx.io", this.onSuccess(result -> {
            this.assertEquals("10.0.0.1", result);
            this.testComplete();
        }));
        this.await();
        this.dnsServer.stop();
    }

    private DnsClient prepareDns(FakeDNSServer server) throws Exception {
        return this.prepareDns(server, 15000L);
    }

    private DnsClient prepareDns(FakeDNSServer server, long queryTimeout) throws Exception {
        this.dnsServer = server;
        this.dnsServer.start();
        InetSocketAddress addr = (InetSocketAddress)this.dnsServer.getTransports()[0].getAcceptor().getLocalAddress();
        return this.vertx.createDnsClient(new DnsClientOptions().setPort(addr.getPort()).setHost(addr.getAddress().getHostAddress()).setQueryTimeout(queryTimeout));
    }
}

