/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.util.CharsetUtil;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpVersion;
import io.vertx.test.core.Http2TestBase;
import org.junit.Test;

public class Http2CompressionTest
extends Http2TestBase {
    private static final String COMPRESS_TEST_STRING = "/*\n * Copyright (c) 2011-2016 The original author or authors\n * ------------------------------------------------------\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * and Apache License v2.0 which accompanies this distribution.\n *\n *     The Eclipse Public License is available at\n *     http://www.eclipse.org/legal/epl-v10.html\n *\n *     The Apache License v2.0 is available at\n *     http://www.opensource.org/licenses/apache2.0.php\n *\n * You may elect to redistribute this code under either of these licenses.\n */";
    HttpServer serverWithMinCompressionLevel;
    HttpServer serverWithMaxCompressionLevel = null;
    HttpClient clientraw = null;
    public static boolean minCompressionTestPassed = false;
    public static boolean maxCompressionTestPassed = false;
    public static Integer rawMaxCompressionResponseByteCount = null;
    public static Integer rawMinCompressionResponseByteCount = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(Http2CompressionTest.createHttp2ClientOptions().setTryUseCompression(true));
        this.clientraw = this.vertx.createHttpClient(Http2CompressionTest.createHttp2ClientOptions().setTryUseCompression(false));
        this.serverWithMinCompressionLevel = this.vertx.createHttpServer(Http2CompressionTest.createHttp2ServerOptions(8079, "localhost").setCompressionSupported(true).setCompressionLevel(1));
        this.serverWithMaxCompressionLevel = this.vertx.createHttpServer(Http2CompressionTest.createHttp2ServerOptions(8081, "localhost").setCompressionSupported(true).setCompressionLevel(9));
    }

    @Test
    public void testDefaultRequestHeaders() {
        Handler requestHandler = req -> {
            this.assertEquals(HttpVersion.HTTP_2, req.version());
            this.assertNotNull(req.headers().get("Accept-Encoding"));
            req.response().end(Buffer.buffer((String)COMPRESS_TEST_STRING).toString(CharsetUtil.UTF_8));
        };
        this.serverWithMinCompressionLevel.requestHandler(requestHandler);
        this.serverWithMaxCompressionLevel.requestHandler(requestHandler);
        this.serverWithMinCompressionLevel.listen(this.onSuccess(serverReady -> {
            this.testMinCompression();
            this.testRawMinCompression();
        }));
        this.serverWithMaxCompressionLevel.listen(this.onSuccess(serverReady -> {
            this.testMaxCompression();
            this.testRawMaxCompression();
        }));
        this.await();
    }

    public void testMinCompression() {
        this.client.request(HttpMethod.GET, 8079, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            String responseBody = responseBuffer.toString(CharsetUtil.UTF_8);
            this.assertEquals(COMPRESS_TEST_STRING, responseBody);
            minCompressionTestPassed = true;
            this.terminateTestWhenAllPassed();
        })).end();
    }

    public void testMaxCompression() {
        this.client.request(HttpMethod.GET, 8081, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            String responseBody = responseBuffer.toString(CharsetUtil.UTF_8);
            this.assertEquals(COMPRESS_TEST_STRING, responseBody);
            maxCompressionTestPassed = true;
            this.terminateTestWhenAllPassed();
        })).end();
    }

    public void testRawMaxCompression() {
        this.clientraw.request(HttpMethod.GET, 8081, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            Integer responseByteCount;
            String responseCompressedBody = responseBuffer.toString(CharsetUtil.UTF_8);
            rawMaxCompressionResponseByteCount = responseByteCount = Integer.valueOf(responseCompressedBody.getBytes(CharsetUtil.UTF_8).length);
            this.terminateTestWhenAllPassed();
        })).putHeader(HttpHeaders.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP).end();
    }

    public void testRawMinCompression() {
        this.clientraw.request(HttpMethod.GET, 8079, "localhost", "some-uri", resp -> resp.bodyHandler(responseBuffer -> {
            Integer responseByteCount;
            String responseCompressedBody = responseBuffer.toString(CharsetUtil.UTF_8);
            rawMinCompressionResponseByteCount = responseByteCount = Integer.valueOf(responseCompressedBody.getBytes(CharsetUtil.UTF_8).length);
            this.terminateTestWhenAllPassed();
        })).putHeader(HttpHeaders.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP).end();
    }

    public void terminateTestWhenAllPassed() {
        if (maxCompressionTestPassed && minCompressionTestPassed && rawMinCompressionResponseByteCount != null && rawMaxCompressionResponseByteCount != null) {
            this.assertTrue("Checking compression byte size difference", rawMaxCompressionResponseByteCount > 0 && rawMinCompressionResponseByteCount > rawMaxCompressionResponseByteCount);
            this.testComplete();
        }
    }
}

