/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.TrustAllTrustManager;
import io.vertx.test.core.HttpTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.tls.Cert;
import io.vertx.test.core.tls.Trust;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.security.cert.X509Certificate;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class HttpTLSTest
extends HttpTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    protected VertxOptions getOptions() {
        VertxOptions options = super.getOptions();
        options.getAddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 localhost\n127.0.0.1 host1\n127.0.0.1 host2.com\n127.0.0.1 sub.host3.com\n127.0.0.1 host4.com\n127.0.0.1 www.host4.com\n127.0.0.1 host5.com\n127.0.0.1 www.host5.com\n127.0.0.1 unknown.com"));
        return options;
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.proxy != null) {
            this.proxy.stop();
        }
        super.tearDown();
    }

    @Test
    public void testTLSClientTrustAll() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE).clientTrustAll().pass();
    }

    @Test
    public void testTLSClientTrustServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_PKCS12, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEM() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_PEM, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertJKSRootCAWithJKSRootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS_ROOT_CA, Cert.SERVER_JKS_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertJKSRootCAWithPKCS12RootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PKCS12_ROOT_CA, Cert.SERVER_JKS_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertJKSRootRootCAWithPEMRootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_JKS_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12RootCAWithJKSRootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS_ROOT_CA, Cert.SERVER_PKCS12_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12RootCAWithPKCS12RootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PKCS12_ROOT_CA, Cert.SERVER_PKCS12_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12RootCAWithPEMRootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PKCS12_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMRootCAWithJKSRootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS_ROOT_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMRootCAWithPKCS12RootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PKCS12_ROOT_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMRootCAWithPEMRootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertMultiPemWithPEMRootCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA_AND_OTHER_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertMultiPemWithPEMOtherCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA_AND_OTHER_CA, Cert.SERVER_PEM_OTHER_CA, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMRootCAWithPEMCAChain() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PEM_CA_CHAIN, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientUntrustedServerCertPEMRootCAWithPEMCA() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PEM_INT_CA, Trust.NONE).fail();
    }

    @Test
    public void testTLSClientTrustPKCS12ServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PKCS12, Cert.SERVER_JKS, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientTrustPEMServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM, Cert.SERVER_JKS, Trust.NONE).pass();
    }

    @Test
    public void testTLSClientUntrustedServer() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE).fail();
    }

    @Test
    public void testTLSClientUntrustedServerPEM() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_PEM, Trust.NONE).fail();
    }

    @Test
    public void testTLSClientCertNotRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS).pass();
    }

    @Test
    public void testTLSClientCertNotRequiredPEM() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_PEM, Trust.CLIENT_JKS).pass();
    }

    @Test
    public void testTLSClientCertRequired() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertRequiredPKCS12() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PKCS12).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertRequiredPEM() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertPKCS12Required() throws Exception {
        this.testTLS(Cert.CLIENT_PKCS12, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertPEMRequired() throws Exception {
        this.testTLS(Cert.CLIENT_PEM, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertPEM_CARequired() throws Exception {
        this.testTLS(Cert.CLIENT_PEM_ROOT_CA, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM_ROOT_CA).requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertRequiredNoClientCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS).requiresClientAuth().fail();
    }

    @Test
    public void testTLSClientCertClientNotTrusted() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).requiresClientAuth().fail();
    }

    @Test
    public void testTLSClientRevokedServerCert() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM_ROOT_CA, Cert.SERVER_PEM_ROOT_CA, Trust.NONE).clientUsesCrl().fail();
    }

    @Test
    public void testTLSRevokedClientCertServer() throws Exception {
        this.testTLS(Cert.CLIENT_PEM_ROOT_CA, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_PEM_ROOT_CA).requiresClientAuth().serverUsesCrl().fail();
    }

    @Test
    public void testTLSMatchingCipherSuites() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE).clientTrustAll().serverEnabledCipherSuites(ENABLED_CIPHER_SUITES).pass();
    }

    @Test
    public void testTLSNonMatchingCipherSuites() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE).clientTrustAll().serverEnabledCipherSuites(new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"}).clientEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).fail();
    }

    @Test
    public void testTLSMatchingProtocolVersions() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE).clientTrustAll().serverEnabledSecureTransportProtocol(new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1", "TLSv1.2"}).pass();
    }

    @Test
    public void testTLSInvalidProtocolVersion() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE).clientTrustAll().serverEnabledSecureTransportProtocol(new String[]{"HelloWorld"}).fail();
    }

    @Test
    public void testTLSNonMatchingProtocolVersions() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE).clientTrustAll().serverEnabledSecureTransportProtocol(new String[]{"TLSv1.2"}).clientEnabledSecureTransportProtocol(new String[]{"SSLv2Hello"}).fail();
    }

    @Test
    public void testTLSVerifyMatchingHost() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_JKS, Trust.NONE).clientTrustAll().clientVerifyHost().pass();
    }

    @Test
    public void testTLSVerifyNonMatchingHost() throws Exception {
        this.testTLS(Cert.NONE, Trust.NONE, Cert.SERVER_MIM, Trust.NONE).clientTrustAll().clientVerifyHost().fail();
    }

    @Test
    public void testTLSClientTrustServerCertJKSOpenSSL() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).serverOpenSSL().pass();
    }

    @Test
    public void testTLSClientTrustServerCertPKCS12OpenSSL() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_PKCS12, Trust.NONE).serverOpenSSL().pass();
    }

    @Test
    public void testTLSClientTrustServerCertPEMOpenSSL() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_PEM, Trust.NONE).serverOpenSSL().pass();
    }

    @Test
    public void testTLSClientTrustServerCertWithJKSOpenSSL() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).clientOpenSSL().pass();
    }

    @Test
    public void testTLSClientTrustServerCertWithPKCS12OpenSSL() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PKCS12, Cert.SERVER_JKS, Trust.NONE).clientOpenSSL().pass();
    }

    @Test
    public void testTLSClientTrustServerCertWithPEMOpenSSL() throws Exception {
        this.testTLS(Cert.NONE, Trust.SERVER_PEM, Cert.SERVER_JKS, Trust.NONE).clientOpenSSL().pass();
    }

    @Test
    public void testTLSClientCertRequiredOpenSSL() throws Exception {
        this.testTLS(Cert.CLIENT_JKS, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS).clientOpenSSL().requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertPKCS12RequiredOpenSSL() throws Exception {
        this.testTLS(Cert.CLIENT_PKCS12, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS).clientOpenSSL().requiresClientAuth().pass();
    }

    @Test
    public void testTLSClientCertPEMRequiredOpenSSL() throws Exception {
        this.testTLS(Cert.CLIENT_PEM, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.CLIENT_JKS).clientOpenSSL().requiresClientAuth().pass();
    }

    @Test
    public void testSNITrust() throws Exception {
        TLSTest test = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host2.com")).pass();
        this.assertEquals("host2.com", TestUtils.cnOf(test.clientPeerCert()));
        this.assertEquals("host2.com", test.indicatedServerName);
    }

    @Test
    public void testSNITrustPKCS12() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_PKCS12, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host2.com")).pass().clientPeerCert();
        this.assertEquals("host2.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNITrustPEM() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_PEM, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host2.com")).pass().clientPeerCert();
        this.assertEquals("host2.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNIServerIgnoresExtension1() throws Exception {
        this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE).requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host2.com")).fail();
    }

    @Test
    public void testSNIServerIgnoresExtension2() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SNI_JKS, Trust.NONE).clientVerifyHost(false).requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host2.com")).pass().clientPeerCert();
        this.assertEquals("localhost", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNIUnknownServerName1() throws Exception {
        this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("unknown.com")).fail();
    }

    @Test
    public void testSNIUnknownServerName2() throws Exception {
        TLSTest test = this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SNI_JKS, Trust.NONE).serverSni().clientVerifyHost(false).requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("unknown.com")).pass();
        this.assertEquals("localhost", TestUtils.cnOf(test.clientPeerCert()));
        this.assertEquals("unknown.com", test.indicatedServerName);
    }

    @Test
    public void testSNIWildcardMatch() throws Exception {
        TLSTest test = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST3, Cert.SNI_JKS, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("sub.host3.com")).pass();
        this.assertEquals("*.host3.com", TestUtils.cnOf(test.clientPeerCert()));
        this.assertEquals("sub.host3.com", test.indicatedServerName);
    }

    @Test
    public void testSNIWildcardMatchPKCS12() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST3, Cert.SNI_PKCS12, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("sub.host3.com")).pass().clientPeerCert();
        this.assertEquals("*.host3.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNIWildcardMatchPEM() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST3, Cert.SNI_PEM, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("sub.host3.com")).pass().clientPeerCert();
        this.assertEquals("*.host3.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameMatch1() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST4, Cert.SNI_JKS, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host4.com")).pass().clientPeerCert();
        this.assertEquals("host4.com certificate", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameMatch1PKCS12() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST4, Cert.SNI_PKCS12, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host4.com")).pass().clientPeerCert();
        this.assertEquals("host4.com certificate", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameMatch1PEM() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST4, Cert.SNI_PEM, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host4.com")).pass().clientPeerCert();
        this.assertEquals("host4.com certificate", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameMatch2() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST4, Cert.SNI_JKS, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("www.host4.com")).pass().clientPeerCert();
        this.assertEquals("host4.com certificate", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameMatch2PKCS12() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST4, Cert.SNI_PKCS12, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("www.host4.com")).pass().clientPeerCert();
        this.assertEquals("host4.com certificate", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameMatch2PEM() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST4, Cert.SNI_PEM, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("www.host4.com")).pass().clientPeerCert();
        this.assertEquals("host4.com certificate", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameWildcardMatch() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_JKS, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("www.host5.com")).pass().clientPeerCert();
        this.assertEquals("host5.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameWildcardMatchPKCS12() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_PKCS12, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("www.host5.com")).pass().clientPeerCert();
        this.assertEquals("host5.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAlternativeNameWildcardMatchPEM() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_PEM, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("www.host5.com")).pass().clientPeerCert();
        this.assertEquals("host5.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAltenativeNameCNMatch1() throws Exception {
        this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_JKS, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host5.com")).fail().clientPeerCert();
    }

    @Test
    public void testSNISubjectAltenativeNameCNMatch1PKCS12() throws Exception {
        this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_PKCS12, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host5.com")).fail().clientPeerCert();
    }

    @Test
    public void testSNISubjectAltenativeNameCNMatch1PEM() throws Exception {
        this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_PEM, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host5.com")).fail().clientPeerCert();
    }

    @Test
    public void testSNISubjectAltenativeNameCNMatch2() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_JKS, Trust.NONE).serverSni().clientVerifyHost(false).requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host5.com")).pass().clientPeerCert();
        this.assertEquals("host5.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAltenativeNameCNMatch2PKCS12() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_PKCS12, Trust.NONE).serverSni().clientVerifyHost(false).requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host5.com")).pass().clientPeerCert();
        this.assertEquals("host5.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNISubjectAltenativeNameCNMatch2PEM() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST5, Cert.SNI_PEM, Trust.NONE).serverSni().clientVerifyHost(false).requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host5.com")).pass().clientPeerCert();
        this.assertEquals("host5.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNIWithALPN() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE).serverSni().clientUsesAlpn().serverUsesAlpn().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host2.com")).pass().clientPeerCert();
        this.assertEquals("host2.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNIWithHostHeader() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE).serverSni().requestProvider(client -> client.post(4043, "localhost", "/somepath").setHost("host2.com:4043")).pass().clientPeerCert();
        this.assertEquals("host2.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNIWithOpenSSL() throws Exception {
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE).clientOpenSSL().serverOpenSSL().serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host2.com")).pass().clientPeerCert();
        this.assertEquals("host2.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testSNIDontSendServerNameForShortnames1() throws Exception {
        this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST1, Cert.SNI_JKS, Trust.NONE).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host1")).fail();
    }

    @Test
    public void testSNIDontSendServerNameForShortnames2() throws Exception {
        TLSTest test = this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SNI_JKS, Trust.NONE).clientVerifyHost(false).serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host1")).pass();
        this.assertEquals(null, test.indicatedServerName);
    }

    @Test
    public void testSNIForceSend() throws Exception {
        TLSTest test = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST1, Cert.SNI_JKS, Trust.NONE).clientForceSni().serverSni().requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host1")).pass();
        this.assertEquals("host1", test.indicatedServerName);
    }

    @Test
    public void testCustomTrustManagerFactory() throws Exception {
        this.testTLS(Cert.NONE, () -> new TrustOptions(){

            public TrustManagerFactory getTrustManagerFactory(Vertx v) throws Exception {
                return new TrustManagerFactory(new TrustManagerFactorySpi(){

                    @Override
                    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
                    }

                    @Override
                    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
                    }

                    @Override
                    protected TrustManager[] engineGetTrustManagers() {
                        return new TrustManager[]{TrustAllTrustManager.INSTANCE};
                    }
                }, KeyPairGenerator.getInstance("RSA").getProvider(), KeyPairGenerator.getInstance("RSA").getAlgorithm()){};
            }

            public TrustOptions clone() {
                return this;
            }
        }, Cert.SERVER_JKS, Trust.NONE).pass();
    }

    abstract HttpServer createHttpServer(HttpServerOptions var1);

    abstract HttpClient createHttpClient(HttpClientOptions var1);

    protected TLSTest testTLS(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust) throws Exception {
        return new TLSTest(clientCert, clientTrust, serverCert, serverTrust);
    }

    @Test
    public void testJKSInvalidPath() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)Cert.SERVER_JKS.get()).setPath("/invalid.jks"), "java.nio.file.NoSuchFileException: ", "invalid.jks");
    }

    @Test
    public void testJKSMissingPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)Cert.SERVER_JKS.get()).setPassword(null), "Password must not be null", null);
    }

    @Test
    public void testJKSInvalidPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((JksOptions)Cert.SERVER_JKS.get()).setPassword("wrongpassword"), "Keystore was tampered with, or password was incorrect", null);
    }

    @Test
    public void testPKCS12InvalidPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)Cert.SERVER_PKCS12.get()).setPath("/invalid.p12"), "java.nio.file.NoSuchFileException: ", "invalid.p12");
    }

    @Test
    public void testPKCS12MissingPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)Cert.SERVER_PKCS12.get()).setPassword(null), "Get Key failed: null", null);
    }

    @Test
    public void testPKCS12InvalidPassword() {
        this.testInvalidKeyStore((KeyCertOptions)((PfxOptions)Cert.SERVER_PKCS12.get()).setPassword("wrongpassword"), Arrays.asList("failed to decrypt safe contents entry: javax.crypto.BadPaddingException: Given final block not properly padded", "keystore password was incorrect"), null);
    }

    @Test
    public void testKeyCertMissingKeyPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)Cert.SERVER_PEM.get()).setKeyPath(null), "Missing private key", null);
    }

    @Test
    public void testKeyCertInvalidKeyPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)Cert.SERVER_PEM.get()).setKeyPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testKeyCertMissingCertPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)Cert.SERVER_PEM.get()).setCertPath(null), "Missing X.509 certificate", null);
    }

    @Test
    public void testKeyCertInvalidCertPath() {
        this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)Cert.SERVER_PEM.get()).setCertPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testKeyCertInvalidPem() throws IOException {
        String[] contents = new String[]{"", "-----BEGIN PRIVATE KEY-----", "-----BEGIN RSA PRIVATE KEY-----", "-----BEGIN PRIVATE KEY-----\n-----END PRIVATE KEY-----", "-----BEGIN RSA PRIVATE KEY-----\n-----END RSA PRIVATE KEY-----", "-----BEGIN PRIVATE KEY-----\n*\n-----END PRIVATE KEY-----", "-----BEGIN RSA PRIVATE KEY-----\n*\n-----END RSA PRIVATE KEY-----"};
        String[] messages = new String[]{"Missing -----BEGIN PRIVATE KEY----- or -----BEGIN RSA PRIVATE KEY----- delimiter", "Missing -----END PRIVATE KEY----- delimiter", "Missing -----END RSA PRIVATE KEY----- delimiter", "Empty pem file", "Empty pem file", "Input byte[] should at least have 2 bytes for base64 bytes", "Input byte[] should at least have 2 bytes for base64 bytes"};
        for (int i = 0; i < contents.length; ++i) {
            Path file = this.testFolder.newFile("vertx" + UUID.randomUUID().toString() + ".pem").toPath();
            Files.write(file, Collections.singleton(contents[i]), new OpenOption[0]);
            String expectedMessage = messages[i];
            this.testInvalidKeyStore((KeyCertOptions)((PemKeyCertOptions)Cert.SERVER_PEM.get()).setKeyPath(file.toString()), expectedMessage, null);
        }
    }

    @Test
    public void testNoKeyCert() {
        this.testInvalidKeyStore(null, "Key/certificate is mandatory for SSL", null);
    }

    @Test
    public void testCaInvalidPath() {
        this.testInvalidTrustStore((TrustOptions)new PemTrustOptions().addCertPath("/invalid.pem"), "java.nio.file.NoSuchFileException: ", "invalid.pem");
    }

    @Test
    public void testCaInvalidPem() throws IOException {
        String[] contents = new String[]{"", "-----BEGIN CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\n-----END CERTIFICATE-----", "-----BEGIN CERTIFICATE-----\n*\n-----END CERTIFICATE-----"};
        String[] messages = new String[]{"Missing -----BEGIN CERTIFICATE----- delimiter", "Missing -----END CERTIFICATE----- delimiter", "Empty pem file", "Input byte[] should at least have 2 bytes for base64 bytes"};
        for (int i = 0; i < contents.length; ++i) {
            Path file = this.testFolder.newFile("vertx" + UUID.randomUUID().toString() + ".pem").toPath();
            Files.write(file, Collections.singleton(contents[i]), new OpenOption[0]);
            String expectedMessage = messages[i];
            this.testInvalidTrustStore((TrustOptions)new PemTrustOptions().addCertPath(file.toString()), expectedMessage, null);
        }
    }

    private void testInvalidKeyStore(KeyCertOptions options, String expectedPrefix, String expectedSuffix) {
        HttpServerOptions serverOptions = new HttpServerOptions();
        HttpTLSTest.setOptions((TCPSSLOptions)serverOptions, options);
        this.testStore(serverOptions, Collections.singletonList(expectedPrefix), expectedSuffix);
    }

    private void testInvalidKeyStore(KeyCertOptions options, List<String> expectedPossiblePrefixes, String expectedSuffix) {
        HttpServerOptions serverOptions = new HttpServerOptions();
        HttpTLSTest.setOptions((TCPSSLOptions)serverOptions, options);
        this.testStore(serverOptions, expectedPossiblePrefixes, expectedSuffix);
    }

    private void testInvalidTrustStore(TrustOptions options, String expectedPrefix, String expectedSuffix) {
        HttpServerOptions serverOptions = new HttpServerOptions();
        serverOptions.setTrustOptions(options);
        this.testStore(serverOptions, Collections.singletonList(expectedPrefix), expectedSuffix);
    }

    private void testStore(HttpServerOptions serverOptions, List<String> expectedPossiblePrefixes, String expectedSuffix) {
        serverOptions.setSsl(true);
        serverOptions.setPort(4043);
        HttpServer server = this.vertx.createHttpServer(serverOptions);
        server.requestHandler(req -> {});
        try {
            server.listen();
            this.fail("Was expecting a failure");
        }
        catch (VertxException e) {
            Throwable cause = e.getCause();
            if (expectedSuffix == null) {
                boolean ok = expectedPossiblePrefixes.isEmpty();
                for (String expectedPossiblePrefix : expectedPossiblePrefixes) {
                    ok |= expectedPossiblePrefix.equals(cause.getMessage());
                }
                if (!ok) {
                    this.fail("Was expecting <" + cause.getMessage() + ">  to be equals to one of " + expectedPossiblePrefixes);
                }
            }
            boolean ok = expectedPossiblePrefixes.isEmpty();
            for (String expectedPossiblePrefix : expectedPossiblePrefixes) {
                ok |= cause.getMessage().startsWith(expectedPossiblePrefix);
            }
            if (!ok) {
                this.fail("Was expecting e.getCause().getMessage() to be prefixed by one of " + expectedPossiblePrefixes);
            }
            this.assertTrue(cause.getMessage().endsWith(expectedSuffix));
        }
    }

    @Test
    public void testCrlInvalidPath() throws Exception {
        HttpClientOptions clientOptions = new HttpClientOptions();
        clientOptions.setTrustOptions((TrustOptions)Trust.SERVER_PEM_ROOT_CA.get());
        clientOptions.setSsl(true);
        clientOptions.addCrlPath("/invalid.pem");
        HttpClient client = this.vertx.createHttpClient(clientOptions);
        HttpClientRequest req = client.request(HttpMethod.CONNECT, 8080, "localhost", "/", handler -> {});
        try {
            req.end();
            this.fail("Was expecting a failure");
        }
        catch (VertxException e) {
            this.assertNotNull(e.getCause());
            this.assertEquals(NoSuchFileException.class, e.getCause().getCause().getClass());
        }
    }

    @Test
    public void testHttpsProxy() throws Exception {
        this.testProxy(ProxyType.HTTP);
        this.assertEquals("Host header doesn't contain target host", "localhost:4043", this.proxy.getLastRequestHeaders().get("Host"));
        this.assertEquals("Host header doesn't contain target host", HttpMethod.CONNECT, this.proxy.getLastMethod());
    }

    private void testProxy(ProxyType proxyType) throws Exception {
        this.startProxy(null, proxyType);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).useProxy(proxyType).pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "localhost:4043", this.proxy.getLastUri());
    }

    @Test
    public void testHttpsProxyWithSNI() throws Exception {
        this.testProxyWithSNI(ProxyType.HTTP);
        this.assertEquals("Host header doesn't contain target host", "host2.com:4043", this.proxy.getLastRequestHeaders().get("Host"));
        this.assertEquals("Host header doesn't contain target host", HttpMethod.CONNECT, this.proxy.getLastMethod());
    }

    private void testProxyWithSNI(ProxyType proxyType) throws Exception {
        this.startProxy(null, proxyType);
        X509Certificate cert = this.testTLS(Cert.NONE, Trust.SNI_JKS_HOST2, Cert.SNI_JKS, Trust.NONE).serverSni().useProxy(proxyType).requestOptions(new RequestOptions().setSsl(true).setPort(4043).setHost("host2.com")).pass().clientPeerCert();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "host2.com:4043", this.proxy.getLastUri());
        this.assertEquals("host2.com", TestUtils.cnOf(cert));
    }

    @Test
    public void testHttpsProxyAuthFail() throws Exception {
        this.startProxy("username", ProxyType.HTTP);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).useProxy(ProxyType.HTTP).fail();
    }

    @Test
    public void testHttpsProxyAuth() throws Exception {
        this.startProxy("username", ProxyType.HTTP);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).useProxy(ProxyType.HTTP).useProxyAuth().pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "localhost:4043", this.proxy.getLastUri());
        this.assertEquals("Host header doesn't contain target host", "localhost:4043", this.proxy.getLastRequestHeaders().get("Host"));
        this.assertEquals("Host header doesn't contain target host", HttpMethod.CONNECT, this.proxy.getLastMethod());
    }

    @Test
    public void testHttpsProxyUnknownHost() throws Exception {
        this.startProxy(null, ProxyType.HTTP);
        this.proxy.setForceUri("localhost:4043");
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).useProxy(ProxyType.HTTP).connectHostname("doesnt-resolve.host-name").clientTrustAll().clientVerifyHost(false).pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "doesnt-resolve.host-name:4043", this.proxy.getLastUri());
        this.assertEquals("Host header doesn't contain target host", "doesnt-resolve.host-name:4043", this.proxy.getLastRequestHeaders().get("Host"));
        this.assertEquals("Host header doesn't contain target host", HttpMethod.CONNECT, this.proxy.getLastMethod());
    }

    @Test
    public void testHttpsSocks() throws Exception {
        this.testProxy(ProxyType.SOCKS5);
    }

    @Test
    public void testHttpsSocksWithSNI() throws Exception {
        this.testProxyWithSNI(ProxyType.SOCKS5);
    }

    @Test
    public void testHttpsSocksAuth() throws Exception {
        this.startProxy("username", ProxyType.SOCKS5);
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).useProxy(ProxyType.SOCKS5).useProxyAuth().pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "localhost:4043", this.proxy.getLastUri());
    }

    @Test
    public void testSocksProxyUnknownHost() throws Exception {
        this.startProxy(null, ProxyType.SOCKS5);
        this.proxy.setForceUri("localhost:4043");
        this.testTLS(Cert.NONE, Trust.SERVER_JKS, Cert.SERVER_JKS, Trust.NONE).useProxy(ProxyType.SOCKS5).connectHostname("doesnt-resolve.host-name").clientTrustAll().clientVerifyHost(false).pass();
        this.assertNotNull("connection didn't access the proxy", this.proxy.getLastUri());
        this.assertEquals("hostname resolved but it shouldn't be", "doesnt-resolve.host-name:4043", this.proxy.getLastUri());
    }

    class TLSTest {
        HttpVersion version;
        KeyCertOptions clientCert;
        TrustOptions clientTrust;
        boolean clientTrustAll;
        boolean clientUsesCrl;
        boolean clientUsesAlpn;
        boolean clientOpenSSL;
        boolean clientVerifyHost = true;
        boolean clientSSL = true;
        boolean requiresClientAuth;
        KeyCertOptions serverCert;
        TrustOptions serverTrust;
        boolean serverUsesCrl;
        boolean serverOpenSSL;
        boolean serverUsesAlpn;
        boolean serverSSL = true;
        ProxyType proxyType;
        boolean useProxyAuth;
        String[] clientEnabledCipherSuites = new String[0];
        String[] serverEnabledCipherSuites = new String[0];
        String[] clientEnabledSecureTransportProtocol = new String[0];
        String[] serverEnabledSecureTransportProtocol = new String[0];
        private String connectHostname;
        private boolean followRedirects;
        private boolean serverSNI;
        private boolean clientForceSNI;
        private Function<HttpClient, HttpClientRequest> requestProvider = client -> {
            String httpHost = this.connectHostname != null ? this.connectHostname : "localhost";
            return client.request(HttpMethod.POST, 4043, httpHost, "some-uri");
        };
        X509Certificate clientPeerCert;
        String indicatedServerName;

        public TLSTest(Cert<?> clientCert, Trust<?> clientTrust, Cert<?> serverCert, Trust<?> serverTrust) {
            this.version = HttpVersion.HTTP_1_1;
            this.clientCert = (KeyCertOptions)clientCert.get();
            this.clientTrust = (TrustOptions)clientTrust.get();
            this.serverCert = (KeyCertOptions)serverCert.get();
            this.serverTrust = (TrustOptions)serverTrust.get();
        }

        TLSTest version(HttpVersion version) {
            this.version = version;
            return this;
        }

        TLSTest requiresClientAuth() {
            this.requiresClientAuth = true;
            return this;
        }

        TLSTest serverUsesCrl() {
            this.serverUsesCrl = true;
            return this;
        }

        TLSTest serverOpenSSL() {
            this.serverOpenSSL = true;
            return this;
        }

        TLSTest clientOpenSSL() {
            this.clientOpenSSL = true;
            return this;
        }

        TLSTest clientUsesCrl() {
            this.clientUsesCrl = true;
            return this;
        }

        TLSTest clientTrustAll() {
            this.clientTrustAll = true;
            return this;
        }

        TLSTest clientVerifyHost() {
            this.clientVerifyHost = true;
            return this;
        }

        TLSTest clientVerifyHost(boolean verify) {
            this.clientVerifyHost = verify;
            return this;
        }

        TLSTest clientEnabledCipherSuites(String[] value) {
            this.clientEnabledCipherSuites = value;
            return this;
        }

        TLSTest serverEnabledCipherSuites(String[] value) {
            this.serverEnabledCipherSuites = value;
            return this;
        }

        TLSTest clientEnabledSecureTransportProtocol(String[] value) {
            this.clientEnabledSecureTransportProtocol = value;
            return this;
        }

        TLSTest serverEnabledSecureTransportProtocol(String[] value) {
            this.serverEnabledSecureTransportProtocol = value;
            return this;
        }

        TLSTest serverSni() {
            this.serverSNI = true;
            return this;
        }

        TLSTest clientForceSni() {
            this.clientForceSNI = true;
            return this;
        }

        TLSTest clientUsesAlpn() {
            this.clientUsesAlpn = true;
            return this;
        }

        TLSTest serverUsesAlpn() {
            this.serverUsesAlpn = true;
            return this;
        }

        TLSTest useProxy(ProxyType type) {
            this.proxyType = type;
            return this;
        }

        TLSTest useProxyAuth() {
            this.useProxyAuth = true;
            return this;
        }

        TLSTest connectHostname(String connectHostname) {
            this.connectHostname = connectHostname;
            return this;
        }

        TLSTest requestOptions(RequestOptions requestOptions) {
            this.requestProvider = client -> client.request(HttpMethod.POST, requestOptions);
            return this;
        }

        TLSTest requestProvider(Function<HttpClient, HttpClientRequest> requestProvider) {
            this.requestProvider = requestProvider;
            return this;
        }

        TLSTest clientSSL(boolean ssl) {
            this.clientSSL = ssl;
            return this;
        }

        TLSTest serverSSL(boolean ssl) {
            this.serverSSL = ssl;
            return this;
        }

        TLSTest followRedirects(boolean follow) {
            this.followRedirects = follow;
            return this;
        }

        public X509Certificate clientPeerCert() {
            return this.clientPeerCert;
        }

        TLSTest pass() {
            return this.run(true);
        }

        TLSTest fail() {
            return this.run(false);
        }

        TLSTest run(boolean shouldPass) {
            if (this.proxyType == null || shouldPass) {
                HttpTLSTest.this.waitFor(2);
            }
            HttpTLSTest.this.server.close();
            HttpClientOptions options = new HttpClientOptions();
            options.setProtocolVersion(this.version);
            options.setSsl(this.clientSSL);
            options.setForceSni(this.clientForceSNI);
            if (this.clientTrustAll) {
                options.setTrustAll(true);
            }
            if (this.clientUsesCrl) {
                options.addCrlPath("tls/root-ca/crl.pem");
            }
            if (this.clientOpenSSL) {
                options.setOpenSslEngineOptions(new OpenSSLEngineOptions());
            }
            if (this.clientUsesAlpn) {
                options.setUseAlpn(true);
            }
            options.setVerifyHost(this.clientVerifyHost);
            options.setTrustOptions(this.clientTrust);
            options.setKeyCertOptions(this.clientCert);
            for (String suite : this.clientEnabledCipherSuites) {
                options.addEnabledCipherSuite(suite);
            }
            for (String protocols : this.clientEnabledSecureTransportProtocol) {
                options.addEnabledSecureTransportProtocol(protocols);
            }
            if (this.proxyType != null) {
                ProxyOptions proxyOptions = this.proxyType == ProxyType.SOCKS5 ? new ProxyOptions().setHost("localhost").setPort(11080).setType(ProxyType.SOCKS5) : new ProxyOptions().setHost("localhost").setPort(13128).setType(ProxyType.HTTP);
                if (this.useProxyAuth) {
                    proxyOptions.setUsername("username").setPassword("username");
                }
                options.setProxyOptions(proxyOptions);
            }
            HttpTLSTest.this.client = HttpTLSTest.this.createHttpClient(options);
            HttpServerOptions serverOptions = new HttpServerOptions();
            serverOptions.setTrustOptions(this.serverTrust);
            serverOptions.setKeyCertOptions(this.serverCert);
            if (this.requiresClientAuth) {
                serverOptions.setClientAuth(ClientAuth.REQUIRED);
            }
            if (this.serverUsesCrl) {
                serverOptions.addCrlPath("tls/root-ca/crl.pem");
            }
            if (this.serverOpenSSL) {
                serverOptions.setOpenSslEngineOptions(new OpenSSLEngineOptions());
            }
            serverOptions.setUseAlpn(this.serverUsesAlpn);
            serverOptions.setSsl(this.serverSSL);
            serverOptions.setSni(this.serverSNI);
            for (String suite : this.serverEnabledCipherSuites) {
                serverOptions.addEnabledCipherSuite(suite);
            }
            for (String protocols : this.serverEnabledSecureTransportProtocol) {
                serverOptions.addEnabledSecureTransportProtocol(protocols);
            }
            HttpTLSTest.this.server = HttpTLSTest.this.createHttpServer(serverOptions.setPort(4043));
            HttpTLSTest.this.server.connectionHandler(conn -> HttpTLSTest.this.complete());
            AtomicInteger count = new AtomicInteger();
            HttpTLSTest.this.server.exceptionHandler(err -> {
                if (shouldPass) {
                    this.fail();
                } else if (count.incrementAndGet() == 1) {
                    HttpTLSTest.this.complete();
                }
            });
            HttpTLSTest.this.server.requestHandler(req -> {
                this.indicatedServerName = req.connection().indicatedServerName();
                HttpTLSTest.this.assertEquals(this.version, req.version());
                req.bodyHandler(buffer -> {
                    HttpTLSTest.this.assertEquals(this.serverSSL, req.isSSL());
                    HttpTLSTest.this.assertEquals("foo", buffer.toString());
                    req.response().end("bar");
                });
            });
            HttpTLSTest.this.server.listen(ar -> {
                HttpTLSTest.this.assertTrue(ar.succeeded());
                if (this.connectHostname != null) {
                    String httpHost = this.connectHostname;
                } else {
                    String httpHost = "localhost";
                }
                HttpClientRequest req = this.requestProvider.apply(HttpTLSTest.this.client);
                req.setFollowRedirects(this.followRedirects);
                req.handler(response -> {
                    HttpConnection conn = response.request().connection();
                    if (conn.isSsl()) {
                        try {
                            this.clientPeerCert = conn.peerCertificateChain()[0];
                        }
                        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                            // empty catch block
                        }
                    }
                    if (shouldPass) {
                        response.version();
                        response.bodyHandler(data -> HttpTLSTest.this.assertEquals("bar", data.toString()));
                        HttpTLSTest.this.complete();
                    } else {
                        HttpTLSTest.this.fail("Should not get a response");
                    }
                });
                req.exceptionHandler(t -> {
                    if (shouldPass) {
                        t.printStackTrace();
                        HttpTLSTest.this.fail("Should not throw exception");
                    } else {
                        HttpTLSTest.this.complete();
                    }
                });
                req.end("foo");
            });
            HttpTLSTest.this.await();
            return this;
        }
    }
}

