/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.net.NetSocket;
import io.vertx.test.core.Http1xTest;
import io.vertx.test.core.HttpTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.netty.TestLoggerFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class HttpTest
extends HttpTestBase {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    protected File testDir;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testDir = this.testFolder.newFolder();
    }

    protected HttpServerOptions createBaseServerOptions() {
        return new HttpServerOptions().setPort(8080).setHost("localhost");
    }

    protected HttpClientOptions createBaseClientOptions() {
        return new HttpClientOptions();
    }

    @Test
    public void testClientRequestArguments() throws Exception {
        HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler());
        TestUtils.assertNullPointerException(() -> req.putHeader((String)null, "someValue"));
        TestUtils.assertNullPointerException(() -> req.putHeader((CharSequence)null, (CharSequence)"someValue"));
        TestUtils.assertNullPointerException(() -> req.putHeader("someKey", (Iterable)null));
        TestUtils.assertNullPointerException(() -> req.write((Buffer)null));
        TestUtils.assertNullPointerException(() -> req.write((String)null));
        TestUtils.assertNullPointerException(() -> req.write(null, "UTF-8"));
        TestUtils.assertNullPointerException(() -> req.write("someString", null));
        TestUtils.assertNullPointerException(() -> req.end((Buffer)null));
        TestUtils.assertNullPointerException(() -> req.end((String)null));
        TestUtils.assertNullPointerException(() -> req.end(null, "UTF-8"));
        TestUtils.assertNullPointerException(() -> req.end("someString", null));
        TestUtils.assertIllegalArgumentException(() -> req.setTimeout(0L));
    }

    @Test
    public void testClientChaining() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler());
            this.assertTrue(req.setChunked(true) == req);
            this.assertTrue(req.sendHead() == req);
            this.assertTrue(req.write("foo", "UTF-8") == req);
            this.assertTrue(req.write("foo") == req);
            this.assertTrue(req.write(Buffer.buffer((String)"foo")) == req);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testLowerCaseHeaders() {
        this.server.requestHandler(req -> {
            this.assertEquals("foo", req.headers().get("Foo"));
            this.assertEquals("foo", req.headers().get("foo"));
            this.assertEquals("foo", req.headers().get("fOO"));
            this.assertTrue(req.headers().contains("Foo"));
            this.assertTrue(req.headers().contains("foo"));
            this.assertTrue(req.headers().contains("fOO"));
            req.response().putHeader("Quux", "quux");
            this.assertEquals("quux", req.response().headers().get("Quux"));
            this.assertEquals("quux", req.response().headers().get("quux"));
            this.assertEquals("quux", req.response().headers().get("qUUX"));
            this.assertTrue(req.response().headers().contains("Quux"));
            this.assertTrue(req.response().headers().contains("quux"));
            this.assertTrue(req.response().headers().contains("qUUX"));
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals("quux", resp.headers().get("Quux"));
                this.assertEquals("quux", resp.headers().get("quux"));
                this.assertEquals("quux", resp.headers().get("qUUX"));
                this.assertTrue(resp.headers().contains("Quux"));
                this.assertTrue(resp.headers().contains("quux"));
                this.assertTrue(resp.headers().contains("qUUX"));
                this.testComplete();
            });
            req.putHeader("Foo", "foo");
            this.assertEquals("foo", req.headers().get("Foo"));
            this.assertEquals("foo", req.headers().get("foo"));
            this.assertEquals("foo", req.headers().get("fOO"));
            this.assertTrue(req.headers().contains("Foo"));
            this.assertTrue(req.headers().contains("foo"));
            this.assertTrue(req.headers().contains("fOO"));
            req.end();
        }));
        this.await();
    }

    @Test
    public void testServerActualPortWhenSet() {
        this.server.requestHandler(request -> request.response().end("hello")).listen(ar -> {
            this.assertEquals(((HttpServer)ar.result()).actualPort(), 8080L);
            this.vertx.createHttpClient(this.createBaseClientOptions()).getNow(((HttpServer)ar.result()).actualPort(), "localhost", "/", response -> {
                this.assertEquals(response.statusCode(), 200L);
                response.bodyHandler(body -> {
                    this.assertEquals(body.toString("UTF-8"), "hello");
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testServerActualPortWhenZero() {
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setPort(0).setHost("localhost"));
        this.server.requestHandler(request -> request.response().end("hello")).listen(ar -> {
            this.assertTrue(((HttpServer)ar.result()).actualPort() != 0);
            this.vertx.createHttpClient(this.createBaseClientOptions()).getNow(((HttpServer)ar.result()).actualPort(), "localhost", "/", response -> {
                this.assertEquals(response.statusCode(), 200L);
                response.bodyHandler(body -> {
                    this.assertEquals(body.toString("UTF-8"), "hello");
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testServerActualPortWhenZeroPassedInListen() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions(this.createBaseServerOptions()).setHost("localhost"));
        this.server.requestHandler(request -> request.response().end("hello")).listen(0, ar -> {
            this.assertTrue(((HttpServer)ar.result()).actualPort() != 0);
            this.vertx.createHttpClient(this.createBaseClientOptions()).getNow(((HttpServer)ar.result()).actualPort(), "localhost", "/", response -> {
                this.assertEquals(response.statusCode(), 200L);
                response.bodyHandler(body -> {
                    this.assertEquals(body.toString("UTF-8"), "hello");
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testRequestNPE() {
        String uri = "/some-uri?foo=bar";
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", uri, null));
        TestUtils.assertNullPointerException(() -> this.client.request((HttpMethod)null, 8080, "localhost", uri, resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.requestAbs((HttpMethod)null, "http://someuri", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", "/somepath", null));
        TestUtils.assertNullPointerException(() -> this.client.request((HttpMethod)null, 8080, "localhost", "/somepath", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, null, "/somepath", resp -> {}));
        TestUtils.assertNullPointerException(() -> this.client.request(HttpMethod.GET, 8080, "localhost", null, resp -> {}));
    }

    @Test
    public void testInvalidAbsoluteURI() {
        try {
            this.client.requestAbs(HttpMethod.GET, "ijdijwidjqwoijd192d192192ej12d", resp -> {}).end();
            this.fail("Should throw exception");
        }
        catch (VertxException vertxException) {
            // empty catch block
        }
    }

    @Test
    public void testPutHeadersOnRequest() {
        this.server.requestHandler(req -> {
            this.assertEquals("bar", req.headers().get("foo"));
            this.assertEquals("bar", req.getHeader("foo"));
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).putHeader("foo", "bar").end()));
        this.await();
    }

    @Test
    public void testPutHeaderReplacesPreviousHeaders() throws Exception {
        this.server.requestHandler(req -> req.response().putHeader("Location", "http://example1.org").putHeader("location", "http://example2.org").end());
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(Collections.singletonList("http://example2.org"), resp.headers().getAll("LocatioN"));
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testSimpleGET() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePUT() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PUT, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePOST() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.POST, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleDELETE() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.DELETE, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleHEAD() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.HEAD, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleTRACE() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.TRACE, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleCONNECT() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.CONNECT, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleOPTIONS() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.OPTIONS, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePATCH() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PATCH, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleGETAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.GET, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePUTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PUT, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePOSTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.POST, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleDELETEAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.DELETE, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleHEADAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.HEAD, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleTRACEAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.TRACE, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleCONNECTAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.CONNECT, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimpleOPTIONSAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.OPTIONS, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    @Test
    public void testSimplePATCHAbsolute() {
        String uri = "/some-uri?foo=bar";
        this.testSimpleRequest(uri, HttpMethod.PATCH, true, (Handler<HttpClientResponse>)((Handler)resp -> this.testComplete()));
    }

    private void testSimpleRequest(String uri, HttpMethod method, Handler<HttpClientResponse> handler) {
        this.testSimpleRequest(uri, method, false, handler);
    }

    private void testSimpleRequest(String uri, HttpMethod method, boolean absolute, Handler<HttpClientResponse> handler) {
        HttpClientRequest req = absolute ? this.client.requestAbs(method, "http://localhost:8080" + uri, handler) : this.client.request(method, 8080, "localhost", uri, handler);
        this.testSimpleRequest(uri, method, req, absolute);
    }

    private void testSimpleRequest(String uri, HttpMethod method, HttpClientRequest request, boolean absolute) {
        String query;
        int index = uri.indexOf(63);
        String path = index == -1 ? uri : uri.substring(0, index);
        String string = query = index == -1 ? null : uri.substring(index + 1);
        if (absolute) {
            this.server.close();
            this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setSsl(false).setUseAlpn(false));
        }
        this.server.requestHandler(req -> {
            String expectedPath = req.method() == HttpMethod.CONNECT && req.version() == HttpVersion.HTTP_2 ? null : path;
            String expectedQuery = req.method() == HttpMethod.CONNECT && req.version() == HttpVersion.HTTP_2 ? null : query;
            this.assertEquals(expectedPath, req.path());
            this.assertEquals(method, req.method());
            this.assertEquals(expectedQuery, req.query());
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> request.end()));
        this.await();
    }

    @Test
    public void testServerChaining() {
        this.server.requestHandler(req -> {
            this.assertTrue(req.response().setChunked(true) == req.response());
            this.assertTrue(req.response().write("foo", "UTF-8") == req.response());
            this.assertTrue(req.response().write("foo") == req.response());
            this.testComplete();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testServerChainingSendFile() throws Exception {
        File file = this.setupFile("test-server-chaining.dat", "blah");
        this.server.requestHandler(req -> {
            this.assertTrue(req.response().sendFile(file.getAbsolutePath()) == req.response());
            this.assertTrue(req.response().ended());
            file.delete();
            this.testComplete();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlers1() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(0L, req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().end();
        }).listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            this.complete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlers2() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String content = "blah";
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().end(content);
        }).listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content), buff);
                this.complete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlersChunkedResponse() {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String chunk = "blah";
        int numChunks = 6;
        StringBuilder content = new StringBuilder(chunk.length() * numChunks);
        IntStream.range(0, numChunks).forEach(i -> content.append(chunk));
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().setChunked(true);
            IntStream.range(0, numChunks - 1).forEach(x -> req.response().write(chunk));
            req.response().end(chunk);
        }).listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content.toString()), buff);
                this.complete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testResponseEndHandlersSendFile() throws Exception {
        this.waitFor(2);
        AtomicInteger cnt = new AtomicInteger();
        String content = "iqdioqwdqwiojqwijdwqd";
        File toSend = this.setupFile("somefile.txt", content);
        this.server.requestHandler(req -> {
            req.response().headersEndHandler(v -> {
                req.response().putHeader("extraheader", "wibble");
                this.assertEquals(0L, cnt.getAndIncrement());
            });
            req.response().bodyEndHandler(v -> {
                this.assertEquals(content.length(), req.response().bytesWritten());
                this.assertEquals(1L, cnt.getAndIncrement());
                this.complete();
            });
            req.response().sendFile(toSend.getAbsolutePath());
        }).listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
            this.assertEquals(200L, res.statusCode());
            this.assertEquals("wibble", res.headers().get("extraheader"));
            res.bodyHandler(buff -> {
                this.assertEquals(Buffer.buffer((String)content), buff);
                this.complete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testAbsoluteURI() {
        this.testURIAndPath("http://localhost:8080/this/is/a/path/foo.html", "/this/is/a/path/foo.html");
    }

    @Test
    public void testRelativeURI() {
        this.testURIAndPath("/this/is/a/path/foo.html", "/this/is/a/path/foo.html");
    }

    @Test
    public void testAbsoluteURIWithHttpSchemaInQuery() {
        this.testURIAndPath("http://localhost:8080/correct/path?url=http://localhost:8008/wrong/path", "/correct/path");
    }

    @Test
    public void testRelativeURIWithHttpSchemaInQuery() {
        this.testURIAndPath("/correct/path?url=http://localhost:8008/wrong/path", "/correct/path");
    }

    @Test
    public void testAbsoluteURIEmptyPath() {
        this.testURIAndPath("http://localhost:8080/", "/");
    }

    private void testURIAndPath(String uri, String path) {
        this.server.requestHandler(req -> {
            this.assertEquals(uri, req.uri());
            this.assertEquals(path, req.path());
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", uri, resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testParamUmlauteDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("\u00e4\u00fc\u00f6");
    }

    @Test
    public void testParamPlusDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("+");
    }

    @Test
    public void testParamPercentDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("%");
    }

    @Test
    public void testParamSpaceDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding(" ");
    }

    @Test
    public void testParamNormalDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("hello");
    }

    @Test
    public void testParamAltogetherDecoding() throws UnsupportedEncodingException {
        this.testParamDecoding("\u00e4\u00fc\u00f6+% hello");
    }

    private void testParamDecoding(String value) throws UnsupportedEncodingException {
        this.server.requestHandler(req -> {
            req.setExpectMultipart(true);
            req.endHandler(v -> {
                MultiMap formAttributes = req.formAttributes();
                this.assertEquals(value, formAttributes.get("param"));
            });
            req.response().end();
        });
        String postData = "param=" + URLEncoder.encode(value, "UTF-8");
        this.server.listen(this.onSuccess(server -> this.client.post(8080, "localhost", "/").putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED).putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(postData.length())).handler(resp -> this.testComplete()).write(postData).end()));
        this.await();
    }

    @Test
    public void testParamsAmpersand() {
        this.testParams('&');
    }

    @Test
    public void testParamsSemiColon() {
        this.testParams(';');
    }

    private void testParams(char delim) {
        Map<String, String> params = HttpTest.genMap(10);
        String query = HttpTest.generateQueryString(params, delim);
        this.server.requestHandler(req -> {
            this.assertEquals(query, req.query());
            this.assertEquals(params.size(), req.params().size());
            for (Map.Entry entry : req.params()) {
                this.assertEquals(entry.getValue(), params.get(entry.getKey()));
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri/?" + query, resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testNoParams() {
        this.server.requestHandler(req -> {
            this.assertNull(req.query());
            this.assertTrue(req.params().isEmpty());
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testDefaultRequestHeaders() {
        this.server.requestHandler(req -> {
            if (req.version() == HttpVersion.HTTP_1_1) {
                this.assertEquals(1L, req.headers().size());
                this.assertEquals("localhost:8080", req.headers().get("host"));
            } else {
                this.assertEquals(4L, req.headers().size());
                this.assertEquals("https", req.headers().get(":scheme"));
                this.assertEquals("GET", req.headers().get(":method"));
                this.assertEquals("some-uri", req.headers().get(":path"));
                this.assertEquals("localhost:8080", req.headers().get(":authority"));
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete()).end()));
        this.await();
    }

    @Test
    public void testRequestHeadersWithCharSequence() {
        HashMap<CharSequence, String> headers = new HashMap<CharSequence, String>();
        headers.put(HttpHeaders.TEXT_HTML, "text/html");
        headers.put(HttpHeaders.USER_AGENT, "User-Agent");
        headers.put(HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED, "application/x-www-form-urlencoded");
        this.server.requestHandler(req -> {
            this.assertTrue(headers.size() < req.headers().size());
            headers.forEach((k, v) -> this.assertEquals(v, req.headers().get(k)));
            headers.forEach((k, v) -> this.assertEquals(v, req.getHeader(k)));
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete());
            headers.forEach((k, v) -> req.headers().add(k, (CharSequence)v));
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestHeadersPutAll() {
        this.testRequestHeaders(false);
    }

    @Test
    public void testRequestHeadersIndividually() {
        this.testRequestHeaders(true);
    }

    private void testRequestHeaders(boolean individually) {
        MultiMap headers = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            this.assertTrue(headers.size() < req.headers().size());
            for (Map.Entry entry : headers) {
                this.assertEquals(entry.getValue(), req.headers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), req.getHeader((String)entry.getKey()));
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete());
            if (individually) {
                for (Map.Entry header : headers) {
                    req.headers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.headers().setAll(headers);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testResponseHeadersPutAll() {
        this.testResponseHeaders(false);
    }

    @Test
    public void testResponseHeadersIndividually() {
        this.testResponseHeaders(true);
    }

    private void testResponseHeaders(boolean individually) {
        MultiMap headers = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            if (individually) {
                for (Map.Entry header : headers) {
                    req.response().headers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.response().headers().setAll(headers);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertTrue(headers.size() < resp.headers().size());
            for (Map.Entry entry : headers) {
                this.assertEquals(entry.getValue(), resp.headers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), resp.getHeader((String)entry.getKey()));
            }
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseHeadersWithCharSequence() {
        HashMap<CharSequence, String> headers = new HashMap<CharSequence, String>();
        headers.put(HttpHeaders.TEXT_HTML, "text/html");
        headers.put(HttpHeaders.USER_AGENT, "User-Agent");
        headers.put(HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED, "application/x-www-form-urlencoded");
        this.server.requestHandler(req -> {
            headers.forEach((k, v) -> req.response().headers().add(k, (CharSequence)v));
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertTrue(headers.size() < resp.headers().size());
            headers.forEach((k, v) -> this.assertEquals(v, resp.headers().get(k)));
            headers.forEach((k, v) -> this.assertEquals(v, resp.getHeader(k)));
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseMultipleSetCookieInHeader() {
        this.testResponseMultipleSetCookie(true, false);
    }

    @Test
    public void testResponseMultipleSetCookieInTrailer() {
        this.testResponseMultipleSetCookie(false, true);
    }

    @Test
    public void testResponseMultipleSetCookieInHeaderAndTrailer() {
        this.testResponseMultipleSetCookie(true, true);
    }

    private void testResponseMultipleSetCookie(boolean inHeader, boolean inTrailer) {
        ArrayList cookies = new ArrayList();
        this.server.requestHandler(req -> {
            if (inHeader) {
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("h1=h1v1");
                headers.add("h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT");
                cookies.addAll(headers);
                req.response().headers().set("Set-Cookie", headers);
            }
            if (inTrailer) {
                req.response().setChunked(true);
                ArrayList<String> trailers = new ArrayList<String>();
                trailers.add("t1=t1v1");
                trailers.add("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT");
                cookies.addAll(trailers);
                req.response().trailers().set("Set-Cookie", trailers);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertEquals(cookies.size(), resp.cookies().size());
            for (int i = 0; i < cookies.size(); ++i) {
                this.assertEquals(cookies.get(i), resp.cookies().get(i));
            }
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testUseRequestAfterComplete() {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler());
            req.end();
            Buffer buff = Buffer.buffer();
            TestUtils.assertIllegalStateException(() -> req.end());
            TestUtils.assertIllegalStateException(() -> req.continueHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> req.drainHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> req.end("foo"));
            TestUtils.assertIllegalStateException(() -> req.end(buff));
            TestUtils.assertIllegalStateException(() -> req.end("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> req.sendHead());
            TestUtils.assertIllegalStateException(() -> req.setChunked(false));
            TestUtils.assertIllegalStateException(() -> req.setWriteQueueMaxSize(123));
            TestUtils.assertIllegalStateException(() -> req.write(buff));
            TestUtils.assertIllegalStateException(() -> req.write("foo"));
            TestUtils.assertIllegalStateException(() -> req.write("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> req.write(buff));
            TestUtils.assertIllegalStateException(() -> req.writeQueueFull());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testRequestBodyBufferAtEnd() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(body, buffer);
            req.response().end();
        }));
        this.server.listen(this.onSuccess(server -> this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> this.testComplete()).end(body)));
        this.await();
    }

    @Test
    public void testRequestBodyStringDefaultEncodingAtEnd() {
        this.testRequestBodyStringAtEnd(null);
    }

    @Test
    public void testRequestBodyStringUTF8AtEnd() {
        this.testRequestBodyStringAtEnd("UTF-8");
    }

    @Test
    public void testRequestBodyStringUTF16AtEnd() {
        this.testRequestBodyStringAtEnd("UTF-16");
    }

    private void testRequestBodyStringAtEnd(String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(bodyBuff, buffer);
            this.testComplete();
        }));
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler());
            if (encoding == null) {
                req.end(body);
            } else {
                req.end(body, encoding);
            }
        }));
        this.await();
    }

    @Test
    public void testRequestBodyWriteChunked() {
        this.testRequestBodyWrite(true);
    }

    @Test
    public void testRequestBodyWriteNonChunked() {
        this.testRequestBodyWrite(false);
    }

    private void testRequestBodyWrite(boolean chunked) {
        Buffer body = Buffer.buffer();
        this.server.requestHandler(req -> req.bodyHandler(buffer -> {
            this.assertEquals(body, buffer);
            req.response().end();
        }));
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> this.testComplete());
            int numWrites = 10;
            int chunkSize = 100;
            if (chunked) {
                req.setChunked(true);
            } else {
                req.headers().set("Content-Length", String.valueOf(numWrites * chunkSize));
            }
            for (int i = 0; i < numWrites; ++i) {
                Buffer b = TestUtils.randomBuffer(chunkSize);
                body.appendBuffer(b);
                req.write(b);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestBodyWriteStringChunkedDefaultEncoding() {
        this.testRequestBodyWriteString(true, null);
    }

    @Test
    public void testRequestBodyWriteStringChunkedUTF8() {
        this.testRequestBodyWriteString(true, "UTF-8");
    }

    @Test
    public void testRequestBodyWriteStringChunkedUTF16() {
        this.testRequestBodyWriteString(true, "UTF-16");
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedDefaultEncoding() {
        this.testRequestBodyWriteString(false, null);
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedUTF8() {
        this.testRequestBodyWriteString(false, "UTF-8");
    }

    @Test
    public void testRequestBodyWriteStringNonChunkedUTF16() {
        this.testRequestBodyWriteString(false, "UTF-16");
    }

    private void testRequestBodyWriteString(boolean chunked, String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> req.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        }));
        this.server.listen(this.onSuccess(server -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler());
            if (chunked) {
                req.setChunked(true);
            } else {
                req.headers().set("Content-Length", String.valueOf(bodyBuff.length()));
            }
            if (encoding == null) {
                req.write(body);
            } else {
                req.write(body, encoding);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestWrite() {
        int times = 3;
        Buffer chunk = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(buff -> {
            Buffer expected = Buffer.buffer();
            for (int i = 0; i < times; ++i) {
                expected.appendBuffer(chunk);
            }
            this.assertEquals(expected, buff);
            this.testComplete();
        }));
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", this.noOpHandler());
            req.setChunked(true);
            int padding = 5;
            for (int i = 0; i < times; ++i) {
                Buffer paddedChunk = TestUtils.leftPad(padding, chunk);
                this.assertEquals(paddedChunk.getByteBuf().readerIndex(), padding);
                req.write(paddedChunk);
            }
            req.end();
        }));
        this.await();
    }

    @Test
    public void testConnectWithoutResponseHandler() throws Exception {
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end("whatever");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end("whatever", "UTF-8");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").end(Buffer.buffer((String)"whatever"));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").sendHead();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write(Buffer.buffer((String)"whatever"));
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write("whatever");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri").write("whatever", "UTF-8");
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testClientExceptionHandlerCalledWhenFailingToConnect() throws Exception {
        this.client.request(HttpMethod.GET, 9998, "255.255.255.255", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(error -> this.testComplete()).endHandler(done -> this.fail()).end();
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenServerTerminatesConnection() throws Exception {
        int numReqs = 10;
        CountDownLatch latch = new CountDownLatch(numReqs);
        this.server.requestHandler(request -> request.response().close()).listen(8080, this.onSuccess(s -> {
            for (int i = 0; i < numReqs; ++i) {
                this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(error -> latch.countDown()).endHandler(done -> this.fail()).end();
            }
        }));
        this.awaitLatch(latch);
    }

    @Test
    public void testClientExceptionHandlerCalledWhenServerTerminatesConnectionAfterPartialResponse() throws Exception {
        this.server.requestHandler(request -> request.response().setChunked(true).write("foo").close()).listen(8080, this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.exceptionHandler(t -> this.testComplete())).exceptionHandler(error -> this.fail()).end()));
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenExceptionOnDataHandler() throws Exception {
        this.server.requestHandler(request -> request.response().end("foo")).listen(8080, this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            resp.handler(data -> {
                throw new RuntimeException("should be caught");
            });
            resp.exceptionHandler(t -> this.testComplete());
        }).exceptionHandler(error -> this.fail()).end()));
        this.await();
    }

    @Test
    public void testClientExceptionHandlerCalledWhenExceptionOnBodyHandler() throws Exception {
        this.server.requestHandler(request -> request.response().end("foo")).listen(8080, this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            resp.bodyHandler(data -> {
                throw new RuntimeException("should be caught");
            });
            resp.exceptionHandler(t -> this.testComplete());
        }).exceptionHandler(error -> this.fail()).end()));
        this.await();
    }

    @Test
    public void testNoExceptionHandlerCalledWhenResponseReceivedOK() throws Exception {
        this.server.requestHandler(request -> request.response().end()).listen(8080, this.onSuccess(s -> this.client.get(8080, "localhost", "some-uri", resp -> {
            resp.endHandler(v -> this.vertx.setTimer(100L, tid -> this.testComplete()));
            resp.exceptionHandler(t -> this.fail("Should not be called"));
        }).exceptionHandler(t -> this.fail("Should not be called")).end()));
        this.await();
    }

    @Test
    public void testServerRequestExceptionHandlerCalledWhenConnectionClosed() throws Exception {
        CountDownLatch closeLatch = new CountDownLatch(1);
        this.server.requestHandler(request -> {
            request.exceptionHandler(err -> this.testComplete());
            request.handler(buff -> closeLatch.countDown());
        });
        this.startServer();
        AtomicReference conn = new AtomicReference();
        this.client.post(8080, "localhost", "some-uri", resp -> {}).connectionHandler(conn::set).setChunked(true).write("some_chunk");
        this.awaitLatch(closeLatch);
        ((HttpConnection)conn.get()).close();
        this.await();
    }

    @Test
    public void testServerResponseExceptionHandlerCalledWhenConnectionClosed() throws Exception {
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            AtomicInteger errs = new AtomicInteger();
            resp.exceptionHandler(err -> errs.incrementAndGet());
            resp.endHandler(v -> {
                this.assertEquals(1L, errs.get());
                this.testComplete();
            });
            resp.setChunked(true).write("chunk");
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "/somepath", resp -> resp.handler(chunk -> resp.request().connection().close()));
        this.await();
    }

    @Test
    public void testClientRequestExceptionHandlerCalledWhenConnectionClosed() throws Exception {
        this.server.requestHandler(req -> req.handler(buff -> req.connection().close()));
        this.startServer();
        HttpClientRequest req2 = this.client.post(8080, "localhost", "/somepath", resp -> resp.handler(chunk -> resp.request().connection().close())).setChunked(true);
        req2.exceptionHandler(err -> this.testComplete());
        req2.write("chunk");
        this.await();
    }

    @Test
    public void testClientResponseExceptionHandlerCalledWhenConnectionClosed() throws Exception {
        AtomicReference conn = new AtomicReference();
        this.server.requestHandler(req -> {
            conn.set(req.connection());
            req.response().setChunked(true).write("chunk");
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "/somepath", resp -> {
            resp.handler(buff -> ((HttpConnection)conn.get()).close());
            resp.exceptionHandler(err -> this.testComplete());
        });
        this.await();
    }

    @Test
    public void testDefaultStatus() {
        this.testStatusCode(-1, null);
    }

    @Test
    public void testDefaultOther() {
        this.testStatusCode(405, null);
    }

    @Test
    public void testOverrideStatusMessage() {
        this.testStatusCode(404, "some message");
    }

    @Test
    public void testOverrideDefaultStatusMessage() {
        this.testStatusCode(-1, "some other message");
    }

    private void testStatusCode(int code, String statusMessage) {
        this.server.requestHandler(req -> {
            if (code != -1) {
                req.response().setStatusCode(code);
            }
            if (statusMessage != null) {
                req.response().setStatusMessage(statusMessage);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            int theCode;
            if (code == -1) {
                this.assertEquals(200L, resp.statusCode());
                theCode = 200;
            } else {
                theCode = code;
            }
            if (statusMessage != null && resp.version() != HttpVersion.HTTP_2) {
                this.assertEquals(statusMessage, resp.statusMessage());
            } else {
                this.assertEquals(HttpResponseStatus.valueOf((int)theCode).reasonPhrase(), resp.statusMessage());
            }
            this.testComplete();
        }).end()));
        this.await();
    }

    @Test
    public void testResponseTrailersPutAll() {
        this.testResponseTrailers(false);
    }

    @Test
    public void testResponseTrailersPutIndividually() {
        this.testResponseTrailers(true);
    }

    private void testResponseTrailers(boolean individually) {
        MultiMap trailers = HttpTest.getHeaders(10);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            if (individually) {
                for (Map.Entry header : trailers) {
                    req.response().trailers().add((String)header.getKey(), (String)header.getValue());
                }
            } else {
                req.response().trailers().setAll(trailers);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertEquals(trailers.size(), resp.trailers().size());
            for (Map.Entry entry : trailers) {
                this.assertEquals(entry.getValue(), resp.trailers().get((String)entry.getKey()));
                this.assertEquals(entry.getValue(), resp.getTrailer((String)entry.getKey()));
            }
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseNoTrailers() {
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> {
            this.assertTrue(resp.trailers().isEmpty());
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testUseResponseAfterComplete() {
        this.server.requestHandler(req -> {
            Buffer buff = Buffer.buffer();
            HttpServerResponse resp = req.response();
            this.assertFalse(resp.ended());
            resp.end();
            this.assertTrue(resp.ended());
            TestUtils.assertIllegalStateException(() -> resp.drainHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> resp.end());
            TestUtils.assertIllegalStateException(() -> resp.end("foo"));
            TestUtils.assertIllegalStateException(() -> resp.end(buff));
            TestUtils.assertIllegalStateException(() -> resp.end("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.exceptionHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> resp.setChunked(false));
            TestUtils.assertIllegalStateException(() -> resp.setWriteQueueMaxSize(123));
            TestUtils.assertIllegalStateException(() -> resp.write(buff));
            TestUtils.assertIllegalStateException(() -> resp.write("foo"));
            TestUtils.assertIllegalStateException(() -> resp.write("foo", "UTF-8"));
            TestUtils.assertIllegalStateException(() -> resp.write(buff));
            TestUtils.assertIllegalStateException(() -> resp.writeQueueFull());
            TestUtils.assertIllegalStateException(() -> resp.sendFile("asokdasokd"));
            this.testComplete();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", this.noOpHandler()).end()));
        this.await();
    }

    @Test
    public void testResponseBodyBufferAtEnd() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.response().end(body));
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseBodyWriteChunked() {
        this.testResponseBodyWrite(true);
    }

    @Test
    public void testResponseBodyWriteNonChunked() {
        this.testResponseBodyWrite(false);
    }

    private void testResponseBodyWrite(boolean chunked) {
        Buffer body = Buffer.buffer();
        int numWrites = 10;
        int chunkSize = 100;
        this.server.requestHandler(req -> {
            this.assertFalse(req.response().headWritten());
            if (chunked) {
                req.response().setChunked(true);
            } else {
                req.response().headers().set("Content-Length", String.valueOf(numWrites * chunkSize));
            }
            this.assertFalse(req.response().headWritten());
            for (int i = 0; i < numWrites; ++i) {
                Buffer b = TestUtils.randomBuffer(chunkSize);
                body.appendBuffer(b);
                req.response().write(b);
                this.assertTrue(req.response().headWritten());
            }
            req.response().end();
            this.assertTrue(req.response().headWritten());
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseBodyWriteStringChunkedDefaultEncoding() {
        this.testResponseBodyWriteString(true, null);
    }

    @Test
    public void testResponseBodyWriteStringChunkedUTF8() {
        this.testResponseBodyWriteString(true, "UTF-8");
    }

    @Test
    public void testResponseBodyWriteStringChunkedUTF16() {
        this.testResponseBodyWriteString(true, "UTF-16");
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedDefaultEncoding() {
        this.testResponseBodyWriteString(false, null);
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedUTF8() {
        this.testResponseBodyWriteString(false, "UTF-8");
    }

    @Test
    public void testResponseBodyWriteStringNonChunkedUTF16() {
        this.testResponseBodyWriteString(false, "UTF-16");
    }

    private void testResponseBodyWriteString(boolean chunked, String encoding) {
        String body = TestUtils.randomUnicodeString(1000);
        Buffer bodyBuff = encoding == null ? Buffer.buffer((String)body) : Buffer.buffer((String)body, (String)encoding);
        this.server.requestHandler(req -> {
            if (chunked) {
                req.response().setChunked(true);
            } else {
                req.response().headers().set("Content-Length", String.valueOf(bodyBuff.length()));
            }
            if (encoding == null) {
                req.response().write(body);
            } else {
                req.response().write(body, encoding);
            }
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseWrite() {
        Buffer body = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().write(body);
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.POST, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(body, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testSendFile() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        this.sendFile("test-send-file.html", content, false);
    }

    @Test
    public void testSendFileWithHandler() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        this.sendFile("test-send-file.html", content, true);
    }

    private void sendFile(String fileName, String contentExpected, boolean handler) throws Exception {
        File fileToSend = this.setupFile(fileName, contentExpected);
        CountDownLatch latch = handler ? new CountDownLatch(2) : new CountDownLatch(1);
        this.server.requestHandler(req -> {
            if (handler) {
                Handler<AsyncResult<Void>> completionHandler = this.onSuccess(v -> latch.countDown());
                req.response().sendFile(fileToSend.getAbsolutePath(), completionHandler);
            } else {
                req.response().sendFile(fileToSend.getAbsolutePath());
            }
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("text/html", resp.headers().get("Content-Type"));
            resp.bodyHandler(buff -> {
                this.assertEquals(contentExpected, buff.toString());
                this.assertEquals(fileToSend.length(), Long.parseLong(resp.headers().get("content-length")));
                latch.countDown();
            });
        }).end()));
        this.assertTrue("Timed out waiting for test to complete.", latch.await(10L, TimeUnit.SECONDS));
        this.testComplete();
    }

    @Test
    public void testSendNonExistingFile() throws Exception {
        this.server.requestHandler(req -> {
            Context ctx = this.vertx.getOrCreateContext();
            req.response().sendFile("/not/existing/path", event -> {
                this.assertEquals(ctx, this.vertx.getOrCreateContext());
                if (event.failed()) {
                    req.response().end("failed");
                }
            });
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals("failed", buff.toString());
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testSendFileOverrideHeaders() throws Exception {
        String content = TestUtils.randomUnicodeString(10000);
        File file = this.setupFile("test-send-file.html", content);
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile(file.getAbsolutePath());
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(file.length(), Long.parseLong(resp.headers().get("content-length")));
            this.assertEquals("wibble", resp.headers().get("content-type"));
            resp.bodyHandler(buff -> {
                this.assertEquals(content, buff.toString());
                file.delete();
                this.testComplete();
            });
        }).end()));
        this.await();
    }

    @Test
    public void testSendFileNotFound() throws Exception {
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile("nosuchfile.html");
        });
        this.server.listen(this.onSuccess(s -> {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end();
            this.vertx.setTimer(100L, tid -> this.testComplete());
        }));
        this.await();
    }

    @Test
    public void testSendFileNotFoundWithHandler() throws Exception {
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile("nosuchfile.html", this.onFailure(t -> {
                this.assertTrue(t instanceof FileNotFoundException);
                this.testComplete();
            }));
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end()));
        this.await();
    }

    @Test
    public void testSendFileDirectoryWithHandler() throws Exception {
        File dir = this.testFolder.newFolder();
        this.server.requestHandler(req -> {
            req.response().putHeader("Content-Type", "wibble");
            req.response().sendFile(dir.getAbsolutePath(), this.onFailure(t -> {
                this.assertTrue(t instanceof FileNotFoundException);
                this.testComplete();
            }));
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Should not receive response")).end()));
        this.await();
    }

    @Test
    public void testSendOpenRangeFileFromClasspath() {
        this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(res -> res.response().sendFile("webroot/somefile.html", 6L)).listen(this.onSuccess(res -> this.vertx.createHttpClient(new HttpClientOptions()).request(HttpMethod.GET, 8080, "localhost", "/", resp -> resp.bodyHandler(buff -> {
            this.assertTrue(buff.toString().startsWith("<body>blah</body></html>"));
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testSendRangeFileFromClasspath() {
        this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(res -> res.response().sendFile("webroot/somefile.html", 6L, 6L)).listen(this.onSuccess(res -> this.vertx.createHttpClient(new HttpClientOptions()).request(HttpMethod.GET, 8080, "localhost", "/", resp -> resp.bodyHandler(buff -> {
            this.assertEquals("<body>", buff.toString());
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void test100ContinueHandledAutomatically() throws Exception {
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.bodyHandler(data -> {
            this.assertEquals(toSend, data);
            req.response().end();
        }));
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete()));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> {
                req.write(toSend);
                req.end();
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void test100ContinueHandledManually() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions());
        Buffer toSend = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> {
            this.assertEquals("100-continue", req.getHeader("expect"));
            req.response().writeContinue();
            req.bodyHandler(data -> {
                this.assertEquals(toSend, data);
                req.response().end();
            });
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete()));
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> {
                req.write(toSend);
                req.end();
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void test100ContinueRejectedManually() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions());
        this.server.requestHandler(req -> {
            req.response().setStatusCode(405).end();
            req.bodyHandler(data -> this.fail("body should not be received"));
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.PUT, 8080, "localhost", "some-uri", resp -> {
                this.assertEquals(405L, resp.statusCode());
                this.testComplete();
            });
            req.headers().set("Expect", "100-continue");
            req.setChunked(true);
            req.continueHandler(v -> this.fail("should not be called"));
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void testClientDrainHandler() {
        this.pausingServer(resumeFuture -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", this.noOpHandler());
            req.setChunked(true);
            this.assertFalse(req.writeQueueFull());
            req.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                req.write(buff);
                if (req.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.drainHandler(v -> {
                        this.assertFalse(req.writeQueueFull());
                        this.testComplete();
                    });
                    resumeFuture.complete();
                }
            });
        });
        this.await();
    }

    @Test
    public void testClientRequestExceptionHandlerCalledWhenExceptionOnDrainHandler() {
        this.pausingServer(resumeFuture -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", this.noOpHandler());
            req.setChunked(true);
            this.assertFalse(req.writeQueueFull());
            req.setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            AtomicBoolean failed = new AtomicBoolean();
            this.vertx.setPeriodic(1L, id -> {
                req.write(buff);
                if (req.writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.drainHandler(v -> {
                        throw new RuntimeException("error");
                    }).exceptionHandler(t -> {
                        if (failed.compareAndSet(false, true)) {
                            this.testComplete();
                        }
                    });
                    resumeFuture.complete();
                }
            });
        });
        this.await();
    }

    private void pausingServer(Consumer<Future<Void>> consumer) {
        Future resumeFuture = Future.future();
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.pause();
            Context ctx = this.vertx.getOrCreateContext();
            resumeFuture.setHandler(v1 -> ctx.runOnContext(v2 -> req.resume()));
            req.handler(buff -> req.response().write(buff));
        });
        this.server.listen(this.onSuccess(s -> consumer.accept(resumeFuture)));
    }

    @Test
    public void testServerDrainHandler() {
        this.drainingServer(resumeFuture -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            resp.pause();
            resumeFuture.setHandler(ar -> resp.resume());
        }).end());
        this.await();
    }

    private void drainingServer(Consumer<Future<Void>> consumer) {
        Future resumeFuture = Future.future();
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            this.assertFalse(req.response().writeQueueFull());
            req.response().setWriteQueueMaxSize(1000);
            Buffer buff = TestUtils.randomBuffer(10000);
            this.vertx.setPeriodic(1L, id -> {
                req.response().write(buff);
                if (req.response().writeQueueFull()) {
                    this.vertx.cancelTimer(id.longValue());
                    req.response().drainHandler(v -> {
                        this.assertFalse(req.response().writeQueueFull());
                        this.testComplete();
                    });
                    resumeFuture.complete();
                }
            });
        });
        this.server.listen(this.onSuccess(s -> consumer.accept(resumeFuture)));
    }

    @Test
    public void testConnectionErrorsGetReportedToRequest() throws InterruptedException {
        AtomicInteger req1Exceptions = new AtomicInteger();
        AtomicInteger req2Exceptions = new AtomicInteger();
        AtomicInteger req3Exceptions = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(3);
        HttpClientRequest req1 = this.client.request(HttpMethod.GET, 9998, "localhost", "someurl1", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req1.exceptionHandler(t -> {
            this.assertEquals("More than one call to req1 exception handler was not expected", 1L, req1Exceptions.incrementAndGet());
            latch.countDown();
        });
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, 9998, "localhost", "someurl2", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req2.exceptionHandler(t -> {
            this.assertEquals("More than one call to req2 exception handler was not expected", 1L, req2Exceptions.incrementAndGet());
            latch.countDown();
        });
        HttpClientRequest req3 = this.client.request(HttpMethod.GET, 9998, "localhost", "someurl2", resp -> this.fail("Should never get a response on a bad port, if you see this message than you are running an http server on port 9998"));
        req3.exceptionHandler(t -> {
            this.assertEquals("More than one call to req2 exception handler was not expected", 1L, req3Exceptions.incrementAndGet());
            latch.countDown();
        });
        req1.end();
        req2.end();
        req3.end();
        this.awaitLatch(latch);
        this.testComplete();
    }

    @Test
    public void testRequestTimesoutWhenIndicatedPeriodExpiresWithoutAResponseFromRemoteServer() {
        this.server.requestHandler(this.noOpHandler());
        AtomicBoolean failed = new AtomicBoolean();
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("End should not be called because the request should timeout"));
            req.exceptionHandler(t -> {
                if (failed.compareAndSet(false, true)) {
                    this.assertTrue("Expected to end with timeout exception but ended with other exception: " + t, t instanceof TimeoutException);
                    this.testComplete();
                }
            });
            req.setTimeout(1000L);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testRequestTimeoutCanceledWhenRequestHasAnOtherError() {
        AtomicReference exception = new AtomicReference();
        HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("End should not be called because the request should fail to connect"));
        req.exceptionHandler(exception::set);
        req.setTimeout(800L);
        req.end();
        this.vertx.setTimer(1500L, id -> {
            this.assertNotNull("Expected an exception to be set", exception.get());
            this.assertFalse("Expected to not end with timeout exception, but did: " + exception.get(), exception.get() instanceof TimeoutException);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testRequestTimeoutCanceledWhenRequestEndsNormally() {
        this.server.requestHandler(req -> req.response().end());
        this.server.listen(this.onSuccess(s -> {
            AtomicReference exception = new AtomicReference();
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", this.noOpHandler());
            req.exceptionHandler(exception::set);
            req.setTimeout(500L);
            req.end();
            this.vertx.setTimer(1000L, id -> {
                this.assertNull("Did not expect any exception", exception.get());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testRequestNotReceivedIfTimedout() {
        this.server.requestHandler(req -> this.vertx.setTimer(500L, id -> {
            req.response().setStatusCode(200);
            req.response().end("OK");
        }));
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.fail("Response should not be handled"));
            req.exceptionHandler(t -> {
                this.assertTrue("Expected to end with timeout exception but ended with other exception: " + t, t instanceof TimeoutException);
                this.vertx.setTimer(500L, id -> this.testComplete());
            });
            req.setTimeout(100L);
            req.end();
        }));
        this.await();
    }

    @Test
    public void testConnectInvalidPort() {
        this.client.request(HttpMethod.GET, 9998, "localhost", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(t -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testConnectInvalidHost() {
        this.client.request(HttpMethod.GET, 9998, "255.255.255.255", "some-uri", resp -> this.fail("Connect should not be called")).exceptionHandler(t -> this.testComplete()).end();
        this.await();
    }

    @Test
    public void testSetHandlersAfterListening() throws Exception {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(s -> {
            TestUtils.assertIllegalStateException(() -> this.server.requestHandler(this.noOpHandler()));
            TestUtils.assertIllegalStateException(() -> this.server.websocketHandler(this.noOpHandler()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSetHandlersAfterListening2() throws Exception {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(v -> this.testComplete()));
        TestUtils.assertIllegalStateException(() -> this.server.requestHandler(this.noOpHandler()));
        TestUtils.assertIllegalStateException(() -> this.server.websocketHandler(this.noOpHandler()));
        this.await();
    }

    @Test
    public void testListenNoHandlers() throws Exception {
        TestUtils.assertIllegalStateException(() -> this.server.listen(ar -> {}));
    }

    @Test
    public void testListenNoHandlers2() throws Exception {
        TestUtils.assertIllegalStateException(() -> this.server.listen());
    }

    @Test
    public void testListenTwice() throws Exception {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onSuccess(v -> this.testComplete()));
        TestUtils.assertIllegalStateException(() -> this.server.listen());
        this.await();
    }

    @Test
    public void testListenTwice2() throws Exception {
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            TestUtils.assertIllegalStateException(() -> this.server.listen());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testHeadNoBody() {
        this.server.requestHandler(req -> {
            this.assertEquals(HttpMethod.HEAD, req.method());
            req.response().headers().set("Content-Length", String.valueOf(41));
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.HEAD, 8080, "localhost", "some-uri", resp -> {
            this.assertEquals(41L, Integer.parseInt(resp.headers().get("Content-Length")));
            resp.endHandler(v -> this.testComplete());
        }).end()));
        this.await();
    }

    @Test
    public void testRemoteAddress() {
        this.server.requestHandler(req -> {
            this.assertEquals("127.0.0.1", req.remoteAddress().host());
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.endHandler(v -> this.testComplete())).end()));
        this.await();
    }

    @Test
    public void testGetAbsoluteURI() {
        this.server.requestHandler(req -> {
            this.assertEquals(req.scheme() + "://localhost:" + 8080 + "/foo/bar", req.absoluteURI());
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "/foo/bar", resp -> resp.endHandler(v -> this.testComplete())).end()));
        this.await();
    }

    @Test
    public void testListenInvalidPort() throws Exception {
        Assume.assumeFalse((boolean)System.getProperty("os.name").startsWith("Windows"));
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(7));
        this.server.requestHandler(this.noOpHandler()).listen(this.onFailure(server -> this.testComplete()));
        this.await();
    }

    @Test
    public void testListenInvalidHost() {
        this.server.close();
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("iqwjdoqiwjdoiqwdiojwd"));
        this.server.requestHandler(this.noOpHandler());
        this.server.listen(this.onFailure(s -> this.testComplete()));
    }

    @Test
    public void testPauseClientResponse() {
        int numWrites = 10;
        int numBytes = 100;
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            for (int i = 0; i < numWrites; ++i) {
                req.response().write(TestUtils.randomBuffer(numBytes));
            }
            req.response().end();
        });
        AtomicBoolean paused = new AtomicBoolean();
        Buffer totBuff = Buffer.buffer();
        HttpClientRequest clientRequest = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
            resp.pause();
            paused.set(true);
            resp.handler(chunk -> {
                if (paused.get()) {
                    this.fail("Shouldn't receive chunks when paused");
                } else {
                    totBuff.appendBuffer(chunk);
                }
            });
            resp.endHandler(v -> {
                if (paused.get()) {
                    this.fail("Shouldn't receive chunks when paused");
                } else {
                    this.assertEquals(numWrites * numBytes, totBuff.length());
                    this.testComplete();
                }
            });
            this.vertx.setTimer(500L, id -> {
                paused.set(false);
                resp.resume();
            });
        });
        this.server.listen(this.onSuccess(s -> clientRequest.end()));
        this.await();
    }

    @Test
    public void testDeliverPausedBufferWhenResume() throws Exception {
        int i;
        Buffer data = TestUtils.randomBuffer(20);
        int num = 10;
        this.waitFor(num);
        List resumes = Collections.synchronizedList(new ArrayList());
        for (i = 0; i < num; ++i) {
            resumes.add(new CompletableFuture());
        }
        this.server.requestHandler(req -> {
            int idx = Integer.parseInt(req.path().substring(1));
            HttpServerResponse resp = req.response();
            ((CompletableFuture)resumes.get(idx)).thenAccept(v -> resp.end());
            resp.setChunked(true).write(data);
        });
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        for (i = 0; i < num; ++i) {
            int idx = i;
            this.client.request(HttpMethod.GET, 8080, "localhost", "/" + i, resp -> {
                Buffer body = Buffer.buffer();
                resp.handler(buff -> {
                    ((CompletableFuture)resumes.get(idx)).complete(null);
                    body.appendBuffer(buff);
                });
                resp.endHandler(v -> {
                    this.assertEquals(data, body);
                    this.complete();
                });
                resp.pause();
                this.vertx.setTimer(10L, id -> resp.resume());
            }).end();
        }
        this.await();
    }

    @Test
    public void testClearPausedBuffersWhenResponseEnds() throws Exception {
        Buffer data = TestUtils.randomBuffer(20);
        int num = 10;
        this.waitFor(num);
        this.server.requestHandler(req -> req.response().end(data));
        this.startServer();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setMaxPoolSize(1).setKeepAlive(true));
        for (int i = 0; i < num; ++i) {
            this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> {
                resp.bodyHandler(buff -> {
                    this.assertEquals(data, buff);
                    this.complete();
                });
                resp.pause();
                this.vertx.setTimer(10L, id -> resp.resume());
            }).end();
        }
        this.await();
    }

    @Test
    public void testFormUploadSmallFile() throws Exception {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), false);
    }

    @Test
    public void testFormUploadLargerFile() throws Exception {
        this.testFormUploadFile(TestUtils.randomAlphaString(20000), false);
    }

    @Test
    public void testFormUploadSmallFileStreamToDisk() throws Exception {
        this.testFormUploadFile(TestUtils.randomAlphaString(100), true);
    }

    @Test
    public void testFormUploadLargerFileStreamToDisk() throws Exception {
        this.testFormUploadFile(TestUtils.randomAlphaString(20000), true);
    }

    private void testFormUploadFile(String contentStr, boolean streamToDisk) throws Exception {
        Buffer content = Buffer.buffer((String)contentStr);
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.response().setChunked(true);
                req.setExpectMultipart(true);
                this.assertTrue(req.isExpectMultipart());
                req.setExpectMultipart(true);
                this.assertTrue(req.isExpectMultipart());
                req.uploadHandler(upload -> {
                    String uploadedFileName;
                    Buffer tot = Buffer.buffer();
                    this.assertEquals("file", upload.name());
                    this.assertEquals("tmp-0.txt", upload.filename());
                    this.assertEquals("image/gif", upload.contentType());
                    if (!streamToDisk) {
                        upload.handler(buffer -> tot.appendBuffer(buffer));
                        uploadedFileName = null;
                    } else {
                        uploadedFileName = new File(this.testDir, UUID.randomUUID().toString()).getPath();
                        upload.streamToFileSystem(uploadedFileName);
                    }
                    upload.endHandler(v -> {
                        if (streamToDisk) {
                            Buffer uploaded = this.vertx.fileSystem().readFileBlocking(uploadedFileName);
                            this.assertEquals(content, uploaded);
                        } else {
                            this.assertEquals(content, tot);
                        }
                        this.assertTrue(upload.isSizeAvailable());
                        this.assertEquals(content.length(), upload.size());
                    });
                });
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    req.response().end();
                });
            }
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(0L, attributeCount.get());
                this.testComplete();
            });
            String boundary = "dLV9Wyq26L_-JQxk6ferf-RT153LhOO";
            Buffer buffer = Buffer.buffer();
            String body = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"file\"; filename=\"tmp-0.txt\"\r\nContent-Type: image/gif\r\n\r\n" + contentStr + "\r\n--" + boundary + "--\r\n";
            buffer.appendString(body);
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "multipart/form-data; boundary=" + boundary);
            req.write(buffer).end();
        }));
        this.await();
    }

    @Test
    public void testFormUploadAttributes() throws Exception {
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.response().setChunked(true);
                req.setExpectMultipart(true);
                req.uploadHandler(upload -> upload.handler(buffer -> this.fail("Should get here")));
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    this.assertEquals("vert x", attrs.get("framework"));
                    this.assertEquals("vert x", req.getFormAttribute("framework"));
                    this.assertEquals("jvm", attrs.get("runson"));
                    this.assertEquals("jvm", req.getFormAttribute("runson"));
                    req.response().end();
                });
            }
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(2L, attributeCount.get());
                this.testComplete();
            });
            try {
                Buffer buffer = Buffer.buffer();
                buffer.appendString("framework=" + URLEncoder.encode("vert x", "UTF-8") + "&runson=jvm", "UTF-8");
                req.headers().set("content-length", String.valueOf(buffer.length()));
                req.headers().set("content-type", "application/x-www-form-urlencoded");
                req.write(buffer).end();
            }
            catch (UnsupportedEncodingException e) {
                this.fail(e.getMessage());
            }
        }));
        this.await();
    }

    @Test
    public void testFormUploadAttributes2() throws Exception {
        AtomicInteger attributeCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (req.method() == HttpMethod.POST) {
                this.assertEquals(req.path(), "/form");
                req.setExpectMultipart(true);
                req.uploadHandler(event -> event.handler(buffer -> this.fail("Should not get here")));
                req.endHandler(v -> {
                    MultiMap attrs = req.formAttributes();
                    attributeCount.set(attrs.size());
                    this.assertEquals("junit-testUserAlias", attrs.get("origin"));
                    this.assertEquals("admin@foo.bar", attrs.get("login"));
                    this.assertEquals("admin", attrs.get("pass word"));
                    req.response().end();
                });
            }
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.POST, 8080, "localhost", "/form", resp -> {
                this.assertEquals(200L, resp.statusCode());
                resp.bodyHandler(body -> this.assertEquals(0L, body.length()));
                this.assertEquals(3L, attributeCount.get());
                this.testComplete();
            });
            Buffer buffer = Buffer.buffer();
            buffer.appendString("origin=junit-testUserAlias&login=admin%40foo.bar&pass+word=admin");
            req.headers().set("content-length", String.valueOf(buffer.length()));
            req.headers().set("content-type", "application/x-www-form-urlencoded");
            req.write(buffer).end();
        }));
        this.await();
    }

    @Test
    public void testHostHeaderOverridePossible() {
        this.server.requestHandler(req -> {
            this.assertEquals("localhost:4444", req.host());
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> this.testComplete());
            req.setHost("localhost:4444");
            req.end();
        }));
        this.await();
    }

    @Test
    public void testResponseBodyWriteFixedString() {
        String body = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        Buffer bodyBuff = Buffer.buffer((String)body);
        this.server.requestHandler(req -> {
            req.response().setChunked(true);
            req.response().write(body);
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri", resp -> resp.bodyHandler(buff -> {
            this.assertEquals(bodyBuff, buff);
            this.testComplete();
        })).end()));
        this.await();
    }

    @Test
    public void testResponseDataTimeout() {
        Buffer expected = TestUtils.randomBuffer(1000);
        this.server.requestHandler(req -> req.response().setChunked(true).write(expected));
        this.server.listen(this.onSuccess(s -> {
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", "some-uri");
            Buffer received = Buffer.buffer();
            req.handler(resp -> {
                req.setTimeout(500L);
                resp.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            });
            AtomicInteger count = new AtomicInteger();
            req.exceptionHandler(t -> {
                if (count.getAndIncrement() == 0) {
                    this.assertTrue(t instanceof TimeoutException);
                    this.assertEquals(expected, received);
                    this.testComplete();
                }
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void testClientMultiThreaded() throws Exception {
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch latch = new CountDownLatch(numThreads);
        this.server.requestHandler(req -> {
            req.response().putHeader("count", req.headers().get("count"));
            req.response().end();
        }).listen(ar -> {
            this.assertTrue(ar.succeeded());
            for (int i = 0; i < numThreads; ++i) {
                final int index = i;
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        HttpTest.this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
                            HttpTest.this.assertEquals(200L, res.statusCode());
                            HttpTest.this.assertEquals(String.valueOf(index), res.headers().get("count"));
                            latch.countDown();
                        }).putHeader("count", String.valueOf(index)).end();
                    }
                };
                threads[i].start();
            }
        });
        this.awaitLatch(latch);
        for (int i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
    }

    @Test
    public void testInVerticle() throws Exception {
        this.testInVerticle(false);
    }

    private void testInVerticle(final boolean worker) throws Exception {
        this.client.close();
        this.server.close();
        class MyVerticle
        extends AbstractVerticle {
            Context ctx;

            MyVerticle() {
            }

            public void start() {
                this.ctx = Vertx.currentContext();
                if (worker) {
                    HttpTest.this.assertTrue(this.ctx instanceof WorkerContext);
                } else {
                    HttpTest.this.assertTrue(this.ctx instanceof EventLoopContext);
                }
                Thread thr = Thread.currentThread();
                HttpTest.this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
                HttpTest.this.server.requestHandler(req -> {
                    req.response().end();
                    HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                    if (!worker) {
                        HttpTest.this.assertSame(thr, Thread.currentThread());
                    }
                });
                HttpTest.this.server.listen(ar -> {
                    HttpTest.this.assertTrue(ar.succeeded());
                    HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                    if (!worker) {
                        HttpTest.this.assertSame(thr, Thread.currentThread());
                    }
                    HttpTest.this.client = this.vertx.createHttpClient(new HttpClientOptions());
                    HttpTest.this.client.request(HttpMethod.GET, 8080, "localhost", "/", res -> {
                        HttpTest.this.assertSame(this.ctx, Vertx.currentContext());
                        if (!worker) {
                            HttpTest.this.assertSame(thr, Thread.currentThread());
                        }
                        HttpTest.this.assertEquals(200L, res.statusCode());
                        HttpTest.this.testComplete();
                    }).end();
                });
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(worker));
        this.await();
    }

    @Test
    public void testUseInMultithreadedWorker() throws Exception {
        class MyVerticle
        extends AbstractVerticle {
            MyVerticle() {
            }

            public void start() {
                TestUtils.assertIllegalStateException(() -> {
                    HttpTest.this.server = this.vertx.createHttpServer(new HttpServerOptions());
                });
                TestUtils.assertIllegalStateException(() -> {
                    HttpTest.this.client = this.vertx.createHttpClient(new HttpClientOptions());
                });
                HttpTest.this.testComplete();
            }
        }
        MyVerticle verticle = new MyVerticle();
        this.vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testMultipleServerClose() {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        AtomicInteger times = new AtomicInteger();
        ThreadLocal<Boolean> stack = new ThreadLocal<Boolean>();
        stack.set(true);
        this.server.requestStream().endHandler(v -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            times.incrementAndGet();
        });
        this.server.close(ar1 -> {
            this.assertNull(stack.get());
            this.assertTrue(Vertx.currentContext().isEventLoopContext());
            this.server.close(ar2 -> this.server.close(ar3 -> {
                this.assertEquals(1L, times.get());
                this.testComplete();
            }));
        });
        this.await();
    }

    @Test
    public void testClearHandlersOnEnd() {
        String path = "/some/path";
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions());
        this.server.requestHandler(req -> req.endHandler(v -> {
            try {
                req.endHandler(null);
                req.exceptionHandler(null);
                req.handler(null);
                req.bodyHandler(null);
                req.uploadHandler(null);
            }
            catch (Exception e) {
                this.fail("Was expecting to set to null the handlers when the request is completed");
                return;
            }
            HttpServerResponse resp = req.response();
            resp.setStatusCode(200).end();
            try {
                resp.endHandler(null);
                resp.exceptionHandler(null);
                resp.drainHandler(null);
                resp.bodyEndHandler(null);
                resp.closeHandler(null);
                resp.headersEndHandler(null);
            }
            catch (Exception e) {
                this.fail("Was expecting to set to null the handlers when the response is completed");
            }
        }));
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            HttpClientRequest req = this.client.request(HttpMethod.GET, 8080, "localhost", path);
            AtomicInteger count = new AtomicInteger();
            req.handler(resp -> resp.endHandler(v -> {
                try {
                    resp.endHandler(null);
                    resp.exceptionHandler(null);
                    resp.handler(null);
                    resp.bodyHandler(null);
                }
                catch (Exception e) {
                    this.fail("Was expecting to set to null the handlers when the response is completed");
                    return;
                }
                if (count.incrementAndGet() == 2) {
                    this.testComplete();
                }
            }));
            req.endHandler(done -> {
                try {
                    req.handler(null);
                    req.exceptionHandler(null);
                    req.endHandler(null);
                    req.drainHandler(null);
                    req.connectionHandler(null);
                    req.continueHandler(null);
                }
                catch (Exception e) {
                    this.fail("Was expecting to set to null the handlers when the response is completed");
                    return;
                }
                if (count.incrementAndGet() == 2) {
                    this.testComplete();
                }
            });
            req.end();
        });
        this.await();
    }

    @Test
    public void testSetHandlersOnEnd() throws Exception {
        String path = "/some/path";
        this.server.requestHandler(req -> req.response().setStatusCode(200).end());
        this.startServer();
        HttpClientRequest req2 = this.client.request(HttpMethod.GET, 8080, "localhost", path);
        req2.handler(resp -> {});
        req2.endHandler(done -> {
            try {
                req2.handler(arg -> {});
                this.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                req2.exceptionHandler(arg -> {});
                this.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                req2.endHandler(arg -> {});
                this.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.testComplete();
        });
        req2.end();
        this.await();
    }

    @Test
    public void testRequestEnded() {
        this.server.requestHandler(req -> {
            this.assertFalse(req.isEnded());
            req.endHandler(v -> {
                this.assertTrue(req.isEnded());
                try {
                    req.endHandler(v2 -> {});
                    this.fail("Shouldn't be able to set end handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.setExpectMultipart(true);
                    this.fail("Shouldn't be able to set expect multipart");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.bodyHandler(v2 -> {});
                    this.fail("Shouldn't be able to set body handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.handler(v2 -> {});
                    this.fail("Shouldn't be able to set handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                req.response().setStatusCode(200).end();
            });
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.getNow(8080, "localhost", "/blah", resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testRequestEndedNoEndHandler() {
        this.server.requestHandler(req -> {
            this.assertFalse(req.isEnded());
            req.response().setStatusCode(200).end();
            this.vertx.setTimer(500L, v -> {
                this.assertTrue(req.isEnded());
                try {
                    req.endHandler(v2 -> {});
                    this.fail("Shouldn't be able to set end handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.setExpectMultipart(true);
                    this.fail("Shouldn't be able to set expect multipart");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.bodyHandler(v2 -> {});
                    this.fail("Shouldn't be able to set body handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    req.handler(v2 -> {});
                    this.fail("Shouldn't be able to set handler");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.testComplete();
            });
        });
        this.server.listen(ar -> {
            this.assertTrue(ar.succeeded());
            this.client.getNow(8080, "localhost", "/blah", resp -> this.assertEquals(200L, resp.statusCode()));
        });
        this.await();
    }

    @Test
    public void testInMultithreadedWorker() throws Exception {
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                HttpTest.this.assertTrue(Vertx.currentContext().isWorkerContext());
                HttpTest.this.assertTrue(Vertx.currentContext().isMultiThreadedWorkerContext());
                HttpTest.this.assertTrue(Context.isOnWorkerThread());
                try {
                    this.vertx.createHttpServer();
                    HttpTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    this.vertx.createHttpClient();
                    HttpTest.this.fail("Should throw exception");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                HttpTest.this.testComplete();
            }
        }, new DeploymentOptions().setWorker(true).setMultiThreaded(true));
        this.await();
    }

    @Test
    public void testAbsoluteURIServer() {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setHost("0.0.0.0"));
        this.server.requestHandler(req -> {
            String absURI = req.absoluteURI();
            this.assertEquals(req.scheme() + "://localhost:8080/path", absURI);
            req.response().end();
        });
        this.server.listen(this.onSuccess(s -> {
            String host = "localhost";
            String path = "/path";
            int port = 8080;
            this.client.getNow(port, host, path, resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            });
        }));
        this.await();
    }

    @Test
    public void testDumpManyRequestsOnQueue() throws Exception {
        int sendRequests = 10000;
        AtomicInteger receivedRequests = new AtomicInteger();
        this.vertx.createHttpServer(this.createBaseServerOptions()).requestHandler(r -> {
            r.response().end();
            if (receivedRequests.incrementAndGet() == sendRequests) {
                this.testComplete();
            }
        }).listen(this.onSuccess(s -> {
            HttpClientOptions ops = this.createBaseClientOptions().setDefaultPort(8080).setPipelining(true).setKeepAlive(true);
            HttpClient client = this.vertx.createHttpClient(ops);
            IntStream.range(0, sendRequests).forEach(x -> client.getNow("/", r -> {}));
        }));
        this.await();
    }

    @Test
    public void testOtherMethodWithRawMethod() throws Exception {
        try {
            this.client.request(HttpMethod.OTHER, 8080, "localhost", "/somepath", resp -> {}).end();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testOtherMethodRequest() throws Exception {
        this.server.requestHandler(r -> {
            this.assertEquals(HttpMethod.OTHER, r.method());
            this.assertEquals("COPY", r.rawMethod());
            r.response().end();
        }).listen(this.onSuccess(s -> this.client.request(HttpMethod.OTHER, 8080, "localhost", "/somepath", resp -> this.testComplete()).setRawMethod("COPY").end()));
        this.await();
    }

    @Test
    public void testClientConnectionHandler() throws Exception {
        this.server.requestHandler(req -> req.response().end());
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        AtomicInteger status = new AtomicInteger();
        HttpClientRequest req2 = this.client.post(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(1L, status.getAndIncrement());
            this.testComplete();
        });
        req2.connectionHandler(conn -> this.assertEquals(0L, status.getAndIncrement()));
        req2.end();
        this.await();
    }

    @Test
    public void testServerConnectionHandler() throws Exception {
        AtomicInteger status = new AtomicInteger();
        AtomicReference connRef = new AtomicReference();
        this.server.connectionHandler(conn -> {
            this.assertEquals(0L, status.getAndIncrement());
            this.assertNull(connRef.getAndSet(conn));
        });
        this.server.requestHandler(req -> {
            this.assertEquals(1L, status.getAndIncrement());
            this.assertSame(connRef.get(), req.connection());
            req.response().end();
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        this.client.getNow(8080, "localhost", "/somepath", resp -> this.testComplete());
        this.await();
    }

    @Test
    public void testClientConnectionClose() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            AtomicInteger len = new AtomicInteger();
            req.handler(buff -> {
                if (len.addAndGet(buff.length()) == 1024) {
                    latch.countDown();
                }
            });
            req.connection().closeHandler(v -> this.testComplete());
        });
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        HttpClientRequest req2 = this.client.post(8080, "localhost", "/somepath", resp -> this.fail());
        req2.setChunked(true);
        req2.write(TestUtils.randomBuffer(1024));
        this.awaitLatch(latch);
        req2.connection().close();
        this.await();
    }

    @Test
    public void testServerConnectionClose() throws Exception {
        this.server.requestHandler(req -> req.connection().close());
        CountDownLatch listenLatch = new CountDownLatch(1);
        this.server.listen(this.onSuccess(s -> listenLatch.countDown()));
        this.awaitLatch(listenLatch);
        HttpClientRequest req2 = this.client.post(8080, "localhost", "/somepath", resp -> this.fail());
        req2.connectionHandler(conn -> conn.closeHandler(v -> this.testComplete()));
        req2.sendHead();
        this.await();
    }

    @Test
    public void testNoLogging() throws Exception {
        TestLoggerFactory factory = this.testLogging();
        this.assertFalse(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
    }

    @Test
    public void testServerLogging() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        if (this instanceof Http1xTest) {
            this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
        } else {
            this.assertTrue(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
        }
    }

    @Test
    public void testClientLogging() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setLogActivity(true));
        TestLoggerFactory factory = this.testLogging();
        if (this instanceof Http1xTest) {
            this.assertTrue(factory.hasName("io.netty.handler.logging.LoggingHandler"));
        } else {
            this.assertTrue(factory.hasName("io.netty.handler.codec.http2.Http2FrameLogger"));
        }
    }

    @Test
    public void testClientLocalAddress() throws Exception {
        String expectedAddress = InetAddress.getLocalHost().getHostAddress();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setLocalAddress(expectedAddress));
        this.server.requestHandler(req -> {
            this.assertEquals(expectedAddress, req.remoteAddress().host());
            req.response().end();
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testFollowRedirectGetOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 301, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 301, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPutOn301() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 301, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectGetOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 302, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 302, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPutOn302() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 302, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectGetOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPutOn303() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.GET, 303, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectNotOn304() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 304, 304, 1, "http://localhost:8080/redirected", "http://localhost:8080/somepath");
    }

    @Test
    public void testFollowRedirectGetOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 307, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPostOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.POST, HttpMethod.POST, 307, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectPutOn307() throws Exception {
        this.testFollowRedirect(HttpMethod.PUT, HttpMethod.PUT, 307, 200, 2, "http://localhost:8080/redirected", "http://localhost:8080/redirected");
    }

    @Test
    public void testFollowRedirectWithRelativeLocation() throws Exception {
        this.testFollowRedirect(HttpMethod.GET, HttpMethod.GET, 301, 200, 2, "/another", "http://localhost:8080/another");
    }

    private void testFollowRedirect(HttpMethod method, HttpMethod expectedMethod, int statusCode, int expectedStatus, int expectedRequests, String location, String expectedURI) throws Exception {
        String s = this.createBaseServerOptions().isSsl() && location.startsWith("http://") ? "https://" + location.substring("http://".length()) : location;
        String t = this.createBaseServerOptions().isSsl() && expectedURI.startsWith("http://") ? "https://" + expectedURI.substring("http://".length()) : expectedURI;
        AtomicInteger numRequests = new AtomicInteger();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            if (numRequests.getAndIncrement() == 0) {
                resp.setStatusCode(statusCode);
                if (s != null) {
                    resp.putHeader(HttpHeaders.LOCATION, (CharSequence)s);
                }
                resp.end();
            } else {
                this.assertEquals(t, req.absoluteURI());
                this.assertEquals("foo_value", req.getHeader("foo"));
                this.assertEquals(expectedMethod, req.method());
                resp.end();
            }
        });
        this.startServer();
        this.client.request(method, 8080, "localhost", "/somepath", resp -> {
            this.assertEquals(resp.request().absoluteURI(), t);
            this.assertEquals(expectedRequests, numRequests.get());
            this.assertEquals(expectedStatus, resp.statusCode());
            this.testComplete();
        }).putHeader("foo", "foo_value").setFollowRedirects(true).end();
        this.await();
    }

    @Test
    public void testFollowRedirectWithBody() throws Exception {
        this.testFollowRedirectWithBody(Function.identity());
    }

    @Test
    public void testFollowRedirectWithPaddedBody() throws Exception {
        this.testFollowRedirectWithBody(buff -> TestUtils.leftPad(1, buff));
    }

    private void testFollowRedirectWithBody(Function<Buffer, Buffer> translator) throws Exception {
        Buffer expected = TestUtils.randomBuffer(2048);
        AtomicBoolean redirected = new AtomicBoolean();
        this.server.requestHandler(req -> req.bodyHandler(body -> {
            this.assertEquals(HttpMethod.PUT, req.method());
            this.assertEquals(body, expected);
            if (redirected.compareAndSet(false, true)) {
                String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                req.response().setStatusCode(307).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
            } else {
                req.response().end();
            }
        }));
        this.startServer();
        this.client.put(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true).end(translator.apply(expected));
        this.await();
    }

    @Test
    public void testFollowRedirectWithChunkedBody() throws Exception {
        Buffer buff1 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer buff2 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer expected = Buffer.buffer().appendBuffer(buff1).appendBuffer(buff2);
        AtomicBoolean redirected = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            boolean redirect = redirected.compareAndSet(false, true);
            if (redirect) {
                latch.countDown();
            }
            req.bodyHandler(body -> {
                this.assertEquals(HttpMethod.PUT, req.method());
                this.assertEquals(body, expected);
                if (redirect) {
                    String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                    req.response().setStatusCode(307).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
                } else {
                    req.response().end();
                }
            });
        });
        this.startServer();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true).setChunked(true).write(buff1);
        this.awaitLatch(latch);
        req2.end(buff2);
        this.await();
    }

    @Test
    public void testFollowRedirectWithRequestNotEnded() throws Exception {
        this.testFollowRedirectWithRequestNotEnded(false);
    }

    @Test
    public void testFollowRedirectWithRequestNotEndedFailing() throws Exception {
        this.testFollowRedirectWithRequestNotEnded(true);
    }

    private void testFollowRedirectWithRequestNotEnded(boolean expectFail) throws Exception {
        Buffer buff1 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer buff2 = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        Buffer expected = Buffer.buffer().appendBuffer(buff1).appendBuffer(buff2);
        AtomicBoolean redirected = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            boolean redirect = redirected.compareAndSet(false, true);
            if (redirect) {
                Buffer body = Buffer.buffer();
                req.handler(buff -> {
                    if (body.length() == 0) {
                        HttpServerResponse resp = req.response();
                        String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                        resp.setStatusCode(307).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever"));
                        if (expectFail) {
                            resp.setChunked(true).write("whatever");
                            this.vertx.runOnContext(v -> resp.close());
                        } else {
                            resp.end();
                        }
                        latch.countDown();
                    }
                    body.appendBuffer(buff);
                });
                req.endHandler(v -> this.assertEquals(expected, body));
            } else {
                req.response().end();
            }
        });
        this.startServer();
        AtomicBoolean called = new AtomicBoolean();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true).exceptionHandler(err -> {
            if (expectFail) {
                if (called.compareAndSet(false, true)) {
                    this.testComplete();
                }
            } else {
                this.fail((Throwable)err);
            }
        }).setChunked(true).write(buff1);
        this.awaitLatch(latch);
        if (!expectFail) {
            Thread.sleep(500L);
            req2.end(buff2);
        }
        this.await();
    }

    @Test
    public void testFollowRedirectSendHeadThenBody() throws Exception {
        Buffer expected = Buffer.buffer((String)TestUtils.randomAlphaString(2048));
        AtomicBoolean redirected = new AtomicBoolean();
        this.server.requestHandler(req -> req.bodyHandler(body -> {
            this.assertEquals(HttpMethod.PUT, req.method());
            this.assertEquals(body, expected);
            if (redirected.compareAndSet(false, true)) {
                req.response().setStatusCode(307).putHeader(HttpHeaders.LOCATION, (CharSequence)"/whatever").end();
            } else {
                req.response().end();
            }
        }));
        this.startServer();
        HttpClientRequest req2 = this.client.put(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }).setFollowRedirects(true);
        req2.putHeader("Content-Length", "" + expected.length());
        req2.exceptionHandler(this::fail);
        req2.sendHead(v -> req2.end(expected));
        this.await();
    }

    @Test
    public void testFollowRedirectLimit() throws Exception {
        AtomicInteger redirects = new AtomicInteger();
        this.server.requestHandler(req -> {
            int val = redirects.incrementAndGet();
            if (val > 16) {
                this.fail();
            } else {
                String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/otherpath")).end();
            }
        });
        this.startServer();
        this.client.get(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(16L, redirects.get());
            this.assertEquals(301L, resp.statusCode());
            this.assertEquals("/otherpath", resp.request().path());
            this.testComplete();
        }).setFollowRedirects(true).end();
        this.await();
    }

    @Test
    public void testFollowRedirectPropagatesTimeout() throws Exception {
        AtomicInteger redirections = new AtomicInteger();
        this.server.requestHandler(req -> {
            switch (redirections.getAndIncrement()) {
                case 0: {
                    String scheme = this.createBaseServerOptions().isSsl() ? "https" : "http";
                    req.response().setStatusCode(307).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:8080/whatever")).end();
                }
            }
        });
        this.startServer();
        AtomicBoolean done = new AtomicBoolean();
        this.client.get(8080, "localhost", "/somepath", resp -> this.fail()).setFollowRedirects(true).exceptionHandler(err -> {
            if (done.compareAndSet(false, true)) {
                this.assertEquals(2L, redirections.get());
                this.testComplete();
            }
        }).setTimeout(500L).end();
        this.await();
    }

    @Test
    public void testFollowRedirectHost() throws Exception {
        String scheme = this.createBaseClientOptions().isSsl() ? "https" : "http";
        this.waitFor(2);
        HttpServerOptions options = this.createBaseServerOptions();
        int port = options.getPort() + 1;
        options.setPort(port);
        AtomicInteger redirects = new AtomicInteger();
        this.server.requestHandler(req -> {
            redirects.incrementAndGet();
            req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:" + port + "/whatever")).end();
        });
        this.startServer();
        HttpServer server2 = this.vertx.createHttpServer(options);
        server2.requestHandler(req -> {
            this.assertEquals(1L, redirects.get());
            this.assertEquals(scheme + "://localhost:" + port + "/whatever", req.absoluteURI());
            req.response().end();
            this.complete();
        });
        this.startServer(server2);
        this.client.get(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(scheme + "://localhost:" + port + "/whatever", resp.request().absoluteURI());
            this.complete();
        }).setFollowRedirects(true).setHost("localhost:" + options.getPort()).end();
        this.await();
    }

    @Test
    public void testFollowRedirectWithCustomHandler() throws Exception {
        String scheme = this.createBaseClientOptions().isSsl() ? "https" : "http";
        this.waitFor(2);
        HttpServerOptions options = this.createBaseServerOptions();
        int port = options.getPort() + 1;
        options.setPort(port);
        AtomicInteger redirects = new AtomicInteger();
        this.server.requestHandler(req -> {
            redirects.incrementAndGet();
            req.response().setStatusCode(301).putHeader(HttpHeaders.LOCATION, (CharSequence)(scheme + "://localhost:" + port + "/whatever")).end();
        });
        this.startServer();
        HttpServer server2 = this.vertx.createHttpServer(options);
        server2.requestHandler(req -> {
            this.assertEquals(1L, redirects.get());
            this.assertEquals(scheme + "://localhost:" + port + "/custom", req.absoluteURI());
            req.response().end();
            this.complete();
        });
        this.startServer(server2);
        this.client.redirectHandler(resp -> {
            Future fut = Future.future();
            this.vertx.setTimer(25L, id -> {
                HttpClientRequest req = this.client.getAbs(scheme + "://localhost:" + port + "/custom");
                req.putHeader("foo", "foo_another");
                req.setHost("localhost:" + port);
                fut.complete((Object)req);
            });
            return fut;
        });
        this.client.get(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(scheme + "://localhost:" + port + "/custom", resp.request().absoluteURI());
            this.complete();
        }).setFollowRedirects(true).putHeader("foo", "foo_value").setHost("localhost:" + options.getPort()).end();
        this.await();
    }

    @Test
    public void testDefaultRedirectHandler() throws Exception {
        this.testFoo("http://example.com", "http://example.com");
        this.testFoo("http://example.com/somepath", "http://example.com/somepath");
        this.testFoo("http://example.com:8000", "http://example.com:8000");
        this.testFoo("http://example.com:8000/somepath", "http://example.com:8000/somepath");
        this.testFoo("https://example.com", "https://example.com");
        this.testFoo("https://example.com/somepath", "https://example.com/somepath");
        this.testFoo("https://example.com:8000", "https://example.com:8000");
        this.testFoo("https://example.com:8000/somepath", "https://example.com:8000/somepath");
        this.testFoo("whatever://example.com", null);
        this.testFoo("http://", null);
        this.testFoo("http://:8080/somepath", null);
    }

    private void testFoo(String location, String expected) throws Exception {
        final int status = 301;
        final Map<String, String> headers = Collections.singletonMap("Location", location);
        final HttpMethod method = HttpMethod.GET;
        final String baseURI = "https://localhost:8080";
        class MockReq
        implements HttpClientRequest {
            MockReq() {
            }

            public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(Buffer data) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest drainHandler(Handler<Void> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest handler(Handler<HttpClientResponse> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest pause() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest resume() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest endHandler(Handler<Void> endHandler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setFollowRedirects(boolean followRedirects) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setChunked(boolean chunked) {
                throw new UnsupportedOperationException();
            }

            public boolean isChunked() {
                return false;
            }

            public HttpMethod method() {
                return method;
            }

            public String getRawMethod() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setRawMethod(String method2) {
                throw new UnsupportedOperationException();
            }

            public String absoluteURI() {
                return baseURI;
            }

            public String uri() {
                throw new UnsupportedOperationException();
            }

            public String path() {
                throw new UnsupportedOperationException();
            }

            public String query() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setHost(String host) {
                throw new UnsupportedOperationException();
            }

            public String getHost() {
                throw new UnsupportedOperationException();
            }

            public MultiMap headers() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(String name, String value) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(String name, Iterable<String> values) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(String chunk) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest write(String chunk, String enc) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest continueHandler(@Nullable Handler<Void> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest sendHead() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
                throw new UnsupportedOperationException();
            }

            public void end(String chunk) {
                throw new UnsupportedOperationException();
            }

            public void end(String chunk, String enc) {
                throw new UnsupportedOperationException();
            }

            public void end(Buffer chunk) {
                throw new UnsupportedOperationException();
            }

            public void end() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest setTimeout(long timeoutMs) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
                throw new UnsupportedOperationException();
            }

            public boolean reset(long code) {
                return false;
            }

            public HttpConnection connection() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
                throw new UnsupportedOperationException();
            }

            public boolean writeQueueFull() {
                throw new UnsupportedOperationException();
            }
        }
        final MockReq req = new MockReq();
        class MockResp
        implements HttpClientResponse {
            MockResp() {
            }

            public HttpClientResponse resume() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse handler(Handler<Buffer> handler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse pause() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse endHandler(Handler<Void> endHandler) {
                throw new UnsupportedOperationException();
            }

            public HttpVersion version() {
                throw new UnsupportedOperationException();
            }

            public int statusCode() {
                return status;
            }

            public String statusMessage() {
                throw new UnsupportedOperationException();
            }

            public MultiMap headers() {
                throw new UnsupportedOperationException();
            }

            public String getHeader(String headerName) {
                return (String)headers.get(headerName);
            }

            public String getHeader(CharSequence headerName) {
                return this.getHeader(headerName.toString());
            }

            public String getTrailer(String trailerName) {
                throw new UnsupportedOperationException();
            }

            public MultiMap trailers() {
                throw new UnsupportedOperationException();
            }

            public List<String> cookies() {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
                throw new UnsupportedOperationException();
            }

            public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
                throw new UnsupportedOperationException();
            }

            public NetSocket netSocket() {
                throw new UnsupportedOperationException();
            }

            public HttpClientRequest request() {
                return req;
            }
        }
        MockResp resp = new MockResp();
        Function handler = this.client.redirectHandler();
        Future redirection = (Future)handler.apply(resp);
        if (expected != null) {
            this.assertEquals(location, ((HttpClientRequest)redirection.result()).absoluteURI());
        } else {
            this.assertTrue(redirection == null || redirection.failed());
        }
    }

    @Test
    public void testServerResponseCloseHandlerNotHoldingLock() throws Exception {
        this.server.requestHandler(req -> {
            req.response().closeHandler(v -> {
                this.assertFalse(Thread.holdsLock(req.connection()));
                this.testComplete();
            });
            req.response().setChunked(true).write("hello");
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "/somepath", resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.request().connection().close();
        });
        this.await();
    }

    @Test
    public void testCloseHandlerWhenConnectionEnds() throws Exception {
        this.server.requestHandler(req -> {
            req.response().endHandler(v -> this.testComplete());
            req.response().end("some-data");
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "/somepath", resp -> resp.handler(v -> resp.request().connection().close()));
        this.await();
    }

    @Test
    public void testCloseHandlerWhenConnectionClose() throws Exception {
        this.server.requestHandler(req -> {
            req.response().setChunked(true).write("some-data");
            req.response().closeHandler(v -> this.testComplete());
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "/somepath", resp -> resp.handler(v -> resp.request().connection().close()));
        this.await();
    }

    @Test
    public abstract void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd() throws Exception;

    protected void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd(int expected) throws Exception {
        AtomicInteger closeCount = new AtomicInteger();
        AtomicInteger endCount = new AtomicInteger();
        this.server.requestHandler(req -> {
            req.response().closeHandler(v -> closeCount.incrementAndGet());
            req.response().endHandler(v -> endCount.incrementAndGet());
            req.connection().closeHandler(v -> {
                this.assertEquals(expected, closeCount.get());
                this.assertEquals(1L, endCount.get());
                this.testComplete();
            });
            req.response().end("some-data");
        });
        this.startServer();
        this.client.getNow(8080, "localhost", "/somepath", resp -> resp.endHandler(v -> resp.request().connection().close()));
        this.await();
    }

    private TestLoggerFactory testLogging() throws Exception {
        InternalLoggerFactory prev = InternalLoggerFactory.getDefaultFactory();
        TestLoggerFactory factory = new TestLoggerFactory();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)factory);
        try {
            this.server.requestHandler(req -> req.response().end());
            this.startServer();
            this.client.getNow(8080, "localhost", "/somepath", resp -> this.testComplete());
            this.await();
        }
        finally {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)prev);
        }
        return factory;
    }

    protected File setupFile(String fileName, String content) throws Exception {
        File file = new File(this.testDir, fileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        out.write(content);
        out.close();
        return file;
    }

    protected static String generateQueryString(Map<String, String> params, char delim) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, String> param : params.entrySet()) {
            sb.append(param.getKey()).append("=").append(param.getValue());
            if (++count == params.size()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    protected static Map<String, String> genMap(int num) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < num; ++i) {
            String key;
            while (map.containsKey(key = TestUtils.randomAlphaString(1 + (int)(19.0 * Math.random())).toLowerCase())) {
            }
            map.put(key, TestUtils.randomAlphaString(1 + (int)(19.0 * Math.random())));
        }
        return map;
    }

    protected static MultiMap getHeaders(int num) {
        Map<String, String> map = HttpTest.genMap(num);
        HeadersAdaptor headers = new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)new DefaultHttpHeaders());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        return headers;
    }
}

