/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Starter;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.CustomMetricsOptions;
import io.vertx.test.core.MetricsOptionsTest;
import io.vertx.test.core.TestVerticle;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StarterTest
extends VertxTestBase {
    Vertx vertx;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestVerticle.instanceCount.set(0);
        TestVerticle.processArgs = null;
        TestVerticle.conf = null;
        VertxCommandLauncher.resetProcessArguments();
        File manifest = new File("target/test-classes/META-INF/MANIFEST-Starter.MF");
        if (!manifest.isFile()) {
            throw new IllegalStateException("Cannot find the MANIFEST-Starter.MF file");
        }
        File target = new File("target/test-classes/META-INF/MANIFEST.MF");
        Files.copy(manifest.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void tearDown() throws Exception {
        this.clearProperties();
        super.tearDown();
        if (this.vertx != null) {
            this.vertx.close();
        }
    }

    @Test
    public void testVersion() throws Exception {
        String[] args = new String[]{"-version"};
        MyStarter starter = new MyStarter();
        starter.run(args);
        this.assertEquals(System.getProperty("vertx.version"), starter.getVersion());
        this.cleanup(starter);
    }

    @Test
    public void testRunVerticle() throws Exception {
        this.testRunVerticleMultiple(1);
    }

    @Test
    public void testRunVerticleMultipleInstances() throws Exception {
        this.testRunVerticleMultiple(10);
    }

    public void testRunVerticleMultiple(int instances) throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-instances", String.valueOf(instances)};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == instances);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        starter.assertHooksInvoked();
        this.cleanup(starter);
    }

    @Test
    public void testRunVerticleClustered() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster"};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        starter.assertHooksInvoked();
        this.cleanup(starter);
    }

    @Test
    public void testRunVerticleHA() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-ha"};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        starter.assertHooksInvoked();
        this.cleanup(starter);
    }

    @Test
    public void testRunVerticleWithMainVerticleInManifestNoArgs() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        this.cleanup(starter);
    }

    private void cleanup(MyStarter starter) {
        if (starter != null && starter.getVertx() != null) {
            starter.getVertx().close();
        }
    }

    @Test
    public void testRunVerticleWithMainVerticleInManifestWithHA() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"-ha"};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        this.cleanup(starter);
    }

    @Test
    public void testRunVerticleWithMainVerticleInManifestWithArgs() throws Exception {
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"-cluster", "-worker"};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(Arrays.asList(args), TestVerticle.processArgs);
        this.cleanup(starter);
    }

    @Test
    public void testRunVerticleWithConfString() throws Exception {
        MyStarter starter = new MyStarter();
        JsonObject conf = new JsonObject().put("foo", "bar").put("wibble", Integer.valueOf(123));
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-conf", conf.encode()};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(conf, TestVerticle.conf);
        this.cleanup(starter);
    }

    @Test
    public void testRunVerticleWithConfFile() throws Exception {
        Path tempDir = this.testFolder.newFolder().toPath();
        Path tempFile = Files.createTempFile(tempDir, "conf", "json", new FileAttribute[0]);
        MyStarter starter = new MyStarter();
        JsonObject conf = new JsonObject().put("foo", "bar").put("wibble", Integer.valueOf(123));
        Files.write(tempFile, conf.encode().getBytes(), new OpenOption[0]);
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-conf", tempFile.toString()};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        this.assertEquals(conf, TestVerticle.conf);
        this.cleanup(starter);
    }

    @Test
    public void testConfigureFromSystemProperties() throws Exception {
        this.testConfigureFromSystemProperties(false);
    }

    @Test
    public void testConfigureFromSystemPropertiesClustered() throws Exception {
        this.testConfigureFromSystemProperties(true);
    }

    private void testConfigureFromSystemProperties(boolean clustered) throws Exception {
        System.setProperty("vertx.options.eventLoopPoolSize", "123");
        System.setProperty("vertx.options.maxEventLoopExecuteTime", "123767667");
        System.setProperty("vertx.metrics.options.enabled", "true");
        System.setProperty("vertx.options.haGroup", "somegroup");
        MyStarter starter = new MyStarter();
        String[] args = clustered ? new String[]{"run", "java:" + TestVerticle.class.getCanonicalName(), "-cluster"} : new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = starter.getVertxOptions();
        this.assertEquals(123.0, (double)opts.getEventLoopPoolSize(), 0.0);
        this.assertEquals(123767667L, opts.getMaxEventLoopExecuteTime());
        this.assertEquals(true, opts.getMetricsOptions().isEnabled());
        this.assertEquals("somegroup", opts.getHAGroup());
        this.cleanup(starter);
    }

    private void clearProperties() {
        HashSet<String> toClear = new HashSet<String>();
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (!propName.startsWith("vertx.options")) continue;
            toClear.add(propName);
        }
        for (String propName : toClear) {
            System.clearProperty(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomMetricsOptions() throws Exception {
        System.setProperty("vertx.metrics.options.enabled", "true");
        System.setProperty("vertx.metrics.options.customProperty", "customPropertyValue");
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(MetricsOptionsTest.createMetricsFromMetaInfLoader("io.vertx.test.core.CustomMetricsFactory"));
        try {
            starter.run(args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = starter.getVertxOptions();
        CustomMetricsOptions custom = (CustomMetricsOptions)opts.getMetricsOptions();
        this.assertEquals("customPropertyValue", custom.getCustomProperty());
        this.cleanup(starter);
    }

    @Test
    public void testConfigureFromSystemPropertiesInvalidPropertyName() throws Exception {
        System.setProperty("vertx.options.nosuchproperty", "123");
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = starter.getVertxOptions();
        VertxOptions def = new VertxOptions();
        if (opts.getMetricsOptions().isEnabled()) {
            def.getMetricsOptions().setEnabled(true);
        }
        this.assertEquals(def, opts);
        this.cleanup(starter);
    }

    @Test
    public void testConfigureFromSystemPropertiesInvalidPropertyType() throws Exception {
        System.setProperty("vertx.options.eventLoopPoolSize", "sausages");
        MyStarter starter = new MyStarter();
        String[] args = new String[]{"run", "java:" + TestVerticle.class.getCanonicalName()};
        starter.run(args);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == 1);
        VertxOptions opts = starter.getVertxOptions();
        VertxOptions def = new VertxOptions();
        if (opts.getMetricsOptions().isEnabled()) {
            def.getMetricsOptions().setEnabled(true);
        }
        this.assertEquals(def, opts);
        this.cleanup(starter);
    }

    @Test
    public void testRunWithCommandLine() throws Exception {
        MyStarter starter = new MyStarter();
        int instances = 10;
        String cl = "run java:" + TestVerticle.class.getCanonicalName() + " -instances " + instances;
        starter.run(cl);
        this.assertWaitUntil(() -> TestVerticle.instanceCount.get() == instances);
        this.cleanup(starter);
    }

    class MyStarter
    extends Starter {
        boolean beforeStartingVertxInvoked = false;
        boolean afterStartingVertxInvoked = false;
        boolean beforeDeployingVerticle = false;

        MyStarter() {
        }

        public Vertx getVertx() {
            return this.vertx;
        }

        public VertxOptions getVertxOptions() {
            return this.options;
        }

        public DeploymentOptions getDeploymentOptions() {
            return this.deploymentOptions;
        }

        public void run(String[] sargs) {
            super.run(sargs);
        }

        public void run(String commandLine) {
            super.run(commandLine);
        }

        public void beforeStartingVertx(VertxOptions options) {
            this.beforeStartingVertxInvoked = true;
        }

        public void afterStartingVertx() {
            this.afterStartingVertxInvoked = true;
        }

        protected void beforeDeployingVerticle(DeploymentOptions deploymentOptions) {
            this.beforeDeployingVerticle = true;
        }

        public void assertHooksInvoked() {
            StarterTest.this.vertx = this.vertx;
            StarterTest.this.assertTrue(this.beforeStartingVertxInvoked);
            StarterTest.this.assertTrue(this.afterStartingVertxInvoked);
            StarterTest.this.assertTrue(this.beforeDeployingVerticle);
        }
    }
}

