/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakecluster;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.impl.AsynchronousCounter;
import io.vertx.core.shareddata.impl.AsynchronousLock;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.test.fakecluster.ChoosableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class FakeClusterManager
implements ClusterManager {
    private static Map<String, FakeClusterManager> nodes = Collections.synchronizedMap(new LinkedHashMap());
    private static ConcurrentMap<String, ConcurrentMap> asyncMaps = new ConcurrentHashMap<String, ConcurrentMap>();
    private static ConcurrentMap<String, ConcurrentMap> asyncMultiMaps = new ConcurrentHashMap<String, ConcurrentMap>();
    private static ConcurrentMap<String, Map> syncMaps = new ConcurrentHashMap<String, Map>();
    private static ConcurrentMap<String, AsynchronousLock> locks = new ConcurrentHashMap<String, AsynchronousLock>();
    private static ConcurrentMap<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private String nodeID;
    private NodeListener nodeListener;
    private VertxInternal vertx;

    public void setVertx(Vertx vertx) {
        this.vertx = (VertxInternal)vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doJoin(String nodeID, FakeClusterManager node) {
        if (nodes.containsKey(nodeID)) {
            throw new IllegalStateException("Node has already joined!");
        }
        nodes.put(nodeID, node);
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            for (Map.Entry<String, FakeClusterManager> entry : nodes.entrySet()) {
                if (entry.getKey().equals(nodeID)) continue;
                new Thread(() -> ((FakeClusterManager)entry.getValue()).memberAdded(nodeID)).start();
            }
        }
    }

    private synchronized void memberAdded(String nodeID) {
        if (this.isActive()) {
            try {
                if (this.nodeListener != null) {
                    this.nodeListener.nodeAdded(nodeID);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLeave(String nodeID) {
        nodes.remove(nodeID);
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            for (Map.Entry<String, FakeClusterManager> entry : nodes.entrySet()) {
                if (entry.getKey().equals(nodeID)) continue;
                new Thread(() -> ((FakeClusterManager)entry.getValue()).memberRemoved(nodeID)).start();
            }
        }
    }

    private synchronized void memberRemoved(String nodeID) {
        if (this.isActive()) {
            try {
                if (this.nodeListener != null) {
                    this.nodeListener.nodeLeft(nodeID);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public <K, V> void getAsyncMultiMap(String name, Handler<AsyncResult<AsyncMultiMap<K, V>>> resultHandler) {
        ConcurrentMap prevMap;
        ConcurrentMap map = (ConcurrentHashMap)asyncMultiMaps.get(name);
        if (map == null && (prevMap = (ConcurrentMap)asyncMultiMaps.putIfAbsent(name, map = new ConcurrentHashMap())) != null) {
            map = prevMap;
        }
        ConcurrentHashMap theMap = map;
        this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture(new FakeAsyncMultiMap(theMap))));
    }

    public <K, V> void getAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        ConcurrentMap prevMap;
        ConcurrentMap map = (ConcurrentHashMap)asyncMaps.get(name);
        if (map == null && (prevMap = (ConcurrentMap)asyncMaps.putIfAbsent(name, map = new ConcurrentHashMap())) != null) {
            map = prevMap;
        }
        ConcurrentHashMap theMap = map;
        this.vertx.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture(new FakeAsyncMap(theMap))));
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        Map prevMap;
        Map map = (ConcurrentHashMap)syncMaps.get(name);
        if (map == null && (prevMap = (Map)syncMaps.putIfAbsent(name, map = new ConcurrentHashMap())) != null) {
            map = prevMap;
        }
        ConcurrentHashMap theMap = map;
        return theMap;
    }

    public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        AsynchronousLock lock = new AsynchronousLock((Vertx)this.vertx);
        AsynchronousLock prev = locks.putIfAbsent(name, lock);
        if (prev != null) {
            lock = prev;
        }
        FakeLock flock = new FakeLock(lock);
        flock.acquire(timeout, resultHandler);
    }

    public void getCounter(String name, Handler<AsyncResult<Counter>> resultHandler) {
        AtomicLong counter = new AtomicLong();
        AtomicLong prev = counters.putIfAbsent(name, counter);
        if (prev != null) {
            counter = prev;
        }
        AtomicLong theCounter = counter;
        ContextImpl context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)new AsynchronousCounter(this.vertx, theCounter))));
    }

    public String getNodeID() {
        return this.nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNodes() {
        ArrayList<String> res;
        Map<String, FakeClusterManager> map = nodes;
        synchronized (map) {
            res = new ArrayList<String>(nodes.keySet());
        }
        return res;
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    public void join(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            FakeClusterManager fakeClusterManager = this;
            synchronized (fakeClusterManager) {
                this.nodeID = UUID.randomUUID().toString();
                FakeClusterManager.doJoin(this.nodeID, this);
            }
            fut.complete();
        }, resultHandler);
    }

    public void leave(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            FakeClusterManager fakeClusterManager = this;
            synchronized (fakeClusterManager) {
                if (this.nodeID != null) {
                    if (this.nodeListener != null) {
                        this.nodeListener = null;
                    }
                    FakeClusterManager.doLeave(this.nodeID);
                    this.nodeID = null;
                }
            }
            fut.complete();
        }, resultHandler);
    }

    public boolean isActive() {
        return this.nodeID != null;
    }

    public static void reset() {
        nodes.clear();
        asyncMaps.clear();
        asyncMultiMaps.clear();
        locks.clear();
        counters.clear();
        syncMaps.clear();
    }

    private class FakeAsyncMultiMap<K, V>
    implements AsyncMultiMap<K, V> {
        private final ConcurrentMap<K, ChoosableSet<V>> map;
        private final TaskQueue taskQueue = new TaskQueue();

        public FakeAsyncMultiMap(ConcurrentMap<K, ChoosableSet<V>> map) {
            this.map = map;
        }

        public void add(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
            ContextImpl ctx = FakeClusterManager.this.vertx.getOrCreateContext();
            ctx.executeBlocking(fut -> {
                ChoosableSet prevVals;
                ChoosableSet<Object> vals = (ChoosableSet<Object>)this.map.get(k);
                if (vals == null && (prevVals = this.map.putIfAbsent(k, vals = new ChoosableSet<Object>(1))) != null) {
                    vals = prevVals;
                }
                vals.add(v);
                fut.complete();
            }, this.taskQueue, completionHandler);
        }

        public void get(K k, Handler<AsyncResult<ChoosableIterable<V>>> asyncResultHandler) {
            ContextImpl ctx = FakeClusterManager.this.vertx.getOrCreateContext();
            ctx.executeBlocking(fut -> {
                ChoosableSet it = (ChoosableSet)this.map.get(k);
                if (it == null) {
                    it = new ChoosableSet(0);
                }
                fut.complete((Object)it);
            }, this.taskQueue, asyncResultHandler);
        }

        public void remove(K k, V v, Handler<AsyncResult<Boolean>> completionHandler) {
            ContextImpl ctx = FakeClusterManager.this.vertx.getOrCreateContext();
            ctx.executeBlocking(fut -> {
                boolean removed;
                ChoosableSet vals = (ChoosableSet)this.map.get(k);
                boolean found = false;
                if (vals != null && (removed = vals.remove(v))) {
                    if (vals.isEmpty()) {
                        this.map.remove(k);
                    }
                    found = true;
                }
                fut.complete((Object)found);
            }, this.taskQueue, completionHandler);
        }

        public void removeAllForValue(V v, Handler<AsyncResult<Void>> completionHandler) {
            this.removeAllMatching(v::equals, completionHandler);
        }

        public void removeAllMatching(Predicate<V> p, Handler<AsyncResult<Void>> completionHandler) {
            ContextImpl ctx = FakeClusterManager.this.vertx.getOrCreateContext();
            ctx.executeBlocking(fut -> {
                Iterator mapIter = this.map.entrySet().iterator();
                while (mapIter.hasNext()) {
                    Map.Entry entry = mapIter.next();
                    ChoosableSet vals = (ChoosableSet)entry.getValue();
                    Iterator iter = vals.iterator();
                    while (iter.hasNext()) {
                        Object val = iter.next();
                        if (!p.test(val)) continue;
                        iter.remove();
                    }
                    if (!vals.isEmpty()) continue;
                    mapIter.remove();
                }
                fut.complete();
            }, this.taskQueue, completionHandler);
        }
    }

    private class FakeAsyncMap<K, V>
    implements AsyncMap<K, V> {
        private final Map<K, V> map;

        public FakeAsyncMap(Map<K, V> map) {
            this.map = map;
        }

        public void get(K k, Handler<AsyncResult<V>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete(this.map.get(k)), resultHandler);
        }

        public void put(K k, V v, Handler<AsyncResult<Void>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> {
                this.map.put(k, v);
                fut.complete();
            }, resultHandler);
        }

        public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete(this.map.putIfAbsent(k, v)), resultHandler);
        }

        public void put(K k, V v, long timeout, Handler<AsyncResult<Void>> completionHandler) {
            this.put(k, v, completionHandler);
            FakeClusterManager.this.vertx.setTimer(timeout, tid -> this.map.remove(k));
        }

        public void putIfAbsent(K k, V v, long timeout, Handler<AsyncResult<V>> completionHandler) {
            Future future = Future.future();
            this.putIfAbsent(k, v, (Handler<AsyncResult<V>>)future);
            future.map(vv -> {
                if (vv == null) {
                    FakeClusterManager.this.vertx.setTimer(timeout, tid -> this.map.remove(k));
                }
                return vv;
            }).setHandler(completionHandler);
        }

        public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.remove(k, v)), resultHandler);
        }

        public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete(this.map.replace(k, v)), resultHandler);
        }

        public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.replace(k, oldValue, newValue)), resultHandler);
        }

        public void clear(Handler<AsyncResult<Void>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> {
                this.map.clear();
                fut.complete();
            }, resultHandler);
        }

        public void size(Handler<AsyncResult<Integer>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.size()), resultHandler);
        }

        public void keys(Handler<AsyncResult<Set<K>>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete(new HashSet<K>(this.map.keySet())), resultHandler);
        }

        public void values(Handler<AsyncResult<List<V>>> asyncResultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete(new ArrayList<V>(this.map.values())), asyncResultHandler);
        }

        public void entries(Handler<AsyncResult<Map<K, V>>> asyncResultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete(new HashMap<K, V>(this.map)), asyncResultHandler);
        }

        public void remove(K k, Handler<AsyncResult<V>> resultHandler) {
            FakeClusterManager.this.vertx.executeBlocking(fut -> fut.complete(this.map.remove(k)), resultHandler);
        }
    }

    private class FakeLock
    implements Lock {
        private final AsynchronousLock delegate;

        public FakeLock(AsynchronousLock delegate) {
            this.delegate = delegate;
        }

        public void acquire(long timeout, Handler<AsyncResult<Lock>> resultHandler) {
            ContextImpl context = FakeClusterManager.this.vertx.getOrCreateContext();
            this.delegate.doAcquire((Context)context, timeout, resultHandler);
        }

        public void release() {
            this.delegate.release();
        }
    }
}

