/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.benchmarks.HeadersUtils;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class HeadersContainsBenchmark
extends BenchmarkBase {
    private HttpHeaders nettySmallHeaders;
    private VertxHttpHeaders vertxSmallHeaders;

    @Setup
    public void setup() {
        this.nettySmallHeaders = new DefaultHttpHeaders();
        this.vertxSmallHeaders = new VertxHttpHeaders();
        HeadersUtils.setBaseHeaders(this.nettySmallHeaders);
        HeadersUtils.setBaseHeaders((HttpHeaders)this.vertxSmallHeaders);
    }

    @Benchmark
    public boolean nettySmall() throws Exception {
        return this.nettySmallHeaders.contains(HeadersUtils.CONTENT_LENGTH_HEADER);
    }

    @Benchmark
    public boolean vertxSmall() throws Exception {
        return this.vertxSmallHeaders.contains(HeadersUtils.CONTENT_LENGTH_HEADER);
    }
}

