/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.benchmarks.HeadersUtils;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class HeadersSetBenchmark
extends BenchmarkBase {
    private HttpHeaders nettySmallHeaders;
    private VertxHttpHeaders vertxSmallHeaders;

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public static void consume(HttpHeaders headers) {
    }

    @Setup
    public void setup() {
        this.nettySmallHeaders = new DefaultHttpHeaders();
        this.vertxSmallHeaders = new VertxHttpHeaders();
    }

    @Benchmark
    public void nettySmall() throws Exception {
        this.nettySmallHeaders.clear();
        HeadersUtils.setBaseHeaders(this.nettySmallHeaders);
        HeadersSetBenchmark.consume(this.nettySmallHeaders);
    }

    @Benchmark
    public void vertxSmall() throws Exception {
        this.vertxSmallHeaders.clear();
        HeadersUtils.setBaseHeaders((HttpHeaders)this.vertxSmallHeaders);
        HeadersSetBenchmark.consume((HttpHeaders)this.vertxSmallHeaders);
    }
}

